/*
 * Decompiled with CFR 0.152.
 */
package avail.tools.bootstrap;

import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006%"}, d2={"Lavail/tools/bootstrap/Resources;", "", "()V", "errorCodesBaseName", "", "getErrorCodesBaseName", "()Ljava/lang/String;", "generatedPackageName", "getGeneratedPackageName", "preambleBaseName", "getPreambleBaseName", "primitivesBaseName", "getPrimitivesBaseName", "sourceBaseName", "specialObjectsBaseName", "getSpecialObjectsBaseName", "errorCodeCommentKey", "code", "Lavail/exceptions/AvailErrorCode;", "errorCodeExceptionKey", "errorCodeKey", "escape", "propertyValue", "localName", "bundleName", "primitiveCommentKey", "primitive", "Lavail/interpreter/Primitive;", "primitiveParameterNameKey", "index", "", "specialObjectCommentKey", "specialObjectKey", "specialObjectTypeKey", "stringify", "string", "Key", "avail"})
public final class Resources {
    @NotNull
    public static final Resources INSTANCE = new Resources();
    @NotNull
    public static final String sourceBaseName = "src/main/resources";
    @NotNull
    private static final String preambleBaseName = Resources.class.getPackage().getName() + ".Preamble";
    @NotNull
    private static final String generatedPackageName = Resources.class.getPackage().getName() + ".generated";
    @NotNull
    private static final String specialObjectsBaseName = generatedPackageName + ".SpecialObjectNames";
    @NotNull
    private static final String primitivesBaseName = generatedPackageName + ".PrimitiveNames";
    @NotNull
    private static final String errorCodesBaseName = generatedPackageName + ".ErrorCodeNames";

    private Resources() {
    }

    @NotNull
    public final String getPreambleBaseName() {
        return preambleBaseName;
    }

    @NotNull
    public final String getGeneratedPackageName() {
        return generatedPackageName;
    }

    @NotNull
    public final String getSpecialObjectsBaseName() {
        return specialObjectsBaseName;
    }

    @NotNull
    public final String getPrimitivesBaseName() {
        return primitivesBaseName;
    }

    @NotNull
    public final String getErrorCodesBaseName() {
        return errorCodesBaseName;
    }

    @NotNull
    public final String localName(@NotNull String bundleName) {
        Intrinsics.checkNotNullParameter(bundleName, "bundleName");
        String string2 = bundleName.substring(StringsKt.lastIndexOf$default((CharSequence)bundleName, '.', 0, false, 6, null) + 1);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
        return string2;
    }

    @NotNull
    public final String stringify(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "string");
        return "\"" + string2 + "\"";
    }

    @NotNull
    public final String specialObjectKey(int index2) {
        return "specialObject" + index2;
    }

    @NotNull
    public final String specialObjectCommentKey(int index2) {
        return this.specialObjectKey(index2) + "_comment";
    }

    @NotNull
    public final String specialObjectTypeKey(int index2) {
        return this.specialObjectKey(index2) + "_type";
    }

    @NotNull
    public final String primitiveParameterNameKey(@NotNull Primitive primitive2, int index2) {
        Intrinsics.checkNotNullParameter(primitive2, "primitive");
        return primitive2.getSimpleName() + "_" + index2;
    }

    @NotNull
    public final String primitiveCommentKey(@NotNull Primitive primitive2) {
        Intrinsics.checkNotNullParameter(primitive2, "primitive");
        return primitive2.getSimpleName() + "_comment";
    }

    @NotNull
    public final String errorCodeKey(@NotNull AvailErrorCode code) {
        Intrinsics.checkNotNullParameter((Object)code, "code");
        return "errorCode" + code.nativeCode();
    }

    @NotNull
    public final String errorCodeExceptionKey(@NotNull AvailErrorCode code) {
        Intrinsics.checkNotNullParameter((Object)code, "code");
        return this.errorCodeKey(code) + "_exception";
    }

    @NotNull
    public final String errorCodeCommentKey(@NotNull AvailErrorCode code) {
        Intrinsics.checkNotNullParameter((Object)code, "code");
        return this.errorCodeKey(code) + "_comment";
    }

    @NotNull
    public final String escape(@NotNull String propertyValue) {
        Intrinsics.checkNotNullParameter(propertyValue, "propertyValue");
        Object newValue = StringsKt.replace$default(propertyValue, "\n", "\\n\\\n", false, 4, null);
        if (StringsKt.indexOf$default((CharSequence)newValue, '\n', 0, false, 6, null) != StringsKt.lastIndexOf$default((CharSequence)newValue, '\n', 0, false, 6, null)) {
            newValue = "\\\n" + (String)newValue;
        }
        if (StringsKt.endsWith$default((String)newValue, "\\n\\\n", false, 2, null)) {
            String string2 = ((String)newValue).substring(0, ((String)newValue).length() - 2);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            newValue = string2;
        }
        newValue = StringsKt.replace$default((String)newValue, "\n ", "\n\\ ", false, 4, null);
        CharSequence charSequence = (CharSequence)newValue;
        Regex regex = new Regex("\\\\(?![n\\n ])");
        String string3 = Matcher.quoteReplacement("\\\\");
        Intrinsics.checkNotNullExpressionValue(string3, "quoteReplacement(...)");
        String string4 = string3;
        newValue = regex.replace(charSequence, string4);
        return newValue;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b7\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7\u00a8\u00068"}, d2={"Lavail/tools/bootstrap/Resources$Key;", "", "(Ljava/lang/String;I)V", "propertiesCopyright", "generatedPropertiesNotice", "availCopyright", "specialObjectCommentTemplate", "specialObjectCommentTypeTemplate", "specialObjectCommentValueTemplate", "methodCommentTemplate", "methodCommentParameterTemplate", "methodCommentReturnsTemplate", "methodCommentRaisesTemplate", "generatedModuleNotice", "originModuleName", "originModuleHeader", "specialObjectsModuleName", "primitivesModuleName", "infalliblePrimitivesModuleName", "falliblePrimitivesModuleName", "errorCodesModuleName", "generalModuleHeader", "representativeModuleName", "bootstrapDefiningMethod", "bootstrapSpecialObject", "bootstrapDefineSpecialObjectMacro", "bootstrapMacroNames", "bootstrapMacros", "definingSpecialObjectUse", "definingMethodUse", "specialObjectUse", "parameterPrefix", "primitiveKeyword", "primitiveFailureMethod", "primitiveFailureMethodUse", "primitiveFailureVariableName", "primitiveFailureFunctionName", "primitiveFailureFunctionSetterMethod", "primitiveFailureFunctionGetterMethod", "invokePrimitiveFailureFunctionMethod", "invokePrimitiveFailureFunctionMethodUse", "primitiveSemanticRestriction", "primitiveSemanticRestrictionUse", "primitiveCoverageTestPackageName", "primitiveCoverageTestPackageRepresentativeHeader", "primitiveCoverageTestSubPackageRepresentativeHeader", "primitiveCommonTestPackageName", "primitiveCommonTestPackageRepresentativeHeader", "availModuleName", "primitiveCoverageTestModuleName", "primitiveCoverageTestModuleHeader", "primitiveCoverageTestCaseOk", "primitiveCoverageTestCaseFailed", "primitiveCoverageTestCaseFailedSpecial", "primitiveTestSuiteName", "primitiveTestSuiteImplementation", "avail"})
    public static final class Key
    extends Enum<Key> {
        public static final /* enum */ Key propertiesCopyright = new Key();
        public static final /* enum */ Key generatedPropertiesNotice = new Key();
        public static final /* enum */ Key availCopyright = new Key();
        public static final /* enum */ Key specialObjectCommentTemplate = new Key();
        public static final /* enum */ Key specialObjectCommentTypeTemplate = new Key();
        public static final /* enum */ Key specialObjectCommentValueTemplate = new Key();
        public static final /* enum */ Key methodCommentTemplate = new Key();
        public static final /* enum */ Key methodCommentParameterTemplate = new Key();
        public static final /* enum */ Key methodCommentReturnsTemplate = new Key();
        public static final /* enum */ Key methodCommentRaisesTemplate = new Key();
        public static final /* enum */ Key generatedModuleNotice = new Key();
        public static final /* enum */ Key originModuleName = new Key();
        public static final /* enum */ Key originModuleHeader = new Key();
        public static final /* enum */ Key specialObjectsModuleName = new Key();
        public static final /* enum */ Key primitivesModuleName = new Key();
        public static final /* enum */ Key infalliblePrimitivesModuleName = new Key();
        public static final /* enum */ Key falliblePrimitivesModuleName = new Key();
        public static final /* enum */ Key errorCodesModuleName = new Key();
        public static final /* enum */ Key generalModuleHeader = new Key();
        public static final /* enum */ Key representativeModuleName = new Key();
        public static final /* enum */ Key bootstrapDefiningMethod = new Key();
        public static final /* enum */ Key bootstrapSpecialObject = new Key();
        public static final /* enum */ Key bootstrapDefineSpecialObjectMacro = new Key();
        public static final /* enum */ Key bootstrapMacroNames = new Key();
        public static final /* enum */ Key bootstrapMacros = new Key();
        public static final /* enum */ Key definingSpecialObjectUse = new Key();
        public static final /* enum */ Key definingMethodUse = new Key();
        public static final /* enum */ Key specialObjectUse = new Key();
        public static final /* enum */ Key parameterPrefix = new Key();
        public static final /* enum */ Key primitiveKeyword = new Key();
        public static final /* enum */ Key primitiveFailureMethod = new Key();
        public static final /* enum */ Key primitiveFailureMethodUse = new Key();
        public static final /* enum */ Key primitiveFailureVariableName = new Key();
        public static final /* enum */ Key primitiveFailureFunctionName = new Key();
        public static final /* enum */ Key primitiveFailureFunctionSetterMethod = new Key();
        public static final /* enum */ Key primitiveFailureFunctionGetterMethod = new Key();
        public static final /* enum */ Key invokePrimitiveFailureFunctionMethod = new Key();
        public static final /* enum */ Key invokePrimitiveFailureFunctionMethodUse = new Key();
        public static final /* enum */ Key primitiveSemanticRestriction = new Key();
        public static final /* enum */ Key primitiveSemanticRestrictionUse = new Key();
        public static final /* enum */ Key primitiveCoverageTestPackageName = new Key();
        public static final /* enum */ Key primitiveCoverageTestPackageRepresentativeHeader = new Key();
        public static final /* enum */ Key primitiveCoverageTestSubPackageRepresentativeHeader = new Key();
        public static final /* enum */ Key primitiveCommonTestPackageName = new Key();
        public static final /* enum */ Key primitiveCommonTestPackageRepresentativeHeader = new Key();
        public static final /* enum */ Key availModuleName = new Key();
        public static final /* enum */ Key primitiveCoverageTestModuleName = new Key();
        public static final /* enum */ Key primitiveCoverageTestModuleHeader = new Key();
        public static final /* enum */ Key primitiveCoverageTestCaseOk = new Key();
        public static final /* enum */ Key primitiveCoverageTestCaseFailed = new Key();
        public static final /* enum */ Key primitiveCoverageTestCaseFailedSpecial = new Key();
        public static final /* enum */ Key primitiveTestSuiteName = new Key();
        public static final /* enum */ Key primitiveTestSuiteImplementation = new Key();
        private static final /* synthetic */ Key[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Key[] values() {
            return (Key[])$VALUES.clone();
        }

        public static Key valueOf(String value) {
            return Enum.valueOf(Key.class, value);
        }

        @NotNull
        public static EnumEntries<Key> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = keyArray = new Key[]{Key.propertiesCopyright, Key.generatedPropertiesNotice, Key.availCopyright, Key.specialObjectCommentTemplate, Key.specialObjectCommentTypeTemplate, Key.specialObjectCommentValueTemplate, Key.methodCommentTemplate, Key.methodCommentParameterTemplate, Key.methodCommentReturnsTemplate, Key.methodCommentRaisesTemplate, Key.generatedModuleNotice, Key.originModuleName, Key.originModuleHeader, Key.specialObjectsModuleName, Key.primitivesModuleName, Key.infalliblePrimitivesModuleName, Key.falliblePrimitivesModuleName, Key.errorCodesModuleName, Key.generalModuleHeader, Key.representativeModuleName, Key.bootstrapDefiningMethod, Key.bootstrapSpecialObject, Key.bootstrapDefineSpecialObjectMacro, Key.bootstrapMacroNames, Key.bootstrapMacros, Key.definingSpecialObjectUse, Key.definingMethodUse, Key.specialObjectUse, Key.parameterPrefix, Key.primitiveKeyword, Key.primitiveFailureMethod, Key.primitiveFailureMethodUse, Key.primitiveFailureVariableName, Key.primitiveFailureFunctionName, Key.primitiveFailureFunctionSetterMethod, Key.primitiveFailureFunctionGetterMethod, Key.invokePrimitiveFailureFunctionMethod, Key.invokePrimitiveFailureFunctionMethodUse, Key.primitiveSemanticRestriction, Key.primitiveSemanticRestrictionUse, Key.primitiveCoverageTestPackageName, Key.primitiveCoverageTestPackageRepresentativeHeader, Key.primitiveCoverageTestSubPackageRepresentativeHeader, Key.primitiveCommonTestPackageName, Key.primitiveCommonTestPackageRepresentativeHeader, Key.availModuleName, Key.primitiveCoverageTestModuleName, Key.primitiveCoverageTestModuleHeader, Key.primitiveCoverageTestCaseOk, Key.primitiveCoverageTestCaseFailed, Key.primitiveCoverageTestCaseFailedSpecial, Key.primitiveTestSuiteName, Key.primitiveTestSuiteImplementation};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

