/*
 * Decompiled with CFR 0.152.
 */
package avail;

import avail.AvailRuntimeConfiguration;
import avail.CallbackSystem;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.pojos.PojoDescriptor;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PojoTypeDescriptor;
import avail.utility.SimpleThreadFactory;
import java.lang.reflect.Type;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lavail/CallbackSystem;", "", "()V", "callbackExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "destroy", "", "executeCallbackTask", "callback", "Lavail/CallbackSystem$Callback;", "argumentsTuple", "Lavail/descriptor/tuples/A_Tuple;", "completion", "Lavail/CallbackSystem$CallbackCompletion;", "failure", "Lavail/CallbackSystem$CallbackFailure;", "Callback", "CallbackCompletion", "CallbackFailure", "Companion", "avail"})
public final class CallbackSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadPoolExecutor callbackExecutor = new ThreadPoolExecutor(AvailRuntimeConfiguration.INSTANCE.getAvailableProcessors(), AvailRuntimeConfiguration.INSTANCE.getAvailableProcessors() << 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue(), new SimpleThreadFactory("AvailCallback"), new ThreadPoolExecutor.CallerRunsPolicy());
    @GuardedBy(value="rawFunctionCacheLock")
    @NotNull
    private static final WeakHashMap<A_Type, A_RawFunction> rawFunctionCache = new WeakHashMap();
    @NotNull
    private static final ReentrantReadWriteLock rawFunctionCacheLock = new ReentrantReadWriteLock();
    @NotNull
    private static final A_Type callbackTypePojo = PojoTypeDescriptor.Companion.resolvePojoType((Type)((Object)Callback.class), MapDescriptor.Companion.getEmptyMap()).makeShared();

    public final void executeCallbackTask(@NotNull Callback callback2, @NotNull A_Tuple argumentsTuple, @NotNull CallbackCompletion completion, @NotNull CallbackFailure failure) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)argumentsTuple, (String)"argumentsTuple");
        Intrinsics.checkNotNullParameter((Object)completion, (String)"completion");
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        this.callbackExecutor.execute(() -> CallbackSystem.executeCallbackTask$lambda$0(callback2, argumentsTuple, completion, failure));
    }

    public final void destroy() {
        this.callbackExecutor.shutdownNow();
        try {
            this.callbackExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static final void executeCallbackTask$lambda$0(Callback $callback, A_Tuple $argumentsTuple, CallbackCompletion $completion, CallbackFailure $failure) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)$argumentsTuple, (String)"$argumentsTuple");
        Intrinsics.checkNotNullParameter((Object)$completion, (String)"$completion");
        Intrinsics.checkNotNullParameter((Object)$failure, (String)"$failure");
        try {
            $callback.call($argumentsTuple, $completion, $failure);
        }
        catch (Throwable t) {
            $failure.failed(t);
        }
    }

    @FunctionalInterface
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lavail/CallbackSystem$Callback;", "", "call", "", "argumentsTuple", "Lavail/descriptor/tuples/A_Tuple;", "completion", "Lavail/CallbackSystem$CallbackCompletion;", "failure", "Lavail/CallbackSystem$CallbackFailure;", "avail"})
    public static interface Callback {
        public void call(@NotNull A_Tuple var1, @NotNull CallbackCompletion var2, @NotNull CallbackFailure var3);
    }

    @FunctionalInterface
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lavail/CallbackSystem$CallbackCompletion;", "", "complete", "", "result", "Lavail/descriptor/representation/A_BasicObject;", "avail"})
    public static interface CallbackCompletion {
        public void complete(@NotNull A_BasicObject var1);
    }

    @FunctionalInterface
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lavail/CallbackSystem$CallbackFailure;", "", "failed", "", "throwable", "", "avail"})
    public static interface CallbackFailure {
        public void failed(@NotNull Throwable var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J[\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042K\u0010\r\u001aG\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u000eJ\u0016\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lavail/CallbackSystem$Companion;", "", "()V", "callbackTypePojo", "Lavail/descriptor/types/A_Type;", "rawFunctionCache", "Ljava/util/WeakHashMap;", "Lavail/descriptor/functions/A_RawFunction;", "rawFunctionCacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "createCallbackFunction", "Lavail/descriptor/functions/A_Function;", "functionType", "callbackFunction", "Lkotlin/Function3;", "Lavail/descriptor/tuples/A_Tuple;", "Lkotlin/ParameterName;", "name", "argumentsTuple", "Lavail/CallbackSystem$CallbackCompletion;", "completion", "Lavail/CallbackSystem$CallbackFailure;", "failure", "", "createCallbackFunctionInJava", "callback", "Lavail/CallbackSystem$Callback;", "avail"})
    @SourceDebugExtension(value={"SMAP\nCallbackSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallbackSystem.kt\navail/CallbackSystem$Companion\n+ 2 Locks.kt\navail/utility/LocksKt\n*L\n1#1,332:1\n55#2:333\n55#2:334\n*S KotlinDebug\n*F\n+ 1 CallbackSystem.kt\navail/CallbackSystem$Companion\n*L\n290#1:333\n322#1:334\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final A_Function createCallbackFunction(@NotNull A_Type functionType, @NotNull Function3<? super A_Tuple, ? super CallbackCompletion, ? super CallbackFailure, Unit> callbackFunction) {
            A_RawFunction a_RawFunction;
            Intrinsics.checkNotNullParameter((Object)functionType, (String)"functionType");
            Intrinsics.checkNotNullParameter(callbackFunction, (String)"callbackFunction");
            Callback callback2 = new Callback(callbackFunction){
                final /* synthetic */ Function3<A_Tuple, CallbackCompletion, CallbackFailure, Unit> $callbackFunction;
                {
                    this.$callbackFunction = $callbackFunction;
                }

                public void call(@NotNull A_Tuple argumentsTuple, @NotNull CallbackCompletion completion, @NotNull CallbackFailure failure) {
                    Intrinsics.checkNotNullParameter((Object)argumentsTuple, (String)"argumentsTuple");
                    Intrinsics.checkNotNullParameter((Object)completion, (String)"completion");
                    Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
                    this.$callbackFunction.invoke((Object)argumentsTuple, (Object)completion, (Object)failure);
                }
            };
            AvailObject callbackPojo = PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.identityPojo(callback2), callbackTypePojo);
            ReentrantReadWriteLock $this$safeWrite$iv = rawFunctionCacheLock;
            boolean $i$f$safeWrite = false;
            ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
            Lock lock = writeLock;
            lock.lock();
            try {
                boolean bl = false;
                a_RawFunction = rawFunctionCache.computeIfAbsent(functionType, arg_0 -> Companion.createCallbackFunction$lambda$1$lambda$0(createCallbackFunction.rawFunction.1.1.INSTANCE, arg_0));
            }
            finally {
                lock.unlock();
            }
            A_RawFunction rawFunction2 = a_RawFunction;
            Intrinsics.checkNotNull((Object)rawFunction2);
            return FunctionDescriptor.Companion.createWithOuters1(rawFunction2, callbackPojo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final A_Function createCallbackFunctionInJava(@NotNull A_Type functionType, @NotNull Callback callback2) {
            A_RawFunction rawFunction2;
            A_RawFunction a_RawFunction;
            Object object;
            Intrinsics.checkNotNullParameter((Object)functionType, (String)"functionType");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            AvailObject callbackPojo = PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.identityPojo(callback2), callbackTypePojo);
            ReentrantReadWriteLock.ReadLock readLock = rawFunctionCacheLock.readLock();
            readLock.lock();
            try {
                boolean bl = false;
                object = (A_RawFunction)rawFunctionCache.get(functionType);
                a_RawFunction = object;
            }
            finally {
                readLock.unlock();
            }
            A_RawFunction a_RawFunction2 = a_RawFunction;
            if (a_RawFunction == null) {
                ReentrantReadWriteLock $this$safeWrite$iv = rawFunctionCacheLock;
                boolean $i$f$safeWrite = false;
                ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
                object = writeLock;
                object.lock();
                try {
                    boolean bl = false;
                    A_RawFunction a_RawFunction3 = rawFunctionCache.computeIfAbsent(functionType, arg_0 -> Companion.createCallbackFunctionInJava$lambda$4$lambda$3(createCallbackFunctionInJava.rawFunction.2.1.INSTANCE, arg_0));
                    a_RawFunction2 = a_RawFunction3;
                }
                finally {
                    object.unlock();
                }
            }
            A_RawFunction a_RawFunction4 = rawFunction2 = a_RawFunction2;
            Intrinsics.checkNotNull((Object)a_RawFunction4);
            return FunctionDescriptor.Companion.createWithOuters1(a_RawFunction4, callbackPojo);
        }

        private static final A_RawFunction createCallbackFunction$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (A_RawFunction)$tmp0.invoke(p0);
        }

        private static final A_RawFunction createCallbackFunctionInJava$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (A_RawFunction)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

