/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.debugger;

import avail.AvailDebuggerModel;
import avail.AvailRuntime;
import avail.anvil.AdaptiveColor;
import avail.anvil.AvailWorkbench;
import avail.anvil.CodeOverlay;
import avail.anvil.MenuBarBuilder;
import avail.anvil.MenuBuilder;
import avail.anvil.RenderingEngine;
import avail.anvil.SourceCodeInfo;
import avail.anvil.Stylesheet;
import avail.anvil.SwingHelperKt;
import avail.anvil.actions.FindAction;
import avail.anvil.debugger.AbstractDebuggerAction;
import avail.anvil.debugger.AvailDebugger;
import avail.anvil.debugger.AvailDebuggerKt;
import avail.anvil.shortcuts.ResumeActionShortcut;
import avail.anvil.shortcuts.StepIntoShortcut;
import avail.anvil.shortcuts.StepOutShortcut;
import avail.anvil.shortcuts.StepOverShortcut;
import avail.anvil.text.CodePane;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.character.A_Character;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.module.A_Module;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.interpreter.levelOne.L1Disassembler;
import avail.persistence.cache.record.PhrasePathRecord;
import avail.persistence.cache.record.StylingRecord;
import avail.utility.structures.EnumMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.StyledDocument;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f*\t(+05:FJNR\u0018\u00002\u00020\u0001:\u0004{|}~B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u00172\u0006\u0010`\u001a\u00020aJ6\u0010b\u001a\u00020^2\u0006\u0010c\u001a\u00020\u00132$\u0010d\u001a \u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u0006\u0012\u0004\u0012\u00020^0eH\u0002J\u001a\u0010f\u001a\u00020^2\u0012\u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0i0hJ\u0018\u0010j\u001a\u00020^2\u0006\u0010k\u001a\u00020 2\u0006\u0010l\u001a\u00020mH\u0002J\u0006\u0010n\u001a\u00020^J\b\u0010o\u001a\u00020^H\u0002J+\u0010p\u001a\u00020^2#\u0010q\u001a\u001f\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020^0r\u00a2\u0006\u0002\bsJ\r\u0010t\u001a\u00020^H\u0000\u00a2\u0006\u0002\buJ\b\u0010v\u001a\u00020^H\u0002J\b\u0010w\u001a\u00020^H\u0002J\b\u0010x\u001a\u00020^H\u0002J\b\u0010y\u001a\u00020^H\u0002J\b\u0010z\u001a\u00020^H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u00af\u0001\u0010\u001c\u001a\u00a2\u0001\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u00130\u0013\u0012<\u0012:\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u0006 \u001e*\u001c\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u0006\u0018\u00010\u001f0\u001f \u001e*P\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u00130\u0013\u0012<\u0012:\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u0006 \u001e*\u001c\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u0006\u0018\u00010\u001f0\u001f\u0018\u00010\u00060\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010&0&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u0010\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010,R\u000e\u0010-\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020 0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010;R\u000e\u0010<\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010=\u001a\u00020>\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u000e\u0010A\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010C\u001a\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010D0D0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010GR\u000e\u0010H\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u00020JX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010KR\u000e\u0010L\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u00020NX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010OR\u000e\u0010P\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010SR\u000e\u0010T\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020VX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020XX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010Y\u001a\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010Z0Z0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\\\u00a8\u0006\u007f"}, d2={"Lavail/anvil/debugger/AvailDebugger;", "Ljavax/swing/JFrame;", "workbench", "Lavail/anvil/AvailWorkbench;", "(Lavail/anvil/AvailWorkbench;)V", "captureActions", "", "Lavail/descriptor/fiber/FiberDescriptor$FiberKind;", "Ljavax/swing/Action;", "captureButtons", "", "Ljavax/swing/JToggleButton;", "codeGuide", "Lavail/anvil/CodeOverlay;", "getCodeGuide", "()Lavail/anvil/CodeOverlay;", "codeHighlightPainter", "Ljavax/swing/text/DefaultHighlighter$DefaultHighlightPainter;", "currentCode", "Lavail/descriptor/functions/A_RawFunction;", "currentModule", "Lavail/descriptor/module/A_Module;", "currentSource", "", "debuggerModel", "Lavail/AvailDebuggerModel;", "getDebuggerModel", "()Lavail/AvailDebuggerModel;", "disassemblyCache", "", "kotlin.jvm.PlatformType", "Lkotlin/Pair;", "", "Lkotlin/ranges/IntRange;", "disassemblyPane", "Lavail/anvil/text/CodePane;", "fiberListPane", "Ljavax/swing/JList;", "Lavail/descriptor/fiber/A_Fiber;", "inspectFrame", "avail/anvil/debugger/AvailDebugger$inspectFrame$1", "Lavail/anvil/debugger/AvailDebugger$inspectFrame$1;", "inspectVariable", "avail/anvil/debugger/AvailDebugger$inspectVariable$1", "Lavail/anvil/debugger/AvailDebugger$inspectVariable$1;", "lineDelimiter", "lineEnds", "paneVersionTracker", "avail/anvil/debugger/AvailDebugger$paneVersionTracker$1", "Lavail/anvil/debugger/AvailDebugger$paneVersionTracker$1;", "phrasePathRecord", "Lavail/persistence/cache/record/PhrasePathRecord;", "restartAction", "avail/anvil/debugger/AvailDebugger$restartAction$1", "Lavail/anvil/debugger/AvailDebugger$restartAction$1;", "restartButton", "Ljavax/swing/JButton;", "resumeAction", "avail/anvil/debugger/AvailDebugger$resumeAction$1", "Lavail/anvil/debugger/AvailDebugger$resumeAction$1;", "resumeButton", "runtime", "Lavail/AvailRuntime;", "getRuntime", "()Lavail/AvailRuntime;", "secondaryCodeHighlightPainter", "sourcePane", "stackListPane", "Lavail/descriptor/functions/A_Continuation;", "stepIntoAction", "avail/anvil/debugger/AvailDebugger$stepIntoAction$1", "Lavail/anvil/debugger/AvailDebugger$stepIntoAction$1;", "stepIntoButton", "stepOutAction", "avail/anvil/debugger/AvailDebugger$stepOutAction$1", "Lavail/anvil/debugger/AvailDebugger$stepOutAction$1;", "stepOutButton", "stepOverAction", "avail/anvil/debugger/AvailDebugger$stepOverAction$1", "Lavail/anvil/debugger/AvailDebugger$stepOverAction$1;", "stepOverButton", "stepToLineAction", "avail/anvil/debugger/AvailDebugger$stepToLineAction$1", "Lavail/anvil/debugger/AvailDebugger$stepToLineAction$1;", "stepToLineButton", "stylingRecord", "Lavail/persistence/cache/record/StylingRecord;", "variableValuePane", "Ljavax/swing/JTextArea;", "variablesPane", "Lavail/anvil/debugger/AvailDebugger$Variable;", "getWorkbench", "()Lavail/anvil/AvailWorkbench;", "changeCodeFont", "", "name", "updatedSize", "", "disassembledWithMapThen", "code", "then", "Lkotlin/Function2;", "gatherFibers", "fibersProvider", "Lkotlin/Function0;", "", "highlightSourceLine", "lineNumber", "isTopFrame", "", "open", "releaseAllFibers", "runFiberAction", "doAction", "Lkotlin/Function3;", "Lkotlin/ExtensionFunctionType;", "styleCode", "styleCode$avail", "updateDisassemblyAndSourcePanes", "updateFiberList", "updateStackList", "updateVariableValuePane", "updateVariablesList", "FiberRenderer", "FrameRenderer", "Variable", "VariablesRenderer", "avail"})
@SourceDebugExtension(value={"SMAP\nAvailDebugger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvailDebugger.kt\navail/anvil/debugger/AvailDebugger\n+ 2 EnumMap.kt\navail/utility/structures/EnumMap$Companion\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 MenuBarBuilder.kt\navail/anvil/MenuBarBuilder$Companion\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 9 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1234:1\n234#2,3:1235\n237#2:1239\n238#2:1241\n239#2:1243\n13309#3:1238\n13310#3:1242\n1#4:1240\n1#4:1249\n125#5:1244\n152#5,3:1245\n56#6:1248\n37#7,2:1250\n37#7,2:1253\n37#7,2:1266\n26#8:1252\n1549#9:1255\n1620#9,3:1256\n350#9,7:1259\n1855#9,2:1268\n1855#9,2:1270\n*S KotlinDebug\n*F\n+ 1 AvailDebugger.kt\navail/anvil/debugger/AvailDebugger\n*L\n491#1:1235,3\n491#1:1239\n491#1:1241\n491#1:1243\n491#1:1238\n491#1:1242\n491#1:1240\n1167#1:1249\n571#1:1244\n571#1:1245,3\n1167#1:1248\n654#1:1250,2\n703#1:1253,2\n942#1:1266,2\n689#1:1252\n897#1:1255\n897#1:1256,3\n941#1:1259,7\n1081#1:1268,2\n1110#1:1270,2\n*E\n"})
public final class AvailDebugger
extends JFrame {
    @NotNull
    private final AvailWorkbench workbench;
    @NotNull
    private final AvailDebuggerModel debuggerModel;
    @NotNull
    private final AvailRuntime runtime;
    @NotNull
    private final inspectFrame.1 inspectFrame;
    private final Map<A_RawFunction, Pair<String, Map<Integer, IntRange>>> disassemblyCache;
    @NotNull
    private DefaultHighlighter.DefaultHighlightPainter codeHighlightPainter;
    @NotNull
    private DefaultHighlighter.DefaultHighlightPainter secondaryCodeHighlightPainter;
    @NotNull
    private final stepIntoAction.1 stepIntoAction;
    @NotNull
    private final stepOverAction.1 stepOverAction;
    @NotNull
    private final stepOutAction.1 stepOutAction;
    @NotNull
    private final stepToLineAction.1 stepToLineAction;
    @NotNull
    private final resumeAction.1 resumeAction;
    @NotNull
    private final restartAction.1 restartAction;
    @NotNull
    private final Map<FiberDescriptor.FiberKind, Action> captureActions;
    @NotNull
    private final inspectVariable.1 inspectVariable;
    @NotNull
    private final JList<A_Fiber> fiberListPane;
    @NotNull
    private final JList<A_Continuation> stackListPane;
    @NotNull
    private final JButton stepIntoButton;
    @NotNull
    private final JButton stepOverButton;
    @NotNull
    private final JButton stepOutButton;
    @NotNull
    private final JButton stepToLineButton;
    @NotNull
    private final JButton resumeButton;
    @NotNull
    private final JButton restartButton;
    @NotNull
    private final List<JToggleButton> captureButtons;
    @NotNull
    private final CodePane disassemblyPane;
    @NotNull
    private final CodePane sourcePane;
    @NotNull
    private final JList<Variable> variablesPane;
    @NotNull
    private final JTextArea variableValuePane;
    @NotNull
    private A_RawFunction currentCode;
    @NotNull
    private A_Module currentModule;
    @NotNull
    private String currentSource;
    @NotNull
    private String lineDelimiter;
    @NotNull
    private List<Integer> lineEnds;
    @NotNull
    private StylingRecord stylingRecord;
    @NotNull
    private PhrasePathRecord phrasePathRecord;
    @NotNull
    private final paneVersionTracker.1 paneVersionTracker;

    /*
     * WARNING - void declaration
     */
    public AvailDebugger(@NotNull AvailWorkbench workbench) {
        void $this$_init__u24lambda_u2432;
        JMenuBar jMenuBar;
        void $this$variableValuePane_u24lambda_u2414;
        JComponent $this$variablesPane_u24lambda_u2413;
        void $this$mapTo$iv$iv;
        JComponent $this$map$iv;
        void $this$stackListPane_u24lambda_u249;
        JList<A_BasicObject> $this$fiberListPane_u24lambda_u247;
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        super("Avail Debugger");
        this.workbench = workbench;
        this.debuggerModel = new AvailDebuggerModel(this.workbench.getRuntime());
        this.runtime = this.workbench.getRuntime();
        this.inspectFrame = new AbstractDebuggerAction(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Inspect", null, null, 12, null);
            }

            public void updateIsEnabled(boolean busy) {
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    A_Continuation a_Continuation = (A_Continuation)AvailDebugger.access$getStackListPane$p(this.this$0).getSelectedValue();
                    if (a_Continuation == null) break block0;
                    A_Continuation it = a_Continuation;
                    boolean bl = false;
                    AvailDebuggerKt.inspect(A_Continuation.Companion.function(it).code().toString(), (AvailObject)it);
                }
            }
        };
        this.disassemblyCache = Collections.synchronizedMap(new LinkedHashMap());
        this.codeHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.BLACK);
        this.secondaryCodeHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.BLACK);
        Object object = StepIntoShortcut.INSTANCE;
        this.stepIntoAction = new AbstractDebuggerAction(this, (StepIntoShortcut)object){

            public void updateIsEnabled(boolean busy) {
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.getDebugger().runFiberAction((Function3<? super AvailDebuggerModel, ? super A_Fiber, ? super A_Continuation, Unit>)((Function3)stepIntoAction.actionPerformed.1.INSTANCE));
            }
        };
        object = StepOverShortcut.INSTANCE;
        this.stepOverAction = new AbstractDebuggerAction(this, (StepOverShortcut)object){

            public void updateIsEnabled(boolean busy) {
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.getDebugger().runFiberAction((Function3<? super AvailDebuggerModel, ? super A_Fiber, ? super A_Continuation, Unit>)((Function3)stepOverAction.actionPerformed.1.INSTANCE));
            }
        };
        object = StepOutShortcut.INSTANCE;
        this.stepOutAction = new AbstractDebuggerAction(this, (StepOutShortcut)object){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Out (\u21e7F8)", null, $super_call_param$1);
                this.setEnabled(false);
            }

            public void updateIsEnabled(boolean busy) {
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JOptionPane.showMessageDialog(this.this$0, "\"Out\" is not implemented");
            }
        };
        this.stepToLineAction = new AbstractDebuggerAction(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "To Line", null, null, 12, null);
                this.setEnabled(false);
            }

            public void updateIsEnabled(boolean busy) {
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JOptionPane.showMessageDialog(this.this$0, "\"To Line\" is not implemented");
            }
        };
        object = ResumeActionShortcut.INSTANCE;
        this.resumeAction = new AbstractDebuggerAction(this, (ResumeActionShortcut)object){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Resume (\u2318R)", null, $super_call_param$1);
            }

            public void updateIsEnabled(boolean busy) {
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getRuntime().whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ AvailDebugger this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$safeWrite$iv;
                        ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                        AvailDebugger availDebugger = this.this$0;
                        boolean $i$f$safeWrite = false;
                        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
                        Lock lock = writeLock;
                        lock.lock();
                        try {
                            boolean bl = false;
                            SwingUtilities.invokeLater(() -> resumeAction.actionPerformed.1.invoke$lambda$2$lambda$1(availDebugger));
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                    }

                    private static final void invoke$lambda$2$lambda$1(AvailDebugger this$0) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            A_Fiber a_Fiber = (A_Fiber)AvailDebugger.access$getFiberListPane$p(this$0).getSelectedValue();
                            if (a_Fiber == null) break block0;
                            A_Fiber fiber2 = a_Fiber;
                            boolean bl = false;
                            this$0.getDebuggerModel().resume(fiber2);
                        }
                    }
                }));
            }
        };
        this.restartAction = new AbstractDebuggerAction(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Restart", null, null, 12, null);
                this.setEnabled(false);
            }

            public void updateIsEnabled(boolean busy) {
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JOptionPane.showMessageDialog(this.this$0, "\"Restart\" is not implemented");
            }
        };
        object = EnumMap.Companion;
        AvailDebugger availDebugger = this;
        boolean $i$f$enumMap22 = false;
        Enum[] keys$iv = (Enum[])FiberDescriptor.FiberKind.class.getEnumConstants();
        Intrinsics.checkNotNull((Object)keys$iv);
        EnumMap map$iv = new EnumMap(keys$iv);
        Enum[] $this$forEach$iv$iv = keys$iv;
        boolean $i$f$forEach22 = false;
        int n = $this$forEach$iv$iv.length;
        for (int j = 0; j < n; ++j) {
            Enum element$iv$iv;
            Enum key$iv = element$iv$iv = $this$forEach$iv$iv[j];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)key$iv);
            FiberDescriptor.FiberKind fiberKind = (FiberDescriptor.FiberKind)key$iv;
            boolean bl2 = false;
            Object object2 = fiberKind.getVeryShortName();
            Object $this$captureActions_u24lambda_u245_u24lambda_u244 = object2 = new AbstractDebuggerAction(this, fiberKind, (String)object2){
                final /* synthetic */ AvailDebugger this$0;
                final /* synthetic */ FiberDescriptor.FiberKind $fiberKind;
                {
                    this.this$0 = $receiver;
                    this.$fiberKind = $fiberKind;
                    super($receiver, $super_call_param$1, null, null, 12, null);
                }

                /*
                 * Unable to fully structure code
                 */
                public void updateIsEnabled(boolean busy) {
                    if (this.this$0.getDebuggerModel().isCapturingNewFibers(this.$fiberKind)) ** GOTO lbl-1000
                    v0 = this.this$0.getRuntime().getNewFiberHandlers().get((Object)this.$fiberKind);
                    Intrinsics.checkNotNull(v0);
                    if (v0.get() == null) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    this.setEnabled(v1);
                }

                public void actionPerformed(@NotNull ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Object object = e.getSource();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JToggleButton");
                    JToggleButton checkBox = (JToggleButton)object;
                    boolean install = checkBox.isSelected();
                    boolean installed = this.this$0.getDebuggerModel().installFiberCapture(this.$fiberKind, install);
                    if (!installed) {
                        String un = install ? "" : "un";
                        JOptionPane.showMessageDialog(this.this$0, "Could not " + un + "install capture mode for " + this.$fiberKind + " fibers for this debugger", "Warning", 2);
                    }
                    checkBox.setSelected(this.this$0.getDebuggerModel().isCapturingNewFibers(this.$fiberKind));
                }
            };
            boolean bl3 = false;
            if (fiberKind.getIcon() != null) {
                ImageIcon icon;
                boolean bl4 = false;
                ((AbstractAction)$this$captureActions_u24lambda_u245_u24lambda_u244).putValue("SmallIcon", icon);
            }
            Object value$iv = object2;
            boolean bl5 = false;
            map$iv.set(key$iv, value$iv);
        }
        availDebugger.captureActions = map$iv;
        this.inspectVariable = new AbstractDebuggerAction(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super($receiver, "Inspect", null, null, 12, null);
            }

            public void updateIsEnabled(boolean busy) {
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Variable variable = (Variable)AvailDebugger.access$getVariablesPane$p(this.this$0).getSelectedValue();
                    if (variable == null) break block0;
                    Variable $this$actionPerformed_u24lambda_u240 = variable;
                    boolean bl = false;
                    AvailDebuggerKt.inspect($this$actionPerformed_u24lambda_u240.getName(), $this$actionPerformed_u24lambda_u240.getValue());
                }
            }
        };
        Object this_$iv = new JList<A_Fiber>(new A_Fiber[0]);
        JList<A_Fiber> $i$f$enumMap22 = this_$iv;
        availDebugger = this;
        boolean bl = false;
        $this$fiberListPane_u24lambda_u247.setCellRenderer(new FiberRenderer());
        $this$fiberListPane_u24lambda_u247.setSelectionMode(0);
        $this$fiberListPane_u24lambda_u247.getSelectionModel().addListSelectionListener(arg_0 -> AvailDebugger.fiberListPane$lambda$7$lambda$6(this, arg_0));
        availDebugger.fiberListPane = this_$iv;
        this_$iv = new JList<A_Continuation>(new A_Continuation[0]);
        $this$fiberListPane_u24lambda_u247 = this_$iv;
        availDebugger = this;
        boolean $i$a$-apply-AvailDebugger$stackListPane$22 = false;
        $this$stackListPane_u24lambda_u249.setCellRenderer(new FrameRenderer());
        $this$stackListPane_u24lambda_u249.setSelectionMode(0);
        $this$stackListPane_u24lambda_u249.getSelectionModel().addListSelectionListener(arg_0 -> AvailDebugger.stackListPane$lambda$9$lambda$8(this, arg_0));
        availDebugger.stackListPane = this_$iv;
        this.stepIntoButton = new JButton(this.stepIntoAction);
        this.stepOverButton = new JButton(this.stepOverAction);
        this.stepOutButton = new JButton(this.stepOutAction);
        this.stepToLineButton = new JButton(this.stepToLineAction);
        this.resumeButton = new JButton(this.resumeAction);
        this.restartButton = new JButton(this.restartAction);
        this_$iv = this.captureActions;
        availDebugger = this;
        boolean $i$f$map22 = false;
        void $i$a$-apply-AvailDebugger$stackListPane$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Object $i$f$forEach22 = $this$mapTo$iv$iv.entrySet().iterator();
        while ($i$f$forEach22.hasNext()) {
            JToggleButton jToggleButton;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = $i$f$forEach22.next();
            Collection collection2 = destination$iv$iv;
            boolean bl6 = false;
            FiberDescriptor.FiberKind kind2 = (FiberDescriptor.FiberKind)((Object)entry.getKey());
            Action action2 = (Action)entry.getValue();
            JToggleButton $this$captureButtons_u24lambda_u2411_u24lambda_u2410 = jToggleButton = new JToggleButton(action2);
            boolean bl7 = false;
            $this$captureButtons_u24lambda_u2411_u24lambda_u2410.setToolTipText(kind2.name());
            $this$captureButtons_u24lambda_u2411_u24lambda_u2410.setIcon((Icon)action2.getValue("SmallIcon"));
            collection2.add(jToggleButton);
        }
        availDebugger.captureButtons = (List)destination$iv$iv;
        this.disassemblyPane = new CodePane(this.workbench, false, null, 4, null);
        this.sourcePane = new CodePane(this.workbench, false, null, 4, null);
        JList<Variable> $i$f$map22 = $this$map$iv = new JList<Variable>(new Variable[0]);
        availDebugger = this;
        boolean bl8 = false;
        $this$variablesPane_u24lambda_u2413.setCellRenderer(new VariablesRenderer());
        $this$variablesPane_u24lambda_u2413.setSelectionMode(0);
        $this$variablesPane_u24lambda_u2413.getSelectionModel().addListSelectionListener(arg_0 -> AvailDebugger.variablesPane$lambda$13$lambda$12(this, arg_0));
        availDebugger.variablesPane = $this$map$iv;
        $this$variablesPane_u24lambda_u2413 = $this$map$iv = new JTextArea();
        availDebugger = this;
        boolean bl9 = false;
        $this$variableValuePane_u24lambda_u2414.setTabSize(2);
        availDebugger.variableValuePane = $this$map$iv;
        this.currentCode = NilDescriptor.Companion.getNil();
        this.currentModule = NilDescriptor.Companion.getNil();
        this.currentSource = "";
        this.lineDelimiter = "";
        this.lineEnds = CollectionsKt.emptyList();
        this.stylingRecord = new StylingRecord(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        this.phrasePathRecord = new PhrasePathRecord(null, 1, null);
        this.paneVersionTracker = new Object(){
            @NotNull
            private final AtomicLong allocator;
            private long renderedVersion;
            {
                this.allocator = new AtomicLong(0L);
                this.renderedVersion = -1L;
            }

            @NotNull
            public final AtomicLong getAllocator() {
                return this.allocator;
            }

            public final long getRenderedVersion() {
                return this.renderedVersion;
            }

            public final void setRenderedVersion(long l) {
                this.renderedVersion = l;
            }
        };
        this_$iv = MenuBarBuilder.Companion;
        boolean $i$f$createMenuBar = false;
        JMenuBar it$iv = jMenuBar = new JMenuBar();
        boolean bl10 = false;
        $i$f$forEach22 = new MenuBarBuilder(it$iv);
        availDebugger = this;
        boolean bl11 = false;
        $this$_init__u24lambda_u2432.menu("Edit", (Function1<? super MenuBuilder, Unit>)((Function1)new Function1<MenuBuilder, Unit>(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MenuBuilder $this$menu) {
                Intrinsics.checkNotNullParameter((Object)$this$menu, (String)"$this$menu");
                $this$menu.item(new FindAction(this.this$0.getWorkbench(), this.this$0));
            }
        }));
        SwingHelperKt.addWindowMenu((MenuBarBuilder)$this$_init__u24lambda_u2432, this);
        availDebugger.setJMenuBar(jMenuBar);
    }

    @NotNull
    public final AvailWorkbench getWorkbench() {
        return this.workbench;
    }

    @NotNull
    public final AvailDebuggerModel getDebuggerModel() {
        return this.debuggerModel;
    }

    @NotNull
    public final AvailRuntime getRuntime() {
        return this.runtime;
    }

    private final void disassembledWithMapThen(A_RawFunction code, Function2<? super String, ? super Map<Integer, IntRange>, Unit> then) {
        Pair<String, Map<Integer, IntRange>> pair = this.disassemblyCache.get(code);
        if (pair != null) {
            Pair<String, Map<Integer, IntRange>> it = pair;
            boolean bl = false;
            then.invoke(it.getFirst(), it.getSecond());
            return;
        }
        this.runtime.whenRunningInterpretersDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this, code, then){
            final /* synthetic */ AvailDebugger this$0;
            final /* synthetic */ A_RawFunction $code;
            final /* synthetic */ Function2<String, Map<Integer, IntRange>, Unit> $then;
            {
                this.this$0 = $receiver;
                this.$code = $code;
                this.$then = $then;
                super(0);
            }

            public final void invoke() {
                Map map = new LinkedHashMap<K, V>();
                Object object = this.$code;
                Object object2 = new StringBuilder();
                StringBuilder $this$invoke_u24lambda_u240 = object2;
                boolean bl = false;
                new L1Disassembler((A_RawFunction)object).printInstructions(new IdentityHashMap<A_BasicObject, Void>(10), 0, (Function3<? super Integer, ? super Integer, ? super String, Unit>)((Function3)new Function3<Integer, Integer, String, Unit>($this$invoke_u24lambda_u240, (Map<Integer, IntRange>)map){
                    final /* synthetic */ StringBuilder $this_buildString;
                    final /* synthetic */ Map<Integer, IntRange> $map;
                    {
                        this.$this_buildString = $receiver;
                        this.$map = $map;
                        super(3);
                    }

                    public final void invoke(int pc, int line, @NotNull String string2) {
                        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
                        int before = this.$this_buildString.length();
                        this.$this_buildString.append(pc + ". [:" + line + "] " + string2);
                        Integer n = pc;
                        this.$map.put(n, new IntRange(before, this.$this_buildString.length()));
                        this.$this_buildString.append("\n");
                    }
                }));
                int pcPastEnd = A_RawFunction.Companion.getNumNybbles((A_RawFunction)object) + 1;
                int returnStart = $this$invoke_u24lambda_u240.length();
                $this$invoke_u24lambda_u240.append("(" + pcPastEnd + ". return)");
                Integer n = pcPastEnd;
                map.put(n, new IntRange(returnStart, $this$invoke_u24lambda_u240.length()));
                $this$invoke_u24lambda_u240.append("\n");
                String string2 = ((StringBuilder)object2).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                String string3 = string2;
                Map map2 = AvailDebugger.access$getDisassemblyCache$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"access$getDisassemblyCache$p(...)");
                object = map2;
                object2 = this.$code;
                Pair pair = TuplesKt.to((Object)string3, (Object)map);
                object.put(object2, pair);
                this.$then.invoke((Object)string3, (Object)map);
            }
        }));
    }

    public final void runFiberAction(@NotNull Function3<? super AvailDebuggerModel, ? super A_Fiber, ? super A_Continuation, Unit> doAction) {
        block1: {
            A_Continuation a_Continuation;
            Intrinsics.checkNotNullParameter(doAction, (String)"doAction");
            A_Fiber a_Fiber = this.fiberListPane.getSelectedValue();
            if (a_Fiber == null) break block1;
            A_Fiber fiber2 = a_Fiber;
            boolean bl = false;
            A_Continuation a_Continuation2 = a_Continuation = this.stackListPane.getSelectedValue();
            if (a_Continuation2 != null) {
                Intrinsics.checkNotNull((Object)a_Continuation2);
                A_Continuation continuation = a_Continuation;
                boolean bl2 = false;
                this.debuggerModel.runFiberAction(fiber2, continuation, doAction);
            }
        }
    }

    public final void changeCodeFont(@NotNull String name, float updatedSize) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.disassemblyPane.setFont(Font.decode(name).deriveFont(updatedSize));
        this.sourcePane.setFont(Font.decode(name).deriveFont(updatedSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateFiberList() {
        JList<A_Fiber> $this$updateFiberList_u24lambda_u2415 = this.fiberListPane;
        boolean bl = false;
        boolean bl2 = SwingUtilities.isEventDispatchThread();
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Fiber oldFiber = $this$updateFiberList_u24lambda_u2415.getSelectedValue();
        boolean changedFiber = false;
        boolean wasAdjusting = $this$updateFiberList_u24lambda_u2415.getValueIsAdjusting();
        Collection $this$toTypedArray$iv = this.debuggerModel.getDebuggedFibers();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] newArray = thisCollection$iv.toArray(new A_Fiber[0]);
        $this$updateFiberList_u24lambda_u2415.setValueIsAdjusting(true);
        try {
            $this$updateFiberList_u24lambda_u2415.setListData((A_Fiber[])newArray);
            int newIndex = ArraysKt.indexOf((Object[])newArray, (Object)oldFiber);
            if (newIndex == -1 && !(newArray.length == 0)) {
                newIndex = newArray.length - 1;
                changedFiber = true;
            }
            $this$updateFiberList_u24lambda_u2415.setSelectedIndex(newIndex);
        }
        finally {
            $this$updateFiberList_u24lambda_u2415.setValueIsAdjusting(wasAdjusting);
        }
        if (changedFiber) {
            this.updateStackList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateStackList() {
        boolean bl = SwingUtilities.isEventDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Fiber fiber2 = this.fiberListPane.getSelectedValue();
        if (fiber2 == null) {
            boolean $i$f$emptyArray = false;
            this.stackListPane.setListData((A_Continuation[])new A_Continuation[0]);
        } else {
            AvailObject frame = A_Fiber.Companion.getContinuation(fiber2).makeShared();
            List frames = new ArrayList();
            while (frame.getNotNil()) {
                frames.add(frame);
                A_Continuation a_Continuation = A_Continuation.Companion.caller(frame);
                Intrinsics.checkNotNull((Object)a_Continuation, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                frame = (AvailObject)a_Continuation;
            }
            this.stackListPane.setValueIsAdjusting(true);
            try {
                Collection $this$toTypedArray$iv = frames;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                this.stackListPane.setListData((A_Continuation[])thisCollection$iv.toArray(new A_Continuation[0]));
                int[] nArray = new int[]{0};
                this.stackListPane.setSelectedIndices(nArray);
            }
            finally {
                this.stackListPane.setValueIsAdjusting(false);
            }
        }
    }

    private final void updateDisassemblyAndSourcePanes() {
        boolean bl = SwingUtilities.isEventDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean isTopFrame = this.stackListPane.getSelectedIndex() == 0;
        A_Continuation frame = this.stackListPane.getSelectedValue();
        if (frame == null) {
            this.currentCode = NilDescriptor.Companion.getNil();
            this.disassemblyPane.getHighlighter().removeAllHighlights();
            this.disassemblyPane.setText("");
            this.sourcePane.getHighlighter().removeAllHighlights();
            this.sourcePane.setText("");
        } else {
            A_RawFunction code = A_Continuation.Companion.function(frame).code();
            this.disassembledWithMapThen(code, (Function2<? super String, ? super Map<Integer, IntRange>, Unit>)((Function2)new Function2<String, Map<Integer, ? extends IntRange>, Unit>(code, this, frame, isTopFrame){
                final /* synthetic */ A_RawFunction $code;
                final /* synthetic */ AvailDebugger this$0;
                final /* synthetic */ A_Continuation $frame;
                final /* synthetic */ boolean $isTopFrame;
                {
                    this.$code = $code;
                    this.this$0 = $receiver;
                    this.$frame = $frame;
                    this.$isTopFrame = $isTopFrame;
                    super(2);
                }

                public final void invoke(@NotNull String text, @NotNull Map<Integer, IntRange> map) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Intrinsics.checkNotNullParameter(map, (String)"map");
                    SwingUtilities.invokeLater(() -> updateDisassemblyAndSourcePanes.1.invoke$lambda$2(this.$code, this.this$0, text, this.$frame, this.$isTopFrame, map));
                }

                private static final void invoke$lambda$2(A_RawFunction $code, AvailDebugger this$0, String $text, A_Continuation $frame, boolean $isTopFrame, Map $map) {
                    block8: {
                        int n;
                        Intrinsics.checkNotNullParameter((Object)$code, (String)"$code");
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
                        Intrinsics.checkNotNullParameter((Object)$map, (String)"$map");
                        if (!$code.equals(AvailDebugger.access$getCurrentCode$p(this$0))) {
                            AvailDebugger.access$setCurrentCode$p(this$0, $code);
                            AvailDebugger.access$getDisassemblyPane$p(this$0).setText($text);
                        }
                        Intrinsics.checkNotNull((Object)$frame);
                        int pc = A_Continuation.Companion.pc($frame);
                        if ($isTopFrame) {
                            n = A_Continuation.Companion.pc($frame);
                        } else {
                            Iterator<T> iterator2 = ((Iterable)$map.keySet()).iterator();
                            if (!iterator2.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            int it = ((Number)iterator2.next()).intValue();
                            boolean bl = false;
                            int n2 = it = it < pc ? it : Integer.MIN_VALUE;
                            while (iterator2.hasNext()) {
                                int it2 = ((Number)iterator2.next()).intValue();
                                $i$a$-maxOf-AvailDebugger$updateDisassemblyAndSourcePanes$1$1$highlightPc$1 = false;
                                int n3 = it2 < pc ? it2 : Integer.MIN_VALUE;
                                if (it >= n3) continue;
                                it = n3;
                            }
                            n = it;
                        }
                        int highlightPc = n;
                        AvailDebugger.access$getDisassemblyPane$p(this$0).getHighlighter().removeAllHighlights();
                        IntRange intRange = (IntRange)$map.get(highlightPc);
                        if (intRange == null) break block8;
                        IntRange range = intRange;
                        boolean bl = false;
                        AvailDebugger.access$getDisassemblyPane$p(this$0).getHighlighter().addHighlight(range.getFirst(), range.getLast() + 1, $isTopFrame ? AvailDebugger.access$getCodeHighlightPainter$p(this$0) : AvailDebugger.access$getSecondaryCodeHighlightPainter$p(this$0));
                        try {
                            AvailDebugger.access$getDisassemblyPane$p(this$0).select(range.getFirst(), range.getLast() + 1);
                            SwingHelperKt.showTextRange(AvailDebugger.access$getDisassemblyPane$p(this$0), range.getFirst(), range.getLast() + 1);
                        }
                        catch (BadLocationException badLocationException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
            }));
            A_Module module = A_RawFunction.Companion.getModule(code);
            if (!module.equals(this.currentModule)) {
                this.currentModule = module;
                if (module.getNotNil()) {
                    this.sourcePane.setText("Fetching source...");
                    SourceCodeInfo.Companion.sourceWithInfoThen(this.runtime, module, (Function3<? super String, ? super String, ? super List<Integer>, Unit>)((Function3)new Function3<String, String, List<? extends Integer>, Unit>(this, module, frame, isTopFrame){
                        final /* synthetic */ AvailDebugger this$0;
                        final /* synthetic */ A_Module $module;
                        final /* synthetic */ A_Continuation $frame;
                        final /* synthetic */ boolean $isTopFrame;
                        {
                            this.this$0 = $receiver;
                            this.$module = $module;
                            this.$frame = $frame;
                            this.$isTopFrame = $isTopFrame;
                            super(3);
                        }

                        public final void invoke(@NotNull String src, @NotNull String delimiter, @NotNull List<Integer> ends) {
                            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                            Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
                            Intrinsics.checkNotNullParameter(ends, (String)"ends");
                            SwingUtilities.invokeLater(() -> updateDisassemblyAndSourcePanes.2.invoke$lambda$1(this.this$0, src, delimiter, ends, this.$module, this.$frame, this.$isTopFrame));
                        }

                        private static final void invoke$lambda$1$lambda$0(AvailDebugger this$0, A_Continuation $frame, boolean $isTopFrame) {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Intrinsics.checkNotNull((Object)$frame);
                            AvailDebugger.access$highlightSourceLine(this$0, A_Continuation.Companion.currentLineNumber($frame, $isTopFrame), $isTopFrame);
                        }

                        private static final void invoke$lambda$1(AvailDebugger this$0, String $src, String $delimiter, List $ends, A_Module $module, A_Continuation $frame, boolean $isTopFrame) {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Intrinsics.checkNotNullParameter((Object)$src, (String)"$src");
                            Intrinsics.checkNotNullParameter((Object)$delimiter, (String)"$delimiter");
                            Intrinsics.checkNotNullParameter((Object)$ends, (String)"$ends");
                            Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
                            AvailDebugger.access$setCurrentSource$p(this$0, $src);
                            AvailDebugger.access$setLineDelimiter$p(this$0, $delimiter);
                            AvailDebugger.access$setLineEnds$p(this$0, $ends);
                            AvailDebugger.access$setStylingRecord$p(this$0, A_Module.Companion.stylingRecord($module));
                            StyledDocument doc = AvailDebugger.access$getSourcePane$p(this$0).getStyledDocument();
                            doc.remove(0, doc.getLength());
                            doc.insertString(0, $src, null);
                            this$0.styleCode$avail();
                            SwingUtilities.invokeLater(() -> updateDisassemblyAndSourcePanes.2.invoke$lambda$1$lambda$0(this$0, $frame, $isTopFrame));
                        }
                    }));
                } else {
                    this.currentSource = "";
                    this.sourcePane.setText("(no module)");
                }
            } else {
                SwingUtilities.invokeLater(() -> AvailDebugger.updateDisassemblyAndSourcePanes$lambda$16(this, frame, isTopFrame));
            }
        }
    }

    public final void styleCode$avail() {
        Stylesheet stylesheet = this.workbench.getStylesheet();
        this.sourcePane.setBackground(this.sourcePane.computeBackground$avail(stylesheet));
        this.sourcePane.setForeground(this.sourcePane.computeForeground$avail(stylesheet));
        this.getCodeGuide().setGuideColor(this.getCodeGuide().computeColor());
        StyledDocument styledDocument = this.sourcePane.getStyledDocument();
        Intrinsics.checkNotNullExpressionValue((Object)styledDocument, (String)"getStyledDocument(...)");
        RenderingEngine.INSTANCE.applyStylesAndPhrasePaths(styledDocument, stylesheet, this.stylingRecord, this.phrasePathRecord);
    }

    private final void highlightSourceLine(int lineNumber, boolean isTopFrame) {
        if (lineNumber == 0) {
            return;
        }
        int rangeStart = lineNumber <= 1 ? 0 : (lineNumber <= this.lineEnds.size() + 1 ? ((Number)this.lineEnds.get(lineNumber - 2)).intValue() + 1 : this.currentSource.length());
        int rangeEnd = this.lineEnds.isEmpty() ? this.currentSource.length() : (lineNumber <= 1 ? ((Number)this.lineEnds.get(0)).intValue() : (lineNumber <= this.lineEnds.size() ? ((Number)this.lineEnds.get(lineNumber - 1)).intValue() : this.currentSource.length()));
        this.sourcePane.getHighlighter().removeAllHighlights();
        this.sourcePane.getHighlighter().addHighlight(rangeStart, rangeEnd + 1, isTopFrame ? this.codeHighlightPainter : this.secondaryCodeHighlightPainter);
        this.sourcePane.select(rangeStart, rangeEnd);
        SwingHelperKt.showTextRange(this.sourcePane, rangeStart, rangeEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateVariablesList() {
        Variable variable = this.variablesPane.getSelectedValue();
        String oldName = variable != null ? variable.getName() : null;
        List entries2 = new ArrayList();
        A_Continuation a_Continuation = this.stackListPane.getSelectedValue();
        if (a_Continuation != null) {
            int n;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            A_Continuation frame = a_Continuation;
            boolean bl = false;
            A_Function function = A_Continuation.Companion.function(frame);
            A_RawFunction code = function.code();
            int numArgs = A_RawFunction.Companion.numArgs(code);
            int numLocals = A_RawFunction.Companion.getNumLocals(code);
            int numConstants = A_RawFunction.Companion.getNumConstants(code);
            int numOuters = A_RawFunction.Companion.getNumOuters(code);
            Iterable iterable = A_RawFunction.Companion.getDeclarationNames(code);
            int $i$f$map = 0;
            void var15_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AvailObject availObject = (AvailObject)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(A_String.Companion.asNativeString((A_String)it));
            }
            Iterator names = ((List)destination$iv$iv).iterator();
            int frameIndex = 0;
            frameIndex = 1;
            $i$f$map = 0;
            while ($i$f$map < numArgs) {
                int it = $i$f$map++;
                boolean bl3 = false;
                n = frameIndex;
                frameIndex = n + 1;
                entries2.add(new Variable("[arg] " + names.next(), A_Continuation.Companion.frameAt(frame, n)));
            }
            $i$f$map = 0;
            while ($i$f$map < numLocals) {
                int it = $i$f$map++;
                boolean bl4 = false;
                n = frameIndex;
                frameIndex = n + 1;
                entries2.add(new Variable("[local] " + names.next(), A_Continuation.Companion.frameAt(frame, n)));
            }
            $i$f$map = 0;
            while ($i$f$map < numConstants) {
                int it = $i$f$map++;
                boolean bl5 = false;
                n = frameIndex;
                frameIndex = n + 1;
                entries2.add(new Variable("[const] " + names.next(), A_Continuation.Companion.frameAt(frame, n)));
            }
            int i2 = 1;
            if (i2 <= numOuters) {
                while (true) {
                    entries2.add(new Variable("[outer] " + names.next(), function.outerVarAt(i2)));
                    if (i2 == numOuters) break;
                    ++i2;
                }
            }
            i2 = A_Continuation.Companion.numSlots(frame);
            int n2 = A_Continuation.Companion.stackp(frame);
            if (n2 <= i2) {
                while (true) {
                    Object name = i2 == A_Continuation.Companion.stackp(frame) ? "stack top" : "stack [" + i2 + "]";
                    entries2.add(new Variable((String)name, A_Continuation.Companion.frameAt(frame, i2)));
                    if (i2 == n2) break;
                    --i2;
                }
            }
        }
        this.variablesPane.setValueIsAdjusting(true);
        try {
            int[] nArray;
            int n;
            block16: {
                List $this$indexOfFirst$iv = entries2;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    Variable it = (Variable)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)oldName)) {
                        n = index$iv;
                        break block16;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int index2 = n;
            Collection $this$toTypedArray$iv = entries2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.variablesPane.setListData((Variable[])thisCollection$iv.toArray(new Variable[0]));
            if (index2 == -1) {
                nArray = new int[]{};
            } else {
                int[] nArray2 = new int[]{index2};
                nArray = nArray2;
            }
            this.variablesPane.setSelectedIndices(nArray);
        }
        finally {
            this.variablesPane.setValueIsAdjusting(false);
        }
    }

    private final void updateVariableValuePane() {
        long id = this.paneVersionTracker.getAllocator().getAndIncrement();
        Variable variable = this.variablesPane.getSelectedValue();
        A_Atom valueToStringify = variable == null ? AtomDescriptor.Companion.getTrueObject() : (variable.getValue().isNil() ? AtomDescriptor.Companion.getTrueObject() : (A_Atom)variable.getValue());
        AvailRuntime.stringifyThen$default(this.runtime, valueToStringify, null, updateVariableValuePane.1.INSTANCE, (Function1)new Function1<String, Unit>(variable, id, this){
            final /* synthetic */ Variable $variable;
            final /* synthetic */ long $id;
            final /* synthetic */ AvailDebugger this$0;
            {
                this.$variable = $variable;
                this.$id = $id;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string2 = this.$variable == null ? "" : (this.$variable.getValue().isNil() ? "nil\n" : this.$variable.getValue().getTypeTag() + "\n\n" + it + "\n");
                SwingUtilities.invokeLater(() -> updateVariableValuePane.2.invoke$lambda$0(this.$id, this.this$0, string2));
            }

            private static final void invoke$lambda$0(long $id, AvailDebugger this$0, String $string) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$string, (String)"$string");
                if ($id > AvailDebugger.access$getPaneVersionTracker$p(this$0).getRenderedVersion()) {
                    AvailDebugger.access$getVariableValuePane$p(this$0).setText($string);
                    AvailDebugger.access$getPaneVersionTracker$p(this$0).setRenderedVersion($id);
                }
            }
        }, 2, null);
    }

    private final CodeOverlay getCodeGuide() {
        return SwingHelperKt.getCodeOverlay(this.sourcePane);
    }

    /*
     * WARNING - void declaration
     */
    public final void open() {
        void $this$open_u24lambda_u2431;
        Object $this$open_u24lambda_u2430;
        Object $this$open_u24lambda_u2429;
        AvailDebugger $this$open_u24lambda_u2428;
        GroupLayout.Group $this$open_u24lambda_u2427_u24lambda_u2424;
        JToggleButton it;
        AvailDebugger $this$open_u24lambda_u2427;
        this.debuggerModel.getWhenPausedActions().add(new Function1<A_Fiber, Unit>(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull A_Fiber it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it == AvailDebugger.access$getFiberListPane$p(this.this$0).getSelectedValue()) {
                    if (A_Fiber.Companion.getExecutionState(it).getIndicatesTermination()) {
                        AvailDebugger.access$updateFiberList(this.this$0);
                    } else {
                        AvailDebugger.access$updateStackList(this.this$0);
                    }
                }
                this.this$0.repaint();
            }
        });
        this.debuggerModel.getWhenAddedFiberActions().add(new Function1<A_Fiber, Unit>(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull A_Fiber it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AvailDebugger.access$updateFiberList(this.this$0);
            }
        });
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ AvailDebugger this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void windowClosing(@NotNull WindowEvent e) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getWorkbench().closeDebugger(this.this$0);
                AvailDebugger.access$releaseAllFibers(this.this$0);
                FiberDescriptor.FiberKind[] fiberKindArray = FiberDescriptor.FiberKind.Companion.getAll();
                AvailDebugger availDebugger = this.this$0;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv;
                    void kind2 = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    if (!availDebugger.getDebuggerModel().isCapturingNewFibers((FiberDescriptor.FiberKind)kind2)) continue;
                    availDebugger.getDebuggerModel().installFiberCapture((FiberDescriptor.FiberKind)kind2, false);
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout(20, 20));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(panel.getBackground());
        Object object = new GroupLayout(panel);
        GroupLayout groupLayout = object;
        Container container = panel;
        boolean bl = false;
        int pref = -2;
        int max2 = Integer.MAX_VALUE;
        ((GroupLayout)((Object)$this$open_u24lambda_u2427)).setAutoCreateGaps(true);
        Component[] componentArray = ((GroupLayout)((Object)$this$open_u24lambda_u2427)).createSequentialGroup();
        GroupLayout.SequentialGroup sequentialGroup = componentArray;
        GroupLayout.Group group = ((GroupLayout)((Object)$this$open_u24lambda_u2427)).createSequentialGroup().addComponent(this.stepIntoButton).addComponent(this.stepOverButton).addComponent(this.stepOutButton).addComponent(this.stepToLineButton).addComponent(this.resumeButton).addComponent(this.restartButton);
        GroupLayout.Group group2 = ((GroupLayout)((Object)$this$open_u24lambda_u2427)).createParallelGroup().addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2427)).createSequentialGroup().addComponent(SwingHelperKt.scroll(this.fiberListPane), 100, 100, max2).addComponent(SwingHelperKt.scroll(this.stackListPane), 200, 200, max2));
        void var11_14 = $this$open_u24lambda_u2427;
        boolean bl2 = false;
        Iterable $this$forEach$iv = this.captureButtons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JToggleButton)element$iv;
            boolean bl3 = false;
            $this$open_u24lambda_u2427_u24lambda_u2424.addComponent(it);
        }
        Unit unit = Unit.INSTANCE;
        var11_14.setHorizontalGroup(((GroupLayout.ParallelGroup)group2).addGroup(((GroupLayout.SequentialGroup)group).addGroup((GroupLayout.Group)componentArray)).addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2427)).createSequentialGroup().addComponent(SwingHelperKt.scroll(this.disassemblyPane), 100, 100, max2).addComponent(SwingHelperKt.scrollTextWithLineNumbers(this.sourcePane, this.workbench, this.workbench.getGlobalSettings().getEditorGuideLines()), 100, 100, max2)).addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2427)).createSequentialGroup().addComponent(SwingHelperKt.scroll(this.variablesPane), 60, 60, max2).addComponent(SwingHelperKt.scroll(this.variableValuePane), 100, 100, max2)));
        componentArray = ((GroupLayout)((Object)$this$open_u24lambda_u2427)).createParallelGroup();
        $this$open_u24lambda_u2427_u24lambda_u2424 = componentArray;
        group = ((GroupLayout)((Object)$this$open_u24lambda_u2427)).createParallelGroup().addComponent(this.stepIntoButton, pref, pref, pref).addComponent(this.stepOverButton, pref, pref, pref).addComponent(this.stepOutButton, pref, pref, pref).addComponent(this.stepToLineButton, pref, pref, pref).addComponent(this.resumeButton, pref, pref, pref).addComponent(this.restartButton, pref, pref, pref);
        group2 = ((GroupLayout)((Object)$this$open_u24lambda_u2427)).createSequentialGroup().addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2427)).createParallelGroup().addComponent(SwingHelperKt.scroll(this.fiberListPane), 60, 60, max2).addComponent(SwingHelperKt.scroll(this.stackListPane), 60, 60, max2));
        var11_14 = $this$open_u24lambda_u2427;
        boolean bl4 = false;
        $this$forEach$iv = this.captureButtons;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$open_u24lambda_u2427_u24lambda_u2426;
            it = (JToggleButton)element$iv;
            boolean bl5 = false;
            $this$open_u24lambda_u2427_u24lambda_u2426.addComponent(it, pref, pref, pref);
        }
        unit = Unit.INSTANCE;
        var11_14.setVerticalGroup(((GroupLayout.SequentialGroup)group2).addGroup(((GroupLayout.ParallelGroup)group).addGroup((GroupLayout.Group)componentArray)).addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2427)).createParallelGroup().addComponent(SwingHelperKt.scroll(this.disassemblyPane), 150, 150, max2).addComponent(SwingHelperKt.scrollTextWithLineNumbers(this.sourcePane, this.workbench, this.workbench.getGlobalSettings().getEditorGuideLines()), 150, 150, max2)).addGroup(((GroupLayout)((Object)$this$open_u24lambda_u2427)).createParallelGroup().addComponent(SwingHelperKt.scroll(this.variablesPane), 80, 80, max2).addComponent(SwingHelperKt.scroll(this.variableValuePane), 80, 80, max2)));
        componentArray = new Component[]{this.stepIntoButton, this.stepOverButton, this.stepOutButton, this.stepToLineButton, this.resumeButton, this.restartButton};
        ((GroupLayout)((Object)$this$open_u24lambda_u2427)).linkSize(0, componentArray);
        container.setLayout((LayoutManager)object);
        this.setMinimumSize(new Dimension(550, 350));
        this.setPreferredSize(new Dimension(1000, 1000));
        this.add(panel);
        this.pack();
        $this$open_u24lambda_u2427 = this;
        container = this;
        boolean bl6 = false;
        Color selectionColor = $this$open_u24lambda_u2428.disassemblyPane.getSelectionColor();
        Color color = selectionColor.darker();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"darker(...)");
        Color color2 = selectionColor.brighter();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"brighter(...)");
        AdaptiveColor adaptiveColor = new AdaptiveColor(color, color2);
        Color color3 = $this$open_u24lambda_u2428.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getBackground(...)");
        AdaptiveColor currentLineColor = adaptiveColor.blend(color3, 0.2f);
        ((AvailDebugger)container).codeHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(currentLineColor.getColor());
        $this$open_u24lambda_u2428 = this;
        container = this;
        boolean bl7 = false;
        Color color4 = ((AvailDebugger)$this$open_u24lambda_u2429).codeHighlightPainter.getColor();
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getColor(...)");
        Color color5 = ((Window)$this$open_u24lambda_u2429).getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"getBackground(...)");
        Color washedOut = AdaptiveColor.Companion.blend(color4, color5, 0.5f);
        ((AvailDebugger)container).secondaryCodeHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(washedOut);
        $this$open_u24lambda_u2429 = object = new JPopupMenu("Stack");
        container = this.stackListPane;
        boolean bl8 = false;
        ((JPopupMenu)$this$open_u24lambda_u2430).add(this.inspectFrame);
        ((JComponent)container).setComponentPopupMenu((JPopupMenu)object);
        $this$open_u24lambda_u2430 = object = new JPopupMenu("Variable");
        container = this.variablesPane;
        boolean bl9 = false;
        $this$open_u24lambda_u2431.add(this.inspectVariable);
        ((JComponent)container).setComponentPopupMenu((JPopupMenu)object);
        this.setVisible(true);
        this.updateFiberList();
    }

    public final void gatherFibers(@NotNull Function0<? extends Collection<? extends A_Fiber>> fibersProvider) {
        Intrinsics.checkNotNullParameter(fibersProvider, (String)"fibersProvider");
        Semaphore semaphore = new Semaphore(0);
        this.runtime.whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this, fibersProvider, semaphore){
            final /* synthetic */ AvailDebugger this$0;
            final /* synthetic */ Function0<Collection<A_Fiber>> $fibersProvider;
            final /* synthetic */ Semaphore $semaphore;
            {
                this.this$0 = $receiver;
                this.$fibersProvider = $fibersProvider;
                this.$semaphore = $semaphore;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                this.this$0.getDebuggerModel().gatherFibers(this.$fibersProvider);
                Iterable iterable = ArraysKt.zip((Object[])FiberDescriptor.FiberKind.Companion.getAll(), (Iterable)AvailDebugger.access$getCaptureButtons$p(this.this$0));
                AvailDebugger availDebugger = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    FiberDescriptor.FiberKind kind2 = (FiberDescriptor.FiberKind)((Object)pair.component1());
                    JToggleButton button2 = (JToggleButton)pair.component2();
                    button2.setSelected(availDebugger.getDebuggerModel().isCapturingNewFibers(kind2));
                }
                this.$semaphore.release();
            }
        }));
        semaphore.acquire();
    }

    private final void releaseAllFibers() {
        Semaphore semaphore = new Semaphore(0);
        this.runtime.whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this, semaphore){
            final /* synthetic */ AvailDebugger this$0;
            final /* synthetic */ Semaphore $semaphore;
            {
                this.this$0 = $receiver;
                this.$semaphore = $semaphore;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$safeWrite$iv;
                ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                AvailDebugger availDebugger = this.this$0;
                Semaphore semaphore = this.$semaphore;
                boolean $i$f$safeWrite = false;
                ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
                Lock lock = writeLock;
                lock.lock();
                try {
                    boolean bl = false;
                    availDebugger.getDebuggerModel().getWhenPausedActions().clear();
                    availDebugger.getDebuggerModel().releaseFibersThen((Function0<Unit>)((Function0)new Function0<Unit>(semaphore){
                        final /* synthetic */ Semaphore $semaphore;
                        {
                            this.$semaphore = $semaphore;
                            super(0);
                        }

                        public final void invoke() {
                            this.$semaphore.release();
                        }
                    }));
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        }));
        semaphore.acquire();
    }

    private static final void fiberListPane$lambda$7$lambda$6(AvailDebugger this$0, ListSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateStackList();
    }

    private static final void stackListPane$lambda$9$lambda$8(AvailDebugger this$0, ListSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!it.getValueIsAdjusting()) {
            this$0.updateDisassemblyAndSourcePanes();
            this$0.updateVariablesList();
        }
    }

    private static final void variablesPane$lambda$13$lambda$12(AvailDebugger this$0, ListSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!it.getValueIsAdjusting()) {
            this$0.updateVariableValuePane();
        }
    }

    private static final void updateDisassemblyAndSourcePanes$lambda$16(AvailDebugger this$0, A_Continuation $frame, boolean $isTopFrame) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)$frame);
        this$0.highlightSourceLine(A_Continuation.Companion.currentLineNumber($frame, $isTopFrame), $isTopFrame);
    }

    public static final /* synthetic */ Map access$getDisassemblyCache$p(AvailDebugger $this) {
        return $this.disassemblyCache;
    }

    public static final /* synthetic */ CodePane access$getDisassemblyPane$p(AvailDebugger $this) {
        return $this.disassemblyPane;
    }

    public static final /* synthetic */ DefaultHighlighter.DefaultHighlightPainter access$getCodeHighlightPainter$p(AvailDebugger $this) {
        return $this.codeHighlightPainter;
    }

    public static final /* synthetic */ DefaultHighlighter.DefaultHighlightPainter access$getSecondaryCodeHighlightPainter$p(AvailDebugger $this) {
        return $this.secondaryCodeHighlightPainter;
    }

    public static final /* synthetic */ A_RawFunction access$getCurrentCode$p(AvailDebugger $this) {
        return $this.currentCode;
    }

    public static final /* synthetic */ void access$setCurrentCode$p(AvailDebugger $this, A_RawFunction a_RawFunction) {
        $this.currentCode = a_RawFunction;
    }

    public static final /* synthetic */ void access$highlightSourceLine(AvailDebugger $this, int lineNumber, boolean isTopFrame) {
        $this.highlightSourceLine(lineNumber, isTopFrame);
    }

    public static final /* synthetic */ void access$setCurrentSource$p(AvailDebugger $this, String string2) {
        $this.currentSource = string2;
    }

    public static final /* synthetic */ void access$setLineDelimiter$p(AvailDebugger $this, String string2) {
        $this.lineDelimiter = string2;
    }

    public static final /* synthetic */ void access$setLineEnds$p(AvailDebugger $this, List list2) {
        $this.lineEnds = list2;
    }

    public static final /* synthetic */ void access$setStylingRecord$p(AvailDebugger $this, StylingRecord stylingRecord) {
        $this.stylingRecord = stylingRecord;
    }

    public static final /* synthetic */ CodePane access$getSourcePane$p(AvailDebugger $this) {
        return $this.sourcePane;
    }

    public static final /* synthetic */ paneVersionTracker.1 access$getPaneVersionTracker$p(AvailDebugger $this) {
        return $this.paneVersionTracker;
    }

    public static final /* synthetic */ JTextArea access$getVariableValuePane$p(AvailDebugger $this) {
        return $this.variableValuePane;
    }

    public static final /* synthetic */ JList access$getFiberListPane$p(AvailDebugger $this) {
        return $this.fiberListPane;
    }

    public static final /* synthetic */ void access$updateFiberList(AvailDebugger $this) {
        $this.updateFiberList();
    }

    public static final /* synthetic */ void access$updateStackList(AvailDebugger $this) {
        $this.updateStackList();
    }

    public static final /* synthetic */ void access$releaseAllFibers(AvailDebugger $this) {
        $this.releaseAllFibers();
    }

    public static final /* synthetic */ List access$getCaptureButtons$p(AvailDebugger $this) {
        return $this.captureButtons;
    }

    public static final /* synthetic */ JList access$getStackListPane$p(AvailDebugger $this) {
        return $this.stackListPane;
    }

    public static final /* synthetic */ JList access$getVariablesPane$p(AvailDebugger $this) {
        return $this.variablesPane;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/anvil/debugger/AvailDebugger$FiberRenderer;", "Ljavax/swing/DefaultListCellRenderer;", "()V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "fiber", "", "index", "", "isSelected", "", "cellHasFocus", "avail"})
    public static final class FiberRenderer
    extends DefaultListCellRenderer {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Component getListCellRendererComponent(@Nullable JList<?> list2, @Nullable Object fiber2, int index2, boolean isSelected, boolean cellHasFocus) {
            void $this$getListCellRendererComponent_u24lambda_u240;
            Intrinsics.checkNotNull((Object)fiber2, (String)"null cannot be cast to non-null type avail.descriptor.fiber.A_Fiber");
            A_Fiber a_Fiber = (A_Fiber)fiber2;
            JList<?> jList = list2;
            FiberRenderer fiberRenderer = this;
            boolean bl = false;
            String string2 = FiberDescriptor.FiberKind.Companion.getFiberKind((A_Fiber)$this$getListCellRendererComponent_u24lambda_u240).getVeryShortName() + " [" + A_Fiber.Companion.getExecutionState((A_Fiber)$this$getListCellRendererComponent_u24lambda_u240) + "] " + A_String.Companion.asNativeString(A_Fiber.Companion.getFiberName((A_Fiber)$this$getListCellRendererComponent_u24lambda_u240));
            Component component = super.getListCellRendererComponent(jList, string2, index2, isSelected, cellHasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
            return component;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/anvil/debugger/AvailDebugger$FrameRenderer;", "Ljavax/swing/DefaultListCellRenderer;", "()V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "frame", "", "index", "", "isSelected", "", "cellHasFocus", "avail"})
    public static final class FrameRenderer
    extends DefaultListCellRenderer {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Component getListCellRendererComponent(@Nullable JList<?> list2, @Nullable Object frame, int index2, boolean isSelected, boolean cellHasFocus) {
            void $this$getListCellRendererComponent_u24lambda_u240;
            Intrinsics.checkNotNull((Object)frame, (String)"null cannot be cast to non-null type avail.descriptor.functions.A_Continuation");
            A_Continuation a_Continuation = (A_Continuation)frame;
            JList<?> jList = list2;
            FrameRenderer frameRenderer = this;
            boolean bl = false;
            A_RawFunction code = A_Continuation.Companion.function((A_Continuation)$this$getListCellRendererComponent_u24lambda_u240).code();
            A_Module module = A_RawFunction.Companion.getModule(code);
            String string2 = "%s (%s:%d) pc=%d";
            Object[] objectArray = new Object[]{A_String.Companion.asNativeString(A_RawFunction.Companion.getMethodName(code)), module.isNil() ? "?" : A_Module.Companion.getModuleNameNative(module), A_Continuation.Companion.currentLineNumber((A_Continuation)frame, index2 == 0), A_Continuation.Companion.pc((A_Continuation)frame)};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            String string4 = string3;
            Component component = super.getListCellRendererComponent(jList, string4, index2, isSelected, cellHasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
            return component;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u001a\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u0014H\u0002J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lavail/anvil/debugger/AvailDebugger$Variable;", "", "name", "", "value", "Lavail/descriptor/representation/AvailObject;", "(Ljava/lang/String;Lavail/descriptor/representation/AvailObject;)V", "getName", "()Ljava/lang/String;", "presentationString", "getPresentationString", "getValue", "()Lavail/descriptor/representation/AvailObject;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "stringIfSimple", "depth", "toString", "avail"})
    public static final class Variable {
        @NotNull
        private final String name;
        @NotNull
        private final AvailObject value;
        @NotNull
        private final String presentationString;

        public Variable(@NotNull String name, @NotNull AvailObject value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.name = name;
            this.value = value;
            this.presentationString = this.name + " = " + Variable.stringIfSimple$default(this, this.value, 0, 2, null);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final AvailObject getValue() {
            return this.value;
        }

        @NotNull
        public final String getPresentationString() {
            return this.presentationString;
        }

        private final String stringIfSimple(AvailObject value, int depth2) {
            return depth2 > 3 ? "***depth***" : (value.isNil() ? "nil" : (value.isString() ? value.toString() : (value.isInstanceOf(PrimitiveTypeDescriptor.Types.NUMBER.getO()) ? value.toString() : (value.isInstanceOf(PrimitiveTypeDescriptor.Types.MESSAGE_BUNDLE.getO()) ? A_String.Companion.asNativeString(A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(value))) : (value.isInstanceOf(PrimitiveTypeDescriptor.Types.METHOD.getO()) ? value.toString() : (value.isAtom() ? value.toString() : (A_Character.Companion.isCharacter(value) ? value.toString() : (value.isInstanceOf(VariableTypeDescriptor.Companion.getMostGeneralVariableType()) ? "var(" + this.stringIfSimple(value.getValueForDebugger(), depth2 + 1) + ")" : (!value.isType() ? "(" + value.getTypeTag() + ")" : (value.isTop() ? value.toString() : (value.isBottom() ? value.toString() : (value.traversed().descriptor() instanceof PrimitiveTypeDescriptor ? value.toString() : (A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(value), 1) ? "{" + this.stringIfSimple(A_Type.Companion.getInstance(value), depth2 + 1) + "}\u1d40" : "(" + value.getTypeTag() + ")")))))))))))));
        }

        static /* synthetic */ String stringIfSimple$default(Variable variable, AvailObject availObject, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return variable.stringIfSimple(availObject, n);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final AvailObject component2() {
            return this.value;
        }

        @NotNull
        public final Variable copy(@NotNull String name, @NotNull AvailObject value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Variable(name, value);
        }

        public static /* synthetic */ Variable copy$default(Variable variable, String string2, AvailObject availObject, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = variable.name;
            }
            if ((n & 2) != 0) {
                availObject = variable.value;
            }
            return variable.copy(string2, availObject);
        }

        @NotNull
        public String toString() {
            return "Variable(name=" + this.name + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.value.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Variable)) {
                return false;
            }
            Variable variable = (Variable)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)variable.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)variable.value);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/anvil/debugger/AvailDebugger$VariablesRenderer;", "Ljavax/swing/DefaultListCellRenderer;", "()V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "variable", "", "index", "", "isSelected", "", "cellHasFocus", "avail"})
    public static final class VariablesRenderer
    extends DefaultListCellRenderer {
        @Override
        @NotNull
        public Component getListCellRendererComponent(@Nullable JList<?> list2, @Nullable Object variable, int index2, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNull((Object)variable, (String)"null cannot be cast to non-null type avail.anvil.debugger.AvailDebugger.Variable");
            Component component = super.getListCellRendererComponent(list2, ((Variable)variable).getPresentationString(), index2, isSelected, cellHasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
            return component;
        }
    }
}

