/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.manager;

import avail.AvailRuntimeConfiguration;
import avail.anvil.AvailWorkbench;
import avail.anvil.MenuBarBuilder;
import avail.anvil.SwingHelperKt;
import avail.anvil.environment.GlobalEnvironmentSettings;
import avail.anvil.environment.LocationsKt;
import avail.anvil.manager.AvailProjectManager;
import avail.anvil.manager.CreateProjectDialog;
import avail.anvil.manager.CreateProjectPanel;
import avail.anvil.manager.KnownProjectsPanel;
import avail.anvil.manager.OpenKnownProjectDialog;
import avail.anvil.projects.KnownAvailProject;
import avail.anvil.settings.SettingsView;
import avail.anvil.versions.MavenCentralAPI;
import avail.anvil.versions.SearchResponse;
import avail.anvil.window.LayoutConfiguration;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Taskbar;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitResponse;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.json.JSONReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001EB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020'J\b\u0010/\u001a\u00020-H\u0002J\b\u00100\u001a\u00020-H\u0002J\u000e\u00101\u001a\u00020-2\u0006\u0010.\u001a\u00020'J\u000e\u00102\u001a\u00020-2\u0006\u0010.\u001a\u00020'J\b\u00103\u001a\u00020\u0016H\u0002J\u000e\u00104\u001a\u00020-2\u0006\u0010.\u001a\u00020'J\u001e\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u0002062\u000e\b\u0002\u00107\u001a\b\u0012\u0004\u0012\u00020-08J\u0006\u00109\u001a\u00020-J&\u00109\u001a\u00020\u00162\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00182\f\u00107\u001a\b\u0012\u0004\u0012\u00020-08H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010'2\u0006\u0010>\u001a\u00020\u0018H\u0002J\r\u0010?\u001a\u00020-H\u0000\u00a2\u0006\u0002\b@J\u0006\u0010A\u001a\u00020-J\b\u0010B\u001a\u00020-H\u0002J\b\u0010C\u001a\u00020-H\u0002J\b\u0010D\u001a\u00020-H\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020'0)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006F"}, d2={"Lavail/anvil/manager/AvailProjectManager;", "Ljavax/swing/JFrame;", "globalSettings", "Lavail/anvil/environment/GlobalEnvironmentSettings;", "(Lavail/anvil/environment/GlobalEnvironmentSettings;)V", "createProjectDialog", "Lavail/anvil/manager/CreateProjectDialog;", "getCreateProjectDialog$avail", "()Lavail/anvil/manager/CreateProjectDialog;", "setCreateProjectDialog$avail", "(Lavail/anvil/manager/CreateProjectDialog;)V", "displayed", "Lavail/anvil/manager/AvailProjectManager$DisplayedPanel;", "getDisplayed", "()Lavail/anvil/manager/AvailProjectManager$DisplayedPanel;", "setDisplayed", "(Lavail/anvil/manager/AvailProjectManager$DisplayedPanel;)V", "displayedComponent", "Ljavax/swing/JComponent;", "getGlobalSettings", "()Lavail/anvil/environment/GlobalEnvironmentSettings;", "initialOpenComplete", "", "latestVersion", "", "getLatestVersion", "()Ljava/lang/String;", "setLatestVersion", "(Ljava/lang/String;)V", "layoutConfiguration", "Lavail/anvil/window/LayoutConfiguration;", "openKnownProjectDialog", "Lavail/anvil/manager/OpenKnownProjectDialog;", "getOpenKnownProjectDialog$avail", "()Lavail/anvil/manager/OpenKnownProjectDialog;", "setOpenKnownProjectDialog$avail", "(Lavail/anvil/manager/OpenKnownProjectDialog;)V", "openWorkbenches", "", "Lavail/anvil/AvailWorkbench;", "workbenches", "", "getWorkbenches", "()Ljava/util/Set;", "createProject", "", "workbench", "draw", "hideProjectManager", "onWorkbenchClose", "onWorkbenchOpen", "openFavorites", "openKnownProject", "knownAvailProject", "Lavail/anvil/projects/KnownAvailProject;", "invokeLater", "Lkotlin/Function0;", "openProject", "project", "Lorg/availlang/artifact/environment/project/AvailProject;", "configPath", "openedWorkbench", "projectId", "redraw", "redraw$avail", "saveWindowPosition", "setCreateProjectsSize", "setKnownProjectsSize", "showProjectManager", "DisplayedPanel", "avail"})
@SourceDebugExtension(value={"SMAP\nAvailProjectManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvailProjectManager.kt\navail/anvil/manager/AvailProjectManager\n+ 2 MenuBarBuilder.kt\navail/anvil/MenuBarBuilder$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,559:1\n56#2:560\n1#3:561\n288#4,2:562\n1855#4,2:564\n288#4,2:566\n*S KotlinDebug\n*F\n+ 1 AvailProjectManager.kt\navail/anvil/manager/AvailProjectManager\n*L\n234#1:560\n234#1:561\n131#1:562,2\n478#1:564,2\n215#1:566,2\n*E\n"})
public final class AvailProjectManager
extends JFrame {
    @NotNull
    private final GlobalEnvironmentSettings globalSettings;
    @NotNull
    private String latestVersion;
    private boolean initialOpenComplete;
    @NotNull
    private final Set<AvailWorkbench> openWorkbenches;
    @Nullable
    private OpenKnownProjectDialog openKnownProjectDialog;
    @Nullable
    private CreateProjectDialog createProjectDialog;
    @NotNull
    private final LayoutConfiguration layoutConfiguration;
    @NotNull
    private DisplayedPanel displayed;
    @NotNull
    private JComponent displayedComponent;

    /*
     * WARNING - void declaration
     */
    public AvailProjectManager(@NotNull GlobalEnvironmentSettings globalSettings) {
        void $this$_init__u24lambda_u244;
        Serializable it;
        Intrinsics.checkNotNullParameter((Object)globalSettings, (String)"globalSettings");
        super("Avail");
        this.globalSettings = globalSettings;
        this.latestVersion = "";
        this.openWorkbenches = new LinkedHashSet();
        this.layoutConfiguration = LayoutConfiguration.Companion.from(FilesKt.readText$default((File)new File(LocationsKt.getProjectManagerLayoutFile()), null, (int)1, null));
        this.setDefaultCloseOperation(3);
        this.setKnownProjectsSize();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(@Nullable WindowEvent e) {
                this.saveWindowPosition();
                this.getGlobalSettings().saveToDisk();
            }
        });
        Desktop.getDesktop().setQuitHandler((arg_0, arg_1) -> AvailProjectManager._init_$lambda$2(this, arg_0, arg_1));
        Rectangle rectangle = this.layoutConfiguration.getPlacement$avail();
        if (rectangle != null) {
            it = rectangle;
            boolean bl = false;
            this.setBounds((Rectangle)it);
        }
        MenuBarBuilder.Companion this_$iv = MenuBarBuilder.Companion;
        boolean $i$f$createMenuBar = false;
        Serializable it$iv = it = new JMenuBar();
        boolean bl = false;
        MenuBarBuilder menuBarBuilder = new MenuBarBuilder((JMenuBar)it$iv);
        AvailProjectManager availProjectManager = this;
        boolean bl2 = false;
        SwingHelperKt.addWindowMenu((MenuBarBuilder)$this$_init__u24lambda_u244, this);
        availProjectManager.setJMenuBar((JMenuBar)it);
        this.displayed = DisplayedPanel.KNOWN_PROJECTS;
        this.displayedComponent = new KnownProjectsPanel(this, false, 2, null);
        this.draw();
        MavenCentralAPI.INSTANCE.searchAvailStdLib((Function1<? super JSONReader, Unit>)((Function1)new Function1<JSONReader, Unit>(){

            public final void invoke(@NotNull JSONReader it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SearchResponse rsp = SearchResponse.Companion.parse(it);
                if (rsp == null) {
                    System.err.println("Failed to refresh latest Avail Standard Library version from Maven Central, couldn't parse response:\n" + it);
                    return;
                }
                this.setLatestVersion(rsp.getLatestLibVersion());
            }
        }), (Function3<? super Integer, ? super String, ? super Throwable, Unit>)((Function3)6.INSTANCE));
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        if (StringsKt.startsWith$default((String)string2, (String)"Mac", (boolean)false, (int)2, null)) {
            Desktop $this$_init__u24lambda_u2414 = Desktop.getDesktop();
            boolean bl3 = false;
            $this$_init__u24lambda_u2414.setDefaultMenuBar(this.getJMenuBar());
            $this$_init__u24lambda_u2414.setPreferencesHandler(arg_0 -> AvailProjectManager.lambda$14$lambda$13(this, arg_0));
            Taskbar $this$_init__u24lambda_u2415 = Taskbar.getTaskbar();
            boolean bl4 = false;
            $this$_init__u24lambda_u2415.setIconImage(new ImageIcon(AvailWorkbench.class.getClassLoader().getResource("workbench/AvailHammer.png")).getImage());
            $this$_init__u24lambda_u2415.setIconBadge(AvailRuntimeConfiguration.INSTANCE.getActiveVersionSummary());
        }
    }

    @NotNull
    public final GlobalEnvironmentSettings getGlobalSettings() {
        return this.globalSettings;
    }

    @NotNull
    public final String getLatestVersion() {
        return this.latestVersion;
    }

    public final void setLatestVersion(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.latestVersion = string2;
    }

    @NotNull
    public final Set<AvailWorkbench> getWorkbenches() {
        return this.openWorkbenches;
    }

    @Nullable
    public final OpenKnownProjectDialog getOpenKnownProjectDialog$avail() {
        return this.openKnownProjectDialog;
    }

    public final void setOpenKnownProjectDialog$avail(@Nullable OpenKnownProjectDialog openKnownProjectDialog) {
        this.openKnownProjectDialog = openKnownProjectDialog;
    }

    @Nullable
    public final CreateProjectDialog getCreateProjectDialog$avail() {
        return this.createProjectDialog;
    }

    public final void setCreateProjectDialog$avail(@Nullable CreateProjectDialog createProjectDialog) {
        this.createProjectDialog = createProjectDialog;
    }

    private final AvailWorkbench openedWorkbench(String projectId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.openWorkbenches;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AvailWorkbench it = (AvailWorkbench)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAvailProject$avail().getId(), (Object)projectId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void onWorkbenchOpen(@NotNull AvailWorkbench workbench) {
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        this.openWorkbenches.add(workbench);
        this.hideProjectManager();
    }

    public final void onWorkbenchClose(@NotNull AvailWorkbench workbench) {
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        this.openWorkbenches.remove(workbench);
        if (this.openWorkbenches.isEmpty()) {
            this.showProjectManager();
        }
    }

    private final void setKnownProjectsSize() {
        this.setMinimumSize(new Dimension(750, 400));
        this.setPreferredSize(new Dimension(750, 600));
        this.setMaximumSize(new Dimension(750, 900));
    }

    private final void setCreateProjectsSize() {
        this.setMinimumSize(new Dimension(750, 350));
        this.setPreferredSize(new Dimension(750, 350));
        this.setMaximumSize(new Dimension(750, 350));
    }

    public final void saveWindowPosition() {
        this.layoutConfiguration.setExtendedState$avail(this.getExtendedState());
        if (this.getExtendedState() == 0) {
            this.layoutConfiguration.setPlacement$avail(this.getBounds());
        }
        FilesKt.writeText$default((File)new File(LocationsKt.getProjectManagerLayoutFile()), (String)this.layoutConfiguration.stringToStore$avail(), null, (int)2, null);
    }

    @NotNull
    public final DisplayedPanel getDisplayed() {
        return this.displayed;
    }

    public final void setDisplayed(@NotNull DisplayedPanel displayedPanel) {
        Intrinsics.checkNotNullParameter((Object)((Object)displayedPanel), (String)"<set-?>");
        this.displayed = displayedPanel;
    }

    private final void hideProjectManager() {
        this.setVisible(false);
    }

    private final void showProjectManager() {
        this.redraw$avail();
    }

    private final void draw() {
        int newHeight = this.getHeight();
        this.displayedComponent = switch (WhenMappings.$EnumSwitchMapping$0[this.displayed.ordinal()]) {
            case 1 -> {
                this.setTitle("Avail Projects");
                newHeight = 600;
                this.setKnownProjectsSize();
                yield new KnownProjectsPanel(this, false, 2, null);
            }
            case 2 -> {
                this.setTitle("Create Project");
                this.setCreateProjectsSize();
                newHeight = 450;
                yield new CreateProjectPanel(this.globalSettings, (Function2<? super AvailProject, ? super String, Unit>)((Function2)new Function2<AvailProject, String, Unit>(this){
                    final /* synthetic */ AvailProjectManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull AvailProject project, @NotNull String path) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        AvailWorkbench.Companion.launchWorkbenchWithProject$default(AvailWorkbench.Companion, project, this.this$0.getGlobalSettings(), path, null, false, this.this$0, 24, null);
                        SwingUtilities.invokeLater(() -> draw.1.invoke$lambda$0(this.this$0));
                    }

                    private static final void invoke$lambda$0(AvailProjectManager this$0) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        this$0.setDisplayed(DisplayedPanel.KNOWN_PROJECTS);
                        AvailProjectManager.access$hideProjectManager(this$0);
                    }
                }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ AvailProjectManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.setDisplayed(DisplayedPanel.KNOWN_PROJECTS);
                        SwingUtilities.invokeLater(() -> draw.2.invoke$lambda$0(this.this$0));
                    }

                    private static final void invoke$lambda$0(AvailProjectManager this$0) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        this$0.redraw$avail();
                    }
                }));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        this.add(this.displayedComponent);
        this.setBounds(this.getX(), this.getY(), this.getWidth(), newHeight);
        if (!this.initialOpenComplete) {
            this.initialOpenComplete = true;
            this.openFavorites();
            this.setVisible(this.openWorkbenches.isEmpty());
        } else {
            this.setVisible(true);
        }
    }

    public final void redraw$avail() {
        this.remove(this.displayedComponent);
        this.draw();
    }

    /*
     * WARNING - void declaration
     */
    public final void createProject(@NotNull AvailWorkbench workbench) {
        CreateProjectDialog createProjectDialog;
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        AvailProjectManager availProjectManager = this;
        CreateProjectDialog createProjectDialog2 = this.createProjectDialog;
        if (createProjectDialog2 != null) {
            void it;
            CreateProjectDialog createProjectDialog3 = createProjectDialog2;
            AvailProjectManager availProjectManager2 = availProjectManager;
            boolean bl = false;
            it.toFront();
            createProjectDialog = createProjectDialog3;
            availProjectManager = availProjectManager2;
        } else {
            createProjectDialog = new CreateProjectDialog(this, workbench);
        }
        availProjectManager.createProjectDialog = createProjectDialog;
    }

    private final boolean openProject(AvailProject project, String configPath, Function0<Unit> invokeLater) {
        AvailWorkbench availWorkbench = this.openedWorkbench(project.getId());
        if (availWorkbench != null) {
            AvailWorkbench it = availWorkbench;
            boolean bl = false;
            it.toFront();
            SwingUtilities.invokeLater(() -> AvailProjectManager.openProject$lambda$7$lambda$6(invokeLater));
            return true;
        }
        this.globalSettings.add(project, configPath);
        AvailWorkbench.Companion.launchWorkbenchWithProject$default(AvailWorkbench.Companion, project, this.globalSettings, configPath, null, false, this, 24, null);
        SwingUtilities.invokeLater(() -> AvailProjectManager.openProject$lambda$8(this, invokeLater));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void openKnownProject(@NotNull AvailWorkbench workbench) {
        OpenKnownProjectDialog openKnownProjectDialog;
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        AvailProjectManager availProjectManager = this;
        OpenKnownProjectDialog openKnownProjectDialog2 = this.openKnownProjectDialog;
        if (openKnownProjectDialog2 != null) {
            void it;
            OpenKnownProjectDialog openKnownProjectDialog3 = openKnownProjectDialog2;
            AvailProjectManager availProjectManager2 = availProjectManager;
            boolean bl = false;
            it.toFront();
            openKnownProjectDialog = openKnownProjectDialog3;
            availProjectManager = availProjectManager2;
        } else {
            openKnownProjectDialog = new OpenKnownProjectDialog(this, workbench);
        }
        availProjectManager.openKnownProjectDialog = openKnownProjectDialog;
    }

    public final boolean openKnownProject(@NotNull KnownAvailProject knownAvailProject, @NotNull Function0<Unit> invokeLater) {
        Intrinsics.checkNotNullParameter((Object)knownAvailProject, (String)"knownAvailProject");
        Intrinsics.checkNotNullParameter(invokeLater, (String)"invokeLater");
        AvailProject availProject = knownAvailProject.availProject();
        if (availProject == null) {
            return false;
        }
        AvailProject project = availProject;
        String configPath = knownAvailProject.getConfigFilePath();
        return this.openProject(project, configPath, invokeLater);
    }

    public static /* synthetic */ boolean openKnownProject$default(AvailProjectManager availProjectManager, KnownAvailProject knownAvailProject, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = openKnownProject.2.INSTANCE;
        }
        return availProjectManager.openKnownProject(knownAvailProject, (Function0<Unit>)function0);
    }

    private final boolean openFavorites() {
        boolean opened = false;
        Iterable $this$forEach$iv = this.globalSettings.getFavoriteKnownProjects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KnownAvailProject it = (KnownAvailProject)element$iv;
            boolean bl = false;
            opened = AvailProjectManager.openKnownProject$default(this, it, null, 2, null) || opened;
        }
        return opened;
    }

    public final void openProject() {
        JFileChooser jFileChooser;
        JFileChooser $this$openProject_u24lambda_u2412 = jFileChooser = new JFileChooser();
        boolean bl = false;
        $this$openProject_u24lambda_u2412.setDialogTitle("Select Avail Project Configuration File to Open");
        $this$openProject_u24lambda_u2412.setFileSelectionMode(0);
        String[] stringArray = new String[]{"json"};
        $this$openProject_u24lambda_u2412.setFileFilter(new FileNameExtensionFilter("*.json", stringArray));
        $this$openProject_u24lambda_u2412.addChoosableFileFilter(new FileFilter(){

            @NotNull
            public String getDescription() {
                return "Avail Project Config (*.json)";
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(@NotNull File f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                if (!f.isFile()) return false;
                if (!f.canWrite()) return false;
                String string2 = f.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!StringsKt.endsWith$default((String)string3, (String)".json", (boolean)false, (int)2, null)) return false;
                return true;
            }
        });
        int result2 = $this$openProject_u24lambda_u2412.showDialog(this, "Select Project Config File");
        if (result2 == 0) {
            AvailProject availProject;
            File projectConfigFile = $this$openProject_u24lambda_u2412.getSelectedFile();
            try {
                String string2 = $this$openProject_u24lambda_u2412.getSelectedFile().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                availProject = AvailProject.Companion.from(string2);
            }
            catch (Throwable e) {
                e.printStackTrace();
                availProject = null;
            }
            AvailProject availProject2 = availProject;
            if (availProject2 != null) {
                AvailProject project = availProject2;
                String string3 = projectConfigFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
                this.globalSettings.add(project, string3);
                String string4 = projectConfigFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
                AvailWorkbench.Companion.launchWorkbenchWithProject$default(AvailWorkbench.Companion, project, this.globalSettings, string4, null, false, this, 24, null);
                SwingUtilities.invokeLater(() -> AvailProjectManager.openProject$lambda$12$lambda$11(this));
            }
        }
    }

    private static final void _init_$lambda$2(AvailProjectManager this$0, QuitEvent quitEvent, QuitResponse response) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            response.cancelQuit();
            Iterable $this$firstOrNull$iv = this$0.openWorkbenches;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AvailWorkbench p0 = (AvailWorkbench)element$iv;
                boolean bl = false;
                if (!p0.getWorkbenchWindowIsFocused()) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        AvailWorkbench availWorkbench = v0;
        if (availWorkbench != null) {
            AvailWorkbench it = availWorkbench;
            boolean bl = false;
            it.dispatchEvent(new WindowEvent(it, 201));
        }
        if (this$0.openWorkbenches.isEmpty()) {
            this$0.processWindowEvent(new WindowEvent(this$0, 201));
        }
    }

    private static final void openProject$lambda$7$lambda$6(Function0 $invokeLater) {
        Intrinsics.checkNotNullParameter((Object)$invokeLater, (String)"$invokeLater");
        $invokeLater.invoke();
    }

    private static final void openProject$lambda$8(AvailProjectManager this$0, Function0 $invokeLater) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$invokeLater, (String)"$invokeLater");
        this$0.hideProjectManager();
        $invokeLater.invoke();
    }

    private static final void openProject$lambda$12$lambda$11(AvailProjectManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.hideProjectManager();
    }

    private static final void lambda$14$lambda$13(AvailProjectManager this$0, PreferencesEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        new SettingsView(this$0.globalSettings, this$0, this$0.latestVersion, null, 8, null);
    }

    public static final /* synthetic */ void access$hideProjectManager(AvailProjectManager $this) {
        $this.hideProjectManager();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lavail/anvil/manager/AvailProjectManager$DisplayedPanel;", "", "(Ljava/lang/String;I)V", "KNOWN_PROJECTS", "CREATE_PROJECT", "avail"})
    public static final class DisplayedPanel
    extends Enum<DisplayedPanel> {
        public static final /* enum */ DisplayedPanel KNOWN_PROJECTS = new DisplayedPanel();
        public static final /* enum */ DisplayedPanel CREATE_PROJECT = new DisplayedPanel();
        private static final /* synthetic */ DisplayedPanel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DisplayedPanel[] values() {
            return (DisplayedPanel[])$VALUES.clone();
        }

        public static DisplayedPanel valueOf(String value) {
            return Enum.valueOf(DisplayedPanel.class, value);
        }

        @NotNull
        public static EnumEntries<DisplayedPanel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = displayedPanelArray = new DisplayedPanel[]{DisplayedPanel.KNOWN_PROJECTS, DisplayedPanel.CREATE_PROJECT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DisplayedPanel.values().length];
            try {
                nArray[DisplayedPanel.KNOWN_PROJECTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayedPanel.CREATE_PROJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

