/*
 * Decompiled with CFR 0.152.
 */
package avail.builder;

import avail.AvailRuntime;
import avail.builder.AvailBuilder;
import avail.builder.BuildDirectoryTracer;
import avail.builder.BuildLoader;
import avail.builder.BuildTracer;
import avail.builder.BuildUnloader;
import avail.builder.BuilderProblemHandler;
import avail.builder.DocumentationTracer;
import avail.builder.GraphTracer;
import avail.builder.ModuleName;
import avail.builder.ResolvedModuleName;
import avail.compiler.AvailCompiler;
import avail.compiler.FiberTerminationException;
import avail.compiler.ModuleHeader;
import avail.compiler.ModuleImport;
import avail.compiler.problems.Problem;
import avail.compiler.problems.ProblemHandler;
import avail.compiler.problems.ProblemType;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.module.ModuleDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.io.SimpleCompletionHandler;
import avail.io.TextInterface;
import avail.persistence.cache.record.ModuleCompilation;
import avail.persistence.cache.record.ModuleVersion;
import avail.serialization.Serializer;
import avail.utility.CollectionExtensionsKt;
import avail.utility.Graph;
import avail.utility.StackPrinterKt;
import java.io.File;
import java.io.OutputStream;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.availlang.persistence.IndexedFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 s2\u00020\u0001:\u0004stuvB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Jv\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020\u001d2,\u00105\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020706\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u000107\u0012\u0004\u0012\u00020,08\u0012\u0004\u0012\u00020,0+2*\u00109\u001a&\u0012\u0004\u0012\u00020:\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u0017\u0012\u0004\u0012\u00020,08\u0012\u0004\u0012\u00020,0+2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020,0\u0017Jl\u0010<\u001a\u00020,2\u0006\u0010=\u001a\u00020>26\u0010?\u001a2\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010C0\u0017\u0012\u0004\u0012\u00020,0@j\u0002`D2\u001c\u0010E\u001a\u0018\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020,0+j\u0002`F2\u0006\u0010G\u001a\u00020\fJz\u0010H\u001a\u00020,2\u0006\u0010=\u001a\u00020>26\u0010?\u001a2\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010C0\u0017\u0012\u0004\u0012\u00020,0@j\u0002`D2\u001c\u0010E\u001a\u0018\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020,0+j\u0002`F2\u0006\u0010G\u001a\u00020\f2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020,0\u0017J\u0080\u0001\u0010H\u001a\u00020,2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020>0K26\u0010?\u001a2\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010C0\u0017\u0012\u0004\u0012\u00020,0@j\u0002`D2\u001c\u0010E\u001a\u0018\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020,0+j\u0002`F2\u0006\u0010G\u001a\u00020\f2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020,0\u0017J\u0006\u0010L\u001a\u00020,J\u0006\u0010M\u001a\u00020,J\b\u0010N\u001a\u00020,H\u0002J\u001e\u0010O\u001a\u00020,2\u0006\u0010=\u001a\u00020>2\u0006\u0010P\u001a\u00020Q2\u0006\u0010G\u001a\u00020\fJ\u001e\u0010R\u001a\u00020,2\u0006\u0010=\u001a\u00020\u00072\u0006\u0010S\u001a\u00020T2\u0006\u0010G\u001a\u00020\fJ\u0010\u0010U\u001a\u0004\u0018\u00010\t2\u0006\u0010V\u001a\u00020\u0007J\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\t06J\u00be\u0001\u0010X\u001a\u00020,2\u0018\u0010Y\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020C060\n2\u0018\u0010Z\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020[060\n2,\u00105\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020706\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u000107\u0012\u0004\u0012\u00020,08\u0012\u0004\u0012\u00020,0+2*\u00109\u001a&\u0012\u0004\u0012\u00020:\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u0017\u0012\u0004\u0012\u00020,08\u0012\u0004\u0012\u00020,0+2\u0018\u0010\\\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u0017\u0012\u0004\u0012\u00020,082\f\u0010;\u001a\b\u0012\u0004\u0012\u00020,0\u0017H\u0002J\u001d\u0010]\u001a\u00020,2\u0006\u0010V\u001a\u00020\u00072\u0006\u0010^\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b_J\u0015\u0010`\u001a\u00020,2\u0006\u0010V\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\baJx\u0010b\u001a\u00020,2\u0006\u00104\u001a\u00020\u001d2,\u00105\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020706\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u000107\u0012\u0004\u0012\u00020,08\u0012\u0004\u0012\u00020,0+2*\u00109\u001a&\u0012\u0004\u0012\u00020:\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u0017\u0012\u0004\u0012\u00020,08\u0012\u0004\u0012\u00020,0+2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020,0\u0017H\u0002J\u001d\u0010c\u001a\u00020,2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020gH\u0000\u00a2\u0006\u0002\bhJ \u0010i\u001a\u00020,2\u0018\u0010j\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020,0+J:\u0010k\u001a\u00020,2$\u0010l\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020g\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u0017\u0012\u0004\u0012\u00020,0m2\f\u0010n\u001a\b\u0012\u0004\u0012\u00020,0\u0017J\r\u0010o\u001a\u00020,H\u0000\u00a2\u0006\u0002\bpJ\u0010\u0010q\u001a\u00020,2\b\u0010=\u001a\u0004\u0018\u00010\u0007J \u0010r\u001a\u00020,2\u0018\u0010j\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020,0+RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R(\u0010$\u001a\u0004\u0018\u00010\u001d2\b\u0010#\u001a\u0004\u0018\u00010\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R&\u0010)\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020,0+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006w"}, d2={"Lavail/builder/AvailBuilder;", "", "runtime", "Lavail/AvailRuntime;", "(Lavail/AvailRuntime;)V", "allLoadedModules", "", "Lavail/builder/ResolvedModuleName;", "kotlin.jvm.PlatformType", "Lavail/builder/AvailBuilder$LoadedModule;", "", "buildProblemHandler", "Lavail/compiler/problems/ProblemHandler;", "getBuildProblemHandler", "()Lavail/compiler/problems/ProblemHandler;", "builderLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "commandProblemHandler", "moduleGraph", "Lavail/utility/Graph;", "getModuleGraph", "()Lavail/utility/Graph;", "pollForAbort", "Lkotlin/Function0;", "", "getPollForAbort", "()Lkotlin/jvm/functions/Function0;", "privateStopBuildReason", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getRuntime", "()Lavail/AvailRuntime;", "shouldStopBuild", "getShouldStopBuild", "()Z", "why", "stopBuildReason", "getStopBuildReason", "()Ljava/lang/String;", "setStopBuildReason", "(Ljava/lang/String;)V", "subscriptions", "", "Lkotlin/Function2;", "", "textInterface", "Lavail/io/TextInterface;", "getTextInterface", "()Lavail/io/TextInterface;", "setTextInterface", "(Lavail/io/TextInterface;)V", "attemptCommand", "command", "onAmbiguity", "", "Lavail/builder/AvailBuilder$CompiledCommand;", "Lkotlin/Function1;", "onSuccess", "Lavail/descriptor/representation/AvailObject;", "onFailure", "buildTarget", "target", "Lavail/builder/ModuleName;", "localTracker", "Lkotlin/Function5;", "", "", "Lavail/descriptor/phrases/A_Phrase;", "Lavail/compiler/CompilerProgressReporter;", "globalTracker", "Lavail/compiler/GlobalProgressReporter;", "problemHandler", "buildTargetThen", "originalAfterAll", "targets", "", "cancel", "checkStableInvariants", "clearShouldStopBuild", "generateDocumentation", "documentationPath", "Ljava/nio/file/Path;", "generateGraph", "destinationFile", "Ljava/io/File;", "getLoadedModule", "resolvedModuleName", "loadedModulesCopy", "processParsedCommand", "solutions", "problems", "Lavail/compiler/problems/Problem;", "postSuccessCleanup", "putLoadedModule", "loadedModule", "putLoadedModule$avail", "removeLoadedModule", "removeLoadedModule$avail", "scheduleAttemptCommand", "serialize", "header", "Lavail/compiler/ModuleHeader;", "version", "Lavail/persistence/cache/record/ModuleVersion;", "serialize$avail", "subscribeToModuleLoading", "subscription", "traceDirectoriesThen", "action", "Lkotlin/Function3;", "afterAll", "trimGraphToLoadedModules", "trimGraphToLoadedModules$avail", "unloadTarget", "unsubscribeToModuleLoading", "Companion", "CompiledCommand", "LoadedModule", "ModuleTree", "avail"})
@SourceDebugExtension(value={"SMAP\nAvailBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvailBuilder.kt\navail/builder/AvailBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Locks.kt\navail/utility/LocksKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1255:1\n1#2:1256\n55#3:1257\n55#3:1260\n55#3:1263\n1855#4,2:1258\n1855#4,2:1261\n*S KotlinDebug\n*F\n+ 1 AvailBuilder.kt\navail/builder/AvailBuilder\n*L\n232#1:1257\n247#1:1260\n303#1:1263\n234#1:1258,2\n250#1:1261,2\n*E\n"})
public final class AvailBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AvailRuntime runtime;
    @NotNull
    private final ReentrantReadWriteLock builderLock;
    @NotNull
    private TextInterface textInterface;
    @NotNull
    private final Graph<ResolvedModuleName> moduleGraph;
    private final Map<ResolvedModuleName, LoadedModule> allLoadedModules;
    @NotNull
    private final Set<Function2<LoadedModule, Boolean, Unit>> subscriptions;
    @NotNull
    private final AtomicReference<String> privateStopBuildReason;
    @NotNull
    private final Function0<Boolean> pollForAbort;
    @NotNull
    private final ProblemHandler buildProblemHandler;
    @NotNull
    private final ProblemHandler commandProblemHandler;
    private static final Logger logger = Logger.getLogger(AvailBuilder.class.getName());
    private static final boolean debugBuilder = false;
    public static final long maximumStaleRepositoryMs = 2000L;

    public AvailBuilder(@NotNull AvailRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.runtime = runtime;
        this.builderLock = new ReentrantReadWriteLock();
        this.textInterface = this.runtime.textInterface();
        this.moduleGraph = new Graph();
        this.allLoadedModules = Collections.synchronizedMap(new LinkedHashMap());
        this.subscriptions = new LinkedHashSet();
        this.privateStopBuildReason = new AtomicReference();
        this.pollForAbort = (Function0)new Function0<Boolean>(this){
            final /* synthetic */ AvailBuilder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getShouldStopBuild();
            }
        };
        this.buildProblemHandler = new BuilderProblemHandler(this, "[%s]: module \"%s\", line %d:%n%s%n");
        this.commandProblemHandler = new BuilderProblemHandler(this, "[%1$s]: %4$s%n");
    }

    @NotNull
    public final AvailRuntime getRuntime() {
        return this.runtime;
    }

    @NotNull
    public final TextInterface getTextInterface() {
        return this.textInterface;
    }

    public final void setTextInterface(@NotNull TextInterface textInterface) {
        Intrinsics.checkNotNullParameter((Object)textInterface, (String)"<set-?>");
        this.textInterface = textInterface;
    }

    @NotNull
    public final Graph<ResolvedModuleName> getModuleGraph() {
        return this.moduleGraph;
    }

    @NotNull
    public final Function0<Boolean> getPollForAbort() {
        return this.pollForAbort;
    }

    @NotNull
    public final ProblemHandler getBuildProblemHandler() {
        return this.buildProblemHandler;
    }

    public final void subscribeToModuleLoading(@NotNull Function2<? super LoadedModule, ? super Boolean, Unit> subscription) {
        Intrinsics.checkNotNullParameter(subscription, (String)"subscription");
        this.subscriptions.add(subscription);
    }

    public final void unsubscribeToModuleLoading(@NotNull Function2<? super LoadedModule, ? super Boolean, Unit> subscription) {
        Intrinsics.checkNotNullParameter(subscription, (String)"subscription");
        this.subscriptions.remove(subscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<LoadedModule> loadedModulesCopy() {
        List list2;
        ReentrantReadWriteLock.ReadLock readLock = this.builderLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            list2 = CollectionsKt.toList((Iterable)this.allLoadedModules.values());
        }
        finally {
            readLock.unlock();
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final LoadedModule getLoadedModule(@NotNull ResolvedModuleName resolvedModuleName) {
        LoadedModule loadedModule;
        Intrinsics.checkNotNullParameter((Object)resolvedModuleName, (String)"resolvedModuleName");
        ReentrantReadWriteLock.ReadLock readLock = this.builderLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            loadedModule = this.allLoadedModules.get(resolvedModuleName);
        }
        finally {
            readLock.unlock();
        }
        return loadedModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putLoadedModule$avail(@NotNull ResolvedModuleName resolvedModuleName, @NotNull LoadedModule loadedModule) {
        Intrinsics.checkNotNullParameter((Object)resolvedModuleName, (String)"resolvedModuleName");
        Intrinsics.checkNotNullParameter((Object)loadedModule, (String)"loadedModule");
        ReentrantReadWriteLock $this$safeWrite$iv = this.builderLock;
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            Map<ResolvedModuleName, LoadedModule> map = this.allLoadedModules;
            Intrinsics.checkNotNullExpressionValue(map, (String)"allLoadedModules");
            map.put(resolvedModuleName, loadedModule);
            Iterable $this$forEach$iv = this.subscriptions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function2 it = (Function2)element$iv;
                boolean bl2 = false;
                it.invoke((Object)loadedModule, (Object)true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeLoadedModule$avail(@NotNull ResolvedModuleName resolvedModuleName) {
        Intrinsics.checkNotNullParameter((Object)resolvedModuleName, (String)"resolvedModuleName");
        ReentrantReadWriteLock $this$safeWrite$iv = this.builderLock;
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            LoadedModule loadedModule = this.allLoadedModules.get(resolvedModuleName);
            Intrinsics.checkNotNull((Object)loadedModule);
            LoadedModule loadedModule2 = loadedModule;
            this.allLoadedModules.remove(resolvedModuleName);
            Iterable $this$forEach$iv = this.subscriptions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function2 it = (Function2)element$iv;
                boolean bl2 = false;
                it.invoke((Object)loadedModule2, (Object)false);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void trimGraphToLoadedModules$avail() {
        boolean bl;
        for (ResolvedModuleName moduleName2 : CollectionsKt.toList((Iterable)this.moduleGraph.getVertices())) {
            if (this.getLoadedModule(moduleName2) != null) continue;
            this.moduleGraph.exciseVertex(moduleName2);
        }
        boolean bl2 = bl = this.moduleGraph.getVertexCount() == this.allLoadedModules.size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    public final void checkStableInvariants() {
        boolean bl;
        A_Map loadedRuntimeModules = this.runtime.loadedModules();
        int moduleGraphSize = this.moduleGraph.getVertexCount();
        int allLoadedModulesSize = this.allLoadedModules.size();
        int loadedRuntimeModulesSize = A_Map.Companion.getMapSize(loadedRuntimeModules);
        boolean bl2 = bl = moduleGraphSize == allLoadedModulesSize;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = moduleGraphSize == loadedRuntimeModulesSize;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        for (ResolvedModuleName graphModuleName : CollectionsKt.toList((Iterable)this.moduleGraph.getVertices())) {
            A_String qualifiedAvailName = StringDescriptor.Companion.stringFrom(graphModuleName.getQualifiedName());
            LoadedModule loadedModule = this.allLoadedModules.get(graphModuleName);
            Intrinsics.checkNotNull((Object)loadedModule);
            boolean bl4 = loadedModule.getModule$avail().equals(A_Map.Companion.mapAt(loadedRuntimeModules, qualifiedAvailName));
            if (!_Assertions.ENABLED || bl4) continue;
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
    }

    public final boolean getShouldStopBuild() {
        return this.privateStopBuildReason.get() != null;
    }

    @Nullable
    public final String getStopBuildReason() {
        return this.privateStopBuildReason.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setStopBuildReason(@Nullable String why) {
        ReentrantReadWriteLock $this$safeWrite$iv = this.builderLock;
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            String old = this.privateStopBuildReason.getAndSet(why);
            if (Interpreter.Companion.getDebugWorkUnits()) {
                String string2 = "*****************************************************\n*** stopBuildReason: " + old + " \u2192 " + why + "\n*****************************************************";
                System.out.println((Object)string2);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void clearShouldStopBuild() {
        this.privateStopBuildReason.set(null);
    }

    public final void cancel() {
        this.setStopBuildReason("Canceled");
    }

    public final void serialize$avail(@NotNull ModuleHeader header, @NotNull ModuleVersion version) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        IndexedFile.ByteArrayOutputStream out2 = new IndexedFile.ByteArrayOutputStream(1000);
        header.serializeHeaderOn(new Serializer((OutputStream)out2, null, null, 6, null));
        IndexedFile.Companion.appendCRC(out2);
        byte[] byArray = out2.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        version.putModuleHeader(byArray);
    }

    public final void buildTargetThen(@NotNull ModuleName target, @NotNull Function5<? super ModuleName, ? super Long, ? super Long, ? super Integer, ? super Function0<? extends A_Phrase>, Unit> localTracker, @NotNull Function2<? super Long, ? super Long, Unit> globalTracker, @NotNull ProblemHandler problemHandler, @NotNull Function0<Unit> originalAfterAll) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(localTracker, (String)"localTracker");
        Intrinsics.checkNotNullParameter(globalTracker, (String)"globalTracker");
        Intrinsics.checkNotNullParameter((Object)problemHandler, (String)"problemHandler");
        Intrinsics.checkNotNullParameter(originalAfterAll, (String)"originalAfterAll");
        AtomicBoolean ran = new AtomicBoolean(false);
        Function0 safeAfterAll2 = (Function0)new Function0<Unit>(ran, this, originalAfterAll){
            final /* synthetic */ AtomicBoolean $ran;
            final /* synthetic */ AvailBuilder this$0;
            final /* synthetic */ Function0<Unit> $originalAfterAll;
            {
                this.$ran = $ran;
                this.this$0 = $receiver;
                this.$originalAfterAll = $originalAfterAll;
                super(0);
            }

            public final void invoke() {
                boolean bl;
                boolean old = this.$ran.getAndSet(true);
                boolean bl2 = bl = !old;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                this.this$0.trimGraphToLoadedModules$avail();
                this.$originalAfterAll.invoke();
            }
        };
        this.clearShouldStopBuild();
        new BuildUnloader(this).unloadModified();
        if (this.getShouldStopBuild()) {
            safeAfterAll2.invoke();
            return;
        }
        new BuildTracer(this).traceThen(target, problemHandler, (Function0<Unit>)((Function0)new Function0<Unit>(this, problemHandler, (Function0<Unit>)safeAfterAll2, localTracker, globalTracker, target){
            final /* synthetic */ AvailBuilder this$0;
            final /* synthetic */ ProblemHandler $problemHandler;
            final /* synthetic */ Function0<Unit> $safeAfterAll;
            final /* synthetic */ Function5<ModuleName, Long, Long, Integer, Function0<? extends A_Phrase>, Unit> $localTracker;
            final /* synthetic */ Function2<Long, Long, Unit> $globalTracker;
            final /* synthetic */ ModuleName $target;
            {
                this.this$0 = $receiver;
                this.$problemHandler = $problemHandler;
                this.$safeAfterAll = $safeAfterAll;
                this.$localTracker = $localTracker;
                this.$globalTracker = $globalTracker;
                this.$target = $target;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.getModuleGraph().isCyclic()) {
                    ProblemType problemType = ProblemType.TRACE;
                    Object[] objectArray = new Object[1];
                    String string2 = this.this$0.getModuleGraph().getFirstCycle().stream().map(arg_0 -> buildTargetThen.1.invoke$lambda$0(buildTargetThen.2.INSTANCE, arg_0)).collect(Collectors.joining("\n\t", "\n\t", ""));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"collect(...)");
                    objectArray[0] = string2;
                    Object[] objectArray2 = objectArray;
                    this.$problemHandler.handle(new Problem(this.$target, this.this$0, problemType, objectArray2){
                        final /* synthetic */ AvailBuilder this$0;
                        {
                            this.this$0 = $receiver;
                            super($target, 1, 0L, $super_call_param$1, "Cycle detected in ancestor modules: {0}", $super_call_param$2);
                        }

                        public void abortCompilation() {
                            this.this$0.setStopBuildReason("Module graph has cyclic dependency");
                        }
                    });
                }
                if (this.this$0.getShouldStopBuild()) {
                    this.$safeAfterAll.invoke();
                    return;
                }
                BuildLoader buildLoader = new BuildLoader(this.this$0, this.$localTracker, this.$globalTracker, this.$problemHandler);
                buildLoader.loadThen(this.$safeAfterAll);
            }

            private static final String invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(p0);
            }
        }));
    }

    public final void buildTargetThen(@NotNull Set<? extends ModuleName> targets, @NotNull Function5<? super ModuleName, ? super Long, ? super Long, ? super Integer, ? super Function0<? extends A_Phrase>, Unit> localTracker, @NotNull Function2<? super Long, ? super Long, Unit> globalTracker, @NotNull ProblemHandler problemHandler, @NotNull Function0<Unit> originalAfterAll) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter(localTracker, (String)"localTracker");
        Intrinsics.checkNotNullParameter(globalTracker, (String)"globalTracker");
        Intrinsics.checkNotNullParameter((Object)problemHandler, (String)"problemHandler");
        Intrinsics.checkNotNullParameter(originalAfterAll, (String)"originalAfterAll");
        AtomicBoolean ran = new AtomicBoolean(false);
        Function0 safeAfterAll2 = (Function0)new Function0<Unit>(ran, this, originalAfterAll){
            final /* synthetic */ AtomicBoolean $ran;
            final /* synthetic */ AvailBuilder this$0;
            final /* synthetic */ Function0<Unit> $originalAfterAll;
            {
                this.$ran = $ran;
                this.this$0 = $receiver;
                this.$originalAfterAll = $originalAfterAll;
                super(0);
            }

            public final void invoke() {
                boolean bl;
                boolean old = this.$ran.getAndSet(true);
                boolean bl2 = bl = !old;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                this.this$0.trimGraphToLoadedModules$avail();
                this.$originalAfterAll.invoke();
            }
        };
        this.clearShouldStopBuild();
        new BuildUnloader(this).unloadModified();
        if (this.getShouldStopBuild()) {
            safeAfterAll2.invoke();
            return;
        }
        new BuildTracer(this).traceThen(targets, problemHandler, (Function0<Unit>)((Function0)new Function0<Unit>(this, problemHandler, (Function0<Unit>)safeAfterAll2, localTracker, globalTracker){
            final /* synthetic */ AvailBuilder this$0;
            final /* synthetic */ ProblemHandler $problemHandler;
            final /* synthetic */ Function0<Unit> $safeAfterAll;
            final /* synthetic */ Function5<ModuleName, Long, Long, Integer, Function0<? extends A_Phrase>, Unit> $localTracker;
            final /* synthetic */ Function2<Long, Long, Unit> $globalTracker;
            {
                this.this$0 = $receiver;
                this.$problemHandler = $problemHandler;
                this.$safeAfterAll = $safeAfterAll;
                this.$localTracker = $localTracker;
                this.$globalTracker = $globalTracker;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.getModuleGraph().isCyclic()) {
                    ProblemType problemType = ProblemType.TRACE;
                    Object[] objectArray = new Object[1];
                    String string2 = this.this$0.getModuleGraph().getFirstCycle().stream().map(arg_0 -> buildTargetThen.2.invoke$lambda$0(buildTargetThen.2.INSTANCE, arg_0)).collect(Collectors.joining("\n\t", "\n\t", ""));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"collect(...)");
                    objectArray[0] = string2;
                    Object[] objectArray2 = objectArray;
                    this.$problemHandler.handle(new Problem(this.this$0, problemType, objectArray2){
                        final /* synthetic */ AvailBuilder this$0;
                        {
                            this.this$0 = $receiver;
                            super(null, 1, 0L, $super_call_param$1, "Cycle detected in ancestor modules: {0}", $super_call_param$2);
                        }

                        public void abortCompilation() {
                            this.this$0.setStopBuildReason("Module graph has cyclic dependency");
                        }
                    });
                }
                if (this.this$0.getShouldStopBuild()) {
                    this.$safeAfterAll.invoke();
                    return;
                }
                BuildLoader buildLoader = new BuildLoader(this.this$0, this.$localTracker, this.$globalTracker, this.$problemHandler);
                buildLoader.loadThen(this.$safeAfterAll);
            }

            private static final String invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(p0);
            }
        }));
    }

    public final void buildTarget(@NotNull ModuleName target, @NotNull Function5<? super ModuleName, ? super Long, ? super Long, ? super Integer, ? super Function0<? extends A_Phrase>, Unit> localTracker, @NotNull Function2<? super Long, ? super Long, Unit> globalTracker, @NotNull ProblemHandler problemHandler) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(localTracker, (String)"localTracker");
        Intrinsics.checkNotNullParameter(globalTracker, (String)"globalTracker");
        Intrinsics.checkNotNullParameter((Object)problemHandler, (String)"problemHandler");
        Semaphore semaphore = new Semaphore(0);
        this.buildTargetThen(target, localTracker, globalTracker, problemHandler, (Function0<Unit>)((Function0)new Function0<Unit>(semaphore){
            final /* synthetic */ Semaphore $semaphore;
            {
                this.$semaphore = $semaphore;
                super(0);
            }

            public final void invoke() {
                this.$semaphore.release();
            }
        }));
        semaphore.acquireUninterruptibly();
    }

    public final void unloadTarget(@Nullable ResolvedModuleName target) {
        this.clearShouldStopBuild();
        new BuildUnloader(this).unload(target);
    }

    public final void generateDocumentation(@NotNull ModuleName target, @NotNull Path documentationPath, @NotNull ProblemHandler problemHandler) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)documentationPath, (String)"documentationPath");
        Intrinsics.checkNotNullParameter((Object)problemHandler, (String)"problemHandler");
        this.clearShouldStopBuild();
        BuildTracer tracer = new BuildTracer(this);
        tracer.traceThen(target, problemHandler, (Function0<Unit>)((Function0)new Function0<Unit>(this, documentationPath, problemHandler, target){
            final /* synthetic */ AvailBuilder this$0;
            final /* synthetic */ Path $documentationPath;
            final /* synthetic */ ProblemHandler $problemHandler;
            final /* synthetic */ ModuleName $target;
            {
                this.this$0 = $receiver;
                this.$documentationPath = $documentationPath;
                this.$problemHandler = $problemHandler;
                this.$target = $target;
                super(0);
            }

            public final void invoke() {
                DocumentationTracer documentationTracer = new DocumentationTracer(this.this$0, this.$documentationPath);
                if (!this.this$0.getShouldStopBuild()) {
                    documentationTracer.load(this.$problemHandler);
                }
                if (!this.this$0.getShouldStopBuild()) {
                    documentationTracer.generate(this.$target, this.$problemHandler);
                }
                this.this$0.trimGraphToLoadedModules$avail();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateGraph(@NotNull ResolvedModuleName target, @NotNull File destinationFile, @NotNull ProblemHandler problemHandler) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        Intrinsics.checkNotNullParameter((Object)problemHandler, (String)"problemHandler");
        this.clearShouldStopBuild();
        BuildTracer tracer = new BuildTracer(this);
        try {
            tracer.traceThen(target, problemHandler, (Function0<Unit>)((Function0)new Function0<Unit>(this, target, destinationFile){
                final /* synthetic */ AvailBuilder this$0;
                final /* synthetic */ ResolvedModuleName $target;
                final /* synthetic */ File $destinationFile;
                {
                    this.this$0 = $receiver;
                    this.$target = $target;
                    this.$destinationFile = $destinationFile;
                    super(0);
                }

                public final void invoke() {
                    GraphTracer graphTracer = new GraphTracer(this.this$0, this.$target, this.$destinationFile);
                    if (!this.this$0.getShouldStopBuild()) {
                        graphTracer.traceGraph();
                    }
                }
            }));
        }
        finally {
            this.trimGraphToLoadedModules$avail();
        }
    }

    public final void traceDirectoriesThen(@NotNull Function3<? super ResolvedModuleName, ? super ModuleVersion, ? super Function0<Unit>, Unit> action2, @NotNull Function0<Unit> afterAll) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Intrinsics.checkNotNullParameter(afterAll, (String)"afterAll");
        new BuildDirectoryTracer(this, afterAll).traceAllModuleHeaders(action2);
    }

    public final void attemptCommand(@NotNull String command, @NotNull Function2<? super List<CompiledCommand>, ? super Function1<? super CompiledCommand, Unit>, Unit> onAmbiguity, @NotNull Function2<? super AvailObject, ? super Function1<? super Function0<Unit>, Unit>, Unit> onSuccess, @NotNull Function0<Unit> onFailure) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(onAmbiguity, (String)"onAmbiguity");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        this.clearShouldStopBuild();
        this.runtime.execute(50, (Function0<Unit>)((Function0)new Function0<Unit>(this, command, onAmbiguity, onSuccess, onFailure){
            final /* synthetic */ AvailBuilder this$0;
            final /* synthetic */ String $command;
            final /* synthetic */ Function2<List<CompiledCommand>, Function1<? super CompiledCommand, Unit>, Unit> $onAmbiguity;
            final /* synthetic */ Function2<AvailObject, Function1<? super Function0<Unit>, Unit>, Unit> $onSuccess;
            final /* synthetic */ Function0<Unit> $onFailure;
            {
                this.this$0 = $receiver;
                this.$command = $command;
                this.$onAmbiguity = $onAmbiguity;
                this.$onSuccess = $onSuccess;
                this.$onFailure = $onFailure;
                super(0);
            }

            public final void invoke() {
                AvailBuilder.access$scheduleAttemptCommand(this.this$0, this.$command, this.$onAmbiguity, this.$onSuccess, this.$onFailure);
            }
        }));
    }

    private final void scheduleAttemptCommand(String command, Function2<? super List<CompiledCommand>, ? super Function1<? super CompiledCommand, Unit>, Unit> onAmbiguity, Function2<? super AvailObject, ? super Function1<? super Function0<Unit>, Unit>, Unit> onSuccess, Function0<Unit> onFailure) {
        Set modulesWithEntryPoints = new LinkedHashSet();
        for (Object loadedModule : this.loadedModulesCopy()) {
            if (!(!((Collection)loadedModule.getEntryPoints()).isEmpty())) continue;
            modulesWithEntryPoints.add(loadedModule);
        }
        if (modulesWithEntryPoints.isEmpty()) {
            Object loadedModule;
            loadedModule = ProblemType.EXECUTION;
            Object[] objectArray = new Object[]{};
            Problem problem2 = new Problem(onFailure, (ProblemType)((Object)loadedModule), objectArray){
                final /* synthetic */ Function0<Unit> $onFailure;
                {
                    this.$onFailure = $onFailure;
                    super(null, 1, 1L, $super_call_param$1, "No entry points are defined by loaded modules", $super_call_param$2);
                }

                public void abortCompilation() {
                    this.$onFailure.invoke();
                }
            };
            this.commandProblemHandler.handle(problem2);
            return;
        }
        Map<LoadedModule, List<A_Phrase>> allSolutions = Collections.synchronizedMap(new LinkedHashMap());
        List<Function1<Function0<Unit>, Unit>> allCleanups = Collections.synchronizedList(new ArrayList());
        Map<LoadedModule, List<Problem>> allProblems = Collections.synchronizedMap(new LinkedHashMap());
        AtomicInteger outstanding = new AtomicInteger(modulesWithEntryPoints.size());
        Function0 decrement2 = (Function0)new Function0<Unit>(outstanding, this, allSolutions, allProblems, onAmbiguity, onSuccess, onFailure, allCleanups){
            final /* synthetic */ AtomicInteger $outstanding;
            final /* synthetic */ AvailBuilder this$0;
            final /* synthetic */ Map<LoadedModule, List<A_Phrase>> $allSolutions;
            final /* synthetic */ Map<LoadedModule, List<Problem>> $allProblems;
            final /* synthetic */ Function2<List<CompiledCommand>, Function1<? super CompiledCommand, Unit>, Unit> $onAmbiguity;
            final /* synthetic */ Function2<AvailObject, Function1<? super Function0<Unit>, Unit>, Unit> $onSuccess;
            final /* synthetic */ Function0<Unit> $onFailure;
            final /* synthetic */ List<Function1<Function0<Unit>, Unit>> $allCleanups;
            {
                this.$outstanding = $outstanding;
                this.this$0 = $receiver;
                this.$allSolutions = $allSolutions;
                this.$allProblems = $allProblems;
                this.$onAmbiguity = $onAmbiguity;
                this.$onSuccess = $onSuccess;
                this.$onFailure = $onFailure;
                this.$allCleanups = $allCleanups;
                super(0);
            }

            public final void invoke() {
                if (this.$outstanding.decrementAndGet() == 0) {
                    Map<LoadedModule, List<A_Phrase>> map = this.$allSolutions;
                    Intrinsics.checkNotNullExpressionValue(map, (String)"$allSolutions");
                    Map<LoadedModule, List<Problem>> map2 = this.$allProblems;
                    Intrinsics.checkNotNullExpressionValue(map2, (String)"$allProblems");
                    AvailBuilder.access$processParsedCommand(this.this$0, map, map2, this.$onAmbiguity, this.$onSuccess, (Function1)new Function1<Function0<? extends Unit>, Unit>(this.$allCleanups, this.this$0){
                        final /* synthetic */ List<Function1<Function0<Unit>, Unit>> $allCleanups;
                        final /* synthetic */ AvailBuilder this$0;
                        {
                            this.$allCleanups = $allCleanups;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Function0<Unit> postAction) {
                            Intrinsics.checkNotNullParameter(postAction, (String)"postAction");
                            List<Function1<Function0<Unit>, Unit>> list2 = this.$allCleanups;
                            Intrinsics.checkNotNullExpressionValue(list2, (String)"$allCleanups");
                            CollectionExtensionsKt.parallelDoThen((Collection)list2, (Function2)new Function2<Function1<? super Function0<? extends Unit>, ? extends Unit>, Function0<? extends Unit>, Unit>(this.this$0){
                                final /* synthetic */ AvailBuilder this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2);
                                }

                                public final void invoke(Function1<? super Function0<Unit>, Unit> action2, @NotNull Function0<Unit> after) {
                                    Intrinsics.checkNotNullParameter(after, (String)"after");
                                    this.this$0.getRuntime().execute(50, (Function0<Unit>)((Function0)new Function0<Unit>(action2, after){
                                        final /* synthetic */ Function1<Function0<Unit>, Unit> $action;
                                        final /* synthetic */ Function0<Unit> $after;
                                        {
                                            this.$action = $action;
                                            this.$after = $after;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            this.$action.invoke(this.$after);
                                        }
                                    }));
                                }
                            }, postAction);
                        }
                    }, this.$onFailure);
                }
            }
        };
        for (LoadedModule loadedModule : modulesWithEntryPoints) {
            A_Module module = ModuleDescriptor.Companion.newModule(this.runtime, StringDescriptor.Companion.stringFrom(A_Module.Companion.getModuleNameNative(loadedModule.getModule$avail()) + " (command)"));
            AvailLoader loader = new AvailLoader(this.runtime, module, this.runtime.textInterface());
            ModuleImport moduleImport = ModuleImport.Companion.extend(loadedModule.getModule$avail());
            ModuleHeader header = new ModuleHeader(loadedModule.getName());
            header.getImportedModules().add(moduleImport);
            header.applyToModule(loader);
            A_Module.Companion.addImportedNames(module, A_Tuple.Companion.getAsSet(A_Map.Companion.getValuesAsTuple(A_Module.Companion.getEntryPoints(loadedModule.getModule$avail()))));
            AvailCompiler compiler2 = new AvailCompiler(header, module, StringDescriptor.Companion.stringFrom(command), this.textInterface, this.pollForAbort, (Function5<? super ModuleName, ? super Long, ? super Long, ? super Integer, ? super Function0<? extends A_Phrase>, Unit>)((Function5)scheduleAttemptCommand.compiler.1.INSTANCE), new BuilderProblemHandler(this, allProblems, loadedModule){
                final /* synthetic */ AvailBuilder this$0;
                final /* synthetic */ Map<LoadedModule, List<Problem>> $allProblems;
                final /* synthetic */ LoadedModule $loadedModule;
                {
                    this.this$0 = $receiver;
                    this.$allProblems = $allProblems;
                    this.$loadedModule = $loadedModule;
                    super($receiver, "\u00abcollection only\u00bb");
                }

                public void handleGeneric(@NotNull Problem problem2, @NotNull Function1<? super Boolean, Unit> decider) {
                    Intrinsics.checkNotNullParameter((Object)problem2, (String)"problem");
                    Intrinsics.checkNotNullParameter(decider, (String)"decider");
                    ModuleName moduleName2 = problem2.getModuleName();
                    int n = problem2.getLineNumber();
                    long l = problem2.getCharacterInFile();
                    ProblemType problemType = problem2.getType();
                    Object[] objectArray = new Object[]{problem2.toString()};
                    Object[] objectArray2 = objectArray;
                    Problem copy2 = new Problem(moduleName2, n, l, problemType, objectArray2){

                        public void abortCompilation() {
                        }
                    };
                    this.$allProblems.compute(this.$loadedModule, (arg_0, arg_1) -> scheduleAttemptCommand.compiler.2.handleGeneric$lambda$0((Function2)new Function2<LoadedModule, List<Problem>, List<Problem>>(copy2){
                        final /* synthetic */ scheduleAttemptCommand.compiler.handleGeneric.copy.1 $copy;
                        {
                            this.$copy = $copy;
                            super(2);
                        }

                        @Nullable
                        public final List<Problem> invoke(LoadedModule loadedModule, @Nullable List<Problem> oldV) {
                            List v = oldV == null ? (List)new ArrayList<E>() : oldV;
                            v.add(this.$copy);
                            return v;
                        }
                    }, arg_0, arg_1));
                    decider.invoke((Object)false);
                }

                public void handleInternal(@NotNull Problem problem2, @NotNull Function1<? super Boolean, Unit> decider) {
                    Intrinsics.checkNotNullParameter((Object)problem2, (String)"problem");
                    Intrinsics.checkNotNullParameter(decider, (String)"decider");
                    new SimpleCompletionHandler<V>((Function1)new Function1<SimpleCompletionHandler.Companion.SuccessHelper<Integer>, Unit>(this, problem2, decider){
                        final /* synthetic */ scheduleAttemptCommand.compiler.2 this$0;
                        final /* synthetic */ Problem $problem;
                        final /* synthetic */ Function1<Boolean, Unit> $decider;
                        {
                            this.this$0 = $receiver;
                            this.$problem = $problem;
                            this.$decider = $decider;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.SuccessHelper<Integer> $this$$receiver) {
                            Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                            this.this$0.handleGeneric(this.$problem, this.$decider);
                        }
                    }, (Function1)new Function1<SimpleCompletionHandler.Companion.FailureHelper<Integer>, Unit>(this, problem2, decider){
                        final /* synthetic */ scheduleAttemptCommand.compiler.2 this$0;
                        final /* synthetic */ Problem $problem;
                        final /* synthetic */ Function1<Boolean, Unit> $decider;
                        {
                            this.this$0 = $receiver;
                            this.$problem = $problem;
                            this.$decider = $decider;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.FailureHelper<Integer> $this$$receiver) {
                            Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                            this.this$0.handleGeneric(this.$problem, this.$decider);
                        }
                    }).guardedDo((Function1)new Function1<SimpleCompletionHandler.Companion.GuardHelper<Integer>, Unit>(this.this$0, problem2){
                        final /* synthetic */ AvailBuilder this$0;
                        final /* synthetic */ Problem $problem;
                        {
                            this.this$0 = $receiver;
                            this.$problem = $problem;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.GuardHelper<Integer> $this$guardedDo) {
                            Intrinsics.checkNotNullParameter($this$guardedDo, (String)"$this$guardedDo");
                            this.this$0.getTextInterface().getErrorChannel().write(this.$problem.toString(), Unit.INSTANCE, (CompletionHandler)$this$guardedDo.getHandler());
                        }
                    });
                }

                public void handleExternal(@NotNull Problem problem2, @NotNull Function1<? super Boolean, Unit> decider) {
                    Intrinsics.checkNotNullParameter((Object)problem2, (String)"problem");
                    Intrinsics.checkNotNullParameter(decider, (String)"decider");
                    new SimpleCompletionHandler<V>((Function1)new Function1<SimpleCompletionHandler.Companion.SuccessHelper<Integer>, Unit>(this, problem2, decider){
                        final /* synthetic */ scheduleAttemptCommand.compiler.2 this$0;
                        final /* synthetic */ Problem $problem;
                        final /* synthetic */ Function1<Boolean, Unit> $decider;
                        {
                            this.this$0 = $receiver;
                            this.$problem = $problem;
                            this.$decider = $decider;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.SuccessHelper<Integer> $this$$receiver) {
                            Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                            this.this$0.handleGeneric(this.$problem, this.$decider);
                        }
                    }, (Function1)new Function1<SimpleCompletionHandler.Companion.FailureHelper<Integer>, Unit>(this, problem2, decider){
                        final /* synthetic */ scheduleAttemptCommand.compiler.2 this$0;
                        final /* synthetic */ Problem $problem;
                        final /* synthetic */ Function1<Boolean, Unit> $decider;
                        {
                            this.this$0 = $receiver;
                            this.$problem = $problem;
                            this.$decider = $decider;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.FailureHelper<Integer> $this$$receiver) {
                            Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                            this.this$0.handleGeneric(this.$problem, this.$decider);
                        }
                    }).guardedDo((Function1)new Function1<SimpleCompletionHandler.Companion.GuardHelper<Integer>, Unit>(this.this$0, problem2){
                        final /* synthetic */ AvailBuilder this$0;
                        final /* synthetic */ Problem $problem;
                        {
                            this.this$0 = $receiver;
                            this.$problem = $problem;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.GuardHelper<Integer> $this$guardedDo) {
                            Intrinsics.checkNotNullParameter($this$guardedDo, (String)"$this$guardedDo");
                            this.this$0.getTextInterface().getErrorChannel().write(this.$problem.toString(), Unit.INSTANCE, (CompletionHandler)$this$guardedDo.getHandler());
                        }
                    });
                }

                private static final List handleGeneric$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (List)$tmp0.invoke(p0, p1);
                }
            });
            compiler2.parseCommand((Function2<? super List<? extends A_Phrase>, ? super Function1<? super Function0<Unit>, Unit>, Unit>)((Function2)new Function2<List<? extends A_Phrase>, Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(allSolutions, loadedModule, allCleanups, (Function0<Unit>)decrement2){
                final /* synthetic */ Map<LoadedModule, List<A_Phrase>> $allSolutions;
                final /* synthetic */ LoadedModule $loadedModule;
                final /* synthetic */ List<Function1<Function0<Unit>, Unit>> $allCleanups;
                final /* synthetic */ Function0<Unit> $decrement;
                {
                    this.$allSolutions = $allSolutions;
                    this.$loadedModule = $loadedModule;
                    this.$allCleanups = $allCleanups;
                    this.$decrement = $decrement;
                    super(2);
                }

                public final void invoke(@NotNull List<? extends A_Phrase> solutions2, @NotNull Function1<? super Function0<Unit>, Unit> cleanup) {
                    Intrinsics.checkNotNullParameter(solutions2, (String)"solutions");
                    Intrinsics.checkNotNullParameter(cleanup, (String)"cleanup");
                    Map<LoadedModule, List<A_Phrase>> map = this.$allSolutions;
                    Intrinsics.checkNotNullExpressionValue(map, (String)"$allSolutions");
                    Map<LoadedModule, List<A_Phrase>> map2 = map;
                    map2.put(this.$loadedModule, solutions2);
                    this.$allCleanups.add(cleanup);
                    this.$decrement.invoke();
                }
            }), (Function0<Unit>)decrement2);
        }
    }

    private final void processParsedCommand(Map<LoadedModule, ? extends List<? extends A_Phrase>> solutions2, Map<LoadedModule, ? extends List<? extends Problem>> problems, Function2<? super List<CompiledCommand>, ? super Function1<? super CompiledCommand, Unit>, Unit> onAmbiguity, Function2<? super AvailObject, ? super Function1<? super Function0<Unit>, Unit>, Unit> onSuccess, Function1<? super Function0<Unit>, Unit> postSuccessCleanup, Function0<Unit> onFailure) {
        if (solutions2.isEmpty()) {
            long deepestPosition = Long.MIN_VALUE;
            List list2 = new ArrayList();
            Iterator<Map.Entry<LoadedModule, List<Problem>>> objectArray = problems.entrySet().iterator();
            while (objectArray.hasNext()) {
                List<? extends Problem> value = objectArray.next().getValue();
                for (Problem problem2 : value) {
                    if (problem2.getCharacterInFile() > deepestPosition) {
                        deepestPosition = problem2.getCharacterInFile();
                        list2.clear();
                    }
                    if (problem2.getCharacterInFile() != deepestPosition) continue;
                    list2.add(problem2);
                }
            }
            for (Problem problem3 : list2) {
                this.commandProblemHandler.handle(problem3);
            }
            onFailure.invoke();
            return;
        }
        List commands = new ArrayList();
        for (Map.Entry<LoadedModule, ? extends List<? extends A_Phrase>> object : solutions2.entrySet()) {
            LoadedModule key = object.getKey();
            List<? extends A_Phrase> value = object.getValue();
            List<String> moduleEntryPoints = key.getEntryPoints();
            for (A_Phrase a_Phrase : value) {
                A_Atom name;
                String nameString;
                if (!a_Phrase.isInstanceOfKind(PhraseTypeDescriptor.PhraseKind.SEND_PHRASE.getMostGeneralType()) || !moduleEntryPoints.contains(nameString = A_String.Companion.asNativeString(A_Atom.Companion.getAtomName(name = A_Phrase.Companion.getApparentSendName(a_Phrase))))) continue;
                commands.add(new CompiledCommand(key.getName(), nameString, a_Phrase));
            }
        }
        if (commands.isEmpty()) {
            ProblemType problemType = ProblemType.PARSE;
            Object[] objectArray = new Object[]{};
            Problem problem4 = new Problem(onFailure, problemType, objectArray){
                final /* synthetic */ Function0<Unit> $onFailure;
                {
                    this.$onFailure = $onFailure;
                    super(null, 1, 1L, $super_call_param$1, "The command could be parsed, but not as an invocation of an entry point.", $super_call_param$2);
                }

                public void abortCompilation() {
                    this.$onFailure.invoke();
                }
            };
            this.commandProblemHandler.handle(problem4);
            return;
        }
        Function1 unambiguous2 = (Function1)new Function1<CompiledCommand, Unit>(this, onSuccess, postSuccessCleanup, onFailure){
            final /* synthetic */ AvailBuilder this$0;
            final /* synthetic */ Function2<AvailObject, Function1<? super Function0<Unit>, Unit>, Unit> $onSuccess;
            final /* synthetic */ Function1<Function0<Unit>, Unit> $postSuccessCleanup;
            final /* synthetic */ Function0<Unit> $onFailure;
            {
                this.this$0 = $receiver;
                this.$onSuccess = $onSuccess;
                this.$postSuccessCleanup = $postSuccessCleanup;
                this.$onFailure = $onFailure;
                super(1);
            }

            public final void invoke(@NotNull CompiledCommand command) {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                A_Phrase phrase = command.getPhrase();
                A_Function function = FunctionDescriptor.Companion.createFunctionForPhrase(phrase, NilDescriptor.Companion.getNil(), 1);
                A_Fiber fiber2 = FiberDescriptor.Companion.newFiber$default(FiberDescriptor.Companion, A_Type.Companion.getReturnType(function.kind()), this.this$0.getRuntime(), this.this$0.getTextInterface(), 50, null, (Function0)new Function0<A_String>(phrase){
                    final /* synthetic */ A_Phrase $phrase;
                    {
                        this.$phrase = $phrase;
                        super(0);
                    }

                    @NotNull
                    public final A_String invoke() {
                        return StringDescriptor.Companion.stringFrom("Running command: " + this.$phrase);
                    }
                }, 16, null);
                A_Fiber.Companion.setFiberGlobals(fiber2, A_Map.Companion.mapAtPuttingCanDestroy(A_Fiber.Companion.getFiberGlobals(fiber2), AtomDescriptor.SpecialAtom.CLIENT_DATA_GLOBAL_KEY.getAtom(), MapDescriptor.Companion.getEmptyMap(), true));
                A_Fiber.Companion.setSuccessAndFailure(fiber2, (Function1<? super AvailObject, Unit>)((Function1)new Function1<AvailObject, Unit>(this.$onSuccess, this.$postSuccessCleanup){
                    final /* synthetic */ Function2<AvailObject, Function1<? super Function0<Unit>, Unit>, Unit> $onSuccess;
                    final /* synthetic */ Function1<Function0<Unit>, Unit> $postSuccessCleanup;
                    {
                        this.$onSuccess = $onSuccess;
                        this.$postSuccessCleanup = $postSuccessCleanup;
                        super(1);
                    }

                    public final void invoke(@NotNull AvailObject result2) {
                        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                        this.$onSuccess.invoke((Object)result2, this.$postSuccessCleanup);
                    }
                }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.$onFailure, this.this$0){
                    final /* synthetic */ Function0<Unit> $onFailure;
                    final /* synthetic */ AvailBuilder this$0;
                    {
                        this.$onFailure = $onFailure;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Throwable e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (e instanceof FiberTerminationException) {
                            this.$onFailure.invoke();
                        } else {
                            ProblemType problemType = ProblemType.EXECUTION;
                            Object[] objectArray = new Object[]{e.getMessage() != null ? " " + e.getMessage() : "", StackPrinterKt.getStackToString(e)};
                            Object[] objectArray2 = objectArray;
                            Problem problem2 = new Problem(this.$onFailure, problemType, objectArray2){
                                final /* synthetic */ Function0<Unit> $onFailure;
                                {
                                    this.$onFailure = $onFailure;
                                    super(null, 1, 1L, $super_call_param$1, "Error executing command:{0}\n{1}", $super_call_param$2);
                                }

                                public void abortCompilation() {
                                    this.$onFailure.invoke();
                                }
                            };
                            AvailBuilder.access$getCommandProblemHandler$p(this.this$0).handle(problem2);
                        }
                    }
                }));
                this.this$0.getRuntime().runOutermostFunction(fiber2, function, CollectionsKt.emptyList(), false);
            }
        };
        if (commands.size() == 1) {
            unambiguous2.invoke(commands.get(0));
            return;
        }
        onAmbiguity.invoke((Object)commands, (Object)new Function1<CompiledCommand, Unit>((Function1<? super CompiledCommand, Unit>)unambiguous2, onFailure, this){
            final /* synthetic */ Function1<CompiledCommand, Unit> $unambiguous;
            final /* synthetic */ Function0<Unit> $onFailure;
            final /* synthetic */ AvailBuilder this$0;
            {
                this.$unambiguous = $unambiguous;
                this.$onFailure = $onFailure;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable CompiledCommand choice) {
                if (choice == null) {
                    new SimpleCompletionHandler<V>((Function1)new Function1<SimpleCompletionHandler.Companion.SuccessHelper<Integer>, Unit>(this.$onFailure){
                        final /* synthetic */ Function0<Unit> $onFailure;
                        {
                            this.$onFailure = $onFailure;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.SuccessHelper<Integer> $this$$receiver) {
                            Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                            this.$onFailure.invoke();
                        }
                    }, (Function1)new Function1<SimpleCompletionHandler.Companion.FailureHelper<Integer>, Unit>(this.$onFailure){
                        final /* synthetic */ Function0<Unit> $onFailure;
                        {
                            this.$onFailure = $onFailure;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.FailureHelper<Integer> $this$$receiver) {
                            Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                            this.$onFailure.invoke();
                        }
                    }).guardedDo((Function1)new Function1<SimpleCompletionHandler.Companion.GuardHelper<Integer>, Unit>(this.this$0){
                        final /* synthetic */ AvailBuilder this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.GuardHelper<Integer> $this$guardedDo) {
                            Intrinsics.checkNotNullParameter($this$guardedDo, (String)"$this$guardedDo");
                            this.this$0.getTextInterface().getErrorChannel().write("Action was cancelled by user", Unit.INSTANCE, (CompletionHandler)$this$guardedDo.getHandler());
                        }
                    });
                } else {
                    this.$unambiguous.invoke((Object)choice);
                }
            }
        });
    }

    public static final /* synthetic */ void access$scheduleAttemptCommand(AvailBuilder $this, String command, Function2 onAmbiguity, Function2 onSuccess, Function0 onFailure) {
        $this.scheduleAttemptCommand(command, (Function2<? super List<CompiledCommand>, ? super Function1<? super CompiledCommand, Unit>, Unit>)onAmbiguity, (Function2<? super AvailObject, ? super Function1<? super Function0<Unit>, Unit>, Unit>)onSuccess, (Function0<Unit>)onFailure);
    }

    public static final /* synthetic */ void access$processParsedCommand(AvailBuilder $this, Map solutions2, Map problems, Function2 onAmbiguity, Function2 onSuccess, Function1 postSuccessCleanup, Function0 onFailure) {
        $this.processParsedCommand(solutions2, problems, (Function2<? super List<CompiledCommand>, ? super Function1<? super CompiledCommand, Unit>, Unit>)onAmbiguity, (Function2<? super AvailObject, ? super Function1<? super Function0<Unit>, Unit>, Unit>)onSuccess, (Function1<? super Function0<Unit>, Unit>)postSuccessCleanup, (Function0<Unit>)onFailure);
    }

    public static final /* synthetic */ ProblemHandler access$getCommandProblemHandler$p(AvailBuilder $this) {
        return $this.commandProblemHandler;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0011\"\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J;\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0011\"\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lavail/builder/AvailBuilder$Companion;", "", "()V", "debugBuilder", "", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "maximumStaleRepositoryMs", "", "log", "", "level", "Ljava/util/logging/Level;", "format", "", "args", "", "log$avail", "(Ljava/util/logging/Level;Ljava/lang/String;[Ljava/lang/Object;)V", "exception", "", "(Ljava/util/logging/Level;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final void log$avail(@NotNull Level level, @NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        }

        public final void log$avail(@NotNull Level level, @NotNull Throwable exception, @NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lavail/builder/AvailBuilder$CompiledCommand;", "", "moduleName", "Lavail/builder/ResolvedModuleName;", "entryPointName", "", "phrase", "Lavail/descriptor/phrases/A_Phrase;", "(Lavail/builder/ResolvedModuleName;Ljava/lang/String;Lavail/descriptor/phrases/A_Phrase;)V", "getModuleName", "()Lavail/builder/ResolvedModuleName;", "getPhrase", "()Lavail/descriptor/phrases/A_Phrase;", "toString", "avail"})
    public static final class CompiledCommand {
        @NotNull
        private final ResolvedModuleName moduleName;
        @NotNull
        private final String entryPointName;
        @NotNull
        private final A_Phrase phrase;

        public CompiledCommand(@NotNull ResolvedModuleName moduleName2, @NotNull String entryPointName, @NotNull A_Phrase phrase) {
            Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)entryPointName, (String)"entryPointName");
            Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
            this.moduleName = moduleName2;
            this.entryPointName = entryPointName;
            this.phrase = phrase;
        }

        @NotNull
        public final ResolvedModuleName getModuleName() {
            return this.moduleName;
        }

        @NotNull
        public final A_Phrase getPhrase() {
            return this.phrase;
        }

        @NotNull
        public String toString() {
            return this.moduleName.getQualifiedName() + " : " + this.entryPointName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lavail/builder/AvailBuilder$LoadedModule;", "", "name", "Lavail/builder/ResolvedModuleName;", "sourceDigest", "", "module", "Lavail/descriptor/module/A_Module;", "version", "Lavail/persistence/cache/record/ModuleVersion;", "compilation", "Lavail/persistence/cache/record/ModuleCompilation;", "(Lavail/builder/ResolvedModuleName;[BLavail/descriptor/module/A_Module;Lavail/persistence/cache/record/ModuleVersion;Lavail/persistence/cache/record/ModuleCompilation;)V", "getCompilation$avail", "()Lavail/persistence/cache/record/ModuleCompilation;", "deletionRequest", "", "getDeletionRequest$avail", "()Z", "setDeletionRequest$avail", "(Z)V", "entryPoints", "", "", "getEntryPoints", "()Ljava/util/List;", "getModule$avail", "()Lavail/descriptor/module/A_Module;", "getName", "()Lavail/builder/ResolvedModuleName;", "getSourceDigest$avail", "()[B", "getVersion$avail", "()Lavail/persistence/cache/record/ModuleVersion;", "avail"})
    public static final class LoadedModule {
        @NotNull
        private final ResolvedModuleName name;
        @NotNull
        private final A_Module module;
        @NotNull
        private final ModuleVersion version;
        @NotNull
        private final ModuleCompilation compilation;
        @NotNull
        private final byte[] sourceDigest;
        private boolean deletionRequest;
        @NotNull
        private final List<String> entryPoints;

        public LoadedModule(@NotNull ResolvedModuleName name, @NotNull byte[] sourceDigest, @NotNull A_Module module, @NotNull ModuleVersion version, @NotNull ModuleCompilation compilation) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)sourceDigest, (String)"sourceDigest");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)compilation, (String)"compilation");
            this.name = name;
            this.module = module;
            this.version = version;
            this.compilation = compilation;
            this.sourceDigest = (byte[])sourceDigest.clone();
            this.entryPoints = this.version.getEntryPoints();
        }

        @NotNull
        public final ResolvedModuleName getName() {
            return this.name;
        }

        @NotNull
        public final A_Module getModule$avail() {
            return this.module;
        }

        @NotNull
        public final ModuleVersion getVersion$avail() {
            return this.version;
        }

        @NotNull
        public final ModuleCompilation getCompilation$avail() {
            return this.compilation;
        }

        @NotNull
        public final byte[] getSourceDigest$avail() {
            return this.sourceDigest;
        }

        public final boolean getDeletionRequest$avail() {
            return this.deletionRequest;
        }

        public final void setDeletionRequest$avail(boolean bl) {
            this.deletionRequest = bl;
        }

        @NotNull
        public final List<String> getEntryPoints() {
            return this.entryPoints;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000JB\u0010\u001a\u001a\u00020\u00182\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00180\u001c2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00180\u001c2\u0006\u0010\u001f\u001a\u00020\u001dR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\"\u0010\u0010\u001a\u0004\u0018\u00010\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0000@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\r\u00a8\u0006 "}, d2={"Lavail/builder/AvailBuilder$ModuleTree;", "", "node", "", "label", "resolvedModuleName", "Lavail/builder/ResolvedModuleName;", "(Ljava/lang/String;Ljava/lang/String;Lavail/builder/ResolvedModuleName;)V", "children", "", "getChildren", "()Ljava/util/List;", "getLabel", "()Ljava/lang/String;", "getNode", "<set-?>", "parent", "getParent$avail", "()Lavail/builder/AvailBuilder$ModuleTree;", "getResolvedModuleName", "()Lavail/builder/ResolvedModuleName;", "safeLabel", "getSafeLabel", "addChild", "", "child", "recursiveDo", "enter", "Lkotlin/Function2;", "", "exit", "depth", "avail"})
    public static final class ModuleTree {
        @NotNull
        private final String node;
        @NotNull
        private final String label;
        @Nullable
        private final ResolvedModuleName resolvedModuleName;
        @Nullable
        private ModuleTree parent;
        @NotNull
        private final List<ModuleTree> children;

        public ModuleTree(@NotNull String node, @NotNull String label, @Nullable ResolvedModuleName resolvedModuleName) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.node = node;
            this.label = label;
            this.resolvedModuleName = resolvedModuleName;
            this.children = new ArrayList();
        }

        @NotNull
        public final String getNode() {
            return this.node;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @Nullable
        public final ResolvedModuleName getResolvedModuleName() {
            return this.resolvedModuleName;
        }

        @Nullable
        public final ModuleTree getParent$avail() {
            return this.parent;
        }

        @NotNull
        public final List<ModuleTree> getChildren() {
            return this.children;
        }

        public final void addChild(@NotNull ModuleTree child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            this.children.add(child);
            child.parent = this;
        }

        @NotNull
        public final String getSafeLabel() {
            String addendum = this.label.charAt(this.label.length() - 1) == '\\' ? " " : "";
            CharSequence charSequence = this.label;
            Regex regex = new Regex("\"");
            String string2 = "\\\"";
            return "\"" + regex.replace(charSequence, string2) + addendum + "\"";
        }

        public final void recursiveDo(@NotNull Function2<? super ModuleTree, ? super Integer, Unit> enter, @NotNull Function2<? super ModuleTree, ? super Integer, Unit> exit, int depth2) {
            Intrinsics.checkNotNullParameter(enter, (String)"enter");
            Intrinsics.checkNotNullParameter(exit, (String)"exit");
            enter.invoke((Object)this, (Object)depth2);
            int nextDepth = depth2 + 1;
            for (ModuleTree child : this.children) {
                child.recursiveDo(enter, exit, nextDepth);
            }
            exit.invoke((Object)this, (Object)depth2);
        }
    }
}

