/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.tuples;

import avail.annotations.HideFieldInDebugger;
import avail.descriptor.character.A_Character;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectFieldHelper;
import avail.descriptor.representation.AvailObjectRepresentation;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ByteStringDescriptor;
import avail.descriptor.tuples.ByteTupleDescriptor;
import avail.descriptor.tuples.IntTupleDescriptor;
import avail.descriptor.tuples.LongTupleDescriptor;
import avail.descriptor.tuples.NumericTupleDescriptor;
import avail.descriptor.tuples.NybbleTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TreeTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.tuples.TwoByteStringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.serialization.SerializerOperation;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 A2\u00020\u0001:\u0002ABB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0000H\u0016J\b\u0010\b\u001a\u00020\u0000H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J0\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J \u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001b\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u000eH\u0016J\u0018\u0010%\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020\nH\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0005H\u0016J\u0018\u0010*\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0018\u0010+\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u00100\u001a\u0002012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u000205H\u0016J\u0018\u00106\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0005H\u0016J(\u00107\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u00109\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0006\u0010:\u001a\u00020-H\u0016J\u0018\u0010;\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0005H\u0016J\u0018\u0010<\u001a\u00020=2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0005H\u0016J\u0010\u0010>\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010?\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010@\u001a\u00020\u0000H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lavail/descriptor/tuples/NybbleTupleDescriptor;", "Lavail/descriptor/tuples/NumericTupleDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "unusedNybblesOfLastLong", "", "(Lavail/descriptor/representation/Mutability;I)V", "immutable", "mutable", "o_AppendCanDestroy", "Lavail/descriptor/tuples/A_Tuple;", "self", "Lavail/descriptor/representation/AvailObject;", "newElement", "Lavail/descriptor/representation/A_BasicObject;", "canDestroy", "", "o_BitsPerEntry", "o_CompareFromToWithNybbleTupleStartingAt", "startIndex1", "endIndex1", "aNybbleTuple", "startIndex2", "o_CompareFromToWithStartingAt", "anotherObject", "o_ComputeHashFromTo", "start", "end", "o_ConcatenateWith", "otherTuple", "o_CopyTupleFromToCanDestroy", "o_DescribeForDebugger", "", "Lavail/descriptor/representation/AvailObjectFieldHelper;", "(Lavail/descriptor/representation/AvailObject;)[Lavail/descriptor/representation/AvailObjectFieldHelper;", "o_Equals", "another", "o_EqualsNybbleTuple", "aTuple", "o_ExtractNybbleFromTupleAt", "", "index", "o_IsBetterRepresentationThan", "o_IsInstanceOfKind", "aType", "Lavail/descriptor/types/A_Type;", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_TransferIntoByteBuffer", "", "startIndex", "endIndex", "outputByteBuffer", "Ljava/nio/ByteBuffer;", "o_TupleAt", "o_TupleAtPuttingCanDestroy", "newValueObject", "o_TupleElementsInRangeAreInstancesOf", "type", "o_TupleIntAt", "o_TupleLongAt", "", "o_TupleReverse", "o_TupleSize", "shared", "Companion", "IntegerSlots", "avail"})
@SourceDebugExtension(value={"SMAP\nNybbleTupleDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NybbleTupleDescriptor.kt\navail/descriptor/tuples/NybbleTupleDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,800:1\n1620#2,2:801\n1855#2,2:803\n1622#2:805\n1726#2,3:808\n37#3,2:806\n*S KotlinDebug\n*F\n+ 1 NybbleTupleDescriptor.kt\navail/descriptor/tuples/NybbleTupleDescriptor\n*L\n167#1:801,2\n179#1:803,2\n167#1:805\n507#1:808,3\n192#1:806,2\n*E\n"})
public final class NybbleTupleDescriptor
extends NumericTupleDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int unusedNybblesOfLastLong;
    private static final int maximumCopySize = 128;
    @NotNull
    private static final NybbleTupleDescriptor[] descriptors = new NybbleTupleDescriptor[48];
    @NotNull
    private static final CheckedMethod createUninitializedNybbleTupleMethod;

    private NybbleTupleDescriptor(Mutability mutability, int unusedNybblesOfLastLong) {
        super(mutability, null, IntegerSlots.class);
        this.unusedNybblesOfLastLong = unusedNybblesOfLastLong;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AvailObjectFieldHelper[] o_DescribeForDebugger(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int nybblesCount = A_Tuple.Companion.getTupleSize(self);
        AvailObjectFieldHelper[] availObjectFieldHelperArray = super.o_DescribeForDebugger(self);
        List fields = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(availObjectFieldHelperArray, availObjectFieldHelperArray.length));
        int longsCount = self.variableIntegerSlotsCount();
        Iterable $this$mapTo$iv = (Iterable)new IntRange(1, longsCount);
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            String text;
            StringBuilder stringBuilder;
            void longIndex;
            int item$iv;
            int n = item$iv = ((IntIterator)iterator2).nextInt();
            Collection collection2 = fields;
            boolean bl = false;
            long value = self.get(IntegerSlots.RAW_LONG_AT_, (int)longIndex);
            void lowIndex = longIndex * 16 - 15;
            int highIndex = Math.min((int)(longIndex * 16), nybblesCount);
            StringBuilder $this$o_DescribeForDebugger_u24lambda_u242_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$o_DescribeForDebugger_u24lambda_u242_u24lambda_u241.append("Nybbles[" + (int)lowIndex + ".." + highIndex + "] ");
            String string2 = "0x%04X_%04X_%04X_%04X  :  ";
            Object object = new Object[]{value >>> 48 & 0xFFFFL, value >>> 32 & 0xFFFFL, value >>> 16 & 0xFFFFL, value & 0xFFFFL};
            String string3 = String.format(string2, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            $this$o_DescribeForDebugger_u24lambda_u242_u24lambda_u241.append(string3);
            Iterable $this$forEach$iv = (Iterable)new IntRange((int)lowIndex, highIndex);
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                int element$iv;
                int i2 = element$iv = ((IntIterator)object).nextInt();
                boolean bl3 = false;
                if ((i2 & 3) == 1) {
                    $this$o_DescribeForDebugger_u24lambda_u242_u24lambda_u241.append(" ");
                }
                $this$o_DescribeForDebugger_u24lambda_u242_u24lambda_u241.append(" ");
                $this$o_DescribeForDebugger_u24lambda_u242_u24lambda_u241.append("0123456789ABCDEF".charAt(A_Tuple.Companion.tupleIntAt(self, i2)));
            }
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            collection2.add(new AvailObjectFieldHelper(self, IntegerSlots.RAW_LONG_AT_, -1, value, null, text, null, 80, null));
        }
        Collection $this$toTypedArray$iv = fields;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AvailObjectFieldHelper[0]);
    }

    @Override
    @NotNull
    public A_Tuple o_AppendCanDestroy(@NotNull AvailObject self, @NotNull A_BasicObject newElement, boolean canDestroy) {
        int originalSize;
        AvailObject strongNewElement;
        block5: {
            A_Tuple a_Tuple;
            block7: {
                long longValue;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)self, (String)"self");
                    Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
                    strongNewElement = (AvailObject)newElement;
                    originalSize = A_Tuple.Companion.getTupleSize(self);
                    if (originalSize != 0) break block5;
                    if (A_Character.Companion.isCharacter(strongNewElement)) {
                        int codePoint = A_Character.Companion.getCodePoint(strongNewElement);
                        return (0 <= codePoint ? codePoint < 256 : false) ? (A_Tuple)ByteStringDescriptor.Companion.generateByteString(1, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(codePoint){
                            final /* synthetic */ int $codePoint;
                            {
                                this.$codePoint = $codePoint;
                                super(1);
                            }

                            @NotNull
                            public final Integer invoke(int it) {
                                return this.$codePoint;
                            }
                        })) : ((0 <= codePoint ? codePoint < 65536 : false) ? (A_Tuple)TwoByteStringDescriptor.Companion.generateTwoByteString(1, (Function1<? super Integer, UShort>)((Function1)new Function1<Integer, UShort>(codePoint){
                            final /* synthetic */ int $codePoint;
                            {
                                this.$codePoint = $codePoint;
                                super(1);
                            }

                            public final short invoke-BwKQO78(int it) {
                                return UShort.constructor-impl((short)((short)this.$codePoint));
                            }
                        })) : ObjectTupleDescriptor.Companion.tuple(strongNewElement));
                    }
                    if (!A_Number.Companion.isLong(strongNewElement)) break block5;
                    longValue = A_Number.Companion.getExtractLong(strongNewElement);
                    boolean bl = 0L <= longValue ? longValue < 16L : false;
                    if (!bl) break block6;
                    a_Tuple = Companion.generateNybbleTupleFrom(1, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(longValue){
                        final /* synthetic */ long $longValue;
                        {
                            this.$longValue = $longValue;
                            super(1);
                        }

                        @NotNull
                        public final Integer invoke(int it) {
                            return (int)this.$longValue;
                        }
                    }));
                    break block7;
                }
                a_Tuple = (0L <= longValue ? longValue < 256L : false) ? (A_Tuple)ByteTupleDescriptor.Companion.generateByteTupleFrom(1, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(longValue){
                    final /* synthetic */ long $longValue;
                    {
                        this.$longValue = $longValue;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (int)this.$longValue;
                    }
                })) : ((Integer.MIN_VALUE <= longValue ? longValue <= Integer.MAX_VALUE : false) ? (A_Tuple)IntTupleDescriptor.Companion.generateIntTupleFrom(1, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(longValue){
                    final /* synthetic */ long $longValue;
                    {
                        this.$longValue = $longValue;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(int it) {
                        return (int)this.$longValue;
                    }
                })) : (A_Tuple)LongTupleDescriptor.Companion.generateLongTupleFrom(1, (Function1<? super Integer, Long>)((Function1)new Function1<Integer, Long>(longValue){
                    final /* synthetic */ long $longValue;
                    {
                        this.$longValue = $longValue;
                        super(1);
                    }

                    @NotNull
                    public final Long invoke(int it) {
                        return this.$longValue;
                    }
                })));
            }
            return a_Tuple;
        }
        if (originalSize < 128 && A_Number.Companion.isInt(strongNewElement)) {
            int intValue = A_Number.Companion.getExtractInt(strongNewElement);
            if ((intValue & 0xFFFFFFF0) != 0) {
                A_Tuple singleton2 = ObjectTupleDescriptor.Companion.tuple(strongNewElement);
                return A_Tuple.Companion.concatenateWith(self, singleton2, canDestroy);
            }
            int newSize = originalSize + 1;
            AvailObject result2 = null;
            if (this.isMutable() && canDestroy && (originalSize & 0xF) != 0) {
                result2 = self;
                result2.setDescriptor(NybbleTupleDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize));
            } else {
                result2 = AvailObjectRepresentation.Companion.newLike(NybbleTupleDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize), self, 0, (originalSize & 0xF) == 0 ? 1 : 0);
            }
            NybbleTupleDescriptor.Companion.setNybble(result2, newSize, (byte)intValue);
            result2.set(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return result2;
        }
        A_Tuple singleton3 = ObjectTupleDescriptor.Companion.tuple(strongNewElement);
        return A_Tuple.Companion.concatenateWith(self, singleton3, canDestroy);
    }

    @Override
    public int o_BitsPerEntry(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return 4;
    }

    @Override
    public boolean o_CompareFromToWithNybbleTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple aNybbleTuple, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aNybbleTuple, (String)"aNybbleTuple");
        if (self.sameAddressAs(aNybbleTuple) && startIndex1 == startIndex2) {
            return true;
        }
        if (endIndex1 < startIndex1) {
            return true;
        }
        int index2 = startIndex2;
        int i2 = startIndex1;
        if (i2 <= endIndex1) {
            while (true) {
                if (Companion.getNybble(self, i2) != A_Tuple.Companion.extractNybbleFromTupleAt(aNybbleTuple, index2)) {
                    return false;
                }
                ++index2;
                if (i2 == endIndex1) break;
                ++i2;
            }
        }
        return true;
    }

    @Override
    public boolean o_CompareFromToWithStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anotherObject, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anotherObject, (String)"anotherObject");
        return A_Tuple.Companion.compareFromToWithNybbleTupleStartingAt(anotherObject, startIndex2, startIndex2 + endIndex1 - startIndex1, self, startIndex1);
    }

    @Override
    public int o_ComputeHashFromTo(@NotNull AvailObject self, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int hash = 0;
        int nybbleIndex = end;
        if (start <= nybbleIndex) {
            while (true) {
                int itemHash = IntegerDescriptor.Companion.hashOfUnsignedByte(Companion.getNybble(self, nybbleIndex)) ^ 0x71E570A6;
                hash = (hash + itemHash) * 1664525;
                if (nybbleIndex == start) break;
                --nybbleIndex;
            }
        }
        return hash;
    }

    @Override
    @NotNull
    public A_Tuple o_ConcatenateWith(@NotNull AvailObject self, @NotNull A_Tuple otherTuple, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)otherTuple, (String)"otherTuple");
        int size1 = A_Tuple.Companion.getTupleSize(self);
        if (size1 == 0) {
            if (!canDestroy) {
                otherTuple.makeImmutable();
            }
            return otherTuple;
        }
        int size2 = A_Tuple.Companion.getTupleSize(otherTuple);
        if (size2 == 0) {
            if (!canDestroy) {
                self.makeImmutable();
            }
            return self;
        }
        int newSize = size1 + size2;
        if (newSize <= 128) {
            AvailObject availObject;
            int newWordCount = newSize + 15 >>> 4;
            int deltaSlots = newWordCount - self.variableIntegerSlotsCount();
            if (canDestroy && this.isMutable() && deltaSlots == 0) {
                self.setDescriptor(NybbleTupleDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize));
                availObject = self;
            } else {
                availObject = AvailObjectRepresentation.Companion.newLike(NybbleTupleDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize), self, 0, deltaSlots);
            }
            AvailObject copy2 = availObject;
            copy2.set(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            int dest = size1 + 1;
            A_Tuple result2 = copy2;
            int src = 1;
            while (src <= size2) {
                result2 = A_Tuple.Companion.tupleAtPuttingCanDestroy(result2, dest, A_Tuple.Companion.tupleAt(otherTuple, src), canDestroy || src > 1);
                ++src;
                ++dest;
            }
            return result2;
        }
        if (!canDestroy) {
            self.makeImmutable();
            otherTuple.makeImmutable();
        }
        if (A_Tuple.Companion.getTreeTupleLevel(otherTuple) == 0) {
            return TreeTupleDescriptor.Companion.createTwoPartTreeTuple(self, otherTuple, 1, 0);
        }
        return TreeTupleDescriptor.Companion.concatenateAtLeastOneTree(self, otherTuple, true);
    }

    @Override
    @NotNull
    public A_Tuple o_CopyTupleFromToCanDestroy(@NotNull AvailObject self, int start, int end, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        boolean bl2 = bl = (1 <= start ? start <= end + 1 : false) && end <= tupleSize;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int size = end - start + 1;
        boolean bl3 = 1 <= size ? size < tupleSize : false;
        if (bl3 && size < 128) {
            AvailObject result2 = Companion.generateNybbleTupleFrom(size, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(self, start){
                final /* synthetic */ AvailObject $self;
                final /* synthetic */ int $start;
                {
                    this.$self = $self;
                    this.$start = $start;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    return NybbleTupleDescriptor.Companion.getNybble(this.$self, it + this.$start - 1);
                }
            }));
            if (canDestroy) {
                self.assertObjectUnreachableIfMutable();
            }
            return result2;
        }
        return super.o_CopyTupleFromToCanDestroy(self, start, end, canDestroy);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return another.equalsNybbleTuple(self);
    }

    @Override
    public boolean o_EqualsNybbleTuple(@NotNull AvailObject self, @NotNull A_Tuple aTuple) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aTuple, (String)"aTuple");
        if (self.sameAddressAs(aTuple)) {
            return true;
        }
        if (A_Tuple.Companion.getTupleSize(self) != A_Tuple.Companion.getTupleSize(aTuple)) {
            return false;
        }
        if (self.hash() != aTuple.hash()) {
            return false;
        }
        if (!A_Tuple.Companion.compareFromToWithNybbleTupleStartingAt(self, 1, A_Tuple.Companion.getTupleSize(self), aTuple, 1)) {
            return false;
        }
        if (!this.isShared()) {
            aTuple.makeImmutable();
            self.becomeIndirectionTo(aTuple);
        } else if (!aTuple.descriptor().isShared()) {
            self.makeImmutable();
            aTuple.becomeIndirectionTo(self);
        }
        return true;
    }

    @Override
    public byte o_ExtractNybbleFromTupleAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return Companion.getNybble(self, index2);
    }

    @Override
    public boolean o_IsBetterRepresentationThan(@NotNull AvailObject self, @NotNull A_BasicObject anotherObject) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anotherObject, (String)"anotherObject");
        return true;
    }

    @Override
    public boolean o_IsInstanceOfKind(@NotNull AvailObject self, @NotNull A_Type aType) {
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
            if (A_Type.Companion.isSupertypeOfPrimitiveTypeEnum(aType, PrimitiveTypeDescriptor.Types.NONTYPE)) {
                return true;
            }
            if (!aType.isTupleType()) {
                return false;
            }
            if (!A_Type.Companion.rangeIncludesLong(A_Type.Companion.getSizeRange(aType), A_Tuple.Companion.getTupleSize(self))) {
                return false;
            }
            A_Tuple typeTuple2 = A_Type.Companion.getTypeTuple(aType);
            int i2 = 1;
            int breakIndex = RangesKt.coerceAtMost((int)A_Tuple.Companion.getTupleSize(self), (int)A_Tuple.Companion.getTupleSize(typeTuple2));
            if (i2 <= breakIndex) {
                while (true) {
                    if (!A_Tuple.Companion.tupleAt(self, i2).isInstanceOf(A_Type.Companion.typeAtIndex(aType, i2))) {
                        return false;
                    }
                    if (i2 == breakIndex) break;
                    ++i2;
                }
            }
            A_Type defaultTypeObject = A_Type.Companion.getDefaultType(aType);
            if (A_Type.Companion.isSubtypeOf(IntegerRangeTypeDescriptor.Companion.getU4(), defaultTypeObject)) {
                return true;
            }
            Iterable $this$all$iv = (Iterable)new IntRange(breakIndex + 1, A_Tuple.Companion.getTupleSize(self));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (A_Tuple.Companion.tupleAt(self, it).isInstanceOf(defaultTypeObject)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return SerializerOperation.NYBBLE_TUPLE;
    }

    @Override
    public void o_TransferIntoByteBuffer(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull ByteBuffer outputByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)outputByteBuffer, (String)"outputByteBuffer");
        int index2 = startIndex;
        if (index2 <= endIndex) {
            while (true) {
                outputByteBuffer.put(Companion.getNybble(self, index2));
                if (index2 == endIndex) break;
                ++index2;
            }
        }
    }

    @Override
    @NotNull
    public AvailObject o_TupleAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return IntegerDescriptor.Companion.fromUnsignedByte(Companion.getNybble(self, index2));
    }

    @Override
    @NotNull
    public A_Tuple o_TupleAtPuttingCanDestroy(@NotNull AvailObject self, int index2, @NotNull A_BasicObject newValueObject, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)newValueObject, (String)"newValueObject");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject newValueStrong = (AvailObject)newValueObject;
        if (!newValueStrong.isNybble()) {
            if (newValueStrong.isUnsignedByte()) {
                return A_Tuple.Companion.tupleAtPuttingCanDestroy(NybbleTupleDescriptor.Companion.copyAsMutableByteTuple(self), index2, newValueObject, true);
            }
            return A_Number.Companion.isInt((A_Number)newValueObject) ? A_Tuple.Companion.tupleAtPuttingCanDestroy(A_Tuple.Companion.copyAsMutableIntTuple(self), index2, newValueObject, true) : A_Tuple.Companion.tupleAtPuttingCanDestroy(A_Tuple.Companion.copyAsMutableObjectTuple(self), index2, newValueObject, true);
        }
        AvailObject result2 = canDestroy && this.isMutable() ? self : AvailObjectRepresentation.Companion.newLike(this.mutable(), self, 0, 0);
        byte newNybble = A_Number.Companion.getExtractNybble(newValueStrong);
        NybbleTupleDescriptor.Companion.setNybble(result2, index2, newNybble);
        result2.setHashOrZero(0);
        return result2;
    }

    @Override
    public boolean o_TupleElementsInRangeAreInstancesOf(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull A_Type type) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return A_Type.Companion.isSubtypeOf(IntegerRangeTypeDescriptor.Companion.getU4(), type) || super.o_TupleElementsInRangeAreInstancesOf(self, startIndex, endIndex, type);
    }

    @Override
    public int o_TupleIntAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return Companion.getNybble(self, index2);
    }

    @Override
    public long o_TupleLongAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return Companion.getNybble(self, index2);
    }

    @Override
    @NotNull
    public A_Tuple o_TupleReverse(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int size = A_Tuple.Companion.getTupleSize(self);
        return size >= 128 ? super.o_TupleReverse(self) : (A_Tuple)Companion.generateNybbleTupleFrom(size, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(self, size){
            final /* synthetic */ AvailObject $self;
            final /* synthetic */ int $size;
            {
                this.$self = $self;
                this.$size = $size;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return NybbleTupleDescriptor.Companion.getNybble(this.$self, this.$size + 1 - it);
            }
        }));
    }

    @Override
    public int o_TupleSize(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return (self.variableIntegerSlotsCount() << 4) - this.unusedNybblesOfLastLong;
    }

    @Override
    @NotNull
    public NybbleTupleDescriptor mutable() {
        NybbleTupleDescriptor nybbleTupleDescriptor = descriptors[(16 - this.unusedNybblesOfLastLong & 0xF) * 3 + Mutability.MUTABLE.ordinal()];
        Intrinsics.checkNotNull((Object)nybbleTupleDescriptor);
        return nybbleTupleDescriptor;
    }

    @Override
    @NotNull
    public NybbleTupleDescriptor immutable() {
        NybbleTupleDescriptor nybbleTupleDescriptor = descriptors[(16 - this.unusedNybblesOfLastLong & 0xF) * 3 + Mutability.IMMUTABLE.ordinal()];
        Intrinsics.checkNotNull((Object)nybbleTupleDescriptor);
        return nybbleTupleDescriptor;
    }

    @Override
    @NotNull
    public NybbleTupleDescriptor shared() {
        NybbleTupleDescriptor nybbleTupleDescriptor = descriptors[(16 - this.unusedNybblesOfLastLong & 0xF) * 3 + Mutability.SHARED.ordinal()];
        Intrinsics.checkNotNull((Object)nybbleTupleDescriptor);
        return nybbleTupleDescriptor;
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject mutableObjectOfSize(int size) {
        return Companion.mutableObjectOfSize(size);
    }

    static {
        Class[] classArray = new Class[1];
        Intrinsics.checkNotNull(Integer.TYPE);
        createUninitializedNybbleTupleMethod = CheckedMethod.Companion.staticMethod(NybbleTupleDescriptor.class, "mutableObjectOfSize", AvailObject.class, classArray);
        int i2 = 0;
        int[] nArray = new int[]{0, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
        for (int excess : nArray) {
            NybbleTupleDescriptor.descriptors[i2++] = new NybbleTupleDescriptor(Mutability.MUTABLE, excess);
            NybbleTupleDescriptor.descriptors[i2++] = new NybbleTupleDescriptor(Mutability.IMMUTABLE, excess);
            NybbleTupleDescriptor.descriptors[i2++] = new NybbleTupleDescriptor(Mutability.SHARED, excess);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002J\"\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\fJ\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fH\u0007J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lavail/descriptor/tuples/NybbleTupleDescriptor$Companion;", "", "()V", "createUninitializedNybbleTupleMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getCreateUninitializedNybbleTupleMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "descriptors", "", "Lavail/descriptor/tuples/NybbleTupleDescriptor;", "[Lavail/descriptor/tuples/NybbleTupleDescriptor;", "maximumCopySize", "", "copyAsMutableByteTuple", "Lavail/descriptor/tuples/A_Tuple;", "self", "Lavail/descriptor/representation/AvailObject;", "descriptorFor", "flag", "Lavail/descriptor/representation/Mutability;", "size", "generateNybbleTupleFrom", "generator", "Lkotlin/Function1;", "getNybble", "", "nybbleIndex", "mutableObjectOfSize", "setNybble", "", "aNybble", "avail"})
    @SourceDebugExtension(value={"SMAP\nNybbleTupleDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NybbleTupleDescriptor.kt\navail/descriptor/tuples/NybbleTupleDescriptor$Companion\n+ 2 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor\n+ 3 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor$create$1\n*L\n1#1,800:1\n571#2,4:801\n573#3:805\n*S KotlinDebug\n*F\n+ 1 NybbleTupleDescriptor.kt\navail/descriptor/tuples/NybbleTupleDescriptor$Companion\n*L\n746#1:801,4\n746#1:805\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final byte getNybble(@NotNull AvailObject self, int nybbleIndex) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            boolean bl2 = bl = nybbleIndex >= 1 && nybbleIndex <= A_Tuple.Companion.getTupleSize(self);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            int longIndex = nybbleIndex + 15 >>> 4;
            long longValue = self.get(IntegerSlots.RAW_LONG_AT_, longIndex);
            int shift = (nybbleIndex - 1 & 0xF) << 2;
            return (byte)(longValue >>> shift & 0xFL);
        }

        private final void setNybble(AvailObject self, int nybbleIndex, byte aNybble) {
            boolean bl;
            boolean bl2 = bl = nybbleIndex >= 1 && nybbleIndex <= A_Tuple.Companion.getTupleSize(self);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl3 = bl = (aNybble & 0xF) == aNybble;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            int longIndex = nybbleIndex + 15 >>> 4;
            long longValue = self.get(IntegerSlots.RAW_LONG_AT_, longIndex);
            int leftShift = (nybbleIndex - 1 & 0xF) << 2;
            longValue &= 15L << leftShift ^ 0xFFFFFFFFFFFFFFFFL;
            self.set(IntegerSlots.RAW_LONG_AT_, longIndex, longValue |= (long)aNybble << leftShift);
        }

        @NotNull
        public final AvailObject generateNybbleTupleFrom(int size, @NotNull Function1<? super Integer, Integer> generator) {
            boolean bl;
            Intrinsics.checkNotNullParameter(generator, (String)"generator");
            AvailObject result2 = this.mutableObjectOfSize(size);
            int tupleIndex = 1;
            int limit = size >>> 4;
            for (int slotIndex = 1; slotIndex <= limit; ++slotIndex) {
                long combined = 0L;
                for (int shift = 0; shift < 64; shift += 4) {
                    byte nybble;
                    boolean bl2;
                    boolean bl3 = bl2 = ((nybble = (byte)((Number)generator.invoke((Object)tupleIndex++)).intValue()) & 0xF) == nybble;
                    if (_Assertions.ENABLED && !bl2) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    combined |= (long)nybble << shift;
                }
                result2.set(IntegerSlots.RAW_LONG_AT_, slotIndex, combined);
            }
            int index2 = (size & 0xFFFFFFF0) + 1;
            if (index2 <= size) {
                while (true) {
                    byte nybble;
                    boolean bl4;
                    boolean bl5 = bl4 = ((nybble = (byte)((Number)generator.invoke((Object)tupleIndex++)).intValue()) & 0xF) == nybble;
                    if (_Assertions.ENABLED && !bl4) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    this.setNybble(result2, index2, nybble);
                    if (index2 == size) break;
                    ++index2;
                }
            }
            boolean bl6 = bl = tupleIndex == size + 1;
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            return result2;
        }

        private final A_Tuple copyAsMutableByteTuple(AvailObject self) {
            AvailObject result2 = ByteTupleDescriptor.Companion.generateByteTupleFrom(A_Tuple.Companion.getTupleSize(self), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(self){
                final /* synthetic */ AvailObject $self;
                {
                    this.$self = $self;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    return NybbleTupleDescriptor.Companion.getNybble(this.$self, it);
                }
            }));
            result2.setHashOrZero(self.hashOrZero());
            return result2;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject mutableObjectOfSize(int size) {
            AvailObject availObject;
            boolean bl;
            NybbleTupleDescriptor d = this.descriptorFor(Mutability.MUTABLE, size);
            boolean bl2 = bl = (size + d.unusedNybblesOfLastLong & 0xF) == 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            int indexedSlotCount$iv = size + 15 >>> 4;
            boolean $i$f$create = false;
            AvailObject availObject2 = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, d);
            boolean bl3 = false;
            AvailObject $this$null = availObject2;
            return availObject;
        }

        @NotNull
        public final CheckedMethod getCreateUninitializedNybbleTupleMethod() {
            return createUninitializedNybbleTupleMethod;
        }

        private final NybbleTupleDescriptor descriptorFor(Mutability flag, int size) {
            NybbleTupleDescriptor nybbleTupleDescriptor = descriptors[(size & 0xF) * 3 + flag.ordinal()];
            Intrinsics.checkNotNull((Object)nybbleTupleDescriptor);
            return nybbleTupleDescriptor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/NybbleTupleDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "RAW_LONG_AT_", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots RAW_LONG_AT_;
        private static final /* synthetic */ IntegerSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        @NotNull
        public static EnumEntries<IntegerSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            boolean bl;
            HASH_AND_MORE = new IntegerSlots();
            RAW_LONG_AT_ = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE, IntegerSlots.RAW_LONG_AT_};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, (Function1<? super Integer, String>)((Function1)Companion.HASH_OR_ZERO.1.INSTANCE));
            boolean bl2 = bl = TupleDescriptor.IntegerSlots.HASH_AND_MORE.ordinal() == HASH_AND_MORE.ordinal();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl = TupleDescriptor.IntegerSlots.Companion.getHASH_OR_ZERO().isSamePlaceAs(HASH_OR_ZERO);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/NybbleTupleDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

