/*
 * Decompiled with CFR 0.152.
 */
package avail.files;

import avail.error.ErrorCode;
import avail.files.AbstractFileWrapper;
import avail.files.AvailFile;
import avail.files.EditRange;
import avail.files.TracedAction;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lavail/files/AvailBinaryFile;", "Lavail/files/AvailFile;", "fileWrapper", "Lavail/files/AbstractFileWrapper;", "(Lavail/files/AbstractFileWrapper;)V", "content", "", "rawContent", "getRawContent", "()[B", "editRange", "Lavail/files/TracedAction;", "data", "start", "", "end", "timestamp", "", "originator", "Ljava/util/UUID;", "replaceFile", "avail"})
public final class AvailBinaryFile
extends AvailFile {
    @NotNull
    private byte[] content;

    public AvailBinaryFile(final @NotNull AbstractFileWrapper fileWrapper) {
        Intrinsics.checkNotNullParameter((Object)fileWrapper, (String)"fileWrapper");
        super(fileWrapper);
        this.content = new byte[0];
        fileWrapper.getReference().readFileBytes(true, (Function2<? super byte[], ? super UUID, Unit>)((Function2)new Function2<byte[], UUID, Unit>(){

            public final void invoke(@NotNull byte[] bytes2, @Nullable UUID uUID) {
                Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
                try {
                    content = bytes2;
                    fileWrapper.notifyReady();
                }
                catch (Throwable e) {
                    System.err.println("Attempted to decode bytes from supposed text file " + fileWrapper.getReference().getUri());
                    System.err.println(e);
                }
            }
        }), (Function2<? super ErrorCode, ? super Throwable, Unit>)((Function2)new Function2<ErrorCode, Throwable, Unit>(){

            public final void invoke(@NotNull ErrorCode code, @Nullable Throwable ex) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                    System.err.println("Received ErrorCode: " + code + " while attempting read file: " + fileWrapper.getReference().getUri() + " with exception:\n");
                    Throwable throwable = ex;
                    if (throwable == null) break block0;
                    throwable.printStackTrace();
                }
            }
        }));
    }

    @Override
    @NotNull
    public byte[] getRawContent() {
        return this.content;
    }

    @Override
    @NotNull
    public TracedAction replaceFile(@NotNull byte[] data, long timestamp, @NotNull UUID originator) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
        return AvailFile.editRange$default(this, data, 0, this.content.length, 0L, originator, 8, null);
    }

    @Override
    @NotNull
    public TracedAction editRange(@NotNull byte[] data, int start, int end, long timestamp, @NotNull UUID originator) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
        byte[] byArray = this.content;
        byte[] removed = ArraysKt.copyOfRange((byte[])byArray, (int)start, (int)end);
        byArray = this.content;
        int n = 0;
        byte[] byArray2 = ArraysKt.plus((byte[])ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)start), (byte[])data);
        byArray = this.content;
        n = this.content.length;
        this.content = ArraysKt.plus((byte[])byArray2, (byte[])ArraysKt.copyOfRange((byte[])byArray, (int)end, (int)n));
        this.markDirty();
        return new TracedAction(timestamp, originator, new EditRange(data, start, end), new EditRange(removed, start, start + data.length));
    }
}

