/*
 * Decompiled with CFR 0.152.
 */
package avail.files;

import avail.files.AbstractFileWrapper;
import avail.files.TracedAction;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fJ2\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\b\b\u0002\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H&J\b\u0010(\u001a\u00020\u0019H\u0016J\u0006\u0010)\u001a\u00020\u001dJ\"\u0010*\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00192\b\b\u0002\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006,"}, d2={"Lavail/files/AvailFile;", "", "fileWrapper", "Lavail/files/AbstractFileWrapper;", "(Lavail/files/AbstractFileWrapper;)V", "getFileWrapper", "()Lavail/files/AbstractFileWrapper;", "isDirty", "", "isOpen", "()Z", "lastEdit", "", "getLastEdit", "()J", "setLastEdit", "(J)V", "lastModified", "getLastModified", "setLastModified", "mimeType", "", "getMimeType", "()Ljava/lang/String;", "rawContent", "", "getRawContent", "()[B", "conditionallyClearDirty", "", "saveTimeStart", "editRange", "Lavail/files/TracedAction;", "data", "start", "", "end", "timestamp", "originator", "Ljava/util/UUID;", "getSavableContent", "markDirty", "replaceFile", "Companion", "avail"})
public abstract class AvailFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractFileWrapper fileWrapper;
    @NotNull
    private final String mimeType;
    private long lastModified;
    private long lastEdit;
    private boolean isDirty;
    @NotNull
    private static final Set<String> knownTextMimeTypes;
    @NotNull
    public static final String availMimeType = "text/avail";
    @NotNull
    private static final String defaultMimeType = "application/octet-stream";
    @NotNull
    private static final Map<String, String> mimeTypeMap;

    public AvailFile(@NotNull AbstractFileWrapper fileWrapper) {
        Intrinsics.checkNotNullParameter((Object)fileWrapper, (String)"fileWrapper");
        this.fileWrapper = fileWrapper;
        this.mimeType = this.fileWrapper.getReference().getMimeType();
        this.lastModified = this.fileWrapper.getReference().getLastModified();
    }

    @NotNull
    public final AbstractFileWrapper getFileWrapper() {
        return this.fileWrapper;
    }

    @NotNull
    public abstract byte[] getRawContent();

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    public final void setLastModified(long l) {
        this.lastModified = l;
    }

    @NotNull
    public byte[] getSavableContent() {
        return this.getRawContent();
    }

    public final long getLastEdit() {
        return this.lastEdit;
    }

    public final void setLastEdit(long l) {
        this.lastEdit = l;
    }

    public final synchronized void markDirty() {
        this.lastEdit = System.currentTimeMillis();
        this.isDirty = true;
    }

    public final synchronized void conditionallyClearDirty(long saveTimeStart) {
        if (this.lastEdit < saveTimeStart) {
            this.isDirty = false;
        }
    }

    public final boolean isOpen() {
        return !this.fileWrapper.isClosed();
    }

    @NotNull
    public abstract TracedAction editRange(@NotNull byte[] var1, int var2, int var3, long var4, @NotNull UUID var6);

    public static /* synthetic */ TracedAction editRange$default(AvailFile availFile, byte[] byArray, int n, int n2, long l, UUID uUID, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: editRange");
        }
        if ((n3 & 8) != 0) {
            l = System.currentTimeMillis();
        }
        return availFile.editRange(byArray, n, n2, l, uUID);
    }

    @NotNull
    public abstract TracedAction replaceFile(@NotNull byte[] var1, long var2, @NotNull UUID var4);

    public static /* synthetic */ TracedAction replaceFile$default(AvailFile availFile, byte[] byArray, long l, UUID uUID, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: replaceFile");
        }
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        return availFile.replaceFile(byArray, l, uUID);
    }

    static {
        Object[] objectArray = new String[]{"text/plain", "text/css", "text/csv", "text/html", "text/javascript", "application/json", "application/xml", "text/xml"};
        knownTextMimeTypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"avail", (Object)"text/plain"), TuplesKt.to((Object)"java", (Object)"text/plain"), TuplesKt.to((Object)"kt", (Object)"text/plain"), TuplesKt.to((Object)"kts", (Object)"text/plain"), TuplesKt.to((Object)"txt", (Object)"text/plain"), TuplesKt.to((Object)"css", (Object)"text/css"), TuplesKt.to((Object)"csv", (Object)"text/csv"), TuplesKt.to((Object)"html", (Object)"text/html"), TuplesKt.to((Object)"js", (Object)"text/javascript"), TuplesKt.to((Object)"bin", (Object)defaultMimeType), TuplesKt.to((Object)"gz", (Object)"application/gzip"), TuplesKt.to((Object)"jar", (Object)"application/java-archive"), TuplesKt.to((Object)"json", (Object)"application/json"), TuplesKt.to((Object)"jpg", (Object)"image/jpeg"), TuplesKt.to((Object)"jpeg", (Object)"image/jpeg"), TuplesKt.to((Object)"png", (Object)"image/png"), TuplesKt.to((Object)"pdf", (Object)"application/pdf"), TuplesKt.to((Object)"svg", (Object)"image/svg+xml"), TuplesKt.to((Object)"xml", (Object)"application/xml"), TuplesKt.to((Object)"zip", (Object)"application/zip")};
        mimeTypeMap = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lavail/files/AvailFile$Companion;", "", "()V", "availMimeType", "", "defaultMimeType", "knownTextMimeTypes", "", "mimeTypeMap", "", "isTextFile", "", "mimeType", "path", "Ljava/nio/file/Path;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTextFile(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return knownTextMimeTypes.contains(mimeType);
        }

        @NotNull
        public final String mimeType(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string2 = path.toUri().getRawPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRawPath(...)");
            String[] stringArray = new String[]{"."};
            String extension = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            String string3 = (String)mimeTypeMap.get(extension);
            if (string3 == null) {
                string3 = AvailFile.defaultMimeType;
            }
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

