/*
 * Decompiled with CFR 0.152.
 */
package avail.files;

import avail.files.AvailFile;
import avail.files.FileAction;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/files/TracedAction;", "", "timestamp", "", "originator", "Ljava/util/UUID;", "forwardAction", "Lavail/files/FileAction;", "reverseAction", "(JLjava/util/UUID;Lavail/files/FileAction;Lavail/files/FileAction;)V", "isTraced", "", "redo", "", "file", "Lavail/files/AvailFile;", "undo", "avail"})
public final class TracedAction {
    private final long timestamp;
    @NotNull
    private final UUID originator;
    @NotNull
    private final FileAction forwardAction;
    @NotNull
    private final FileAction reverseAction;

    public TracedAction(long timestamp, @NotNull UUID originator, @NotNull FileAction forwardAction, @NotNull FileAction reverseAction) {
        Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
        Intrinsics.checkNotNullParameter((Object)forwardAction, (String)"forwardAction");
        Intrinsics.checkNotNullParameter((Object)reverseAction, (String)"reverseAction");
        this.timestamp = timestamp;
        this.originator = originator;
        this.forwardAction = forwardAction;
        this.reverseAction = reverseAction;
    }

    public final boolean isTraced() {
        return this.forwardAction.isTraced() && this.reverseAction.isTraced();
    }

    public final void undo(@NotNull AvailFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.reverseAction.execute(file2, System.currentTimeMillis(), this.originator);
    }

    public final void redo(@NotNull AvailFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.forwardAction.execute(file2, System.currentTimeMillis(), this.originator);
    }
}

