/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.ExpressionAsStatementPhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.style.P_BootstrapStatementStyler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapSendAsStatementMacro;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapStatementStyler;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_BootstrapSendAsStatementMacro
extends Primitive {
    @NotNull
    public static final P_BootstrapSendAsStatementMacro INSTANCE = new P_BootstrapSendAsStatementMacro();

    private P_BootstrapSendAsStatementMacro() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject sendPhraseInLiteral = interpreter.argument(0);
        if (A_Fiber.Companion.getAvailLoader(interpreter.fiber()) == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        AvailObject sendPhrase = A_Phrase.Companion.getToken(sendPhraseInLiteral).literal();
        if (!A_Phrase.Companion.phraseKindIsUnder(sendPhrase, PhraseTypeDescriptor.PhraseKind.SEND_PHRASE)) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.SILENT, StringDescriptor.Companion.stringFrom("statement to be a \u22a4-valued send phrase, not a " + A_Phrase.Companion.getPhraseKind(sendPhrase).name() + ": " + sendPhrase));
        }
        if (!A_Phrase.Companion.getPhraseExpressionType(sendPhrase).isTop()) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.SILENT, StringDescriptor.Companion.stringFrom("statement to yield \u22a4, but it yields " + A_Phrase.Companion.getPhraseExpressionType(sendPhrase) + ".  Expression is: " + sendPhrase));
        }
        A_Phrase sendAsStatement = ExpressionAsStatementPhraseDescriptor.Companion.newExpressionAsStatement(sendPhrase);
        return interpreter.primitiveSuccess(sendAsStatement);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(PhraseTypeDescriptor.PhraseKind.SEND_PHRASE.getMostGeneralType())), PhraseTypeDescriptor.PhraseKind.EXPRESSION_AS_STATEMENT_PHRASE.getMostGeneralType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    public P_BootstrapStatementStyler bootstrapStyler() {
        return P_BootstrapStatementStyler.INSTANCE;
    }
}

