/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.tuples;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/primitive/tuples/P_TupleTypeAt;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_TupleTypeAt
extends Primitive {
    @NotNull
    public static final P_TupleTypeAt INSTANCE = new P_TupleTypeAt();

    private P_TupleTypeAt() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject tupleType = interpreter.argument(0);
        AvailObject index2 = interpreter.argument(1);
        return interpreter.primitiveSuccess(A_Number.Companion.isInt(index2) ? A_Type.Companion.typeAtIndex(tupleType, A_Number.Companion.getExtractInt(index2)) : BottomTypeDescriptor.Companion.getBottom());
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type tupleMeta = argumentTypes.get(0);
        A_Type indexType = argumentTypes.get(1);
        AvailObject tupleType = A_Type.Companion.getInstance(tupleMeta);
        A_Number minIndex = A_Type.Companion.getLowerBound(indexType);
        A_Number maxIndex = A_Type.Companion.getUpperBound(indexType);
        return A_Number.Companion.isInt(minIndex) ? InstanceMetaDescriptor.Companion.instanceMeta(A_Type.Companion.unionOfTypesAtThrough(tupleType, A_Number.Companion.getExtractInt(minIndex), A_Number.Companion.isInt(maxIndex) ? A_Number.Companion.getExtractInt(maxIndex) : Integer.MAX_VALUE)) : super.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getTupleMeta(), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers()), InstanceMetaDescriptor.Companion.anyMeta(), null, 4, null);
    }
}

