/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.variables;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.descriptor.variables.VariableDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/primitive/variables/P_AddWriteReactor;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "avail"})
@SourceDebugExtension(value={"SMAP\nP_AddWriteReactor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_AddWriteReactor.kt\navail/interpreter/primitive/variables/P_AddWriteReactor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1726#2,3:116\n2624#2,3:119\n*S KotlinDebug\n*F\n+ 1 P_AddWriteReactor.kt\navail/interpreter/primitive/variables/P_AddWriteReactor\n*L\n103#1:116,3\n104#1:119,3\n*E\n"})
public final class P_AddWriteReactor
extends Primitive {
    @NotNull
    public static final P_AddWriteReactor INSTANCE = new P_AddWriteReactor();

    private P_AddWriteReactor() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.HasSideEffect};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject variable = interpreter.argument(0);
        AvailObject key = interpreter.argument(1);
        AvailObject reactorFunction = interpreter.argument(2);
        if (A_Atom.Companion.isAtomSpecial(key)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SPECIAL_ATOM);
        }
        AvailObject sharedFunction = reactorFunction.makeShared();
        VariableDescriptor.VariableAccessReactor writeReactor = new VariableDescriptor.VariableAccessReactor(sharedFunction);
        variable.addWriteReactor(key, writeReactor);
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(VariableTypeDescriptor.Companion.getMostGeneralVariableType(), PrimitiveTypeDescriptor.Types.ATOM.getO(), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, TupleDescriptor.Companion.getEmptyTuple(), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null)), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SPECIAL_ATOM};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type keyType = argumentTypes.get(1);
        if (keyType.isEnumeration()) {
            boolean bl;
            boolean allSpecial;
            block10: {
                boolean bl2;
                block9: {
                    Iterable $this$all$iv = A_Type.Companion.getInstance(keyType);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            AvailObject it = (AvailObject)element$iv;
                            boolean bl3 = false;
                            if (A_Atom.Companion.isAtomSpecial(it)) continue;
                            bl2 = false;
                            break block9;
                        }
                        bl2 = true;
                    }
                }
                allSpecial = bl2;
                Iterable $this$none$iv = A_Type.Companion.getInstance(keyType);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        AvailObject it = (AvailObject)element$iv;
                        boolean bl4 = false;
                        if (!A_Atom.Companion.isAtomSpecial(it)) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            boolean noneSpecial = bl;
            if (allSpecial) {
                return Primitive.Fallibility.CallSiteMustFail;
            }
            if (noneSpecial) {
                return Primitive.Fallibility.CallSiteCannotFail;
            }
        }
        return Primitive.Fallibility.CallSiteCanFail;
    }
}

