/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache;

import avail.persistence.cache.Repository;
import avail.persistence.cache.record.ManifestRecord;
import avail.persistence.cache.record.ModuleArchive;
import avail.persistence.cache.record.ModuleCompilation;
import avail.persistence.cache.record.NamesIndex;
import avail.persistence.cache.record.PhrasePathRecord;
import avail.persistence.cache.record.StylingRecord;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.persistence.IndexedFile;
import org.availlang.persistence.IndexedFileBuilder;
import org.availlang.persistence.IndexedFileException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 :2\u00020\u0001:\u0003:;<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\u001eJ\b\u0010!\u001a\u00020\u001eH\u0016J\u0006\u0010\"\u001a\u00020\u001eJ\u000e\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\rJ>\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u0011\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\rH\u0086\u0002J\u000e\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\u0003J\u0006\u00106\u001a\u00020\u001eJ\b\u00107\u001a\u00020\u001eH\u0002J\u0006\u00108\u001a\u00020\u001eJ\b\u00109\u001a\u00020\u0003H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lavail/persistence/cache/Repository;", "Ljava/io/Closeable;", "rootName", "", "fileName", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "allArchives", "", "Lavail/persistence/cache/record/ModuleArchive;", "getAllArchives$avail", "()Ljava/util/List;", "dirtySince", "", "getFileName", "()Ljava/io/File;", "isOpen", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock$avail", "()Ljava/util/concurrent/locks/ReentrantLock;", "moduleMap", "", "repository", "Lorg/availlang/persistence/IndexedFile;", "add", "byteArray", "", "cleanModulesUnder", "", "rootRelativePath", "clear", "close", "commit", "commitIfStaleChanges", "maximumChangeAgeMs", "createModuleCompilation", "Lavail/persistence/cache/record/ModuleCompilation;", "compilationTime", "serializedBody", "serializedBlockPhrases", "manifest", "Lavail/persistence/cache/record/ManifestRecord;", "stylingRecord", "Lavail/persistence/cache/record/StylingRecord;", "phrasePaths", "Lavail/persistence/cache/record/PhrasePathRecord;", "namesIndex", "Lavail/persistence/cache/record/NamesIndex;", "get", "index", "getArchive", "rootRelativeName", "markDirty", "openOrCreate", "reopenIfNecessary", "toString", "Companion", "IndexedRepositoryBuilder", "LimitedCache", "avail"})
public final class Repository
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootName;
    @NotNull
    private final File fileName;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private IndexedFile repository;
    private long dirtySince;
    @NotNull
    private final Map<String, ModuleArchive> moduleMap;
    private boolean isOpen;
    private static final Logger logger = Logger.getLogger(Repository.class.getName());
    private static final boolean DEBUG_REPOSITORY = false;
    public static final int DEFAULT_SOFT_SIZE = 1000;
    public static final int DIGEST_SIZE = 32;
    @NotNull
    private static final Function2<Integer, Integer, Boolean> versionCheck = Companion.versionCheck.1.INSTANCE;

    public Repository(@NotNull String rootName, @NotNull File fileName) {
        Intrinsics.checkNotNullParameter((Object)rootName, (String)"rootName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.rootName = rootName;
        this.fileName = fileName;
        this.lock = new ReentrantLock();
        this.moduleMap = new LinkedHashMap();
        this.openOrCreate();
    }

    @NotNull
    public final File getFileName() {
        return this.fileName;
    }

    @NotNull
    public final ReentrantLock getLock$avail() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ModuleArchive> getAllArchives$avail() {
        List<ModuleArchive> list2;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            list2 = this.moduleMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(arg_0 -> Repository._get_allArchives_$lambda$1$lambda$0(allArchives.1.1.INSTANCE, arg_0)).toList();
        }
        finally {
            lock.unlock();
        }
        List<ModuleArchive> list3 = Collections.unmodifiableList(list2);
        Intrinsics.checkNotNullExpressionValue(list3, (String)"unmodifiableList(...)");
        return list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ModuleCompilation createModuleCompilation(long compilationTime, @NotNull byte[] serializedBody, @NotNull byte[] serializedBlockPhrases, @NotNull ManifestRecord manifest2, @NotNull StylingRecord stylingRecord, @NotNull PhrasePathRecord phrasePaths, @NotNull NamesIndex namesIndex) {
        ModuleCompilation moduleCompilation;
        Intrinsics.checkNotNullParameter((Object)serializedBody, (String)"serializedBody");
        Intrinsics.checkNotNullParameter((Object)serializedBlockPhrases, (String)"serializedBlockPhrases");
        Intrinsics.checkNotNullParameter((Object)manifest2, (String)"manifest");
        Intrinsics.checkNotNullParameter((Object)stylingRecord, (String)"stylingRecord");
        Intrinsics.checkNotNullParameter((Object)phrasePaths, (String)"phrasePaths");
        Intrinsics.checkNotNullParameter((Object)namesIndex, (String)"namesIndex");
        IndexedFile.ByteArrayOutputStream manifestBytes = new IndexedFile.ByteArrayOutputStream(4096);
        manifest2.write$avail(new DataOutputStream((OutputStream)manifestBytes));
        IndexedFile.ByteArrayOutputStream innerStylingRecordBytes = new IndexedFile.ByteArrayOutputStream(4096);
        stylingRecord.write$avail(new DataOutputStream((OutputStream)innerStylingRecordBytes));
        IndexedFile.ByteArrayOutputStream innerPhrasePathsBytes = new IndexedFile.ByteArrayOutputStream(4096);
        phrasePaths.write$avail(new DataOutputStream((OutputStream)innerPhrasePathsBytes), namesIndex);
        IndexedFile.ByteArrayOutputStream namesIndexBytes = new IndexedFile.ByteArrayOutputStream(4096);
        namesIndex.write$avail(new DataOutputStream((OutputStream)namesIndexBytes));
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            long l = this.add(serializedBody);
            long l2 = this.add(serializedBlockPhrases);
            byte[] byArray = manifestBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            long l3 = this.add(byArray);
            byte[] byArray2 = innerStylingRecordBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            long l4 = this.add(byArray2);
            byte[] byArray3 = innerPhrasePathsBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
            long l5 = this.add(byArray3);
            byte[] byArray4 = namesIndexBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"toByteArray(...)");
            moduleCompilation = new ModuleCompilation(this, compilationTime, l, l2, l3, l4, l5, this.add(byArray4));
        }
        finally {
            lock.unlock();
        }
        return moduleCompilation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ModuleArchive getArchive(@NotNull String rootRelativeName2) {
        ModuleArchive moduleArchive;
        Intrinsics.checkNotNullParameter((Object)rootRelativeName2, (String)"rootRelativeName");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = bl = !StringsKt.startsWith$default((String)rootRelativeName2, (String)"/", (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            ModuleArchive moduleArchive2 = this.moduleMap.computeIfAbsent(rootRelativeName2, arg_0 -> Repository.getArchive$lambda$4$lambda$3((Function1)new Function1<String, ModuleArchive>(this){
                final /* synthetic */ Repository this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final ModuleArchive invoke(@NotNull String name) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    return new ModuleArchive(this.this$0, name);
                }
            }, arg_0));
            moduleArchive = moduleArchive2;
        }
        finally {
            lock.unlock();
        }
        Intrinsics.checkNotNullExpressionValue((Object)moduleArchive, (String)"withLock(...)");
        return moduleArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() throws IndexedFileException {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Object[] objectArray = new Object[]{this.rootName};
            Companion.log(level, "Clear: %s%n", objectArray);
            this.close();
            try {
                this.fileName.delete();
                this.repository = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)IndexedRepositoryBuilder.INSTANCE, (File)this.fileName, (boolean)true, null, (int)1000, (int)0, (int)0, (int)0, (int)0, null, (int)500, null);
                this.isOpen = true;
            }
            catch (Exception e) {
                throw new IndexedFileException((Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanModulesUnder(@NotNull String rootRelativePath) {
        Intrinsics.checkNotNullParameter((Object)rootRelativePath, (String)"rootRelativePath");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            for (Map.Entry<String, ModuleArchive> entry : this.moduleMap.entrySet()) {
                String moduleKey = entry.getKey();
                ModuleArchive archive = entry.getValue();
                if (!Intrinsics.areEqual((Object)moduleKey, (Object)rootRelativePath) && !StringsKt.startsWith$default((String)moduleKey, (String)(rootRelativePath + "/"), (boolean)false, (int)2, null)) continue;
                archive.cleanCompilations();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void markDirty() {
        if (this.dirtySince == 0L) {
            this.dirtySince = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() throws IndexedFileException {
        Lock lock = this.lock;
        lock.lock();
        try {
            block12: {
                boolean bl = false;
                try {
                    if (this.dirtySince == 0L) break block12;
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                    Object[] objectArray = new Object[]{this.rootName};
                    Companion.log(level, "Commit: %s%n", objectArray);
                    IndexedFile.ByteArrayOutputStream byteStream = new IndexedFile.ByteArrayOutputStream(131072);
                    Closeable closeable = new DataOutputStream((OutputStream)byteStream);
                    Throwable throwable = null;
                    try {
                        DataOutputStream binaryStream = (DataOutputStream)closeable;
                        boolean bl2 = false;
                        binaryStream.writeInt(this.moduleMap.size());
                        for (ModuleArchive moduleArchive : this.moduleMap.values()) {
                            moduleArchive.write(binaryStream);
                        }
                        Level level2 = Level.FINEST;
                        Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"FINEST");
                        Object[] objectArray2 = new Object[]{byteStream.size()};
                        Companion.log(level2, "Commit size = %d%n", objectArray2);
                        binaryStream = Unit.INSTANCE;
                    }
                    catch (Throwable binaryStream) {
                        throwable = binaryStream;
                        throw binaryStream;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    this.reopenIfNecessary();
                    IndexedFile indexedFile = this.repository;
                    Intrinsics.checkNotNull((Object)indexedFile);
                    IndexedFile $this$commit_u24lambda_u249_u24lambda_u248 = indexedFile;
                    boolean bl3 = false;
                    $this$commit_u24lambda_u249_u24lambda_u248.setMetadata(byteStream.toByteArray());
                    $this$commit_u24lambda_u249_u24lambda_u248.commit();
                    this.dirtySince = 0L;
                }
                catch (IndexedFileException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IndexedFileException((Throwable)e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitIfStaleChanges(long maximumChangeAgeMs) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.dirtySince != 0L && System.currentTimeMillis() - this.dirtySince > maximumChangeAgeMs) {
                this.commit();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Level level = Level.FINE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINE");
            Object[] objectArray = new Object[]{this.rootName};
            Companion.log(level, "Close: %s%n", objectArray);
            this.isOpen = false;
            IndexedFile indexedFile = this.repository;
            if (indexedFile != null) {
                indexedFile.close();
            }
            this.moduleMap.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void openOrCreate() throws IndexedFileException {
        boolean bl;
        boolean bl2 = bl = !this.isOpen;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        try {
            Object object;
            IndexedFile indexedFile;
            try {
                indexedFile = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)IndexedRepositoryBuilder.INSTANCE, (File)this.fileName, (boolean)true, null, (int)1000, (int)0, (int)0, (int)0, (int)0, versionCheck, (int)244, null);
            }
            catch (IndexedFileException e) {
                Level level = Level.INFO;
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
                object = new Object[]{this.fileName};
                Companion.log(level, e, "Deleting obsolete repository: %s", object);
                this.fileName.delete();
                indexedFile = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)IndexedRepositoryBuilder.INSTANCE, (File)this.fileName, (boolean)true, null, (int)1000, (int)0, (int)0, (int)0, (int)0, versionCheck, (int)244, null);
            }
            IndexedFile repo = indexedFile;
            byte[] metadata = repo.getMetadata();
            if (metadata != null) {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(metadata);
                object = new DataInputStream(byteStream);
                Throwable throwable = null;
                try {
                    boolean bl3;
                    DataInputStream binaryStream = (DataInputStream)object;
                    boolean bl4 = false;
                    int moduleCount = binaryStream.readInt();
                    while (moduleCount-- > 0) {
                        ModuleArchive archive = new ModuleArchive(this, binaryStream);
                        this.moduleMap.put(archive.getRootRelativeName$avail(), archive);
                    }
                    boolean bl5 = bl3 = byteStream.available() == 0;
                    if (_Assertions.ENABLED && !bl3) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            this.repository = repo;
            this.isOpen = true;
        }
        catch (IOException e) {
            throw new IndexedFileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reopenIfNecessary() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Level level = Level.FINE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINE");
            Object[] objectArray = new Object[]{this.rootName, this.isOpen};
            Companion.log(level, "Reopen if necessary %s (was open = %s)%n", objectArray);
            if (!this.isOpen) {
                this.openOrCreate();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public String toString() {
        Formatter out2 = new Formatter();
        Object[] objectArray = new Object[]{this.rootName};
        out2.format("Repository \"%s\" with modules:", objectArray);
        for (Map.Entry entry : this.moduleMap.entrySet()) {
            String key = (String)entry.getKey();
            ModuleArchive value = (ModuleArchive)entry.getValue();
            Object[] objectArray2 = new Object[]{key, value};
            out2.format("%n\t%s \u2192 %s", objectArray2);
        }
        String string2 = out2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public final long add(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        IndexedFile indexedFile = this.repository;
        Intrinsics.checkNotNull((Object)indexedFile);
        return IndexedFile.add$default((IndexedFile)indexedFile, (byte[])byteArray, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public final byte[] get(long index2) {
        IndexedFile indexedFile = this.repository;
        Intrinsics.checkNotNull((Object)indexedFile);
        return indexedFile.get(index2);
    }

    private static final ModuleArchive _get_allArchives_$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModuleArchive)$tmp0.invoke(p0);
    }

    private static final ModuleArchive getArchive$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModuleArchive)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J/\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001fJ7\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u00122\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e\"\u00020\u0001\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lavail/persistence/cache/Repository$Companion;", "", "()V", "DEBUG_REPOSITORY", "", "DEFAULT_SOFT_SIZE", "", "DIGEST_SIZE", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "versionCheck", "Lkotlin/Function2;", "getVersionCheck$avail", "()Lkotlin/jvm/functions/Function2;", "createTemporary", "Lavail/persistence/cache/Repository;", "rootName", "", "prefix", "suffix", "isIndexedRepositoryFile", "path", "Ljava/io/File;", "log", "", "level", "Ljava/util/logging/Level;", "format", "args", "", "(Ljava/util/logging/Level;Ljava/lang/String;[Ljava/lang/Object;)V", "exception", "", "(Ljava/util/logging/Level;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "mix", "currentHash", "newLong", "", "mix$avail", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final void log(@NotNull Level level, @NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        }

        public final void log(@NotNull Level level, @NotNull Throwable exception, @NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        }

        public final int mix$avail(int currentHash, long newLong) {
            int h = currentHash;
            h *= 1664525;
            h += (int)newLong;
            h *= 1664525;
            return h ^= (int)(newLong >> 32);
        }

        @NotNull
        public final Function2<Integer, Integer, Boolean> getVersionCheck$avail() {
            return versionCheck;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Repository createTemporary(@NotNull String rootName, @NotNull String prefix, @Nullable String suffix) {
            Repository repository;
            Intrinsics.checkNotNullParameter((Object)rootName, (String)"rootName");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            try {
                File file2 = File.createTempFile(prefix, suffix);
                file2.deleteOnExit();
                IndexedFile indexedFile = null;
                IndexedFileBuilder indexedFileBuilder = IndexedRepositoryBuilder.INSTANCE;
                Intrinsics.checkNotNull((Object)file2);
                IndexedFile indexedFile2 = indexedFile = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)indexedFileBuilder, (File)file2, (boolean)true, null, (int)1000, (int)0, (int)0, (int)0, (int)0, null, (int)500, null);
                if (indexedFile2 != null) {
                    indexedFile2.close();
                }
                repository = new Repository(rootName, file2);
            }
            catch (Exception e) {
                throw new IndexedFileException((Throwable)e);
            }
            return repository;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isIndexedRepositoryFile(@NotNull File path) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (path.isFile()) {
                Closeable closeable = new RandomAccessFile(path, "r");
                Throwable throwable = null;
                try {
                    int bytesRead;
                    RandomAccessFile file2 = (RandomAccessFile)closeable;
                    boolean bl = false;
                    byte[] repositoryHeader = IndexedRepositoryBuilder.INSTANCE.getHeaderBytes();
                    byte[] buffer = new byte[repositoryHeader.length];
                    int pos = 0;
                    while ((bytesRead = file2.read(buffer, pos, buffer.length - pos)) != -1 && (pos += bytesRead) != buffer.length) {
                    }
                    boolean bl2 = pos == buffer.length && Arrays.equals(repositoryHeader, buffer);
                    return bl2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/persistence/cache/Repository$IndexedRepositoryBuilder;", "Lorg/availlang/persistence/IndexedFileBuilder;", "()V", "avail"})
    private static final class IndexedRepositoryBuilder
    extends IndexedFileBuilder {
        @NotNull
        public static final IndexedRepositoryBuilder INSTANCE = new IndexedRepositoryBuilder();

        private IndexedRepositoryBuilder() {
            super("Avail compiled module repository V17");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u001e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003j\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002`\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lavail/persistence/cache/Repository$LimitedCache;", "K", "V", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "maximumSize", "", "(I)V", "removeEldestEntry", "", "eldest", "", "avail"})
    public static final class LimitedCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maximumSize;

        public LimitedCache(int maximumSize) {
            super(maximumSize, 0.75f, true);
            boolean bl;
            this.maximumSize = maximumSize;
            boolean bl2 = bl = this.maximumSize > 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }

        @Override
        protected boolean removeEldestEntry(@Nullable Map.Entry<? extends K, ? extends V> eldest) {
            return this.size() > this.maximumSize;
        }
    }
}

