/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache.record;

import avail.utility.CodingKt;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B?\b\u0016\u0012\u001c\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n0\u0006\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0010\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00060\u00070\u0006J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016R'\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lavail/persistence/cache/record/StylingRecord;", "", "bytes", "", "([B)V", "styleRuns", "", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "", "Lavail/persistence/cache/record/StyleRun;", "variableUses", "(Ljava/util/List;Ljava/util/List;)V", "getStyleRuns", "()Ljava/util/List;", "getVariableUses", "declarationsWithUses", "toString", "write", "", "binaryStream", "Ljava/io/DataOutputStream;", "write$avail", "avail"})
@SourceDebugExtension(value={"SMAP\nStylingRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StylingRecord.kt\navail/persistence/cache/record/StylingRecord\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,266:1\n1855#2,2:267\n1855#2,2:269\n1855#2,2:271\n1855#2,2:273\n1855#2:275\n1726#2,3:276\n1855#2,2:279\n1855#2,2:281\n1856#2:283\n1490#2:284\n1520#2,3:285\n1523#2,3:295\n1045#2:301\n1045#2:303\n372#3,7:288\n125#4:298\n152#4,2:299\n154#4:302\n*S KotlinDebug\n*F\n+ 1 StylingRecord.kt\navail/persistence/cache/record/StylingRecord\n*L\n77#1:267,2\n85#1:269,2\n89#1:271,2\n104#1:273,2\n112#1:275\n121#1:276,3\n129#1:279,2\n140#1:281,2\n112#1:283\n160#1:284\n160#1:285,3\n160#1:295,3\n162#1:301\n164#1:303\n160#1:288,7\n162#1:298\n162#1:299,2\n162#1:302\n*E\n"})
public final class StylingRecord {
    @NotNull
    private final List<Pair<IntRange, String>> styleRuns;
    @NotNull
    private final List<Pair<IntRange, IntRange>> variableUses;

    @NotNull
    public final List<Pair<IntRange, String>> getStyleRuns() {
        return this.styleRuns;
    }

    @NotNull
    public final List<Pair<IntRange, IntRange>> getVariableUses() {
        return this.variableUses;
    }

    public final void write$avail(@NotNull DataOutputStream binaryStream) throws IOException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
        Map styleToIndex = new LinkedHashMap();
        List stylesList = new ArrayList();
        Iterable $this$forEach$iv = this.styleRuns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String styleName = (String)pair.component2();
            styleToIndex.computeIfAbsent(styleName, arg_0 -> StylingRecord.write$lambda$1$lambda$0((Function1)new Function1<String, Integer>((List<String>)stylesList){
                final /* synthetic */ List<String> $stylesList;
                {
                    this.$stylesList = $stylesList;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$stylesList.add(it);
                    return this.$stylesList.size();
                }
            }, arg_0));
        }
        CodingKt.vlq(binaryStream, styleToIndex.size());
        $this$forEach$iv = stylesList;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterator p0 = (String)element$iv;
            boolean bl = false;
            CodingKt.sizedString(binaryStream, (String)((Object)p0));
        }
        int pos = 0;
        List nonemptyRuns = new ArrayList();
        Iterable $this$forEach$iv2 = this.styleRuns;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            boolean bl;
            object = (Pair)element$iv;
            boolean bl2 = false;
            IntRange run2 = (IntRange)object.component1();
            String styleName = (String)object.component2();
            int delta = run2.getFirst() - pos;
            boolean bl3 = bl = delta >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (delta > 0) {
                nonemptyRuns.add(TuplesKt.to((Object)0, (Object)delta));
            }
            boolean bl4 = bl = run2.getLast() > run2.getFirst();
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            Object v = styleToIndex.get(styleName);
            Intrinsics.checkNotNull(v);
            nonemptyRuns.add(TuplesKt.to(v, (Object)(run2.getLast() - run2.getFirst())));
            pos = run2.getLast();
        }
        CodingKt.vlq(binaryStream, nonemptyRuns.size());
        $this$forEach$iv2 = nonemptyRuns;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            object = (Pair)element$iv;
            boolean bl = false;
            int styleNumber = ((Number)object.component1()).intValue();
            int length = ((Number)object.component2()).intValue();
            CodingKt.vlq(binaryStream, styleNumber);
            CodingKt.vlq(binaryStream, length);
        }
        List<Pair<IntRange, List<IntRange>>> declarationsWithUses = this.declarationsWithUses();
        CodingKt.vlq(binaryStream, declarationsWithUses.size());
        int previousDeclarationEnd = 0;
        Iterable $this$forEach$iv3 = declarationsWithUses;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            boolean isCompact;
            List uses2;
            IntRange decl;
            block15: {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                decl = (IntRange)pair.component1();
                uses2 = (List)pair.component2();
                CodingKt.vlq(binaryStream, decl.getFirst() - previousDeclarationEnd);
                int declSize = decl.getLast() - decl.getFirst() + 1;
                CodingKt.vlq(binaryStream, declSize);
                Iterable $this$all$iv = uses2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v3 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        IntRange it = (IntRange)element$iv2;
                        boolean bl5 = false;
                        if (it.getLast() - it.getFirst() + 1 == declSize && it.getFirst() > decl.getLast()) continue;
                        v3 = false;
                        break block15;
                    }
                    v3 = isCompact = true;
                }
            }
            if (isCompact) {
                CodingKt.vlq(binaryStream, uses2.size());
                previousUseEnd = 0;
                previousUseEnd = previousDeclarationEnd;
                $this$forEach$iv = uses2;
                $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    IntRange use = (IntRange)element$iv3;
                    boolean bl = false;
                    CodingKt.vlq(binaryStream, use.getFirst() - previousUseEnd);
                    previousUseEnd = use.getLast() + 1;
                }
            } else {
                CodingKt.vlq(binaryStream, 0);
                CodingKt.vlq(binaryStream, uses2.size());
                previousUseEnd = 0;
                $this$forEach$iv = uses2;
                $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    IntRange use = (IntRange)element$iv3;
                    boolean bl = false;
                    CodingKt.vlq(binaryStream, use.getFirst() - previousUseEnd);
                    CodingKt.vlq(binaryStream, use.getLast() - use.getFirst() + 1);
                    previousUseEnd = use.getLast() + 1;
                }
            }
            previousDeclarationEnd = decl.getLast() + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<IntRange, List<IntRange>>> declarationsWithUses() {
        void $this$mapTo$iv$iv;
        Object object;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.variableUses;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object object2;
            Object element$iv$iv = iterator2.next();
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-StylingRecord$declarationsWithUses$32 = false;
            IntRange key$iv$iv = (IntRange)it2.getSecond();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            Pair $i$a$-groupBy-StylingRecord$declarationsWithUses$32 = (Pair)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add((IntRange)it.getFirst());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            object = destination$iv$iv;
            boolean bl = false;
            IntRange k = (IntRange)entry.getKey();
            List v = (List)entry.getValue();
            Iterable $this$sortedBy$iv = v;
            boolean $i$f$sortedBy = false;
            object.add(TuplesKt.to((Object)k, (Object)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IntRange it = (IntRange)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getFirst());
                    it = (IntRange)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getFirst()));
                }
            })));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((IntRange)it.getFirst()).getFirst());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((IntRange)it.getFirst()).getFirst()));
            }
        });
    }

    @NotNull
    public String toString() {
        String string2 = "StylingRecord (%d styled runs)";
        Object[] objectArray = new Object[]{this.styleRuns.size()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return string3;
    }

    public StylingRecord(@NotNull byte[] bytes2) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        DataInputStream binaryStream = new DataInputStream(new ByteArrayInputStream(bytes2));
        int n2 = 0;
        int n3 = CodingKt.unvlqInt(binaryStream);
        String[] stringArray = new String[n3];
        while (n2 < n3) {
            n = n2++;
            stringArray[n] = CodingKt.decodeString(binaryStream);
        }
        String[] styles = stringArray;
        int pos = 0;
        List allRuns = new ArrayList();
        int n4 = CodingKt.unvlqInt(binaryStream);
        for (n = 0; n < n4; ++n) {
            int it = n;
            boolean bl = false;
            int styleNumber = CodingKt.unvlqInt(binaryStream);
            int length = CodingKt.unvlqInt(binaryStream);
            pos += length;
            if (styleNumber <= 0) continue;
            allRuns.add(TuplesKt.to((Object)new IntRange(pos - length, pos), (Object)styles[styleNumber - 1]));
        }
        this.styleRuns = allRuns;
        List usesToDeclarations = new ArrayList();
        int previousDeclarationEnd = 0;
        int n5 = CodingKt.unvlqInt(binaryStream);
        for (int j = 0; j < n5; ++j) {
            int it = j;
            boolean bl = false;
            int declStart = previousDeclarationEnd + CodingKt.unvlqInt(binaryStream);
            int length = CodingKt.unvlqInt(binaryStream);
            IntRange decl = RangesKt.until((int)declStart, (int)(declStart + length));
            int usagesOrZero = CodingKt.unvlqInt(binaryStream);
            if (usagesOrZero == 0) {
                previousUseEnd = 0;
                var17_21 = CodingKt.unvlqInt(binaryStream);
                int n6 = 0;
                while (n6 < var17_21) {
                    int it2 = n6++;
                    boolean bl2 = false;
                    int useStart = previousUseEnd + CodingKt.unvlqInt(binaryStream);
                    int size = CodingKt.unvlqInt(binaryStream);
                    IntRange use = RangesKt.until((int)useStart, (int)(useStart + size));
                    usesToDeclarations.add(TuplesKt.to((Object)use, (Object)decl));
                    previousUseEnd = use.getLast() + 1;
                }
            } else {
                previousUseEnd = 0;
                previousUseEnd = previousDeclarationEnd;
                var17_21 = 0;
                while (var17_21 < usagesOrZero) {
                    int it3 = var17_21++;
                    boolean bl3 = false;
                    int useStart = previousUseEnd + CodingKt.unvlqInt(binaryStream);
                    IntRange use = RangesKt.until((int)useStart, (int)(useStart + length));
                    usesToDeclarations.add(TuplesKt.to((Object)use, (Object)decl));
                    previousUseEnd = use.getLast() + 1;
                }
            }
            previousDeclarationEnd = declStart + length;
        }
        this.variableUses = usesToDeclarations;
        int n7 = n5 = binaryStream.available() == 0 ? 1 : 0;
        if (_Assertions.ENABLED && n5 == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    public StylingRecord(@NotNull List<Pair<IntRange, String>> styleRuns, @NotNull List<Pair<IntRange, IntRange>> variableUses) {
        Intrinsics.checkNotNullParameter(styleRuns, (String)"styleRuns");
        Intrinsics.checkNotNullParameter(variableUses, (String)"variableUses");
        this.styleRuns = styleRuns;
        this.variableUses = variableUses;
    }

    private static final Integer write$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }
}

