/*
 * Decompiled with CFR 0.152.
 */
package avail.serialization;

import avail.AvailRuntime;
import avail.descriptor.maps.A_Map;
import avail.descriptor.module.A_Module;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.A_String;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bH \u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u0006\u0010#\u001a\u00020\bJ\u0006\u0010$\u001a\u00020\bJ\u0006\u0010%\u001a\u00020\bJ\u0015\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001cH \u00a2\u0006\u0002\b)R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lavail/serialization/AbstractDeserializer;", "", "input", "Ljava/io/InputStream;", "runtime", "Lavail/AvailRuntime;", "lookupPumpedObject", "Lkotlin/Function1;", "", "Lavail/descriptor/representation/A_BasicObject;", "(Ljava/io/InputStream;Lavail/AvailRuntime;Lkotlin/jvm/functions/Function1;)V", "currentModule", "Lavail/descriptor/module/A_Module;", "getCurrentModule", "()Lavail/descriptor/module/A_Module;", "setCurrentModule", "(Lavail/descriptor/module/A_Module;)V", "getInput$avail", "()Ljava/io/InputStream;", "loadedModules", "Lavail/descriptor/maps/A_Map;", "getLoadedModules", "()Lavail/descriptor/maps/A_Map;", "getLookupPumpedObject$avail", "()Lkotlin/jvm/functions/Function1;", "getRuntime$avail", "()Lavail/AvailRuntime;", "fromCompressedObjectIndex", "Lavail/descriptor/representation/AvailObject;", "compressedIndex", "fromCompressedObjectIndex$avail", "moduleNamed", "moduleName", "Lavail/descriptor/tuples/A_String;", "moduleNamed$avail", "readByte", "readInt", "readShort", "recordProducedObject", "", "obj", "recordProducedObject$avail", "avail"})
public abstract class AbstractDeserializer {
    @NotNull
    private final InputStream input;
    @NotNull
    private final AvailRuntime runtime;
    @NotNull
    private final Function1<Integer, A_BasicObject> lookupPumpedObject;
    @NotNull
    private A_Module currentModule;
    @NotNull
    private final A_Map loadedModules;

    public AbstractDeserializer(@NotNull InputStream input, @NotNull AvailRuntime runtime, @NotNull Function1<? super Integer, ? extends A_BasicObject> lookupPumpedObject) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        Intrinsics.checkNotNullParameter(lookupPumpedObject, (String)"lookupPumpedObject");
        this.input = input;
        this.runtime = runtime;
        this.lookupPumpedObject = lookupPumpedObject;
        this.currentModule = NilDescriptor.Companion.getNil();
        this.loadedModules = this.runtime.loadedModules();
    }

    @NotNull
    public final InputStream getInput$avail() {
        return this.input;
    }

    @NotNull
    public final AvailRuntime getRuntime$avail() {
        return this.runtime;
    }

    @NotNull
    public final Function1<Integer, A_BasicObject> getLookupPumpedObject$avail() {
        return this.lookupPumpedObject;
    }

    @NotNull
    public final A_Module getCurrentModule() {
        return this.currentModule;
    }

    public final void setCurrentModule(@NotNull A_Module a_Module) {
        Intrinsics.checkNotNullParameter((Object)a_Module, (String)"<set-?>");
        this.currentModule = a_Module;
    }

    @NotNull
    public final A_Map getLoadedModules() {
        return this.loadedModules;
    }

    public final int readByte() {
        int n;
        try {
            n = this.input.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return n;
    }

    public final int readShort() {
        int n;
        try {
            n = (this.input.read() << 8) + this.input.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return n;
    }

    public final int readInt() {
        int n;
        try {
            n = (this.input.read() << 24) + (this.input.read() << 16) + (this.input.read() << 8) + this.input.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return n;
    }

    @NotNull
    public final A_Module moduleNamed$avail(@NotNull A_String moduleName2) {
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        boolean bl = moduleName2.isString();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Module current = this.currentModule;
        if (current.getNotNil() && moduleName2.equals(A_Module.Companion.getModuleName(current))) {
            return current;
        }
        AvailObject availObject = A_Map.Companion.mapAtOrNull(this.loadedModules, moduleName2);
        if (availObject == null) {
            throw new RuntimeException("Cannot locate module named " + moduleName2);
        }
        return availObject;
    }

    @NotNull
    public abstract AvailObject fromCompressedObjectIndex$avail(int var1);

    public abstract void recordProducedObject$avail(@NotNull AvailObject var1);
}

