/*
 * Decompiled with CFR 0.152.
 */
package avail.utility.configuration;

import avail.utility.configuration.Configuration;
import avail.utility.configuration.XMLConfiguratorState;
import avail.utility.configuration.XMLDocumentModel;
import avail.utility.configuration.XMLElement;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*$\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0004*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00060\u0005*\u001a\b\u0002\u0010\u0006*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00060\u00072\u00020\bB'\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\n\u0012\u0006\u0010\u000b\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\fJ\"\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u001aH\u0002J$\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J(\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00028\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\""}, d2={"Lavail/utility/configuration/XMLEventHandler;", "ConfigurationType", "Lavail/utility/configuration/Configuration;", "ElementType", "", "Lavail/utility/configuration/XMLElement;", "StateType", "Lavail/utility/configuration/XMLConfiguratorState;", "Lorg/xml/sax/helpers/DefaultHandler;", "model", "Lavail/utility/configuration/XMLDocumentModel;", "state", "(Lavail/utility/configuration/XMLDocumentModel;Lavail/utility/configuration/XMLConfiguratorState;)V", "Lavail/utility/configuration/XMLConfiguratorState;", "characters", "", "buffer", "", "start", "", "length", "elementNotAllowed", "Lorg/xml/sax/SAXException;", "forbidden", "", "allowed", "", "endElement", "uri", "localName", "qName", "startElement", "attributes", "Lorg/xml/sax/Attributes;", "avail"})
public final class XMLEventHandler<ConfigurationType extends Configuration, ElementType extends Enum<ElementType>, StateType extends XMLConfiguratorState<ConfigurationType, ElementType, StateType>>
extends DefaultHandler {
    @NotNull
    private final XMLDocumentModel<ConfigurationType, ElementType, StateType> model;
    @NotNull
    private final StateType state;

    public XMLEventHandler(@NotNull XMLDocumentModel<ConfigurationType, ElementType, StateType> model, @NotNull StateType state) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter(state, (String)"state");
        this.model = model;
        this.state = state;
    }

    private final SAXException elementNotAllowed(String forbidden, Collection<? extends ElementType> allowed) {
        StringBuilder builder = new StringBuilder(1000);
        builder.append("found element \"");
        String string2 = forbidden.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        builder.append(string2);
        builder.append("\" but expected one of:");
        for (Enum element : allowed) {
            builder.append("\n\t\"");
            String string3 = ((XMLElement)((Object)element)).getQName().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            builder.append(string3);
            builder.append('\"');
        }
        builder.append('\n');
        return new SAXException(builder.toString());
    }

    @Override
    public void startElement(@NotNull String uri, @NotNull String localName2, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
        Set<ElementType> set2;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)localName2, (String)"localName");
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Object parent = ((XMLConfiguratorState)this.state).peek();
        if (parent == null) {
            set2 = SetsKt.setOf(this.model.rootElement());
        } else {
            Set<ElementType> set3 = this.model.allowedChildrenOf(parent);
            set2 = set3;
            Intrinsics.checkNotNull(set3);
        }
        Set<ElementType> allowedChildren = set2;
        ElementType element = this.model.elementWithQName(qName);
        if (!CollectionsKt.contains((Iterable)allowedChildren, element)) {
            throw this.elementNotAllowed(qName, (Collection)allowedChildren);
        }
        ElementType ElementType2 = element;
        Intrinsics.checkNotNull(ElementType2);
        ((XMLConfiguratorState)this.state).push(ElementType2);
        ((XMLElement)element).startElement(this.state, attributes);
    }

    @Override
    public void endElement(@Nullable String uri, @Nullable String localName2, @NotNull String qName) throws SAXException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        ElementType ElementType2 = this.model.elementWithQName(qName);
        Intrinsics.checkNotNull(ElementType2);
        ElementType element = ElementType2;
        boolean bl2 = bl = element == ((XMLConfiguratorState)this.state).peek();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        ((XMLElement)element).endElement(this.state);
        ((XMLConfiguratorState)this.state).pop();
    }

    @Override
    public void characters(@Nullable char[] buffer, int start, int length) {
        Intrinsics.checkNotNull((Object)buffer);
        ((XMLConfiguratorState)this.state).accumulate(buffer, start, length);
    }
}

