/*
 * Decompiled with CFR 0.152.
 */
package avail.utility.fsm;

import avail.utility.fsm.ExecutionContext;
import avail.utility.fsm.StateSummary;
import avail.utility.fsm.StateTransitionArc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\u000e\b\u0002\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u0002*\u000e\b\u0003\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0002*\u0004\b\u0004\u0010\u00062\u00020\u0007B\u001b\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u00a2\u0006\u0002\u0010\u000bJ;\u0010$\u001a\u00020\u00112\b\u0010%\u001a\u0004\u0018\u00018\u00012$\u0010&\u001a \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u000e\u00a2\u0006\u0002\u0010'J*\u0010(\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u000e0)J[\u0010*\u001a\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0018\u00010\u000e2\b\u0010%\u001a\u0004\u0018\u00018\u00012$\u0010+\u001a \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040,\u00a2\u0006\u0002\u0010-JF\u0010.\u001a\u00020\u00112\u001e\u0010/\u001a\u001a\u0012\u0004\u0012\u00028\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u0002010\u0010002\u001e\u00102\u001a\u001a\u0012\u0004\u0012\u00028\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00020\u00110\u001000J\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00010)R2\u0010\f\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R*\u0010\u0016\u001a\u0004\u0018\u00018\u00032\b\u0010\u0015\u001a\u0004\u0018\u00018\u0003@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR:\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R*\u0010\u001e\u001a\u0004\u0018\u00018\u00032\b\u0010\u0015\u001a\u0004\u0018\u00018\u0003@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b!\u0010\u0018R>\u0010\"\u001a2\u0012\u0004\u0012\u00028\u0001\u0012(\u0012&\u0012\"\u0012 \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u000e0\r0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lavail/utility/fsm/StateSummary;", "State", "", "Event", "GuardKey", "ActionKey", "Memento", "", "state", "eventType", "Ljava/lang/Class;", "(Ljava/lang/Enum;Ljava/lang/Class;)V", "automaticTransitionTable", "", "Lavail/utility/fsm/StateTransitionArc;", "<set-?>", "Lkotlin/Function1;", "", "entryAction", "getEntryAction", "()Lkotlin/jvm/functions/Function1;", "actionKey", "entryActionKey", "getEntryActionKey", "()Ljava/lang/Enum;", "setEntryActionKey", "(Ljava/lang/Enum;)V", "Ljava/lang/Enum;", "exitAction", "getExitAction", "exitActionKey", "getExitActionKey", "setExitActionKey", "getState", "transitionTable", "", "addTransitionArc", "event", "arc", "(Ljava/lang/Enum;Lavail/utility/fsm/StateTransitionArc;)V", "allTransitionArcs", "", "getTransitionArc", "executionContext", "Lavail/utility/fsm/ExecutionContext;", "(Ljava/lang/Enum;Lavail/utility/fsm/ExecutionContext;)Lavail/utility/fsm/StateTransitionArc;", "populateGuardsAndActions", "guardMap", "", "", "actionMap", "transitionEvents", "avail"})
public final class StateSummary<State extends Enum<State>, Event extends Enum<Event>, GuardKey extends Enum<GuardKey>, ActionKey extends Enum<ActionKey>, Memento> {
    @NotNull
    private final State state;
    @Nullable
    private ActionKey entryActionKey;
    @Nullable
    private Function1<? super Memento, Unit> entryAction;
    @Nullable
    private ActionKey exitActionKey;
    @Nullable
    private Function1<? super Memento, Unit> exitAction;
    @NotNull
    private final Map<Event, Collection<StateTransitionArc<State, Event, GuardKey, ActionKey, Memento>>> transitionTable;
    @NotNull
    private final Collection<StateTransitionArc<State, Event, GuardKey, ActionKey, Memento>> automaticTransitionTable;

    public StateSummary(@NotNull State state, @NotNull Class<Event> eventType) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter(eventType, (String)"eventType");
        this.state = state;
        this.transitionTable = new EnumMap(eventType);
        this.automaticTransitionTable = new ArrayList();
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    @Nullable
    public final ActionKey getEntryActionKey() {
        return this.entryActionKey;
    }

    public final void setEntryActionKey(@Nullable ActionKey actionKey) {
        boolean bl;
        boolean bl2 = bl = this.entryActionKey == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.entryActionKey = actionKey;
    }

    @Nullable
    public final Function1<Memento, Unit> getEntryAction() {
        return this.entryAction;
    }

    @Nullable
    public final ActionKey getExitActionKey() {
        return this.exitActionKey;
    }

    public final void setExitActionKey(@Nullable ActionKey actionKey) {
        boolean bl;
        boolean bl2 = bl = this.exitActionKey == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.exitActionKey = actionKey;
    }

    @Nullable
    public final Function1<Memento, Unit> getExitAction() {
        return this.exitAction;
    }

    public final void populateGuardsAndActions(@NotNull Map<GuardKey, ? extends Function1<? super Memento, Boolean>> guardMap, @NotNull Map<ActionKey, ? extends Function1<? super Memento, Unit>> actionMap) {
        Intrinsics.checkNotNullParameter(guardMap, (String)"guardMap");
        Intrinsics.checkNotNullParameter(actionMap, (String)"actionMap");
        this.entryAction = actionMap.get(this.entryActionKey);
        this.exitAction = actionMap.get(this.exitActionKey);
        for (StateTransitionArc<State, Event, GuardKey, ActionKey, Memento> transition : this.allTransitionArcs()) {
            transition.populateGuardsAndActions(guardMap, actionMap);
        }
    }

    public final void addTransitionArc(@Nullable Event event, @NotNull StateTransitionArc<State, Event, GuardKey, ActionKey, Memento> arc) {
        Collection collection2;
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        if (event == null) {
            collection2 = this.automaticTransitionTable;
        } else {
            Collection collection3 = this.transitionTable.computeIfAbsent(event, arg_0 -> StateSummary.addTransitionArc$lambda$0(addTransitionArc.collection.1.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)collection3);
            collection2 = collection3;
        }
        Collection collection4 = collection2;
        collection4.add(arc);
    }

    @NotNull
    public final Collection<Event> transitionEvents() {
        return this.transitionTable.keySet();
    }

    @NotNull
    public final Collection<StateTransitionArc<State, Event, GuardKey, ActionKey, Memento>> allTransitionArcs() {
        List aggregate = new ArrayList();
        for (Collection<StateTransitionArc<State, Event, GuardKey, ActionKey, Memento>> transitionArcs : this.transitionTable.values()) {
            aggregate.addAll(transitionArcs);
        }
        aggregate.addAll(this.automaticTransitionTable);
        Collection<StateTransitionArc<State, Event, GuardKey, ActionKey, Memento>> collection2 = Collections.unmodifiableCollection(aggregate);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"unmodifiableCollection(...)");
        return collection2;
    }

    @Nullable
    public final StateTransitionArc<State, Event, GuardKey, ActionKey, Memento> getTransitionArc(@Nullable Event event, @NotNull ExecutionContext<State, Event, GuardKey, ActionKey, Memento> executionContext) {
        Collection<StateTransitionArc<State, Event, GuardKey, ActionKey, Memento>> collection2;
        Intrinsics.checkNotNullParameter(executionContext, (String)"executionContext");
        if (event == null) {
            collection2 = this.automaticTransitionTable;
        } else {
            collection2 = this.transitionTable.get(event);
            if (collection2 == null) {
                return null;
            }
        }
        Collection<StateTransitionArc<State, Event, GuardKey, ActionKey, Memento>> transitions = collection2;
        for (StateTransitionArc<State, Event, GuardKey, ActionKey, Memento> transition : transitions) {
            if (!executionContext.testGuard$avail(transition.getGuard())) continue;
            return transition;
        }
        return null;
    }

    private static final Collection addTransitionArc$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Collection)$tmp0.invoke(p0);
    }
}

