/*
 * Decompiled with CFR 0.152.
 */
package avail.utility.structures;

import avail.descriptor.representation.AvailObject;
import avail.utility.CodingKt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001&B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u0015\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0004J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0004J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u000e\u0010$\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020%R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0012\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006'"}, d2={"Lavail/utility/structures/BloomFilter;", "T", "", "bitCount", "", "hashCount", "(II)V", "existingFilter", "(Lavail/utility/structures/BloomFilter;)V", "binaryStream", "Ljava/io/DataInputStream;", "(Ljava/io/DataInputStream;)V", "array", "", "getBitCount", "()I", "size", "Lkotlin/ULong;", "J", "add", "", "element", "(Ljava/lang/Object;)V", "addAll", "filter", "addHash", "elementHash", "computeHash", "hashIndex", "get", "", "(Ljava/lang/Object;)Z", "getByHash", "setBit", "hash", "testBit", "write", "Ljava/io/DataOutputStream;", "Companion", "avail"})
@SourceDebugExtension(value={"SMAP\nBloomFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BloomFilter.kt\navail/utility/structures/BloomFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,280:1\n1855#2,2:281\n1726#2,3:283\n1855#2,2:288\n13337#3,2:286\n*S KotlinDebug\n*F\n+ 1 BloomFilter.kt\navail/utility/structures/BloomFilter\n*L\n122#1:281,2\n147#1:283,3\n253#1:288,2\n238#1:286,2\n*E\n"})
public final class BloomFilter<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int hashCount;
    @NotNull
    private final long[] array;
    private final long size;
    @NotNull
    private static final int[] hashSalts;

    public BloomFilter(int bitCount, int hashCount) {
        boolean bl;
        boolean bl2 = bl = hashCount < hashSalts.length;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.hashCount = hashCount;
        this.array = new long[(bitCount - 1 >> 6) + 1];
        this.size = ULong.constructor-impl((long)this.array.length);
    }

    public BloomFilter(@NotNull BloomFilter<T> existingFilter) {
        Intrinsics.checkNotNullParameter(existingFilter, (String)"existingFilter");
        this.hashCount = existingFilter.hashCount;
        long[] lArray = Arrays.copyOf(existingFilter.array, existingFilter.array.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(this, size)");
        this.array = lArray;
        this.size = ULong.constructor-impl((long)this.array.length);
    }

    public final int getBitCount() {
        return this.array.length << 6;
    }

    public final void addHash(int elementHash) {
        Iterable $this$forEach$iv = (Iterable)new IntRange(1, this.hashCount);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            this.setBit(this.computeHash(elementHash, it));
        }
    }

    public final void add(T element) {
        T t = element;
        this.addHash(t != null ? t.hashCode() : 0);
    }

    public final boolean getByHash(int elementHash) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)new IntRange(1, this.hashCount);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (this.testBit(this.computeHash(elementHash, it))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean get(T element) {
        T t = element;
        return this.getByHash(t != null ? t.hashCode() : 0);
    }

    private final int computeHash(int element, int hashIndex) {
        return AvailObject.Companion.combine2(element, hashSalts[hashIndex]);
    }

    private final void setBit(int hash) {
        int inRange = (int)ULong.constructor-impl((long)(ULong.constructor-impl((long)(ULong.constructor-impl((long)((long)UInt.constructor-impl((int)hash) & 0xFFFFFFFFL)) * this.size)) >>> 26));
        int index2 = inRange >>> 6;
        long mask = 1L << (inRange & 0x3F);
        this.array[index2] = this.array[index2] | mask;
    }

    private final boolean testBit(int hash) {
        long mask;
        int inRange = (int)ULong.constructor-impl((long)(ULong.constructor-impl((long)(ULong.constructor-impl((long)((long)UInt.constructor-impl((int)hash) & 0xFFFFFFFFL)) * this.size)) >>> 26));
        int index2 = inRange >>> 6;
        return (this.array[index2] & (mask = 1L << (inRange & 0x3F))) != 0L;
    }

    public final void addAll(@NotNull BloomFilter<T> filter2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        boolean bl2 = bl = this.size == filter2.size;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = this.hashCount == filter2.hashCount;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        int n = this.array.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.array[i2] = this.array[i2] | filter2.array[i2];
        }
    }

    public final void write(@NotNull DataOutputStream binaryStream) {
        Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
        CodingKt.vlq(binaryStream, this.getBitCount());
        CodingKt.vlq(binaryStream, this.hashCount);
        long[] $this$forEach$iv = this.array;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            long element$iv;
            long p0 = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            binaryStream.writeLong(p0);
        }
    }

    public BloomFilter(@NotNull DataInputStream binaryStream) {
        Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
        this(CodingKt.unvlqInt(binaryStream), CodingKt.unvlqInt(binaryStream));
        Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((long[])this.array);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            this.array[it] = binaryStream.readLong();
        }
    }

    static {
        int[] nArray = new int[]{275385896, -1979066356, -1371851720, -888758041, 1500474061, -1785706645, 829662425, -1998496237};
        hashSalts = nArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lavail/utility/structures/BloomFilter$Companion;", "", "()V", "hashSalts", "", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

