/*
 * Decompiled with CFR 0.152.
 */
package avail;

import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.exceptions.PrimitiveThrownException;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0010B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0007H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/AvailTask;", "", "Ljava/lang/Runnable;", "priority", "", "body", "Lkotlin/Function0;", "", "(ILkotlin/jvm/functions/Function0;)V", "getPriority", "()I", "quasiDeadline", "", "compareTo", "other", "run", "Companion", "avail"})
public final class AvailTask
implements Comparable<AvailTask>,
Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int priority;
    @NotNull
    private final Function0<Unit> body;
    private final long quasiDeadline;

    public AvailTask(int priority, @NotNull Function0<Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        this.priority = priority;
        int n = this.priority;
        int n2 = 0 <= n ? (n < 256 ? 1 : 0) : (n = 0);
        if (_Assertions.ENABLED && n == 0) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        long deltaNanos = 1000000000L * (long)(255 - this.priority) >> 8;
        this.quasiDeadline = System.nanoTime() + deltaNanos;
        this.body = body2;
    }

    public final int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(@NotNull AvailTask other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.compare(this.quasiDeadline, other.quasiDeadline);
    }

    @Override
    public void run() {
        try {
            this.body.invoke();
        }
        catch (Throwable e) {
            System.err.println("Unexpected internal failure in AvailTask:\n");
            e.printStackTrace();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\b\u000bJ\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u000e"}, d2={"Lavail/AvailTask$Companion;", "", "()V", "forFiberResumption", "Lkotlin/Function0;", "", "fiber", "Lavail/descriptor/fiber/A_Fiber;", "body", "Lkotlin/Function1;", "Lavail/interpreter/execution/Interpreter;", "Lkotlin/ExtensionFunctionType;", "forUnboundFiber", "action", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function0<Unit> forFiberResumption(@NotNull A_Fiber fiber2, @NotNull Function1<? super Interpreter, Unit> body2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(fiber2, "fiber");
            Intrinsics.checkNotNullParameter(body2, "body");
            boolean bl2 = A_Fiber.Companion.getExecutionState(fiber2).getIndicatesSuspension();
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean scheduled = A_Fiber.Companion.getAndSetSynchronizationFlag(fiber2, FiberDescriptor.SynchronizationFlag.SCHEDULED, true);
            boolean bl3 = bl = !scheduled;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            return new Function0<Unit>(fiber2, body2){
                final /* synthetic */ A_Fiber $fiber;
                final /* synthetic */ Function1<Interpreter, Unit> $body;
                {
                    this.$fiber = $fiber;
                    this.$body = $body;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    boolean bl;
                    boolean bl2;
                    Interpreter interpreter = Interpreter.Companion.current();
                    boolean bl3 = bl2 = interpreter.fiberOrNull() == null;
                    if (_Assertions.ENABLED && !bl2) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    this.$fiber.lock((Function0)new Function0<Unit>(this.$fiber, interpreter){
                        final /* synthetic */ A_Fiber $fiber;
                        final /* synthetic */ Interpreter $interpreter;
                        {
                            this.$fiber = $fiber;
                            this.$interpreter = $interpreter;
                            super(0);
                        }

                        public final void invoke() {
                            boolean bl;
                            boolean bl2 = A_Fiber.Companion.getExecutionState(this.$fiber).getIndicatesSuspension();
                            if (_Assertions.ENABLED && !bl2) {
                                String string2 = "Assertion failed";
                                throw new AssertionError((Object)string2);
                            }
                            boolean bound = A_Fiber.Companion.getAndSetSynchronizationFlag(this.$fiber, FiberDescriptor.SynchronizationFlag.BOUND, true);
                            A_Fiber.Companion.getFiberHelper(this.$fiber).startCountingCPU();
                            boolean bl3 = bl = !bound;
                            if (_Assertions.ENABLED && !bl) {
                                String string3 = "Assertion failed";
                                throw new AssertionError((Object)string3);
                            }
                            boolean wasScheduled = A_Fiber.Companion.getAndSetSynchronizationFlag(this.$fiber, FiberDescriptor.SynchronizationFlag.SCHEDULED, false);
                            if (_Assertions.ENABLED && !wasScheduled) {
                                String string4 = "Assertion failed";
                                throw new AssertionError((Object)string4);
                            }
                            A_Fiber.Companion.setExecutionState(this.$fiber, FiberDescriptor.ExecutionState.RUNNING);
                            this.$interpreter.fiber(this.$fiber, "forFiberResumption");
                        }
                    });
                    try {
                        this.$body.invoke(interpreter);
                    }
                    catch (PrimitiveThrownException e) {
                        interpreter.adjustUnreifiedCallDepthBy(-interpreter.unreifiedCallDepth());
                        if (!A_Fiber.Companion.getExecutionState(this.$fiber).getIndicatesTermination()) {
                            boolean bl4;
                            boolean bl5 = bl4 = interpreter.fiberOrNull() == this.$fiber;
                            if (_Assertions.ENABLED && !bl4) {
                                String string3 = "Assertion failed";
                                throw new AssertionError((Object)string3);
                            }
                            interpreter.abortFiber();
                        } else {
                            A_Fiber.Companion.setExecutionState(this.$fiber, FiberDescriptor.ExecutionState.ABORTED);
                        }
                        A_Fiber.Companion.getFailureContinuation(this.$fiber).invoke(e);
                        A_Fiber.Companion.setExecutionState(this.$fiber, FiberDescriptor.ExecutionState.RETIRED);
                        interpreter.runtime.unregisterFiber(this.$fiber);
                    }
                    catch (Throwable e) {
                        System.err.println("An unrecoverable VM error has occurred.");
                        throw e;
                    }
                    finally {
                        Function0<Unit> postExit = interpreter.getPostExitContinuation();
                        if (postExit != null) {
                            interpreter.postExitContinuation(null);
                            postExit.invoke();
                        }
                    }
                    this.$fiber.lock((Function0)new Function0<Unit>(this.$fiber, interpreter){
                        final /* synthetic */ A_Fiber $fiber;
                        final /* synthetic */ Interpreter $interpreter;
                        {
                            this.$fiber = $fiber;
                            this.$interpreter = $interpreter;
                            super(0);
                        }

                        public final void invoke() {
                            if (A_Fiber.Companion.getExecutionState(this.$fiber) == FiberDescriptor.ExecutionState.TERMINATED) {
                                A_Fiber.Companion.getResultContinuation(this.$fiber).invoke(A_Fiber.Companion.getFiberResult(this.$fiber));
                                A_Fiber.Companion.setExecutionState(this.$fiber, FiberDescriptor.ExecutionState.RETIRED);
                                this.$interpreter.runtime.unregisterFiber(this.$fiber);
                            }
                        }
                    });
                    boolean bl6 = bl = interpreter.fiberOrNull() == null;
                    if (_Assertions.ENABLED && !bl) {
                        String string4 = "Assertion failed";
                        throw new AssertionError((Object)string4);
                    }
                }
            };
        }

        @NotNull
        public final Function0<Unit> forUnboundFiber(@NotNull A_Fiber fiber2, @NotNull Function0<Unit> action2) {
            boolean bl;
            boolean bl2;
            Intrinsics.checkNotNullParameter(fiber2, "fiber");
            Intrinsics.checkNotNullParameter(action2, "action");
            boolean bl3 = bl2 = A_Fiber.Companion.getExecutionState(fiber2) == FiberDescriptor.ExecutionState.SUSPENDED;
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean scheduled = A_Fiber.Companion.getAndSetSynchronizationFlag(fiber2, FiberDescriptor.SynchronizationFlag.SCHEDULED, true);
            boolean bl4 = bl = !scheduled;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            return new Function0<Unit>(fiber2, action2){
                final /* synthetic */ A_Fiber $fiber;
                final /* synthetic */ Function0<Unit> $action;
                {
                    this.$fiber = $fiber;
                    this.$action = $action;
                    super(0);
                }

                public final void invoke() {
                    boolean bl;
                    boolean wasScheduled = A_Fiber.Companion.getAndSetSynchronizationFlag(this.$fiber, FiberDescriptor.SynchronizationFlag.SCHEDULED, false);
                    if (_Assertions.ENABLED && !wasScheduled) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    try {
                        this.$action.invoke();
                    }
                    catch (Throwable e) {
                        A_Fiber.Companion.setExecutionState(this.$fiber, FiberDescriptor.ExecutionState.ABORTED);
                        A_Fiber.Companion.getFailureContinuation(this.$fiber).invoke(e);
                    }
                    boolean bl2 = bl = Interpreter.Companion.current().fiberOrNull() == null;
                    if (_Assertions.ENABLED && !bl) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

