/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil;

import avail.anvil.AvailWorkbench;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u001d"}, d2={"Lavail/anvil/AdaptiveColor;", "", "light", "Ljava/awt/Color;", "dark", "(Ljava/awt/Color;Ljava/awt/Color;)V", "color", "getColor", "()Ljava/awt/Color;", "getDark", "hex", "", "getHex", "()Ljava/lang/String;", "getLight", "blend", "otherColor", "selfWeight", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "avail"})
public final class AdaptiveColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Color light;
    @NotNull
    private final Color dark;

    public AdaptiveColor(@NotNull Color light, @NotNull Color dark) {
        Intrinsics.checkNotNullParameter(light, "light");
        Intrinsics.checkNotNullParameter(dark, "dark");
        this.light = light;
        this.dark = dark;
    }

    @NotNull
    public final Color getLight() {
        return this.light;
    }

    @NotNull
    public final Color getDark() {
        return this.dark;
    }

    @NotNull
    public final Color getColor() {
        return AvailWorkbench.Companion.getDarkMode() ? this.dark : this.light;
    }

    @NotNull
    public final String getHex() {
        return Companion.getHex(this.getColor());
    }

    @NotNull
    public final AdaptiveColor blend(@NotNull Color otherColor, float selfWeight) {
        boolean bl;
        Intrinsics.checkNotNullParameter(otherColor, "otherColor");
        double d = selfWeight;
        boolean bl2 = 0.0 <= d ? d <= 1.0 : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return new AdaptiveColor(Companion.blend(this.light, otherColor, selfWeight), Companion.blend(this.dark, otherColor, selfWeight));
    }

    public static /* synthetic */ AdaptiveColor blend$default(AdaptiveColor adaptiveColor, Color color, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.5f;
        }
        return adaptiveColor.blend(color, f);
    }

    @NotNull
    public final Color component1() {
        return this.light;
    }

    @NotNull
    public final Color component2() {
        return this.dark;
    }

    @NotNull
    public final AdaptiveColor copy(@NotNull Color light, @NotNull Color dark) {
        Intrinsics.checkNotNullParameter(light, "light");
        Intrinsics.checkNotNullParameter(dark, "dark");
        return new AdaptiveColor(light, dark);
    }

    public static /* synthetic */ AdaptiveColor copy$default(AdaptiveColor adaptiveColor, Color color, Color color2, int n, Object object) {
        if ((n & 1) != 0) {
            color = adaptiveColor.light;
        }
        if ((n & 2) != 0) {
            color2 = adaptiveColor.dark;
        }
        return adaptiveColor.copy(color, color2);
    }

    @NotNull
    public String toString() {
        return "AdaptiveColor(light=" + this.light + ", dark=" + this.dark + ")";
    }

    public int hashCode() {
        int result2 = this.light.hashCode();
        result2 = result2 * 31 + this.dark.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AdaptiveColor)) {
            return false;
        }
        AdaptiveColor adaptiveColor = (AdaptiveColor)other;
        if (!Intrinsics.areEqual(this.light, adaptiveColor.light)) {
            return false;
        }
        return Intrinsics.areEqual(this.dark, adaptiveColor.dark);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lavail/anvil/AdaptiveColor$Companion;", "", "()V", "hex", "", "Ljava/awt/Color;", "getHex", "(Ljava/awt/Color;)Ljava/lang/String;", "blend", "selfColor", "otherColor", "selfWeight", "", "avail"})
    @SourceDebugExtension(value={"SMAP\nAdaptiveColor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaptiveColor.kt\navail/anvil/AdaptiveColor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1549#2:94\n1620#2,3:95\n*S KotlinDebug\n*F\n+ 1 AdaptiveColor.kt\navail/anvil/AdaptiveColor$Companion\n*L\n87#1:94\n87#1:95,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getHex(@NotNull Color $this$hex) {
            Intrinsics.checkNotNullParameter($this$hex, "<this>");
            String string2 = "#%02x%02x%02x%02x";
            Object[] objectArray = new Object[]{$this$hex.getRed(), $this$hex.getGreen(), $this$hex.getBlue(), $this$hex.getAlpha()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            return string3;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Color blend(@NotNull Color selfColor, @NotNull Color otherColor, float selfWeight) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter(selfColor, "selfColor");
            Intrinsics.checkNotNullParameter(otherColor, "otherColor");
            double d = selfWeight;
            boolean bl2 = 0.0 <= d ? d <= 1.0 : (bl = false);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            float otherWeight = 1.0f - selfWeight;
            float[] fArray = selfColor.getRGBComponents(null);
            Intrinsics.checkNotNullExpressionValue(fArray, "getRGBComponents(...)");
            float[] fArray2 = otherColor.getRGBComponents(null);
            Intrinsics.checkNotNullExpressionValue(fArray2, "getRGBComponents(...)");
            Iterable iterable = ArraysKt.zip(fArray, fArray2);
            boolean $i$f$map = false;
            void var8_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                float a = ((Number)pair.component1()).floatValue();
                float b = ((Number)pair.component2()).floatValue();
                collection2.add(Float.valueOf(a * selfWeight + b * otherWeight));
            }
            float[] vector = CollectionsKt.toFloatArray((List)destination$iv$iv);
            return new Color(vector[0], vector[1], vector[2], vector[3]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

