/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.actions;

import avail.anvil.AvailWorkbench;
import avail.anvil.actions.AbstractWorkbenchAction;
import avail.anvil.actions.AvailRootEditor;
import avail.anvil.actions.CreateRootAction;
import avail.builder.ModuleRoot;
import avail.builder.ModuleRoots;
import avail.resolver.ModuleRootResolver;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.location.AvailLocation;
import org.availlang.artifact.environment.location.Scheme;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.artifact.environment.project.AvailProjectRoot;
import org.availlang.artifact.environment.project.LocalSettings;
import org.availlang.artifact.environment.project.StylingGroup;
import org.availlang.artifact.environment.project.TemplateGroup;
import org.availlang.artifact.jar.AvailArtifactJar;
import org.availlang.artifact.manifest.AvailRootManifest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lavail/anvil/actions/CreateRootAction;", "Lavail/anvil/actions/AbstractWorkbenchAction;", "workbench", "Lavail/anvil/AvailWorkbench;", "(Lavail/anvil/AvailWorkbench;)V", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "updateIsEnabled", "busy", "", "avail"})
public final class CreateRootAction
extends AbstractWorkbenchAction {
    public CreateRootAction(@NotNull AvailWorkbench workbench) {
        Intrinsics.checkNotNullParameter(workbench, "workbench");
        super(workbench, "Create root\u2026", null, null, 12, null);
        this.putValue("ShortDescription", "Add a module root to the project.");
    }

    @Override
    public void updateIsEnabled(boolean busy) {
        this.setEnabled(!busy);
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        AvailRootEditor editor2 = new AvailRootEditor(this.getWorkbench(), null, 2, null);
        editor2.setLocationType(AvailLocation.LocationType.project);
        Object object = this.getWorkbench().selectedModuleRoot();
        if (object == null || (object = ((ModuleRoot)object).getResolver()) == null || (object = ((ModuleRootResolver)object).getUri()) == null || (object = ((URI)object).getPath()) == null) {
            object = System.getProperty("user.dir");
        }
        Object initialPath = object;
        editor2.getChooser().setCurrentDirectory(new File((String)initialPath));
        editor2.setVisible(true);
        editor2.dispose();
        if (!editor2.getApproved()) {
            return;
        }
        AvailLocation.LocationType locationType = editor2.getLocationType();
        if (locationType == null) {
            return;
        }
        AvailLocation.LocationType locationType2 = locationType;
        String relativePath = editor2.relativePath();
        Scheme schema = Intrinsics.areEqual(StringsKt.substringAfterLast(relativePath, '.', ""), "jar") ? Scheme.JAR : Scheme.FILE;
        String rootNameInJar = editor2.getRootNameInJar().getSelectedValue();
        AvailLocation location = locationType2.location(this.getWorkbench().getProjectHomeDirectory(), editor2.relativePath(), schema, rootNameInJar);
        String rootName = editor2.getNameField().getText();
        String string2 = this.getWorkbench().getProjectName();
        Intrinsics.checkNotNull(rootName);
        String rootConfigPath = AvailEnvironment.INSTANCE.projectRootConfigPath(string2, rootName, this.getWorkbench().getProjectHomeDirectory());
        this.getWorkbench().getAvailProject$avail().optionallyInitializeConfigDirectory(rootConfigPath);
        StylingGroup sg = null;
        sg = new StylingGroup();
        TemplateGroup tg = null;
        tg = new TemplateGroup(null, 1, null);
        List extensions = new ArrayList();
        String description2 = null;
        description2 = "";
        if (schema == Scheme.JAR) {
            Intrinsics.checkNotNull(rootNameInJar);
            if (!StringsKt.isBlank(rootNameInJar)) {
                URI uRI = editor2.getChooser().getSelectedFile().toURI();
                Intrinsics.checkNotNullExpressionValue(uRI, "toURI(...)");
                AvailArtifactJar jar = new AvailArtifactJar(uRI);
                AvailRootManifest availRootManifest = jar.getManifest().getRoots().get(rootNameInJar);
                if (availRootManifest != null) {
                    AvailRootManifest it = availRootManifest;
                    boolean bl = false;
                    sg = it.getStyles();
                    tg = it.getTemplates();
                    extensions.addAll((Collection)it.getAvailModuleExtensions());
                    description2 = it.getDescription();
                }
            }
        }
        AvailProjectRoot newProjectRoot = new AvailProjectRoot(rootConfigPath, this.getWorkbench().getProjectHomeDirectory(), rootName, location, new LocalSettings(rootConfigPath, null, null, 6, null), sg, tg, extensions, editor2.getEditable().isSelected(), null, editor2.getVisible().isSelected(), 512, null);
        newProjectRoot.setDescription(description2);
        newProjectRoot.saveLocalSettingsToDisk();
        newProjectRoot.saveTemplatesToDisk();
        newProjectRoot.saveStylesToDisk();
        AvailProject project2 = this.getWorkbench().getAvailProject$avail();
        project2.addRoot(newProjectRoot);
        ModuleRoots moduleRoots = this.getWorkbench().getRuntime().moduleRoots();
        moduleRoots.addRoot(newProjectRoot.getName(), location.getFullPath(), (Function1<? super List<String>, Unit>)new Function1<List<? extends String>, Unit>(this){
            final /* synthetic */ CreateRootAction this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<String> allFailures) {
                Intrinsics.checkNotNullParameter(allFailures, "allFailures");
                SwingUtilities.invokeLater(() -> actionPerformed.2.invoke$lambda$0(allFailures, this.this$0));
            }

            private static final void invoke$lambda$0(List $allFailures, CreateRootAction this$0) {
                Intrinsics.checkNotNullParameter($allFailures, "$allFailures");
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                if (!((Collection)$allFailures).isEmpty()) {
                    System.err.println(CollectionsKt.joinToString$default($allFailures, "\n", null, null, 0, null, null, 62, null));
                }
                this$0.getWorkbench().saveProjectFileToDisk();
                this$0.getWorkbench().getRefreshAction().runAction();
            }
        });
    }
}

