/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.manager;

import avail.anvil.components.DirectoryChooser;
import avail.anvil.components.TextFieldWithLabel;
import avail.anvil.components.TextFieldWithLabelAndButton;
import avail.anvil.environment.GlobalEnvironmentSettings;
import avail.anvil.environment.UtilitiesKt;
import avail.anvil.icons.ProjectManagerIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.location.AvailLibraries;
import org.availlang.artifact.environment.location.AvailRepositories;
import org.availlang.artifact.environment.location.ProjectHome;
import org.availlang.artifact.environment.location.Scheme;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.artifact.environment.project.AvailProjectRoot;
import org.availlang.artifact.environment.project.AvailProjectV1;
import org.availlang.artifact.environment.project.LocalSettings;
import org.availlang.artifact.environment.project.StylingGroup;
import org.availlang.artifact.environment.project.TemplateGroup;
import org.availlang.artifact.jar.AvailArtifactJar;
import org.availlang.artifact.manifest.AvailRootManifest;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010.\u001a\u00020\bR\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u00070\u00070\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010(\u001a\u0016\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u00070\u0007\u0012\u0004\u0012\u00020'0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lavail/anvil/manager/CreateProjectPanel;", "Ljavax/swing/JPanel;", "config", "Lavail/anvil/environment/GlobalEnvironmentSettings;", "onCreate", "Lkotlin/Function2;", "Lorg/availlang/artifact/environment/project/AvailProject;", "", "", "onCancel", "Lkotlin/Function0;", "(Lavail/anvil/environment/GlobalEnvironmentSettings;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;)V", "bottomPanel", "cancel", "Ljavax/swing/JButton;", "getCancel", "()Ljavax/swing/JButton;", "getConfig$avail", "()Lavail/anvil/environment/GlobalEnvironmentSettings;", "createButton", "importStyles", "Ljavax/swing/JCheckBox;", "getImportStyles", "()Ljavax/swing/JCheckBox;", "importTemplates", "getImportTemplates", "libraryNameField", "Lavail/anvil/components/TextFieldWithLabel;", "libraryPicker", "Ljavax/swing/JComboBox;", "kotlin.jvm.PlatformType", "projectFileName", "Lavail/anvil/components/TextFieldWithLabelAndButton;", "projectLocation", "Lavail/anvil/components/DirectoryChooser;", "projectNameField", "rootNameField", "rootsDirField", "selectedLibrary", "Ljava/io/File;", "standardLibraries", "", "standardLibraryNames", "", "getStandardLibraryNames", "()[Ljava/lang/String;", "create", "avail"})
@SourceDebugExtension(value={"SMAP\nCreateProjectPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateProjectPanel.kt\navail/anvil/manager/CreateProjectPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,450:1\n8541#2,2:451\n8801#2,4:453\n37#3,2:457\n1#4:459\n*S KotlinDebug\n*F\n+ 1 CreateProjectPanel.kt\navail/anvil/manager/CreateProjectPanel\n*L\n89#1:451,2\n89#1:453,4\n95#1:457,2\n*E\n"})
public final class CreateProjectPanel
extends JPanel {
    @NotNull
    private final GlobalEnvironmentSettings config;
    @NotNull
    private final Function2<AvailProject, String, Unit> onCreate;
    @NotNull
    private final Function0<Unit> onCancel;
    @NotNull
    private final Map<String, File> standardLibraries;
    @Nullable
    private File selectedLibrary;
    @NotNull
    private final TextFieldWithLabel projectNameField;
    @NotNull
    private final TextFieldWithLabelAndButton projectFileName;
    @NotNull
    private final DirectoryChooser projectLocation;
    @NotNull
    private final TextFieldWithLabel rootNameField;
    @NotNull
    private final TextFieldWithLabel rootsDirField;
    @NotNull
    private final JCheckBox importStyles;
    @NotNull
    private final JCheckBox importTemplates;
    @NotNull
    private final TextFieldWithLabel libraryNameField;
    @NotNull
    private final JComboBox<String> libraryPicker;
    @NotNull
    private final JButton createButton;
    @NotNull
    private final JButton cancel;
    @NotNull
    private final JPanel bottomPanel;

    /*
     * WARNING - void declaration
     */
    public CreateProjectPanel(@NotNull GlobalEnvironmentSettings config, @NotNull Function2<? super AvailProject, ? super String, Unit> onCreate, @NotNull Function0<Unit> onCancel) {
        Object $this$bottomPanel_u24lambda_u2421;
        Object $this$cancel_u24lambda_u2420;
        Object $this$createButton_u24lambda_u2418;
        Object $this$libraryPicker_u24lambda_u2416;
        Object $this$libraryNameField_u24lambda_u2411;
        Object $this$importTemplates_u24lambda_u2410;
        Object $this$importStyles_u24lambda_u249;
        Object $this$rootsDirField_u24lambda_u248;
        Object $this$projectFileName_u24lambda_u247;
        Object object;
        JButton $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(onCreate, "onCreate");
        Intrinsics.checkNotNullParameter(onCancel, "onCancel");
        super(new GridBagLayout());
        this.config = config;
        this.onCreate = onCreate;
        this.onCancel = onCancel;
        Object object2 = UtilitiesKt.getAvailStandardLibraries();
        CreateProjectPanel createProjectPanel = this;
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(((void)$this$associateBy$iv).length), 16);
        void var7_9 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        int n = ((void)$this$associateByTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void element$iv$iv;
            void var13_17 = element$iv$iv = $this$associateByTo$iv$iv[j];
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.getName(), element$iv$iv);
        }
        createProjectPanel.standardLibraries = destination$iv$iv;
        this.projectNameField = new TextFieldWithLabel("Project Name: ", null, null, null, 14, null);
        Object $i$f$associateBy22 = object2 = new TextFieldWithLabelAndButton("Project Config File Name: ", null, null, null, 14, null);
        createProjectPanel = this;
        boolean bl = false;
        $this$projectFileName_u24lambda_u247.setToolTipText("The name applied to the JSON project file.");
        $this$projectFileName_u24lambda_u247.getTextField().setText("avail-config");
        JButton $this$projectFileName_u24lambda_u247_u24lambda_u246 = $this$associateByTo$iv$iv = $this$projectFileName_u24lambda_u247.getButton();
        boolean bl2 = false;
        $this$projectFileName_u24lambda_u247_u24lambda_u246.setContentAreaFilled(false);
        $this$projectFileName_u24lambda_u247_u24lambda_u246.setBorderPainted(false);
        $this$projectFileName_u24lambda_u247_u24lambda_u246.setText("");
        $this$projectFileName_u24lambda_u247_u24lambda_u246.setIcon(ProjectManagerIcons.INSTANCE.refresh(23));
        $this$projectFileName_u24lambda_u247_u24lambda_u246.addActionListener(arg_0 -> CreateProjectPanel.projectFileName$lambda$7$lambda$6$lambda$5((TextFieldWithLabelAndButton)$this$projectFileName_u24lambda_u247, arg_0));
        createProjectPanel.projectFileName = object2;
        this.projectLocation = new DirectoryChooser("Project Directory: ", "Select Project Directory", null, 4, null);
        this.rootNameField = new TextFieldWithLabel("Create Root Name: ", null, null, null, 14, null);
        $this$projectFileName_u24lambda_u247 = object2 = new TextFieldWithLabel("Roots Directory Name (optional): ", null, null, null, 14, null);
        createProjectPanel = this;
        boolean bl3 = false;
        $this$rootsDirField_u24lambda_u248.setToolTipText("Leaving blank will create roots at top level of project");
        createProjectPanel.rootsDirField = object2;
        $this$rootsDirField_u24lambda_u248 = object2 = new JCheckBox("Import Styles", false);
        createProjectPanel = this;
        boolean bl4 = false;
        $this$importStyles_u24lambda_u249.setEnabled(false);
        $this$importStyles_u24lambda_u249.setToolTipText("Imports styles packaged with standard library");
        createProjectPanel.importStyles = object2;
        $this$importStyles_u24lambda_u249 = object2 = new JCheckBox("Import Templates", false);
        createProjectPanel = this;
        boolean bl5 = false;
        $this$importTemplates_u24lambda_u2410.setEnabled(false);
        $this$importTemplates_u24lambda_u2410.setToolTipText("Imports templates packaged with standard library");
        createProjectPanel.importTemplates = object2;
        $this$importTemplates_u24lambda_u2410 = object2 = new TextFieldWithLabel("Standard Library Root Name: ", null, null, null, 14, null);
        createProjectPanel = this;
        boolean bl6 = false;
        $this$libraryNameField_u24lambda_u2411.getTextField().setText("avail");
        createProjectPanel.libraryNameField = object2;
        $this$libraryNameField_u24lambda_u2411 = object2 = new JComboBox<String>(this.getStandardLibraryNames());
        createProjectPanel = this;
        boolean bl7 = false;
        $this$libraryPicker_u24lambda_u2416.addActionListener(arg_0 -> CreateProjectPanel.libraryPicker$lambda$16$lambda$15((JComboBox)$this$libraryPicker_u24lambda_u2416, this, arg_0));
        createProjectPanel.libraryPicker = object2;
        $this$libraryPicker_u24lambda_u2416 = object2 = new JButton("Create");
        createProjectPanel = this;
        boolean bl8 = false;
        $this$createButton_u24lambda_u2418.setOpaque(true);
        $this$createButton_u24lambda_u2418.setBorder(BorderFactory.createLineBorder(new Color(187, 187, 187), 1, true));
        int currentHeight = $this$createButton_u24lambda_u2418.getHeight();
        int currentWidth = $this$createButton_u24lambda_u2418.getWidth();
        $this$createButton_u24lambda_u2418.setMinimumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$createButton_u24lambda_u2418.setPreferredSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$createButton_u24lambda_u2418.setMaximumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$createButton_u24lambda_u2418.addActionListener(arg_0 -> CreateProjectPanel.createButton$lambda$18$lambda$17(this, arg_0));
        createProjectPanel.createButton = object2;
        $this$createButton_u24lambda_u2418 = object2 = new JButton("Cancel");
        createProjectPanel = this;
        boolean bl9 = false;
        $this$cancel_u24lambda_u2420.setOpaque(true);
        currentHeight = $this$cancel_u24lambda_u2420.getHeight();
        currentWidth = $this$cancel_u24lambda_u2420.getWidth();
        $this$cancel_u24lambda_u2420.setMinimumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$cancel_u24lambda_u2420.setPreferredSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$cancel_u24lambda_u2420.setMaximumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$cancel_u24lambda_u2420.addActionListener(arg_0 -> CreateProjectPanel.cancel$lambda$20$lambda$19(this, arg_0));
        createProjectPanel.cancel = object2;
        $this$cancel_u24lambda_u2420 = object2 = new JPanel();
        createProjectPanel = this;
        boolean bl10 = false;
        $this$bottomPanel_u24lambda_u2421.setLayout(new FlowLayout(2));
        $this$bottomPanel_u24lambda_u2421.setMinimumSize(new Dimension(600, 50));
        $this$bottomPanel_u24lambda_u2421.setPreferredSize(new Dimension(600, 50));
        $this$bottomPanel_u24lambda_u2421.setMaximumSize(new Dimension(600, 50));
        $this$bottomPanel_u24lambda_u2421.add(this.cancel);
        $this$bottomPanel_u24lambda_u2421.add(this.createButton);
        createProjectPanel.bottomPanel = object2;
        this.setMinimumSize(new Dimension(600, 50));
        this.setPreferredSize(new Dimension(600, 50));
        this.setMaximumSize(new Dimension(600, 50));
        $this$bottomPanel_u24lambda_u2421 = object2 = new GridBagConstraints();
        object = this.projectNameField;
        createProjectPanel = this;
        boolean bl11 = false;
        $this$_init__u24lambda_u2422.weightx = 1.0;
        $this$_init__u24lambda_u2422.fill = 2;
        $this$_init__u24lambda_u2422.gridx = 0;
        $this$_init__u24lambda_u2422.gridy = 0;
        $this$_init__u24lambda_u2422.gridwidth = 2;
        Unit unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2422 = object2 = new GridBagConstraints();
        object = this.projectFileName;
        createProjectPanel = this;
        boolean bl12 = false;
        $this$_init__u24lambda_u2423.weightx = 1.0;
        $this$_init__u24lambda_u2423.fill = 2;
        $this$_init__u24lambda_u2423.gridx = 0;
        $this$_init__u24lambda_u2423.gridy = 1;
        $this$_init__u24lambda_u2423.gridwidth = 2;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2423 = object2 = new GridBagConstraints();
        object = this.projectLocation;
        createProjectPanel = this;
        boolean bl13 = false;
        $this$_init__u24lambda_u2424.weightx = 1.0;
        $this$_init__u24lambda_u2424.fill = 2;
        $this$_init__u24lambda_u2424.gridx = 0;
        $this$_init__u24lambda_u2424.gridy = 2;
        $this$_init__u24lambda_u2424.gridwidth = 2;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2424 = object2 = new GridBagConstraints();
        object = this.rootNameField;
        createProjectPanel = this;
        boolean bl14 = false;
        $this$_init__u24lambda_u2425.weightx = 1.0;
        $this$_init__u24lambda_u2425.fill = 2;
        $this$_init__u24lambda_u2425.gridx = 0;
        $this$_init__u24lambda_u2425.gridy = 3;
        $this$_init__u24lambda_u2425.gridwidth = 2;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2425 = object2 = new GridBagConstraints();
        object = this.rootsDirField;
        createProjectPanel = this;
        boolean bl15 = false;
        $this$_init__u24lambda_u2426.weightx = 1.0;
        $this$_init__u24lambda_u2426.fill = 2;
        $this$_init__u24lambda_u2426.gridx = 0;
        $this$_init__u24lambda_u2426.gridy = 4;
        $this$_init__u24lambda_u2426.gridwidth = 2;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2426 = object2 = new GridBagConstraints();
        object = this.libraryNameField;
        createProjectPanel = this;
        boolean bl16 = false;
        $this$_init__u24lambda_u2427.weightx = 1.0;
        $this$_init__u24lambda_u2427.fill = 2;
        $this$_init__u24lambda_u2427.gridx = 0;
        $this$_init__u24lambda_u2427.gridy = 5;
        $this$_init__u24lambda_u2427.gridwidth = 1;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2427 = object2 = new GridBagConstraints();
        object = this.libraryPicker;
        createProjectPanel = this;
        boolean bl17 = false;
        $this$_init__u24lambda_u2428.weightx = 1.0;
        $this$_init__u24lambda_u2428.fill = 2;
        $this$_init__u24lambda_u2428.gridx = 1;
        $this$_init__u24lambda_u2428.gridy = 5;
        $this$_init__u24lambda_u2428.gridwidth = 1;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2428 = object2 = new GridBagConstraints();
        object = this.importStyles;
        createProjectPanel = this;
        boolean bl18 = false;
        $this$_init__u24lambda_u2429.weightx = 1.0;
        $this$_init__u24lambda_u2429.fill = 2;
        $this$_init__u24lambda_u2429.gridx = 1;
        $this$_init__u24lambda_u2429.gridy = 6;
        $this$_init__u24lambda_u2429.gridwidth = 1;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2429 = object2 = new GridBagConstraints();
        object = this.importTemplates;
        createProjectPanel = this;
        boolean bl19 = false;
        $this$_init__u24lambda_u2430.weightx = 1.0;
        $this$_init__u24lambda_u2430.fill = 2;
        $this$_init__u24lambda_u2430.gridx = 1;
        $this$_init__u24lambda_u2430.gridy = 7;
        $this$_init__u24lambda_u2430.gridwidth = 1;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2430 = object2 = new GridBagConstraints();
        object = this.bottomPanel;
        createProjectPanel = this;
        boolean bl20 = false;
        $this$_init__u24lambda_u2431.weightx = 1.0;
        $this$_init__u24lambda_u2431.fill = 2;
        $this$_init__u24lambda_u2431.gridx = 0;
        $this$_init__u24lambda_u2431.gridy = 8;
        $this$_init__u24lambda_u2431.gridwidth = 2;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
    }

    @NotNull
    public final GlobalEnvironmentSettings getConfig$avail() {
        return this.config;
    }

    private final String[] getStandardLibraryNames() {
        String[] stringArray = new String[]{"None"};
        Collection $this$toTypedArray$iv = this.standardLibraries.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return ArraysKt.plus(stringArray, thisCollection$iv.toArray(new String[0]));
    }

    public final void create() {
        AvailProjectV1 availProjectV1;
        String fileName = this.projectFileName.getTextField().getText();
        String projLocation = this.projectLocation.getTextField().getText();
        String projectFilePath = projLocation + "/" + fileName + ".json";
        Intrinsics.checkNotNull(fileName);
        Intrinsics.checkNotNull(projLocation);
        String configPath = AvailEnvironment.INSTANCE.projectConfigPath(fileName, projLocation);
        AvailProject.Companion.optionallyInitializeConfigDirectory$default(AvailProject.Companion, configPath, false, 2, null);
        LocalSettings localSettings = LocalSettings.Companion.from(new File(configPath));
        AvailProjectV1 $this$create_u24lambda_u244 = availProjectV1 = new AvailProjectV1(fileName, true, new AvailRepositories(null, null, null, 3, null), localSettings, null, null, null, null, 240, null);
        boolean bl = false;
        new File(projLocation).mkdirs();
        String rootsDir = this.rootsDirField.getTextField().getText();
        String rootName = this.rootNameField.getTextField().getText();
        Intrinsics.checkNotNull(rootsDir);
        String rootLocationDir = ((CharSequence)rootsDir).length() > 0 ? rootsDir + "/" + rootName : rootName;
        new File(projLocation + "/" + rootLocationDir).mkdirs();
        Intrinsics.checkNotNull(rootName);
        String rootConfigDir = AvailEnvironment.INSTANCE.projectRootConfigPath(fileName, rootName, projLocation);
        Intrinsics.checkNotNull(rootLocationDir);
        AvailProjectRoot root = new AvailProjectRoot(rootConfigDir, projLocation, rootName, new ProjectHome(rootLocationDir, Scheme.FILE, projLocation, null), new LocalSettings(rootConfigDir, null, null, 6, null), new StylingGroup(), new TemplateGroup(null, 1, null), null, false, null, false, 1920, null);
        $this$create_u24lambda_u244.addRoot(root);
        $this$create_u24lambda_u244.optionallyInitializeConfigDirectory(rootConfigDir);
        File file2 = this.selectedLibrary;
        if (file2 != null) {
            TemplateGroup templateGroup;
            StylingGroup stylingGroup;
            CharSequence charSequence;
            File lib = file2;
            boolean bl2 = false;
            CharSequence charSequence2 = this.libraryNameField.getInput();
            if (charSequence2.length() == 0) {
                boolean bl3 = false;
                charSequence = "avail";
            } else {
                charSequence = charSequence2;
            }
            String libName = (String)charSequence;
            String libConfigDir = AvailEnvironment.INSTANCE.projectRootConfigPath(fileName, libName, projLocation);
            $this$create_u24lambda_u244.optionallyInitializeConfigDirectory(libConfigDir);
            URI uRI = lib.toURI();
            Intrinsics.checkNotNullExpressionValue(uRI, "toURI(...)");
            AvailArtifactJar jar = new AvailArtifactJar(uRI);
            AvailRootManifest rootManifest2 = jar.getManifest().getRoots().get("avail");
            StylingGroup sg = null;
            if (this.importStyles.isSelected()) {
                stylingGroup = jar.getManifest().stylesFor("avail");
                if (stylingGroup == null) {
                    stylingGroup = new StylingGroup();
                }
            } else {
                stylingGroup = new StylingGroup();
            }
            sg = stylingGroup;
            TemplateGroup tg = null;
            if (this.importTemplates.isSelected()) {
                templateGroup = jar.getManifest().templatesFor("avail");
                if (templateGroup == null) {
                    templateGroup = new TemplateGroup(null, 1, null);
                }
            } else {
                templateGroup = new TemplateGroup(null, 1, null);
            }
            tg = templateGroup;
            List extensions = new ArrayList();
            String description2 = null;
            description2 = "";
            AvailRootManifest availRootManifest = rootManifest2;
            if (availRootManifest != null) {
                AvailRootManifest it = availRootManifest;
                boolean bl4 = false;
                sg = it.getStyles();
                tg = it.getTemplates();
                extensions.addAll((Collection)it.getAvailModuleExtensions());
                description2 = it.getDescription();
            }
            AvailProjectRoot stdLib = new AvailProjectRoot(libConfigDir, projLocation, libName, new AvailLibraries("org/availlang/" + lib.getName(), Scheme.JAR, "avail"), new LocalSettings(AvailEnvironment.INSTANCE.projectRootConfigPath(fileName, libName, projLocation), null, null, 6, null), sg, tg, extensions, false, null, false, 1792, null);
            stdLib.setDescription(description2);
            stdLib.saveLocalSettingsToDisk();
            stdLib.saveTemplatesToDisk();
            stdLib.saveStylesToDisk();
            $this$create_u24lambda_u244.addRoot(stdLib);
        }
        if (((CharSequence)projectFilePath).length() > 0) {
            JSONWriter writer = JSONWriter.Companion.newPrettyPrinterWriter();
            $this$create_u24lambda_u244.writeTo(writer);
            FilesKt.writeText$default(new File(projectFilePath), writer.contents(), null, 2, null);
            this.config.add($this$create_u24lambda_u244, projectFilePath);
            this.onCreate.invoke($this$create_u24lambda_u244, projectFilePath);
        }
    }

    @NotNull
    public final JCheckBox getImportStyles() {
        return this.importStyles;
    }

    @NotNull
    public final JCheckBox getImportTemplates() {
        return this.importTemplates;
    }

    @NotNull
    public final JButton getCancel() {
        return this.cancel;
    }

    private static final void projectFileName$lambda$7$lambda$6$lambda$5(TextFieldWithLabelAndButton $this_panel, ActionEvent it) {
        Intrinsics.checkNotNullParameter($this_panel, "$this_panel");
        $this_panel.getTextField().setText("avail-config");
    }

    private static final void libraryPicker$lambda$16$lambda$15(JComboBox $this_apply, CreateProjectPanel this$0, ActionEvent it) {
        block3: {
            Unit unit;
            Intrinsics.checkNotNullParameter($this_apply, "$this_apply");
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Object object = $this_apply.getSelectedItem();
            if (object == null || (object = object.toString()) == null) break block3;
            Object key = object;
            boolean bl = false;
            File file2 = this$0.standardLibraries.get(key);
            if (file2 != null) {
                File lib = file2;
                boolean bl2 = false;
                this$0.selectedLibrary = lib;
                this$0.importTemplates.setEnabled(true);
                this$0.importStyles.setEnabled(true);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                JComboBox $this$libraryPicker_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413 = $this_apply;
                boolean bl3 = false;
                this$0.selectedLibrary = null;
                this$0.importTemplates.setEnabled(false);
                this$0.importTemplates.setSelected(false);
                this$0.importStyles.setEnabled(false);
                this$0.importStyles.setSelected(false);
            }
        }
    }

    private static final void createButton$lambda$18$lambda$17(CreateProjectPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.create();
    }

    private static final void cancel$lambda$20$lambda$19(CreateProjectPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.onCancel.invoke();
    }
}

