/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.problems.CompilerDiagnostics;
import avail.compiler.splitter.Alternation;
import avail.compiler.splitter.Argument;
import avail.compiler.splitter.ArgumentForMacroOnly;
import avail.compiler.splitter.ArgumentInModuleScope;
import avail.compiler.splitter.CheckIndent;
import avail.compiler.splitter.CompletelyOptional;
import avail.compiler.splitter.Counter;
import avail.compiler.splitter.Expression;
import avail.compiler.splitter.Group;
import avail.compiler.splitter.InstructionGenerator;
import avail.compiler.splitter.MessageSplitter;
import avail.compiler.splitter.MessageSplitterTokenizer;
import avail.compiler.splitter.NumberedChoice;
import avail.compiler.splitter.Optional;
import avail.compiler.splitter.RawKeywordTokenArgument;
import avail.compiler.splitter.RawLiteralTokenArgument;
import avail.compiler.splitter.RawTokenArgument;
import avail.compiler.splitter.SectionCheckpoint;
import avail.compiler.splitter.Sequence;
import avail.compiler.splitter.Simple;
import avail.compiler.splitter.VariableQuote;
import avail.compiler.splitter.WrapState;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.exceptions.SignatureException;
import avail.utility.CollectionExtensionsKt;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.availlang.cache.LRUCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 d2\u00020\u0001:\u0002deB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\b\b\u0002\u00104\u001a\u00020\u0007J\u000e\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u000207J\b\u00108\u001a\u000201H\u0002J\u0014\u00109\u001a\u0002012\n\u0010:\u001a\u00060;j\u0002`<H\u0002J\u0014\u0010=\u001a\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0016\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u0002032\u0006\u0010C\u001a\u00020\u0007J\b\u0010D\u001a\u000201H\u0002J\u000e\u0010E\u001a\u00020F2\u0006\u0010B\u001a\u000203J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020H0\u00062\u0006\u0010B\u001a\u000203H\u0002J\n\u0010I\u001a\u0004\u0018\u00010HH\u0002J\n\u0010J\u001a\u0004\u0018\u00010HH\u0002J\b\u0010K\u001a\u00020HH\u0002J\b\u0010L\u001a\u00020HH\u0002J\u0010\u0010M\u001a\u00020H2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u00020H2\u0006\u0010Q\u001a\u00020HH\u0002J\b\u0010R\u001a\u00020/H\u0002J\b\u0010S\u001a\u00020HH\u0002J\b\u0010T\u001a\u00020HH\u0002J\u0010\u0010U\u001a\u00020\u000b2\u0006\u0010V\u001a\u00020WH\u0002J\u0010\u0010X\u001a\u00020\u000b2\u0006\u0010V\u001a\u00020WH\u0002J(\u0010X\u001a\u00020\u000b2\u0006\u0010V\u001a\u00020W2\u0006\u0010Y\u001a\u00020\u000b2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020AH\u0002J\b\u0010]\u001a\u00020\u0007H\u0002J\"\u0010^\u001a\u0002012\u0006\u0010_\u001a\u0002072\n\u0010:\u001a\u00060;j\u0002`<2\u0006\u0010`\u001a\u00020\u0007J\u000e\u0010a\u001a\u00020>2\u0006\u0010b\u001a\u00020\u0007J\b\u0010c\u001a\u00020AH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u001e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R\u0011\u0010&\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0017R\u001a\u0010(\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0017\"\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\rR\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lavail/compiler/splitter/MessageSplitter;", "", "messageName", "Lavail/descriptor/tuples/A_String;", "(Lavail/descriptor/tuples/A_String;)V", "allSimpleLeafIndices", "", "", "getAllSimpleLeafIndices", "()Ljava/util/List;", "atEnd", "", "getAtEnd", "()Z", "containsGroups", "getContainsGroups", "currentMessagePart", "getCurrentMessagePart", "()Lavail/descriptor/tuples/A_String;", "currentMessagePartOrNull", "getCurrentMessagePartOrNull", "currentPositionForEnd", "getCurrentPositionForEnd", "()I", "currentPositionForStart", "getCurrentPositionForStart", "<set-?>", "leafArgumentCount", "getLeafArgumentCount", "getMessageName", "messagePartPosition", "messagePartPositions", "", "messageParts", "", "getMessageParts", "()[Lavail/descriptor/tuples/A_String;", "[Lavail/descriptor/tuples/A_String;", "numberOfArguments", "getNumberOfArguments", "numberOfSectionCheckpoints", "getNumberOfSectionCheckpoints", "setNumberOfSectionCheckpoints", "(I)V", "recursivelyContainsReorders", "getRecursivelyContainsReorders", "rootSequence", "Lavail/compiler/splitter/Sequence;", "checkImplementationSignature", "", "functionType", "Lavail/descriptor/types/A_Type;", "sectionNumber", "checkListStructure", "list", "Lavail/descriptor/phrases/A_Phrase;", "checkSuffixCharactersNotInSuffix", "dumpForDebug", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "highlightRangeForPath", "Lkotlin/ranges/IntRange;", "indices", "highlightedNameFor", "", "phraseType", "pc", "incrementLeafArgumentCount", "instructionsTupleFor", "Lavail/descriptor/tuples/A_Tuple;", "originExpressionsFor", "Lavail/compiler/splitter/Expression;", "parseElement", "parseElementOrAlternation", "parseEllipsisElement", "parseGuillemetElement", "parseIndent", "indentationMatchType", "Lavail/compiler/splitter/CheckIndent$IndentationMatchType;", "parseOptionalExplicitOrdinal", "expression", "parseSequence", "parseSimple", "parseUnderscoreElement", "peekAheadFor", "metacharacter", "Lavail/compiler/splitter/MessageSplitter$Metacharacter;", "peekFor", "failureCondition", "errorCode", "Lavail/exceptions/AvailErrorCode;", "errorString", "peekForExplicitOrdinal", "printSendNodeOnIndent", "sendPhrase", "indent", "rangeToHighlightForPartIndex", "messagePartIndex", "toString", "Companion", "Metacharacter", "avail"})
@SourceDebugExtension(value={"SMAP\nMessageSplitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageSplitter.kt\navail/compiler/splitter/MessageSplitter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1901:1\n13309#2,2:1902\n1855#3,2:1904\n1747#3,3:1906\n1179#3,2:1910\n1253#3,4:1912\n1#4:1909\n*S KotlinDebug\n*F\n+ 1 MessageSplitter.kt\navail/compiler/splitter/MessageSplitter\n*L\n639#1:1902,2\n971#1:1904,2\n1533#1:1906,3\n1651#1:1910,2\n1651#1:1912,4\n*E\n"})
public final class MessageSplitter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final A_String messageName;
    @NotNull
    private final A_String[] messageParts;
    @NotNull
    private final int[] messagePartPositions;
    private int messagePartPosition;
    private int leafArgumentCount;
    private int numberOfSectionCheckpoints;
    @NotNull
    private final Sequence rootSequence;
    @NotNull
    private static final LRUCache<A_String, MessageSplitter> cache;
    @NotNull
    private static final A_Set possibleErrors;
    @NotNull
    private static final String circledNumbersString = "\u24ea\u2460\u2461\u2462\u2463\u2464\u2465\u2466\u2467\u2468\u2469\u246a\u246b\u246c\u246d\u246e\u246f\u2470\u2471\u2472\u2473\u3251\u3252\u3253\u3254\u3255\u3256\u3257\u3258\u3259\u325a\u325b\u325c\u325d\u325e\u325f\u32b1\u32b2\u32b3\u32b4\u32b5\u32b6\u32b7\u32b8\u32b9\u32ba\u32bb\u32bc\u32bd\u32be\u32bf";
    private static final int circledNumbersCount;
    @NotNull
    private static final int[] circledNumberCodePoints;
    @NotNull
    private static final Map<Integer, Integer> circledNumbersMap;
    @NotNull
    private static final AtomicReference<A_Tuple> permutations;
    @NotNull
    private static final List<AvailObject> constantsList;
    @NotNull
    private static final Map<AvailObject, Integer> constantsMap;
    @NotNull
    private static final ReentrantReadWriteLock constantsLock;
    private static final int indexForTrue;
    private static final int indexForFalse;

    private MessageSplitter(final A_String messageName) throws MalformedMessageException {
        boolean bl = messageName.descriptor().isShared();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.messageName = messageName;
        MessageSplitterTokenizer tokenizer = new MessageSplitterTokenizer(this.messageName);
        this.messageParts = tokenizer.canonicalMessageParts();
        this.messagePartPositions = tokenizer.messagePartPositions();
        try {
            this.messagePartPosition = 1;
            this.rootSequence = this.parseSequence();
            if (!this.getAtEnd()) {
                this.peekFor(Metacharacter.CLOSE_GUILLEMET, true, AvailErrorCode.E_UNBALANCED_GUILLEMETS, "close guillemet (\u00bb) with no corresponding open guillemet (\u00ab)");
                this.peekFor(Metacharacter.DOUBLE_DAGGER, true, AvailErrorCode.E_UNBALANCED_GUILLEMETS, "double-dagger (\u2021) outside of a group");
                Companion.throwMalformedMessageException(AvailErrorCode.E_UNBALANCED_GUILLEMETS, "Encountered unexpected character: " + this.getCurrentMessagePart());
                throw new KotlinNothingValueException();
            }
        }
        catch (MalformedMessageException e) {
            throw new MalformedMessageException(e.getErrorCode(), new Function0<String>(){

                @Override
                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder;
                    MalformedMessageException malformedMessageException = e;
                    MessageSplitter messageSplitter = this;
                    A_String a_String = messageName;
                    StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.append(malformedMessageException.describeProblem());
                    $this$invoke_u24lambda_u240.append(". See arrow (");
                    $this$invoke_u24lambda_u240.append(CompilerDiagnostics.Companion.getErrorIndicatorSymbol());
                    $this$invoke_u24lambda_u240.append(") in: \"");
                    int characterIndex = messageSplitter.getCurrentPositionForStart();
                    A_String before = A_String.Companion.copyStringFromToCanDestroy(a_String, 1, characterIndex - 1, false);
                    A_String after = A_String.Companion.copyStringFromToCanDestroy(a_String, characterIndex, A_Tuple.Companion.getTupleSize(a_String), false);
                    $this$invoke_u24lambda_u240.append(A_String.Companion.asNativeString(before));
                    $this$invoke_u24lambda_u240.append(CompilerDiagnostics.Companion.getErrorIndicatorSymbol());
                    $this$invoke_u24lambda_u240.append(A_String.Companion.asNativeString(after));
                    $this$invoke_u24lambda_u240.append('\"');
                    String string2 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
                    return string2;
                }
            });
        }
    }

    @NotNull
    public final A_String getMessageName() {
        return this.messageName;
    }

    @NotNull
    public final A_String[] getMessageParts() {
        return this.messageParts;
    }

    public final int getLeafArgumentCount() {
        return this.leafArgumentCount;
    }

    public final int getNumberOfSectionCheckpoints() {
        return this.numberOfSectionCheckpoints;
    }

    public final void setNumberOfSectionCheckpoints(int n) {
        this.numberOfSectionCheckpoints = n;
    }

    private final int getCurrentPositionForStart() {
        return this.messagePartPosition == this.messageParts.length + 1 ? A_Tuple.Companion.getTupleSize(this.messageName) + 1 : this.messagePartPositions[this.messagePartPosition - 1];
    }

    private final int getCurrentPositionForEnd() {
        int n = this.messagePartPosition;
        return n == this.messageParts.length + 1 ? A_Tuple.Companion.getTupleSize(this.messageName) + 1 : (n == 1 ? 1 : this.messagePartPositions[this.messagePartPosition - 2] + A_Tuple.Companion.getTupleSize(this.messageParts[this.messagePartPosition - 2]));
    }

    private final void dumpForDebug(StringBuilder builder) {
        StringBuilder $this$dumpForDebug_u24lambda_u241 = builder;
        boolean bl = false;
        $this$dumpForDebug_u24lambda_u241.append(A_String.Companion.asNativeString(this.messageName));
        $this$dumpForDebug_u24lambda_u241.append("\n------\n");
        A_String[] $this$forEach$iv = this.messageParts;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            A_String element$iv;
            A_String it = element$iv = $this$forEach$iv[j];
            boolean bl2 = false;
            $this$dumpForDebug_u24lambda_u241.append("\t" + A_String.Companion.asNativeString(it) + "\n");
        }
    }

    private final boolean getAtEnd() {
        return this.messagePartPosition > this.messageParts.length;
    }

    private final A_String getCurrentMessagePartOrNull() {
        return this.getAtEnd() ? null : this.messageParts[this.messagePartPosition - 1];
    }

    private final A_String getCurrentMessagePart() {
        boolean bl;
        boolean bl2 = bl = !this.getAtEnd();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return this.messageParts[this.messagePartPosition - 1];
    }

    public final void printSendNodeOnIndent(@NotNull A_Phrase sendPhrase, @NotNull StringBuilder builder, int indent) {
        Intrinsics.checkNotNullParameter(sendPhrase, "sendPhrase");
        Intrinsics.checkNotNullParameter(builder, "builder");
        builder.append('\u00ab');
        this.rootSequence.printWithArguments$avail(A_Phrase.Companion.getExpressionsTuple(A_Phrase.Companion.getArgumentsListNode(sendPhrase)).iterator(), builder, indent);
        builder.append('\u00bb');
    }

    @NotNull
    public final A_Tuple instructionsTupleFor(@NotNull A_Type phraseType) throws SignatureException {
        Intrinsics.checkNotNullParameter(phraseType, "phraseType");
        InstructionGenerator generator = new InstructionGenerator();
        this.rootSequence.emitOn$avail(phraseType, generator, WrapState.PUSHED_LIST);
        generator.optimizeInstructions();
        return generator.instructionsTuple();
    }

    private final List<Expression> originExpressionsFor(A_Type phraseType) {
        boolean bl;
        InstructionGenerator generator = new InstructionGenerator();
        this.rootSequence.emitOn$avail(phraseType, generator, WrapState.PUSHED_LIST);
        generator.optimizeInstructions();
        List<Expression> expressions = generator.expressionList();
        boolean bl2 = bl = expressions.size() == A_Tuple.Companion.getTupleSize(generator.instructionsTuple());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return expressions;
    }

    @NotNull
    public final String highlightedNameFor(@NotNull A_Type phraseType, int pc) {
        Intrinsics.checkNotNullParameter(phraseType, "phraseType");
        String string2 = A_String.Companion.asNativeString(this.messageName);
        List<Expression> expressions = this.originExpressionsFor(phraseType);
        int zeroBasedPosition = pc == expressions.size() + 1 ? string2.length() : expressions.get(pc - 1).getStartInName() - 1;
        String string3 = string2;
        IntRange intRange = RangesKt.until(zeroBasedPosition, zeroBasedPosition);
        CharSequence charSequence = CompilerDiagnostics.Companion.getErrorIndicatorSymbol();
        String annotatedString = ((Object)StringsKt.replaceRange((CharSequence)string3, intRange, charSequence)).toString();
        return StringDescriptor.Companion.stringFrom(annotatedString).toString();
    }

    @NotNull
    public final IntRange highlightRangeForPath(@NotNull List<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, "indices");
        Expression expression2 = this.rootSequence;
        Iterator<Integer> indicesIterator = indices.iterator();
        while (indicesIterator.hasNext()) {
            Expression expression3;
            int index2 = ((Number)indicesIterator.next()).intValue();
            Expression expression4 = expression2;
            if (expression4 instanceof Sequence) {
                List<Expression> yielders = ((Sequence)expression2).getYielders();
                int n = yielders.size();
                int n2 = index2 - 1;
                boolean bl = 0 <= n2 ? n2 < n : false;
                if (!bl) break;
                expression2 = yielders.get(index2 - 1);
                continue;
            }
            if (!(expression4 instanceof Group)) continue;
            List<Expression> leftYielders = ((Group)expression2).getBeforeDagger().getYielders();
            List<Expression> rightYielders = ((Group)expression2).getAfterDagger().getYielders();
            if (leftYielders.size() == 1 && rightYielders.isEmpty()) {
                expression2 = CollectionsKt.single(leftYielders);
                continue;
            }
            if (!indicesIterator.hasNext()) continue;
            int nextZeroIndex = ((Number)indicesIterator.next()).intValue() - 1;
            int nextMinusLeft = nextZeroIndex - leftYielders.size();
            if (nextMinusLeft < 0) {
                expression3 = leftYielders.get(nextZeroIndex);
            } else {
                if (nextMinusLeft >= rightYielders.size()) break;
                expression3 = rightYielders.get(nextMinusLeft);
            }
            expression2 = expression3;
        }
        return RangesKt.until(expression2.getStartInName(), expression2.getPastEndInName());
    }

    @NotNull
    public final IntRange rangeToHighlightForPartIndex(int messagePartIndex) {
        boolean bl;
        boolean bl2 = bl = messagePartIndex > 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int start = this.messagePartPositions[messagePartIndex - 1];
        int size = A_Tuple.Companion.getTupleSize(this.messageParts[messagePartIndex - 1]);
        return RangesKt.until(start, start + size);
    }

    private final boolean peekFor(Metacharacter metacharacter) {
        A_String token = this.getCurrentMessagePartOrNull();
        if (token != null && token.equals(metacharacter.getString())) {
            int n = this.messagePartPosition;
            this.messagePartPosition = n + 1;
            return true;
        }
        return false;
    }

    private final boolean peekAheadFor(Metacharacter metacharacter) {
        A_String token = this.getCurrentMessagePartOrNull();
        return token != null && token.equals(metacharacter.getString());
    }

    private final int peekForExplicitOrdinal() {
        int codePoint;
        if (!this.getAtEnd() && circledNumbersMap.containsKey(codePoint = A_Tuple.Companion.tupleCodePointAt(this.getCurrentMessagePart(), 1))) {
            int n = this.messagePartPosition;
            this.messagePartPosition = n + 1;
            Integer n2 = circledNumbersMap.get(codePoint);
            Intrinsics.checkNotNull(n2);
            return ((Number)n2).intValue();
        }
        return -1;
    }

    private final boolean peekFor(Metacharacter metacharacter, boolean failureCondition, AvailErrorCode errorCode, String errorString) throws MalformedMessageException {
        A_String token = this.getCurrentMessagePartOrNull();
        if (token == null || !token.equals(metacharacter.getString())) {
            return false;
        }
        MessageSplitter.Companion.throwMalformedIf(failureCondition, errorCode, errorString);
        int n = this.messagePartPosition;
        this.messagePartPosition = n + 1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence parseSequence() throws MalformedMessageException {
        void $this$forEach$iv;
        int start = this.getCurrentPositionForStart();
        List elements = new ArrayList();
        Boolean isReordered = null;
        boolean anyYielders = false;
        Iterable<Expression> iterable = CollectionExtensionsKt.iterableWith(this.parseElementOrAlternation(), (Function1)new Function1<Expression, Expression>(this){
            final /* synthetic */ MessageSplitter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Expression invoke(@NotNull Expression it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return MessageSplitter.access$parseElementOrAlternation(this.this$0);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean alsoReordered;
            Expression expression2 = (Expression)element$iv;
            boolean bl = false;
            elements.add(expression2);
            if (!expression2.getYieldsValue$avail()) continue;
            boolean bl2 = expression2.getCanBeReordered();
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl3 = alsoReordered = expression2.getExplicitOrdinal() != -1;
            if (!anyYielders) {
                isReordered = alsoReordered;
            } else if (!Intrinsics.areEqual(isReordered, alsoReordered)) {
                Companion.throwMalformedMessageException(AvailErrorCode.E_INCONSISTENT_ARGUMENT_REORDERING, "The sequence of subexpressions before or after a double-dagger (\u2021) in a group must have either all or none of its arguments or direct subgroups numbered for reordering");
                throw new KotlinNothingValueException();
            }
            anyYielders = true;
        }
        Sequence sequence = new Sequence(start, this.getCurrentPositionForEnd(), elements);
        Boolean bl = isReordered;
        sequence.setReordered(bl != null ? bl : false);
        sequence.checkForConsistentOrdinals();
        return sequence;
    }

    private final Expression parseElementOrAlternation() throws MalformedMessageException {
        Expression expression2 = this.parseElement();
        if (expression2 == null) {
            return null;
        }
        Expression firstExpression = expression2;
        if (!this.peekAheadFor(Metacharacter.VERTICAL_BAR)) {
            return firstExpression;
        }
        MessageSplitter.Companion.checkAlternative(firstExpression);
        List alternatives = new ArrayList();
        alternatives.add(firstExpression);
        while (this.peekFor(Metacharacter.VERTICAL_BAR)) {
            Expression nextExpression;
            if (this.parseElement() == null) {
                Companion.throwMalformedMessageException(AvailErrorCode.E_VERTICAL_BAR_MUST_SEPARATE_TOKENS_OR_SIMPLE_GROUPS, "Expecting another token or simple group after the vertical bar (|)");
                throw new KotlinNothingValueException();
            }
            MessageSplitter.Companion.checkAlternative(nextExpression);
            alternatives.add(nextExpression);
        }
        return new Alternation(firstExpression.getStartInName(), ((Expression)CollectionsKt.last(alternatives)).getPastEndInName(), alternatives);
    }

    private final Expression parseElement() throws MalformedMessageException {
        Expression expression2;
        if (this.getAtEnd()) {
            expression2 = null;
        } else if (this.peekAheadFor(Metacharacter.DOUBLE_DAGGER) || this.peekAheadFor(Metacharacter.CLOSE_GUILLEMET)) {
            expression2 = null;
        } else if (this.peekFor(Metacharacter.UNDERSCORE)) {
            expression2 = this.parseOptionalExplicitOrdinal(this.parseUnderscoreElement());
        } else if (this.peekFor(Metacharacter.ELLIPSIS)) {
            expression2 = this.parseOptionalExplicitOrdinal(this.parseEllipsisElement());
        } else if (this.peekFor(Metacharacter.OPEN_GUILLEMET)) {
            expression2 = this.parseOptionalExplicitOrdinal(this.parseGuillemetElement());
        } else if (this.peekFor(Metacharacter.SECTION_SIGN)) {
            ++this.numberOfSectionCheckpoints;
            expression2 = new SectionCheckpoint(this.getCurrentPositionForStart() - 1, this.getCurrentPositionForEnd(), this.numberOfSectionCheckpoints);
        } else {
            expression2 = this.peekFor(Metacharacter.MATCH_INDENT) ? this.parseIndent(CheckIndent.IndentationMatchType.MatchIndent) : (this.peekFor(Metacharacter.INCREASE_INDENT) ? this.parseIndent(CheckIndent.IndentationMatchType.IncreaseIndent) : this.parseSimple());
        }
        return expression2;
    }

    private final Expression parseIndent(CheckIndent.IndentationMatchType indentationMatchType) {
        Expression expression2 = new CheckIndent(this.getCurrentPositionForStart() - 1, this.getCurrentPositionForEnd(), indentationMatchType);
        if (this.peekFor(Metacharacter.DOUBLE_QUESTION_MARK)) {
            Sequence sequence = new Sequence(expression2.getStartInName(), expression2.getPastEndInName(), CollectionsKt.listOf(expression2));
            expression2 = new CompletelyOptional(expression2.getStartInName(), expression2.getPastEndInName(), sequence);
        }
        return expression2;
    }

    private final Expression parseSimple() throws MalformedMessageException {
        if (this.peekFor(Metacharacter.BACK_QUOTE, this.messagePartPosition >= this.messageParts.length, AvailErrorCode.E_EXPECTED_OPERATOR_AFTER_BACKQUOTE, "Backquote (`) must be followed by a special metacharacter, space, or circled number")) {
            A_String token = this.getCurrentMessagePart();
            MessageSplitter.Companion.throwMalformedIf(A_Tuple.Companion.getTupleSize(token) != 1 || !Metacharacter.Companion.canBeBackQuoted(A_Tuple.Companion.tupleCodePointAt(token, 1)), AvailErrorCode.E_EXPECTED_OPERATOR_AFTER_BACKQUOTE, "Backquote (`) must be followed by a special metacharacter, space, or circled number, not (" + token + ")");
        } else {
            this.checkSuffixCharactersNotInSuffix();
        }
        int tokenIndex = this.messagePartPosition;
        Expression expression2 = new Simple(this.messagePartPositions[tokenIndex - 1], this.messagePartPositions[tokenIndex - 1] + A_Tuple.Companion.getTupleSize(this.messageParts[tokenIndex - 1]), this.getCurrentMessagePart(), tokenIndex);
        int n = this.messagePartPosition;
        this.messagePartPosition = n + 1;
        if (this.peekFor(Metacharacter.TILDE, !expression2.isLowerCase$avail(), AvailErrorCode.E_CASE_INSENSITIVE_EXPRESSION_CANONIZATION, "Tilde (~) may only occur after a lowercase token or a group of lowercase tokens")) {
            expression2 = expression2.applyCaseInsensitive$avail();
        }
        if (this.peekFor(Metacharacter.QUESTION_MARK)) {
            Sequence sequence = new Sequence(expression2.getStartInName(), expression2.getPastEndInName(), CollectionsKt.listOf(expression2));
            expression2 = new Optional(expression2.getStartInName(), expression2.getPastEndInName(), sequence);
        } else if (this.peekFor(Metacharacter.DOUBLE_QUESTION_MARK)) {
            Sequence sequence = new Sequence(expression2.getStartInName(), expression2.getPastEndInName(), CollectionsKt.listOf(expression2));
            expression2 = new CompletelyOptional(expression2.getStartInName(), expression2.getPastEndInName(), sequence);
        }
        return expression2;
    }

    private final Expression parseOptionalExplicitOrdinal(Expression expression2) {
        int ordinal = this.peekForExplicitOrdinal();
        if (ordinal != -1) {
            expression2.setExplicitOrdinal(ordinal);
        }
        return expression2;
    }

    private final void checkSuffixCharactersNotInSuffix() throws MalformedMessageException {
        A_String a_String = this.getCurrentMessagePartOrNull();
        if (a_String == null) {
            return;
        }
        A_String token = a_String;
        if (circledNumbersMap.containsKey(A_Tuple.Companion.tupleCodePointAt(token, 1))) {
            Companion.throwMalformedMessageException(AvailErrorCode.E_INCONSISTENT_ARGUMENT_REORDERING, "Unquoted circled numbers (\u24ea-\u32bf) may only follow an argument, an ellipsis, or an argument group");
            throw new KotlinNothingValueException();
        }
        this.peekFor(Metacharacter.OCTOTHORP, true, AvailErrorCode.E_OCTOTHORP_MUST_FOLLOW_A_SIMPLE_GROUP_OR_ELLIPSIS, "An octothorp (#) may only follow a simple group (\u00ab\u00bb) or an ellipsis (\u2026)");
        this.peekFor(Metacharacter.QUESTION_MARK, true, AvailErrorCode.E_QUESTION_MARK_MUST_FOLLOW_A_SIMPLE_GROUP, "A question mark (?) may only follow a simple group (optional) or a group with no double-dagger (\u2021)");
        this.peekFor(Metacharacter.TILDE, true, AvailErrorCode.E_CASE_INSENSITIVE_EXPRESSION_CANONIZATION, "Tilde (~) may only occur after a lowercase token or a group of lowercase tokens");
        this.peekFor(Metacharacter.VERTICAL_BAR, true, AvailErrorCode.E_VERTICAL_BAR_MUST_SEPARATE_TOKENS_OR_SIMPLE_GROUPS, "A vertical bar (|) may only separate tokens or simple groups");
        this.peekFor(Metacharacter.EXCLAMATION_MARK, true, AvailErrorCode.E_EXCLAMATION_MARK_MUST_FOLLOW_AN_ALTERNATION_GROUP, "An exclamation mark (!) may only follow an alternation group (or follow an underscore for macros)");
        this.peekFor(Metacharacter.UP_ARROW, true, AvailErrorCode.E_UP_ARROW_MUST_FOLLOW_ARGUMENT, "An up-arrow (\u2191) may only follow an argument");
    }

    private final Expression parseGuillemetElement() throws MalformedMessageException {
        Expression expression2;
        int startOfGroup = this.getCurrentPositionForStart() - 1;
        Sequence beforeDagger = this.parseSequence();
        boolean hasDagger = this.peekFor(Metacharacter.DOUBLE_DAGGER);
        Sequence afterDagger = null;
        if (hasDagger) {
            afterDagger = this.parseSequence();
            this.peekFor(Metacharacter.DOUBLE_DAGGER, true, AvailErrorCode.E_INCORRECT_USE_OF_DOUBLE_DAGGER, "A group must have at most one double-dagger (\u2021)");
        } else {
            afterDagger = new Sequence(this.getCurrentPositionForStart(), this.getCurrentPositionForStart(), CollectionsKt.emptyList());
        }
        if (!this.peekFor(Metacharacter.CLOSE_GUILLEMET)) {
            Companion.throwMalformedMessageException(AvailErrorCode.E_UNBALANCED_GUILLEMETS, "Expected close guillemet (\u00bb) to end group");
            throw new KotlinNothingValueException();
        }
        Group group = new Group(startOfGroup, this.getCurrentPositionForEnd(), beforeDagger, hasDagger, afterDagger, 0, 32, null);
        if (this.peekFor(Metacharacter.TILDE, !group.isLowerCase$avail(), AvailErrorCode.E_CASE_INSENSITIVE_EXPRESSION_CANONIZATION, "Tilde (~) may only occur after a lowercase token or a group of lowercase tokens")) {
            Group $this$parseGuillemetElement_u24lambda_u243 = group = group.applyCaseInsensitive$avail();
            boolean bl = false;
            group = new Group($this$parseGuillemetElement_u24lambda_u243.getStartInName(), this.getCurrentPositionForEnd(), beforeDagger.applyCaseInsensitive$avail(), hasDagger, afterDagger.applyCaseInsensitive$avail(), $this$parseGuillemetElement_u24lambda_u243.getMaximumCardinality());
        }
        if (this.peekFor(Metacharacter.OCTOTHORP, group.getUnderscoreCount$avail() > 0, AvailErrorCode.E_OCTOTHORP_MUST_FOLLOW_A_SIMPLE_GROUP_OR_ELLIPSIS, "An octothorp (#) may only follow a non-yielding group or an ellipsis (\u2026)")) {
            expression2 = new Counter(startOfGroup, this.getCurrentPositionForEnd(), group);
        } else if (this.peekFor(Metacharacter.QUESTION_MARK, group.getHasDagger(), AvailErrorCode.E_QUESTION_MARK_MUST_FOLLOW_A_SIMPLE_GROUP, "A question mark (?) may only follow a simple group (optional) or a group with arguments (0 or 1 occurrences), but not one with a double-dagger (\u2021), since that suggests multiple occurrences to be separated")) {
            if (group.getUnderscoreCount$avail() > 0) {
                Group $this$parseGuillemetElement_u24lambda_u244 = group;
                boolean bl = false;
                group = new Group($this$parseGuillemetElement_u24lambda_u244.getStartInName(), this.getCurrentPositionForEnd(), beforeDagger, hasDagger, afterDagger, 1);
                expression2 = group;
            } else {
                expression2 = new Optional(startOfGroup, this.getCurrentPositionForEnd(), group.getBeforeDagger());
            }
        } else if (this.peekFor(Metacharacter.DOUBLE_QUESTION_MARK, group.getUnderscoreCount$avail() > 0 || group.getHasDagger(), AvailErrorCode.E_DOUBLE_QUESTION_MARK_MUST_FOLLOW_A_TOKEN_OR_SIMPLE_GROUP, "A double question mark (\u2047) may only follow a token, an indentation indicator, or a simple group, not one with a double-dagger (\u2021) or arguments")) {
            expression2 = new CompletelyOptional(startOfGroup, this.getCurrentPositionForEnd(), group.getBeforeDagger());
        } else if (this.peekFor(Metacharacter.EXCLAMATION_MARK, group.getUnderscoreCount$avail() > 0 || group.getHasDagger() || group.getBeforeDagger().getExpressions().size() != 1 || !(group.getBeforeDagger().getExpressions().get(0) instanceof Alternation), AvailErrorCode.E_EXCLAMATION_MARK_MUST_FOLLOW_AN_ALTERNATION_GROUP, "An exclamation mark (!) may only follow an alternation group or (for macros) an underscore")) {
            Expression expression3 = group.getBeforeDagger().getExpressions().get(0);
            Intrinsics.checkNotNull(expression3, "null cannot be cast to non-null type avail.compiler.splitter.Alternation");
            Alternation alternation = (Alternation)expression3;
            expression2 = new NumberedChoice(startOfGroup, this.getCurrentPositionForEnd(), alternation);
        } else {
            expression2 = group;
        }
        return expression2;
    }

    private final Expression parseEllipsisElement() {
        int tokenStart = this.getCurrentPositionForStart() - 1;
        this.incrementLeafArgumentCount();
        return this.peekFor(Metacharacter.EXCLAMATION_MARK) ? (Expression)new RawTokenArgument(tokenStart, this.getCurrentPositionForEnd(), this.leafArgumentCount) : (this.peekFor(Metacharacter.OCTOTHORP) ? (Expression)new RawLiteralTokenArgument(tokenStart, this.getCurrentPositionForEnd(), this.leafArgumentCount) : (Expression)new RawKeywordTokenArgument(tokenStart, this.getCurrentPositionForEnd(), this.leafArgumentCount));
    }

    private final Expression parseUnderscoreElement() {
        int startInName = this.getCurrentPositionForStart() - 1;
        this.incrementLeafArgumentCount();
        return this.peekFor(Metacharacter.SINGLE_DAGGER) ? (Expression)new ArgumentInModuleScope(startInName, this.getCurrentPositionForEnd(), this.leafArgumentCount) : (this.peekFor(Metacharacter.UP_ARROW) ? (Expression)new VariableQuote(startInName, this.getCurrentPositionForEnd(), this.leafArgumentCount) : (this.peekFor(Metacharacter.EXCLAMATION_MARK) ? (Expression)new ArgumentForMacroOnly(startInName, this.getCurrentPositionForEnd(), this.leafArgumentCount) : (Expression)new Argument(startInName, this.getCurrentPositionForEnd(), this.leafArgumentCount)));
    }

    private final void incrementLeafArgumentCount() {
        int n = this.leafArgumentCount;
        this.leafArgumentCount = n + 1;
    }

    public final int getNumberOfArguments() {
        return this.rootSequence.getYielders().size();
    }

    public final void checkImplementationSignature(@NotNull A_Type functionType, int sectionNumber) throws SignatureException {
        Intrinsics.checkNotNullParameter(functionType, "functionType");
        A_Type argsTupleType = A_Type.Companion.getArgsTupleType(functionType);
        A_Type sizes = A_Type.Companion.getSizeRange(argsTupleType);
        A_Number lowerBound = A_Type.Companion.getLowerBound(sizes);
        A_Number upperBound = A_Type.Companion.getUpperBound(sizes);
        if (!lowerBound.equals(upperBound) || !A_Number.Companion.isInt(lowerBound)) {
            Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
            throw new KotlinNothingValueException();
        }
        int lowerBoundInt = A_Number.Companion.getExtractInt(lowerBound);
        if (lowerBoundInt != this.getNumberOfArguments()) {
            Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
            throw new KotlinNothingValueException();
        }
        this.rootSequence.checkRootType(A_Type.Companion.getArgsTupleType(functionType), sectionNumber);
    }

    public static /* synthetic */ void checkImplementationSignature$default(MessageSplitter messageSplitter, A_Type a_Type, int n, int n2, Object object) throws SignatureException {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        messageSplitter.checkImplementationSignature(a_Type, n);
    }

    public final boolean checkListStructure(@NotNull A_Phrase list2) {
        Intrinsics.checkNotNullParameter(list2, "list");
        return this.rootSequence.checkListStructure(list2);
    }

    public final boolean getContainsGroups() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.rootSequence.getExpressions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Expression p0 = (Expression)element$iv;
                    boolean bl2 = false;
                    if (!p0.isGroup$avail()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean getRecursivelyContainsReorders() {
        return this.rootSequence.getRecursivelyContainsReorders();
    }

    @NotNull
    public final List<Integer> getAllSimpleLeafIndices() {
        List indices = new ArrayList();
        ArrayDeque<Sequence> work = new ArrayDeque<Sequence>();
        work.add(this.rootSequence);
        while (!((Collection)work).isEmpty()) {
            Expression item = (Expression)work.removeLast();
            if (item instanceof Simple) {
                indices.add(((Simple)item).getTokenIndex$avail());
            }
            work.addAll(CollectionsKt.reversed((Iterable)item.children$avail()));
        }
        return indices;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.dumpForDebug($this$toString_u24lambda_u245);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static final /* synthetic */ Expression access$parseElementOrAlternation(MessageSplitter $this) {
        return $this.parseElementOrAlternation();
    }

    public /* synthetic */ MessageSplitter(A_String messageName, DefaultConstructorMarker $constructor_marker) {
        this(messageName);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateTo$iv$iv;
        Companion = new Companion(null);
        cache = new LRUCache(20000, 500, Companion.cache.1.INSTANCE, null, 8, null);
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP, AvailErrorCode.E_INCORRECT_TYPE_FOR_COMPLEX_GROUP, AvailErrorCode.E_INCORRECT_TYPE_FOR_COUNTING_GROUP, AvailErrorCode.E_INCORRECT_TYPE_FOR_BOOLEAN_GROUP, AvailErrorCode.E_INCORRECT_TYPE_FOR_NUMBERED_CHOICE, AvailErrorCode.E_INCORRECT_USE_OF_DOUBLE_DAGGER, AvailErrorCode.E_UNBALANCED_GUILLEMETS, AvailErrorCode.E_METHOD_NAME_IS_NOT_CANONICAL, AvailErrorCode.E_ALTERNATIVE_MUST_NOT_CONTAIN_ARGUMENTS, AvailErrorCode.E_OCTOTHORP_MUST_FOLLOW_A_SIMPLE_GROUP_OR_ELLIPSIS, AvailErrorCode.E_QUESTION_MARK_MUST_FOLLOW_A_SIMPLE_GROUP, AvailErrorCode.E_VERTICAL_BAR_MUST_SEPARATE_TOKENS_OR_SIMPLE_GROUPS, AvailErrorCode.E_EXCLAMATION_MARK_MUST_FOLLOW_AN_ALTERNATION_GROUP, AvailErrorCode.E_DOUBLE_QUESTION_MARK_MUST_FOLLOW_A_TOKEN_OR_SIMPLE_GROUP, AvailErrorCode.E_CASE_INSENSITIVE_EXPRESSION_CANONIZATION, AvailErrorCode.E_EXPECTED_OPERATOR_AFTER_BACKQUOTE, AvailErrorCode.E_UP_ARROW_MUST_FOLLOW_ARGUMENT, AvailErrorCode.E_INCONSISTENT_ARGUMENT_REORDERING};
        possibleErrors = SetDescriptor.Companion.set(availErrorCodeArray).makeShared();
        circledNumbersCount = circledNumbersString.codePointCount(0, 51);
        PrimitiveIterator.OfInt ofInt = circledNumbersString.codePoints().iterator();
        Intrinsics.checkNotNullExpressionValue(ofInt, "iterator(...)");
        circledNumberCodePoints = CollectionsKt.toIntArray(SequencesKt.toList(SequencesKt.asSequence(ofInt)));
        Iterable<IndexedValue<Integer>> $this$associate$iv = ArraysKt.withIndex(circledNumberCodePoints);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable<IndexedValue<Integer>> iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Object object = (IndexedValue)element$iv$iv;
            boolean bl = false;
            int i2 = ((IndexedValue)object).component1();
            int cp = ((Number)((IndexedValue)object).component2()).intValue();
            object = TuplesKt.to(cp, i2);
            map.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
        }
        circledNumbersMap = destination$iv$iv;
        permutations = new AtomicReference<AvailObject>(TupleDescriptor.Companion.getEmptyTuple());
        constantsList = new ArrayList();
        constantsMap = new LinkedHashMap();
        constantsLock = new ReentrantReadWriteLock();
        indexForTrue = Companion.indexForConstant(AtomDescriptor.Companion.getTrueObject());
        indexForFalse = Companion.indexForConstant(AtomDescriptor.Companion.getFalseObject());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u000e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nJ\u000e\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\nJ\u000e\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\u001fJ\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\nJ\u000e\u00104\u001a\u0002022\u0006\u00103\u001a\u00020\nJ\u000e\u00105\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\nJ\u000e\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0005J \u00108\u001a\u00020%2\u0006\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0010H\u0002J\u0016\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020;2\u0006\u0010?\u001a\u00020\u0010J\u000e\u0010@\u001a\u00020>2\u0006\u0010:\u001a\u00020;R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006A"}, d2={"Lavail/compiler/splitter/MessageSplitter$Companion;", "", "()V", "cache", "Lorg/availlang/cache/LRUCache;", "Lavail/descriptor/tuples/A_String;", "Lavail/compiler/splitter/MessageSplitter;", "circledNumberCodePoints", "", "circledNumbersCount", "", "circledNumbersMap", "", "getCircledNumbersMap", "()Ljava/util/Map;", "circledNumbersString", "", "constantsList", "", "Lavail/descriptor/representation/AvailObject;", "constantsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "constantsMap", "", "indexForFalse", "getIndexForFalse", "()I", "indexForTrue", "getIndexForTrue", "permutations", "Ljava/util/concurrent/atomic/AtomicReference;", "Lavail/descriptor/tuples/A_Tuple;", "possibleErrors", "Lavail/descriptor/sets/A_Set;", "getPossibleErrors", "()Lavail/descriptor/sets/A_Set;", "checkAlternative", "", "expression", "Lavail/compiler/splitter/Expression;", "circledNumberCodePoint", "number", "constantForIndex", "index", "indexForConstant", "constant", "Lavail/descriptor/representation/A_BasicObject;", "indexForPermutation", "permutation", "isOperator", "", "cp", "isUnderscoreOrSpaceOrOperator", "permutationAtIndex", "split", "messageName", "throwMalformedIf", "condition", "errorCode", "Lavail/exceptions/AvailErrorCode;", "errorString", "throwMalformedMessageException", "", "errorMessage", "throwSignatureException", "avail"})
    @SourceDebugExtension(value={"SMAP\nMessageSplitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageSplitter.kt\navail/compiler/splitter/MessageSplitter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Locks.kt\navail/utility/LocksKt\n*L\n1#1,1901:1\n1#2:1902\n55#3:1903\n*S KotlinDebug\n*F\n+ 1 MessageSplitter.kt\navail/compiler/splitter/MessageSplitter$Companion\n*L\n1751#1:1903\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MessageSplitter split(@NotNull A_String messageName) {
            Intrinsics.checkNotNullParameter(messageName, "messageName");
            return (MessageSplitter)cache.get(messageName.makeShared());
        }

        @NotNull
        public final A_Set getPossibleErrors() {
            return possibleErrors;
        }

        public final int circledNumberCodePoint(int number) {
            boolean bl;
            boolean bl2 = 0 <= number ? number < circledNumbersCount : (bl = false);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return circledNumberCodePoints[number];
        }

        @NotNull
        public final Map<Integer, Integer> getCircledNumbersMap() {
            return circledNumbersMap;
        }

        @NotNull
        public final AvailObject permutationAtIndex(int index2) {
            Object v = permutations.get();
            Intrinsics.checkNotNullExpressionValue(v, "get(...)");
            return A_Tuple.Companion.tupleAt((A_Tuple)v, index2);
        }

        public final int indexForPermutation(@NotNull A_Tuple permutation) {
            Intrinsics.checkNotNullParameter(permutation, "permutation");
            int checkedLimit = 0;
            while (true) {
                A_Tuple before = (A_Tuple)permutations.get();
                Intrinsics.checkNotNull(before);
                int newLimit = A_Tuple.Companion.getTupleSize(before);
                int i2 = checkedLimit + 1;
                if (i2 <= newLimit) {
                    while (true) {
                        if (A_Tuple.Companion.tupleAt(before, i2).equals(permutation)) {
                            return i2;
                        }
                        if (i2 == newLimit) break;
                        ++i2;
                    }
                }
                AvailObject after = A_Tuple.Companion.appendCanDestroy(before, permutation, false).makeShared();
                if (permutations.compareAndSet(before, after)) {
                    return A_Tuple.Companion.getTupleSize(after);
                }
                checkedLimit = newLimit;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int indexForConstant(@NotNull A_BasicObject constant) {
            Lock lock;
            Intrinsics.checkNotNullParameter(constant, "constant");
            AvailObject strongConstant = constant.makeShared();
            ReentrantReadWriteLock.ReadLock readLock = constantsLock.readLock();
            readLock.lock();
            try {
                Integer index2;
                boolean bl = false;
                Integer n = index2 = (Integer)constantsMap.get(strongConstant);
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl2 = false;
                    int n2 = it;
                    return n2;
                }
                lock = null;
            }
            finally {
                readLock.unlock();
            }
            ReentrantReadWriteLock $this$safeWrite$iv = constantsLock;
            boolean $i$f$safeWrite = false;
            ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
            Intrinsics.checkNotNullExpressionValue(writeLock, "writeLock(...)");
            lock = writeLock;
            lock.lock();
            try {
                boolean bl;
                Integer index3;
                boolean bl3 = false;
                Integer n = index3 = (Integer)constantsMap.get(strongConstant);
                if (n != null) {
                    int it = ((Number)n).intValue();
                    boolean bl4 = false;
                    int n3 = it;
                    return n3;
                }
                boolean bl5 = bl = constantsMap.size() == constantsList.size();
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                int newIndex = constantsList.size() + 1;
                constantsList.add(strongConstant);
                Integer n4 = newIndex;
                constantsMap.put(strongConstant, n4);
                int n5 = newIndex;
                return n5;
            }
            finally {
                lock.unlock();
            }
        }

        public final int getIndexForTrue() {
            return indexForTrue;
        }

        public final int getIndexForFalse() {
            return indexForFalse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final AvailObject constantForIndex(int index2) {
            AvailObject availObject;
            ReentrantReadWriteLock.ReadLock readLock = constantsLock.readLock();
            readLock.lock();
            try {
                boolean bl = false;
                availObject = (AvailObject)constantsList.get(index2 - 1);
            }
            finally {
                readLock.unlock();
            }
            return availObject;
        }

        private final void throwMalformedIf(boolean condition, AvailErrorCode errorCode, String errorString) throws MalformedMessageException {
            if (condition) {
                this.throwMalformedMessageException(errorCode, errorString);
                throw new KotlinNothingValueException();
            }
        }

        private final void checkAlternative(Expression expression2) throws MalformedMessageException {
            this.throwMalformedIf(expression2.getYieldsValue$avail() || expression2.getUnderscoreCount$avail() > 0, AvailErrorCode.E_ALTERNATIVE_MUST_NOT_CONTAIN_ARGUMENTS, "Alternatives must not contain arguments");
        }

        @NotNull
        public final Void throwSignatureException(@NotNull AvailErrorCode errorCode) throws SignatureException {
            Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
            throw new SignatureException(errorCode);
        }

        @NotNull
        public final Void throwMalformedMessageException(@NotNull AvailErrorCode errorCode, @NotNull String errorMessage2) throws MalformedMessageException {
            Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
            Intrinsics.checkNotNullParameter(errorMessage2, "errorMessage");
            throw new MalformedMessageException(errorCode, new Function0<String>(errorMessage2){
                final /* synthetic */ String $errorMessage;
                {
                    this.$errorMessage = $errorMessage;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$errorMessage;
                }
            });
        }

        public final boolean isUnderscoreOrSpaceOrOperator(int cp) {
            return cp == 95 || cp == 8230 || cp == 32 || cp == 47 || this.isOperator(cp);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isOperator(int cp) {
            boolean bl;
            if (Character.isDigit(cp)) return false;
            if (Character.isUnicodeIdentifierStart(cp)) return false;
            if (Character.isSpaceChar(cp)) return false;
            if (Character.isWhitespace(cp)) return false;
            if (cp < 32) return false;
            if (127 <= cp) {
                if (cp < 160) {
                    return false;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return false;
            if (!Character.isDefined(cp)) return false;
            if (cp == 95) return false;
            if (cp == 34) return false;
            if (cp == 65279) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0086\u0081\u0002\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001e\u00a8\u0006 "}, d2={"Lavail/compiler/splitter/MessageSplitter$Metacharacter;", "", "javaString", "", "(Ljava/lang/String;ILjava/lang/String;)V", "codepoint", "", "getCodepoint", "()I", "string", "Lavail/descriptor/tuples/A_String;", "getString", "()Lavail/descriptor/tuples/A_String;", "BACK_QUOTE", "CLOSE_GUILLEMET", "DOUBLE_DAGGER", "DOUBLE_QUESTION_MARK", "ELLIPSIS", "EXCLAMATION_MARK", "INCREASE_INDENT", "MATCH_INDENT", "OCTOTHORP", "OPEN_GUILLEMET", "QUESTION_MARK", "SECTION_SIGN", "SINGLE_DAGGER", "SPACE", "TILDE", "UNDERSCORE", "UP_ARROW", "VERTICAL_BAR", "Companion", "avail"})
    @SourceDebugExtension(value={"SMAP\nMessageSplitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageSplitter.kt\navail/compiler/splitter/MessageSplitter$Metacharacter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1901:1\n1855#2,2:1902\n*S KotlinDebug\n*F\n+ 1 MessageSplitter.kt\navail/compiler/splitter/MessageSplitter$Metacharacter\n*L\n552#1:1902,2\n*E\n"})
    public static final class Metacharacter
    extends Enum<Metacharacter> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final A_String string;
        private final int codepoint;
        @NotNull
        private static final Set<Integer> backquotableCodepoints;
        public static final /* enum */ Metacharacter BACK_QUOTE;
        public static final /* enum */ Metacharacter CLOSE_GUILLEMET;
        public static final /* enum */ Metacharacter DOUBLE_DAGGER;
        public static final /* enum */ Metacharacter DOUBLE_QUESTION_MARK;
        public static final /* enum */ Metacharacter ELLIPSIS;
        public static final /* enum */ Metacharacter EXCLAMATION_MARK;
        public static final /* enum */ Metacharacter INCREASE_INDENT;
        public static final /* enum */ Metacharacter MATCH_INDENT;
        public static final /* enum */ Metacharacter OCTOTHORP;
        public static final /* enum */ Metacharacter OPEN_GUILLEMET;
        public static final /* enum */ Metacharacter QUESTION_MARK;
        public static final /* enum */ Metacharacter SECTION_SIGN;
        public static final /* enum */ Metacharacter SINGLE_DAGGER;
        public static final /* enum */ Metacharacter SPACE;
        public static final /* enum */ Metacharacter TILDE;
        public static final /* enum */ Metacharacter UNDERSCORE;
        public static final /* enum */ Metacharacter UP_ARROW;
        public static final /* enum */ Metacharacter VERTICAL_BAR;
        private static final /* synthetic */ Metacharacter[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        /*
         * WARNING - void declaration
         */
        private Metacharacter(String javaString) {
            void $this$string_u24lambda_u240;
            boolean bl;
            AvailObject availObject;
            AvailObject availObject2 = availObject = StringDescriptor.Companion.stringFrom(javaString).makeShared();
            Metacharacter metacharacter = this;
            boolean bl2 = false;
            boolean bl3 = bl = A_Tuple.Companion.getTupleSize((A_Tuple)$this$string_u24lambda_u240) == 1;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            metacharacter.string = availObject;
            this.codepoint = A_Tuple.Companion.tupleCodePointAt(this.string, 1);
        }

        @NotNull
        public final A_String getString() {
            return this.string;
        }

        public final int getCodepoint() {
            return this.codepoint;
        }

        public static Metacharacter[] values() {
            return (Metacharacter[])$VALUES.clone();
        }

        public static Metacharacter valueOf(String value) {
            return Enum.valueOf(Metacharacter.class, value);
        }

        @NotNull
        public static EnumEntries<Metacharacter> getEntries() {
            return $ENTRIES;
        }

        static {
            BACK_QUOTE = new Metacharacter("`");
            CLOSE_GUILLEMET = new Metacharacter("\u00bb");
            DOUBLE_DAGGER = new Metacharacter("\u2021");
            DOUBLE_QUESTION_MARK = new Metacharacter("\u2047");
            ELLIPSIS = new Metacharacter("\u2026");
            EXCLAMATION_MARK = new Metacharacter("!");
            INCREASE_INDENT = new Metacharacter("\u21e5");
            MATCH_INDENT = new Metacharacter("\u21b9");
            OCTOTHORP = new Metacharacter("#");
            OPEN_GUILLEMET = new Metacharacter("\u00ab");
            QUESTION_MARK = new Metacharacter("?");
            SECTION_SIGN = new Metacharacter("\u00a7");
            SINGLE_DAGGER = new Metacharacter("\u2020");
            SPACE = new Metacharacter(" ");
            TILDE = new Metacharacter("~");
            UNDERSCORE = new Metacharacter("_");
            UP_ARROW = new Metacharacter("\u2191");
            VERTICAL_BAR = new Metacharacter("|");
            $VALUES = metacharacterArray = new Metacharacter[]{Metacharacter.BACK_QUOTE, Metacharacter.CLOSE_GUILLEMET, Metacharacter.DOUBLE_DAGGER, Metacharacter.DOUBLE_QUESTION_MARK, Metacharacter.ELLIPSIS, Metacharacter.EXCLAMATION_MARK, Metacharacter.INCREASE_INDENT, Metacharacter.MATCH_INDENT, Metacharacter.OCTOTHORP, Metacharacter.OPEN_GUILLEMET, Metacharacter.QUESTION_MARK, Metacharacter.SECTION_SIGN, Metacharacter.SINGLE_DAGGER, Metacharacter.SPACE, Metacharacter.TILDE, Metacharacter.UNDERSCORE, Metacharacter.UP_ARROW, Metacharacter.VERTICAL_BAR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            backquotableCodepoints = new LinkedHashSet();
            backquotableCodepoints.addAll((Collection<Integer>)Companion.getCircledNumbersMap().keySet());
            Iterable $this$forEach$iv = Metacharacter.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Metacharacter it = (Metacharacter)((Object)element$iv);
                boolean bl = false;
                backquotableCodepoints.add(it.codepoint);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lavail/compiler/splitter/MessageSplitter$Metacharacter$Companion;", "", "()V", "backquotableCodepoints", "", "", "canBeBackQuoted", "", "codePoint", "avail"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean canBeBackQuoted(int codePoint) {
                return backquotableCodepoints.contains(codePoint);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

