/*
 * Decompiled with CFR 0.152.
 */
package avail.files;

import avail.error.ErrorCode;
import avail.files.AvailFile;
import avail.files.FileAction;
import avail.files.FileErrorCode;
import avail.files.FileManager;
import avail.files.FileRequestHandler;
import avail.files.TracedAction;
import avail.resolver.ResolverReference;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000200J:\u00102\u001a\u0002002\u0014\u00103\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u000200042\u001a\u00105\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020006H&J$\u00107\u001a\u0002002\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00032\f\u0010;\u001a\b\u0012\u0004\u0012\u0002000<J\u001a\u0010=\u001a\u0002002\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\fJ\u0006\u0010?\u001a\u000200JJ\u0010@\u001a\u0002002\u0006\u0010A\u001a\u00020$2\u001e\u0010B\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002000C2\u001a\u0010E\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020006J\u000e\u0010F\u001a\u0002002\u0006\u0010:\u001a\u00020\u0003J\u000e\u0010G\u001a\u0002002\u0006\u0010:\u001a\u00020\u0003R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010%R\u0014\u0010&\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010%R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lavail/files/AbstractFileWrapper;", "", "id", "Ljava/util/UUID;", "reference", "Lavail/resolver/ResolverReference;", "fileManager", "Lavail/files/FileManager;", "(Ljava/util/UUID;Lavail/resolver/ResolverReference;Lavail/files/FileManager;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "error", "", "getError", "()Ljava/lang/Throwable;", "errorCode", "Lavail/error/ErrorCode;", "getErrorCode", "()Lavail/error/ErrorCode;", "file", "Lavail/files/AvailFile;", "getFile", "()Lavail/files/AvailFile;", "getFileManager", "()Lavail/files/FileManager;", "fileRequestQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lavail/files/FileRequestHandler;", "getId", "()Ljava/util/UUID;", "interestCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getInterestCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "isAvailable", "isClosed", "", "()Z", "isError", "getReference", "()Lavail/resolver/ResolverReference;", "tracedActionStack", "Ljava/util/Stack;", "Lavail/files/TracedAction;", "tracedActionStackSavePointer", "", "undoStackDepth", "close", "", "conditionallySaveToLocalHistory", "delete", "success", "Lkotlin/Function1;", "failure", "Lkotlin/Function2;", "execute", "fileAction", "Lavail/files/FileAction;", "originator", "continuation", "Lkotlin/Function0;", "notifyOpenFailure", "e", "notifyReady", "provide", "registerInterest", "successHandler", "Lkotlin/Function3;", "", "failureHandler", "redo", "undo", "avail"})
@SourceDebugExtension(value={"SMAP\nManagedFileWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedFileWrapper.kt\navail/files/AbstractFileWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,571:1\n1855#2,2:572\n1855#2,2:574\n*S KotlinDebug\n*F\n+ 1 ManagedFileWrapper.kt\navail/files/AbstractFileWrapper\n*L\n338#1:572,2\n360#1:574,2\n*E\n"})
public abstract class AbstractFileWrapper {
    @NotNull
    private final UUID id;
    @NotNull
    private final ResolverReference reference;
    @NotNull
    private final FileManager fileManager;
    @Nullable
    private final ErrorCode errorCode;
    @Nullable
    private final Throwable error;
    @NotNull
    private final AtomicBoolean isAvailable;
    @NotNull
    private final ConcurrentLinkedQueue<FileRequestHandler> fileRequestQueue;
    @NotNull
    private final Stack<TracedAction> tracedActionStack;
    private int tracedActionStackSavePointer;
    @NotNull
    private final AtomicInteger undoStackDepth;
    @NotNull
    private final AtomicInteger interestCount;
    @NotNull
    private final AtomicBoolean closed;

    public AbstractFileWrapper(@NotNull UUID id, @NotNull ResolverReference reference, @NotNull FileManager fileManager) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(fileManager, "fileManager");
        this.id = id;
        this.reference = reference;
        this.fileManager = fileManager;
        this.isAvailable = new AtomicBoolean(false);
        this.fileRequestQueue = new ConcurrentLinkedQueue();
        this.tracedActionStack = new Stack();
        this.undoStackDepth = new AtomicInteger(0);
        this.interestCount = new AtomicInteger(0);
        this.closed = new AtomicBoolean(false);
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public final ResolverReference getReference() {
        return this.reference;
    }

    @NotNull
    protected final FileManager getFileManager() {
        return this.fileManager;
    }

    public boolean isError() {
        return false;
    }

    @Nullable
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    @NotNull
    public abstract AvailFile getFile();

    public abstract void delete(@NotNull Function1<? super UUID, Unit> var1, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> var2);

    public final void conditionallySaveToLocalHistory() {
        int currentSize = this.tracedActionStack.size();
        if (this.tracedActionStackSavePointer < currentSize) {
            int start;
            for (int i2 = start = this.tracedActionStackSavePointer; i2 < currentSize; ++i2) {
                this.tracedActionStack.get(i2);
            }
            this.tracedActionStackSavePointer = currentSize;
        }
    }

    public final synchronized void execute(@NotNull FileAction fileAction, @NotNull UUID originator, @NotNull Function0<Unit> continuation) {
        Intrinsics.checkNotNullParameter(fileAction, "fileAction");
        Intrinsics.checkNotNullParameter(originator, "originator");
        Intrinsics.checkNotNullParameter(continuation, "continuation");
        TracedAction tracedAction = fileAction.execute(this.getFile(), System.currentTimeMillis(), originator);
        if (tracedAction.isTraced()) {
            int stackSize = this.tracedActionStack.size();
            int undoPointer = stackSize - this.undoStackDepth.get();
            if (undoPointer < stackSize) {
                do {
                    TracedAction tracedAction2 = this.tracedActionStack.pop();
                } while (this.undoStackDepth.decrementAndGet() > 0);
            }
            this.tracedActionStack.push(tracedAction);
        }
        continuation.invoke();
    }

    public final void undo(@NotNull UUID originator) {
        Intrinsics.checkNotNullParameter(originator, "originator");
        if (this.tracedActionStack.size() >= this.undoStackDepth.get() + 1) {
            int tracedActionIndex = this.tracedActionStack.size() - this.undoStackDepth.incrementAndGet();
            ((TracedAction)this.tracedActionStack.get(tracedActionIndex)).undo(this.getFile());
        }
    }

    public final void redo(@NotNull UUID originator) {
        Intrinsics.checkNotNullParameter(originator, "originator");
        if (this.undoStackDepth.get() == 0) {
            return;
        }
        int index2 = this.tracedActionStack.size() - this.undoStackDepth.get();
        ((TracedAction)this.tracedActionStack.get(index2)).redo(this.getFile());
        this.undoStackDepth.decrementAndGet();
    }

    @NotNull
    public final AtomicInteger getInterestCount() {
        return this.interestCount;
    }

    public final boolean isClosed() {
        return this.closed.get();
    }

    public final void close() {
        this.closed.set(true);
    }

    public final void provide(boolean registerInterest, @NotNull Function3<? super UUID, ? super String, ? super AvailFile, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(successHandler, "successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        if (this.isError()) {
            ErrorCode errorCode = this.getErrorCode();
            Intrinsics.checkNotNull(errorCode);
            failureHandler.invoke(errorCode, this.getError());
            return;
        }
        if (this.closed.get()) {
            failureHandler.invoke(FileErrorCode.FILE_CLOSED, null);
        }
        if (registerInterest) {
            this.interestCount.incrementAndGet();
        }
        if (this.isAvailable.get()) {
            successHandler.invoke(this.id, this.reference.getMimeType(), this.getFile());
            return;
        }
        this.fileRequestQueue.add(new FileRequestHandler(this.id, successHandler, failureHandler));
    }

    public final void notifyReady() {
        if (!this.isAvailable.getAndSet(true)) {
            Iterable $this$forEach$iv = this.fileRequestQueue;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileRequestHandler it = (FileRequestHandler)element$iv;
                boolean bl = false;
                this.fileManager.executeFileTask(new Function0<Unit>(it, this){
                    final /* synthetic */ FileRequestHandler $it;
                    final /* synthetic */ AbstractFileWrapper this$0;
                    {
                        this.$it = $it;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.$it.getRequestConsumer().invoke(this.$it.getId(), this.this$0.getReference().getMimeType(), this.this$0.getFile());
                    }
                });
            }
            this.fileManager.checkInterest(this.id);
        }
    }

    public final void notifyOpenFailure(@NotNull ErrorCode errorCode, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter(errorCode, "errorCode");
        Iterable $this$forEach$iv = this.fileRequestQueue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileRequestHandler it = (FileRequestHandler)element$iv;
            boolean bl = false;
            it.getFailureHandler().invoke(errorCode, e);
        }
    }

    public static /* synthetic */ void notifyOpenFailure$default(AbstractFileWrapper abstractFileWrapper, ErrorCode errorCode, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: notifyOpenFailure");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        abstractFileWrapper.notifyOpenFailure(errorCode, throwable);
    }
}

