/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo;

import avail.AvailDebuggerModel;
import avail.AvailRuntime;
import avail.AvailRuntimeSupport;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.CompiledCodeDescriptor;
import avail.descriptor.functions.ContinuationDescriptor;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.methods.A_Definition;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.A_Sendable;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.variables.A_Variable;
import avail.descriptor.variables.VariableDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MethodDefinitionException;
import avail.exceptions.VariableGetException;
import avail.exceptions.VariableSetException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelOne.L1OperandType;
import avail.interpreter.levelOne.L1Operation;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.optimizer.StackReifier;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 ?2\u00020\u0001:\u0001?B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J'\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010(\u001a\u00020\u0014J\u000e\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0014J\u0016\u0010+\u001a\u00020,2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020\rH\u0002J\u0010\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J \u00106\u001a\u00020,2\u0006\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\n\u0010<\u001a\u0004\u0018\u00010\u001aH\u0007J\u001a\u0010=\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010-\u001a\u00020\rH\u0002J\u0006\u0010>\u001a\u00020,R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006@"}, d2={"Lavail/interpreter/levelTwo/L1InstructionStepper;", "", "interpreter", "Lavail/interpreter/execution/Interpreter;", "(Lavail/interpreter/execution/Interpreter;)V", "instructionDecoder", "Lavail/descriptor/functions/CompiledCodeDescriptor$L1InstructionDecoder;", "getInstructionDecoder", "()Lavail/descriptor/functions/CompiledCodeDescriptor$L1InstructionDecoder;", "getInterpreter", "()Lavail/interpreter/execution/Interpreter;", "pointers", "", "Lavail/descriptor/representation/AvailObject;", "getPointers", "()[Lavail/descriptor/representation/AvailObject;", "setPointers", "([Lavail/descriptor/representation/AvailObject;)V", "[Lavail/descriptor/representation/AvailObject;", "stackp", "", "getStackp", "()I", "setStackp", "(I)V", "callMethodAfterLookup", "Lavail/optimizer/StackReifier;", "matching", "Lavail/descriptor/methods/A_Definition;", "checkReturnType", "result", "expectedReturnType", "Lavail/descriptor/types/A_Type;", "returnee", "Lavail/descriptor/functions/A_Function;", "checkReturnType$avail", "getVariable", "variable", "Lavail/descriptor/variables/A_Variable;", "getVariableClearingIfMutable", "pc", "pointerAt", "index", "pointerAtPut", "", "value", "Lavail/descriptor/representation/A_BasicObject;", "pop", "push", "reifyAndReportFailedLookup", "method", "Lavail/descriptor/methods/A_Method;", "errorCode", "Lavail/exceptions/AvailErrorCode;", "reifyCurrentFrame", "reifier", "entryPoint", "Lavail/interpreter/levelTwo/L2JVMChunk$ChunkEntryPoint;", "logMessage", "", "run", "setVariable", "wipeRegisters", "Companion", "avail"})
@SourceDebugExtension(value={"SMAP\nL1InstructionStepper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L1InstructionStepper.kt\navail/interpreter/levelTwo/L1InstructionStepper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ObjectTupleDescriptor.kt\navail/descriptor/tuples/ObjectTupleDescriptor$Companion\n+ 4 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 Casts.kt\navail/utility/CastsKt\n*L\n1#1,1184:1\n11065#2:1185\n11400#2,3:1186\n571#3:1189\n572#3,5:1191\n574#4:1190\n1#5:1196\n1549#6:1197\n1620#6,3:1198\n46#7:1201\n46#7:1202\n46#7:1203\n*S KotlinDebug\n*F\n+ 1 L1InstructionStepper.kt\navail/interpreter/levelTwo/L1InstructionStepper\n*L\n346#1:1185\n346#1:1186,3\n534#1:1189\n534#1:1191,5\n534#1:1190\n555#1:1197\n555#1:1198,3\n1137#1:1201\n1138#1:1202\n1139#1:1203\n*E\n"})
public final class L1InstructionStepper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Interpreter interpreter;
    @NotNull
    private final CompiledCodeDescriptor.L1InstructionDecoder instructionDecoder;
    private int stackp;
    @NotNull
    private AvailObject[] pointers;
    @NotNull
    private static final Statistic reificationBeforeLabelCreationStat = new Statistic(StatisticReport.REIFICATIONS, "Reification before label creation in L1");
    @NotNull
    private static final AvailObject[] emptyPointersArray = new AvailObject[0];
    private static final Pattern whitespaces = Pattern.compile("\\s+");
    @NotNull
    private static final CheckedMethod runMethod = CheckedMethod.Companion.instanceMethod(L1InstructionStepper.class, "run", StackReifier.class, new Class[0]);

    public L1InstructionStepper(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        this.interpreter = interpreter;
        this.instructionDecoder = new CompiledCodeDescriptor.L1InstructionDecoder();
        this.pointers = emptyPointersArray;
    }

    @NotNull
    public final Interpreter getInterpreter() {
        return this.interpreter;
    }

    @NotNull
    public final CompiledCodeDescriptor.L1InstructionDecoder getInstructionDecoder() {
        return this.instructionDecoder;
    }

    public final int getStackp() {
        return this.stackp;
    }

    public final void setStackp(int n) {
        this.stackp = n;
    }

    @NotNull
    public final AvailObject[] getPointers() {
        return this.pointers;
    }

    public final void setPointers(@NotNull AvailObject[] availObjectArray) {
        Intrinsics.checkNotNullParameter(availObjectArray, "<set-?>");
        this.pointers = availObjectArray;
    }

    public final int pc() {
        return this.instructionDecoder.pc();
    }

    @NotNull
    public final AvailObject pointerAt(int index2) {
        return this.pointers[index2];
    }

    public final void pointerAtPut(int index2, @NotNull A_BasicObject value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.pointers[index2] = value;
    }

    public final void wipeRegisters() {
        this.pointers = emptyPointersArray;
    }

    private final void push(A_BasicObject value) {
        this.stackp += -1;
        this.pointerAtPut(this.stackp, value);
    }

    private final AvailObject pop() {
        AvailObject popped = this.pointerAt(this.stackp);
        int n = this.stackp;
        this.stackp = n + 1;
        this.pointerAtPut(n, NilDescriptor.Companion.getNil());
        return popped;
    }

    /*
     * WARNING - void declaration
     */
    @ReferencedInGeneratedCode
    @Nullable
    public final StackReifier run() {
        A_Function a_Function = this.interpreter.function;
        Intrinsics.checkNotNull(a_Function);
        A_Function function = a_Function;
        A_RawFunction code = function.code();
        if (Interpreter.Companion.getDebugL1()) {
            Logger logger = Interpreter.Companion.getLoggerDebugL1();
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue(level, "FINER");
            Object[] objectArray = new Object[]{this.interpreter.getDebugModeString(), whitespaces.matcher(function.toString()).replaceAll(" ")};
            Interpreter.Companion.log(logger, level, "{0}Started L1 run: {1}", objectArray);
        }
        AvailDebuggerModel debugger = this.interpreter.getDebugger();
        code.setUpInstructionDecoder(this.instructionDecoder);
        block8: while (true) {
            Object valueOrReifier;
            Object valueOrReifier22;
            StackReifier reifier;
            Object newFunction;
            AvailObject result22;
            int i2;
            A_Type expectedReturnType;
            A_Bundle bundle;
            int n;
            Object object;
            void $this$mapTo$iv$iv2;
            boolean $i$f$mapTo;
            Object destination$iv$iv;
            boolean $i$f$map2;
            Object $this$map$iv;
            if (debugger != null) {
                Function1<Interpreter, Boolean> function1 = this.interpreter.getDebuggerRunCondition();
                Intrinsics.checkNotNull(function1);
                if (!function1.invoke(this.interpreter).booleanValue()) {
                    AvailObject[] availObjectArray = this.pointers;
                    AvailObject mutableContinuation2 = ContinuationDescriptor.Companion.createContinuationWithFrame(function, NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), this.pc(), this.stackp, L2JVMChunk.Companion.getUnoptimizedChunk(), L2JVMChunk.ChunkEntryPoint.TO_RESUME.getOffsetInDefaultChunk(), CollectionsKt.listOf(Arrays.copyOf(availObjectArray, availObjectArray.length)), 1);
                    this.interpreter.setReifying(true);
                    return new StackReifier(true, AvailDebuggerModel.Companion.getReificationForDebuggerStat(), new Function0<Unit>(this, mutableContinuation2, debugger){
                        final /* synthetic */ L1InstructionStepper this$0;
                        final /* synthetic */ AvailObject $mutableContinuation;
                        final /* synthetic */ AvailDebuggerModel $debugger;
                        {
                            this.this$0 = $receiver;
                            this.$mutableContinuation = $mutableContinuation;
                            this.$debugger = $debugger;
                            super(0);
                        }

                        public final void invoke() {
                            Interpreter interpreter = this.this$0.getInterpreter();
                            AvailObject availObject = this.$mutableContinuation;
                            L1InstructionStepper l1InstructionStepper = this.this$0;
                            AvailDebuggerModel availDebuggerModel = this.$debugger;
                            Interpreter $this$invoke_u24lambda_u240 = interpreter;
                            boolean bl = false;
                            A_Fiber f = $this$invoke_u24lambda_u240.fiber();
                            $this$invoke_u24lambda_u240.returnNow = false;
                            A_Continuation a_Continuation = availObject;
                            AvailObject availObject2 = $this$invoke_u24lambda_u240.getReifiedContinuation();
                            Intrinsics.checkNotNull(availObject2);
                            A_Fiber.Companion.setContinuation(f, A_Continuation.Companion.replacingCaller(a_Continuation, availObject2));
                            l1InstructionStepper.getInterpreter().setReifiedContinuation(null);
                            $this$invoke_u24lambda_u240.setReifying(false);
                            $this$invoke_u24lambda_u240.returnNow = false;
                            $this$invoke_u24lambda_u240.setExitNow(true);
                            $this$invoke_u24lambda_u240.offset = Integer.MAX_VALUE;
                            $this$invoke_u24lambda_u240.setLatestResult(null);
                            $this$invoke_u24lambda_u240.levelOneStepper.wipeRegisters();
                            f.lock((Function0)new Function0<Unit>(f, $this$invoke_u24lambda_u240){
                                final /* synthetic */ A_Fiber $f;
                                final /* synthetic */ Interpreter $this_apply;
                                {
                                    this.$f = $f;
                                    this.$this_apply = $receiver;
                                    super(0);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public final void invoke() {
                                    A_Fiber a_Fiber = this.$f;
                                    A_Fiber a_Fiber2 = this.$f;
                                    Interpreter interpreter = this.$this_apply;
                                    A_Fiber a_Fiber3 = a_Fiber;
                                    synchronized (a_Fiber3) {
                                        boolean bl;
                                        boolean bl2 = false;
                                        boolean bl3 = bl = A_Fiber.Companion.getExecutionState(a_Fiber2) == FiberDescriptor.ExecutionState.RUNNING;
                                        if (_Assertions.ENABLED && !bl) {
                                            String string2 = "Assertion failed";
                                            throw new AssertionError((Object)string2);
                                        }
                                        A_Fiber.Companion.setExecutionState(a_Fiber2, FiberDescriptor.ExecutionState.PAUSED);
                                        boolean bound = A_Fiber.Companion.getAndSetSynchronizationFlag(a_Fiber2, FiberDescriptor.SynchronizationFlag.BOUND, false);
                                        A_Fiber.Companion.getFiberHelper(a_Fiber2).stopCountingCPU();
                                        if (_Assertions.ENABLED && !bound) {
                                            String string3 = "Assertion failed";
                                            throw new AssertionError((Object)string3);
                                        }
                                        interpreter.fiber(null, "debug pause");
                                        Unit unit = Unit.INSTANCE;
                                    }
                                }
                            });
                            $this$invoke_u24lambda_u240.postExitContinuation(new Function0<Unit>(availDebuggerModel, f){
                                final /* synthetic */ AvailDebuggerModel $debugger;
                                final /* synthetic */ A_Fiber $f;
                                {
                                    this.$debugger = $debugger;
                                    this.$f = $f;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$debugger.justPaused(this.$f);
                                }
                            });
                        }
                    });
                }
            }
            if (this.instructionDecoder.atEnd()) {
                boolean mutableContinuation2;
                this.interpreter.setLatestResult(this.pop());
                boolean bl = mutableContinuation2 = this.stackp == this.pointers.length;
                if (_Assertions.ENABLED && !mutableContinuation2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                this.interpreter.returnNow = true;
                this.interpreter.returningFunction = function;
                if (Interpreter.Companion.getDebugL1()) {
                    Logger logger = Interpreter.Companion.getLoggerDebugL1();
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue(level, "FINER");
                    Object[] mutableContinuation2 = new Object[]{this.interpreter.getDebugModeString()};
                    Interpreter.Companion.log(logger, level, "{0}L1 return", mutableContinuation2);
                }
                return null;
            }
            int operationOrdinal = this.instructionDecoder.getOperationOrdinal();
            if (Interpreter.Companion.getDebugL1()) {
                int savePc = this.pc();
                L1Operation operation = L1Operation.Companion.lookup(operationOrdinal);
                $this$map$iv = operation.getOperandTypes();
                $i$f$map2 = false;
                L1OperandType[] l1OperandTypeArray = $this$map$iv;
                destination$iv$iv = new ArrayList(((L1OperandType[])$this$map$iv).length);
                $i$f$mapTo = false;
                int n2 = ((void)$this$mapTo$iv$iv2).length;
                for (int j = 0; j < n2; ++j) {
                    void item$iv$iv;
                    void var16_64 = item$iv$iv = $this$mapTo$iv$iv2[j];
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(this.instructionDecoder.getOperand());
                }
                List operands = (List)destination$iv$iv;
                Logger logger = Interpreter.Companion.getLoggerDebugL1();
                Level level = Level.FINER;
                Intrinsics.checkNotNullExpressionValue(level, "FINER");
                $this$map$iv = new Object[]{this.interpreter.getDebugModeString(), operands.isEmpty() ? operation : operation + " " + operands};
                Interpreter.Companion.log(logger, level, "{0}L1 step: {1}", (Object[])$this$map$iv);
                this.instructionDecoder.pc(savePc);
            }
            if ((n = operationOrdinal) == L1Operation.L1_doCall.ordinal()) {
                boolean reifier22;
                StackReifier returnCheckReifier;
                bundle = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                expectedReturnType = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                int numArgs = A_Method.Companion.getNumArgs(A_Bundle.Companion.getBundleMethod(bundle));
                if (Interpreter.Companion.getDebugL1()) {
                    Logger logger = Interpreter.Companion.getLoggerDebugL1();
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue(level, "FINER");
                    Object[] $i$f$map2 = new Object[]{this.interpreter.getDebugModeString(), A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(bundle))};
                    Interpreter.Companion.log(logger, level, "{0}         L1 call ({1})", $i$f$map2);
                }
                this.interpreter.argsBuffer.clear();
                i2 = this.stackp + numArgs - 1;
                int $this$mapTo$iv$iv2 = this.stackp;
                if ($this$mapTo$iv$iv2 <= i2) {
                    while (true) {
                        this.interpreter.argsBuffer.add(this.pointerAt(i2));
                        this.pointerAtPut(i2, NilDescriptor.Companion.getNil());
                        if (i2 == $this$mapTo$iv$iv2) break;
                        --i2;
                    }
                }
                this.stackp += numArgs;
                this.push(expectedReturnType);
                A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
                try {
                    destination$iv$iv = A_Method.Companion.lookupByValuesFromList(method, this.interpreter.argsBuffer);
                }
                catch (MethodDefinitionException e) {
                    return this.reifyAndReportFailedLookup(method, e.getErrorCode());
                }
                Object matching = destination$iv$iv;
                destination$iv$iv = this.callMethodAfterLookup((A_Definition)matching);
                if (destination$iv$iv != null) {
                    Object reifier22 = destination$iv$iv;
                    boolean bl2 = false;
                    return reifier22;
                }
                result22 = this.interpreter.getLatestResult();
                if (Interpreter.Companion.getDebugL1()) {
                    Logger logger = Interpreter.Companion.getLoggerDebugL1();
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue(level, "FINER");
                    Object[] e = new Object[]{this.interpreter.getDebugModeString(), result22.getTypeTag().name()};
                    Interpreter.Companion.log(logger, level, "{0}Call returned: {1}", e);
                }
                if ((returnCheckReifier = this.checkReturnType$avail(result22, expectedReturnType, function)) != null) {
                    return returnCheckReifier;
                }
                boolean bl = reifier22 = this.stackp <= A_RawFunction.Companion.getNumSlots(code);
                if (_Assertions.ENABLED && !reifier22) {
                    String bl2 = "Assertion failed";
                    throw new AssertionError((Object)bl2);
                }
                this.pointerAtPut(this.stackp, result22);
                continue;
            }
            if (n == L1Operation.L1_doPushLiteral.ordinal()) {
                this.push(A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand()));
                continue;
            }
            if (n == L1Operation.L1_doPushLastLocal.ordinal()) {
                int localIndex = this.instructionDecoder.getOperand();
                AvailObject local2 = this.pointerAt(localIndex);
                boolean numArgs = local2.getNotNil();
                if (_Assertions.ENABLED && !numArgs) {
                    String method = "Assertion failed";
                    throw new AssertionError((Object)method);
                }
                this.pointerAtPut(localIndex, NilDescriptor.Companion.getNil());
                this.push(local2);
                continue;
            }
            if (n == L1Operation.L1_doPushLocal.ordinal()) {
                AvailObject local = this.pointerAt(this.instructionDecoder.getOperand());
                boolean local2 = local.getNotNil();
                if (_Assertions.ENABLED && !local2) {
                    String numArgs = "Assertion failed";
                    throw new AssertionError((Object)numArgs);
                }
                this.push(local.makeImmutable());
                continue;
            }
            if (n == L1Operation.L1_doPushLastOuter.ordinal()) {
                int outerIndex = this.instructionDecoder.getOperand();
                A_BasicObject outer = function.outerVarAt(outerIndex);
                boolean numArgs = outer.getNotNil();
                if (_Assertions.ENABLED && !numArgs) {
                    String method = "Assertion failed";
                    throw new AssertionError((Object)method);
                }
                if (A_Function.Companion.optionallyNilOuterVar(function, outerIndex)) {
                    this.push(outer);
                    continue;
                }
                this.push(outer.makeImmutable());
                continue;
            }
            if (n == L1Operation.L1_doClose.ordinal()) {
                int numCopiedVars = this.instructionDecoder.getOperand();
                AvailObject codeToClose = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                newFunction = FunctionDescriptor.Companion.createExceptOuters(codeToClose, numCopiedVars);
                for (i2 = numCopiedVars; i2 >= 1; --i2) {
                    AvailObject value = this.pop();
                    boolean result22 = value.getNotNil();
                    if (_Assertions.ENABLED && !result22) {
                        String returnCheckReifier = "Assertion failed";
                        throw new AssertionError((Object)returnCheckReifier);
                    }
                    newFunction.outerVarAtPut(i2, value);
                }
                this.push((A_BasicObject)newFunction);
                continue;
            }
            if (n == L1Operation.L1_doSetLocal.ordinal()) {
                StackReifier stackReifier = reifier = this.setVariable(this.pointerAt(this.instructionDecoder.getOperand()), this.pop());
                if (stackReifier == null) continue;
                return stackReifier;
            }
            if (n == L1Operation.L1_doGetLocalClearing.ordinal()) {
                A_Variable localVariable = this.pointerAt(this.instructionDecoder.getOperand());
                valueOrReifier22 = this.getVariableClearingIfMutable(localVariable);
                if (valueOrReifier22 instanceof StackReifier) {
                    return (StackReifier)valueOrReifier22;
                }
                Intrinsics.checkNotNull(valueOrReifier22, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                this.push((AvailObject)valueOrReifier22);
                continue;
            }
            if (n == L1Operation.L1_doPushOuter.ordinal()) {
                AvailObject outer = function.outerVarAt(this.instructionDecoder.getOperand());
                boolean valueOrReifier22 = outer.getNotNil();
                if (_Assertions.ENABLED && !valueOrReifier22) {
                    newFunction = "Assertion failed";
                    throw new AssertionError(newFunction);
                }
                this.push(outer.makeImmutable());
                continue;
            }
            if (n == L1Operation.L1_doPop.ordinal()) {
                this.pop();
                continue;
            }
            if (n == L1Operation.L1_doGetOuterClearing.ordinal()) {
                A_Variable outerVariable = function.outerVarAt(this.instructionDecoder.getOperand());
                valueOrReifier22 = this.getVariableClearingIfMutable(outerVariable);
                if (valueOrReifier22 instanceof StackReifier) {
                    return (StackReifier)valueOrReifier22;
                }
                Intrinsics.checkNotNull(valueOrReifier22, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                AvailObject value = (AvailObject)valueOrReifier22;
                this.push(value.makeImmutable());
                continue;
            }
            if (n == L1Operation.L1_doSetOuter.ordinal()) {
                StackReifier stackReifier = reifier = this.setVariable(function.outerVarAt(this.instructionDecoder.getOperand()), this.pop());
                if (stackReifier == null) continue;
                return stackReifier;
            }
            if (n == L1Operation.L1_doGetLocal.ordinal()) {
                valueOrReifier = this.getVariable(this.pointerAt(this.instructionDecoder.getOperand()));
                if (valueOrReifier instanceof StackReifier) {
                    return (StackReifier)valueOrReifier;
                }
                Intrinsics.checkNotNull(valueOrReifier, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                this.push((AvailObject)valueOrReifier);
                continue;
            }
            if (n == L1Operation.L1_doMakeTuple.ordinal()) {
                int size = this.instructionDecoder.getOperand();
                switch (size) {
                    case 0: {
                        this.push(TupleDescriptor.Companion.getEmptyTuple());
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case 1: {
                        this.push(ObjectTupleDescriptor.Companion.tuple(this.pop()));
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    default: {
                        void this_$iv;
                        valueOrReifier22 = ObjectTupleDescriptor.Companion;
                        object = this;
                        boolean $i$f$generateReversedFrom = false;
                        AbstractDescriptor this_$iv$iv = this_$iv.getMutable();
                        boolean $i$f$create = false;
                        AvailObject $this$generateReversedFrom_u24lambda_u240$iv = result22 = AvailObject.Companion.newIndexedDescriptor(size, this_$iv$iv);
                        boolean bl4 = false;
                        int i$iv = size;
                        while (0 < i$iv) {
                            int item$iv$iv = i$iv;
                            int n3 = i$iv--;
                            ObjectSlotsEnum objectSlotsEnum = ObjectTupleDescriptor.ObjectSlots.TUPLE_AT_;
                            AvailObject availObject = $this$generateReversedFrom_u24lambda_u240$iv;
                            boolean bl3 = false;
                            A_BasicObject a_BasicObject = this.pop();
                            availObject.setSlot(objectSlotsEnum, n3, a_BasicObject);
                        }
                        super.push(result22);
                        Unit unit = Unit.INSTANCE;
                    }
                }
                continue;
            }
            if (n == L1Operation.L1_doGetOuter.ordinal()) {
                valueOrReifier = this.getVariable(function.outerVarAt(this.instructionDecoder.getOperand()));
                if (valueOrReifier instanceof StackReifier) {
                    return (StackReifier)valueOrReifier;
                }
                Intrinsics.checkNotNull(valueOrReifier, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                this.push((AvailObject)valueOrReifier);
                continue;
            }
            if (n == L1Operation.L1_doExtension.ordinal()) {
                if (!_Assertions.ENABLED) continue;
                boolean $i$a$-assert-L1InstructionStepper$run$52 = false;
                String $i$a$-assert-L1InstructionStepper$run$52 = "Illegal dispatch nybblecode";
                throw new AssertionError((Object)$i$a$-assert-L1InstructionStepper$run$52);
            }
            if (n == L1Operation.L1Ext_doPushLabel.ordinal()) {
                A_Function savedFunction;
                boolean $i$a$-assert-L1InstructionStepper$run$52;
                int numArgs = A_RawFunction.Companion.numArgs(code);
                boolean bl = $i$a$-assert-L1InstructionStepper$run$52 = code.codePrimitive() == null;
                if (_Assertions.ENABLED && !$i$a$-assert-L1InstructionStepper$run$52) {
                    String $i$f$generateReversedFrom = "Assertion failed";
                    throw new AssertionError((Object)$i$f$generateReversedFrom);
                }
                $this$map$iv = new IntRange(1, numArgs);
                $i$f$map2 = false;
                Object $i$f$create = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                Iterator bl4 = $this$mapTo$iv$iv2.iterator();
                while (bl4.hasNext()) {
                    int item$iv$iv;
                    int it = item$iv$iv = ((IntIterator)bl4).nextInt();
                    object = destination$iv$iv;
                    boolean bl5 = false;
                    AvailObject arg = this.pointerAt(it);
                    boolean bl6 = arg.getNotNil();
                    if (_Assertions.ENABLED && !bl6) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    object.add(arg);
                }
                List args2 = (List)destination$iv$iv;
                Intrinsics.checkNotNull(this.interpreter.function);
                AvailObject[] savedPointers = this.pointers;
                int savedPc = this.pc();
                int savedStackp = this.stackp;
                if (this.interpreter.callerIsReified()) {
                    AvailObject availObject = this.interpreter.getReifiedContinuation();
                    Intrinsics.checkNotNull(availObject);
                    A_Continuation newContinuation = ContinuationDescriptor.Companion.createLabelContinuation(savedFunction, availObject, L2JVMChunk.Companion.getUnoptimizedChunk(), L2JVMChunk.ChunkEntryPoint.TO_RESTART.getOffsetInDefaultChunk(), args2);
                    newContinuation.makeSubobjectsImmutable();
                    this.push(newContinuation);
                    continue;
                }
                this.interpreter.setReifying(true);
                return new StackReifier(true, reificationBeforeLabelCreationStat, new Function0<Unit>(this, savedFunction, savedPointers, savedPc, savedStackp, (List<AvailObject>)args2){
                    final /* synthetic */ L1InstructionStepper this$0;
                    final /* synthetic */ A_Function $savedFunction;
                    final /* synthetic */ AvailObject[] $savedPointers;
                    final /* synthetic */ int $savedPc;
                    final /* synthetic */ int $savedStackp;
                    final /* synthetic */ List<AvailObject> $args;
                    {
                        this.this$0 = $receiver;
                        this.$savedFunction = $savedFunction;
                        this.$savedPointers = $savedPointers;
                        this.$savedPc = $savedPc;
                        this.$savedStackp = $savedStackp;
                        this.$args = $args;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getInterpreter().function = this.$savedFunction;
                        this.this$0.getInterpreter().chunk = L2JVMChunk.Companion.getUnoptimizedChunk();
                        this.this$0.getInterpreter().setOffset(L2JVMChunk.ChunkEntryPoint.AFTER_REIFICATION.getOffsetInDefaultChunk());
                        this.this$0.setPointers(this.$savedPointers);
                        this.$savedFunction.code().setUpInstructionDecoder(this.this$0.getInstructionDecoder());
                        this.this$0.getInstructionDecoder().pc(this.$savedPc);
                        this.this$0.setStackp(this.$savedStackp);
                        AvailObject availObject = this.this$0.getInterpreter().getReifiedContinuation();
                        Intrinsics.checkNotNull(availObject);
                        A_Continuation newContinuation = ContinuationDescriptor.Companion.createLabelContinuation(this.$savedFunction, availObject, L2JVMChunk.Companion.getUnoptimizedChunk(), L2JVMChunk.ChunkEntryPoint.TO_RESTART.getOffsetInDefaultChunk(), this.$args);
                        newContinuation.makeSubobjectsImmutable();
                        L1InstructionStepper.access$push(this.this$0, newContinuation);
                        this.this$0.getInterpreter().returnNow = false;
                        this.this$0.getInterpreter().setReifying(false);
                    }
                });
            }
            if (n == L1Operation.L1Ext_doGetLiteral.ordinal()) {
                valueOrReifier = this.getVariable(A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand()));
                if (valueOrReifier instanceof StackReifier) {
                    return (StackReifier)valueOrReifier;
                }
                Intrinsics.checkNotNull(valueOrReifier, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                this.push((AvailObject)valueOrReifier);
                continue;
            }
            if (n == L1Operation.L1Ext_doSetLiteral.ordinal()) {
                this.setVariable(A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand()), this.pop());
                continue;
            }
            if (n == L1Operation.L1Ext_doDuplicate.ordinal()) {
                this.push(this.pointerAt(this.stackp).makeImmutable());
                continue;
            }
            if (n == L1Operation.L1Ext_doPermute.ordinal()) {
                A_Tuple permutation = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                int size = A_Tuple.Companion.getTupleSize(permutation);
                AvailObject[] values2 = new AvailObject[size];
                i2 = 1;
                if (i2 <= size) {
                    while (true) {
                        values2[A_Tuple.Companion.tupleIntAt((A_Tuple)permutation, (int)i2) - 1] = this.pointerAt(this.stackp + size - i2);
                        if (i2 == size) break;
                        ++i2;
                    }
                }
                if ((i2 = 1) > size) continue;
                while (true) {
                    AvailObject availObject = values2[i2 - 1];
                    Intrinsics.checkNotNull(availObject);
                    this.pointerAtPut(this.stackp + size - i2, availObject);
                    if (i2 == size) continue block8;
                    ++i2;
                }
            }
            if (n == L1Operation.L1Ext_doSuperCall.ordinal()) {
                boolean bl;
                StackReifier returnCheckReifier;
                Object item$iv$iv;
                bundle = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                expectedReturnType = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                A_Type superUnionType = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                int numArgs = A_Method.Companion.getNumArgs(A_Bundle.Companion.getBundleMethod(bundle));
                if (Interpreter.Companion.getDebugL1()) {
                    Logger logger = Interpreter.Companion.getLoggerDebugL1();
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue(level, "FINER");
                    Object[] savedPc = new Object[]{this.interpreter.getDebugModeString(), A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(bundle))};
                    Interpreter.Companion.log(logger, level, "{0}L1 supercall: {1}", savedPc);
                }
                this.interpreter.argsBuffer.clear();
                Ref.IntRef reversedStackp = new Ref.IntRef();
                reversedStackp.element = this.stackp + numArgs;
                A_Tuple typesTuple2 = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(numArgs, (Function1<? super Integer, ? extends A_BasicObject>)new Function1<Integer, A_BasicObject>(this, reversedStackp, superUnionType){
                    final /* synthetic */ L1InstructionStepper this$0;
                    final /* synthetic */ Ref.IntRef $reversedStackp;
                    final /* synthetic */ A_Type $superUnionType;
                    {
                        this.this$0 = $receiver;
                        this.$reversedStackp = $reversedStackp;
                        this.$superUnionType = $superUnionType;
                        super(1);
                    }

                    @NotNull
                    public final A_BasicObject invoke(int index2) {
                        this.$reversedStackp.element += -1;
                        AvailObject arg = this.this$0.pointerAt(this.$reversedStackp.element);
                        this.this$0.getInterpreter().argsBuffer.add(arg);
                        return A_Type.Companion.typeUnion(AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(arg), A_Type.Companion.typeAtIndex(this.$superUnionType, index2));
                    }
                });
                this.stackp += numArgs;
                this.push(expectedReturnType);
                A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
                try {
                    item$iv$iv = A_Method.Companion.lookupByTypesFromTuple(method, typesTuple2);
                }
                catch (MethodDefinitionException e) {
                    return this.reifyAndReportFailedLookup(method, e.getErrorCode());
                }
                A_Definition matching = item$iv$iv;
                item$iv$iv = this.callMethodAfterLookup(matching);
                if (item$iv$iv != null) {
                    Object reifier3 = item$iv$iv;
                    boolean bl7 = false;
                    return reifier3;
                }
                AvailObject result3 = this.interpreter.getLatestResult();
                if (Interpreter.Companion.getDebugL1()) {
                    Logger logger = Interpreter.Companion.getLoggerDebugL1();
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue(level, "FINER");
                    Object[] e = new Object[]{this.interpreter.getDebugModeString(), result3.getTypeTag().name()};
                    Interpreter.Companion.log(logger, level, "{0}Call returned: {1}", e);
                }
                if ((returnCheckReifier = this.checkReturnType$avail(result3, expectedReturnType, function)) != null) {
                    return returnCheckReifier;
                }
                boolean bl8 = bl = this.stackp <= A_RawFunction.Companion.getNumSlots(code);
                if (_Assertions.ENABLED && !bl) {
                    String string4 = "Assertion failed";
                    throw new AssertionError((Object)string4);
                }
                this.pointerAtPut(this.stackp, result3);
                continue;
            }
            if (n != L1Operation.L1Ext_doSetLocalSlot.ordinal()) continue;
            this.pointerAtPut(this.instructionDecoder.getOperand(), this.pop());
        }
    }

    private final void reifyCurrentFrame(StackReifier reifier, L2JVMChunk.ChunkEntryPoint entryPoint, String logMessage) {
        A_Function a_Function = this.interpreter.function;
        Intrinsics.checkNotNull(a_Function);
        A_Function function = a_Function;
        Object[] objectArray = this.pointers;
        A_Continuation continuation = ContinuationDescriptor.Companion.createContinuationWithFrame(function, NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), this.pc(), this.stackp, L2JVMChunk.Companion.getUnoptimizedChunk(), entryPoint.getOffsetInDefaultChunk(), CollectionsKt.listOf(Arrays.copyOf(objectArray, objectArray.length)), 1);
        if (Interpreter.Companion.getDebugL2()) {
            Logger logger = Interpreter.Companion.getLoggerDebugL2();
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue(level, "FINER");
            objectArray = new Object[]{this.interpreter.getDebugModeString(), A_RawFunction.Companion.getMethodName(A_Continuation.Companion.function(continuation).code())};
            Interpreter.Companion.log(logger, level, logMessage, objectArray);
        }
        reifier.pushAction((Function1<? super Interpreter, Unit>)new Function1<Interpreter, Unit>(continuation){
            final /* synthetic */ A_Continuation $continuation;
            {
                this.$continuation = $continuation;
                super(1);
            }

            public final void invoke(@NotNull Interpreter theInterpreter) {
                Intrinsics.checkNotNullParameter(theInterpreter, "theInterpreter");
                AvailObject availObject = theInterpreter.getReifiedContinuation();
                Intrinsics.checkNotNull(availObject);
                theInterpreter.setReifiedContinuation(A_Continuation.Companion.replacingCaller(this.$continuation, availObject));
            }
        });
    }

    private final Object getVariable(A_Variable variable) {
        Object object;
        try {
            object = variable.getValue();
        }
        catch (VariableGetException e) {
            boolean bl = e.getNumericCode().equals(AvailErrorCode.E_CANNOT_READ_UNASSIGNED_VARIABLE.numericCode());
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_Function a_Function = this.interpreter.function;
            Intrinsics.checkNotNull(a_Function);
            A_Function savedFunction = a_Function;
            AvailObject[] savedPointers = this.pointers;
            int savedOffset = this.interpreter.offset;
            int savedPc = this.pc();
            int savedStackp = this.stackp;
            A_Function unassignedVariableFunction = this.interpreter.runtime.get(AvailRuntime.HookType.READ_UNASSIGNED_VARIABLE);
            this.interpreter.argsBuffer.clear();
            StackReifier stackReifier = this.interpreter.invokeFunction(unassignedVariableFunction);
            Intrinsics.checkNotNull(stackReifier);
            StackReifier reifier = stackReifier;
            this.pointers = savedPointers;
            this.interpreter.chunk = L2JVMChunk.Companion.getUnoptimizedChunk();
            this.interpreter.setOffset(savedOffset);
            this.interpreter.function = savedFunction;
            savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
            this.instructionDecoder.pc(savedPc);
            this.stackp = savedStackp;
            if (reifier.actuallyReify()) {
                this.reifyCurrentFrame(reifier, L2JVMChunk.ChunkEntryPoint.UNREACHABLE, "{0}Push reified continuation for L1 getVar failure: {1}");
            }
            object = reifier;
        }
        return object;
    }

    private final Object getVariableClearingIfMutable(A_Variable variable) {
        Object object;
        try {
            object = variable.traversed().descriptor().isMutable() ? variable.getValueClearing() : variable.getValue();
        }
        catch (VariableGetException e) {
            boolean bl = e.getNumericCode().equals(AvailErrorCode.E_CANNOT_READ_UNASSIGNED_VARIABLE.numericCode());
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_Function a_Function = this.interpreter.function;
            Intrinsics.checkNotNull(a_Function);
            A_Function savedFunction = a_Function;
            AvailObject[] savedPointers = this.pointers;
            int savedOffset = this.interpreter.offset;
            int savedPc = this.pc();
            int savedStackp = this.stackp;
            A_Function unassignedVariableFunction = this.interpreter.runtime.get(AvailRuntime.HookType.READ_UNASSIGNED_VARIABLE);
            this.interpreter.argsBuffer.clear();
            StackReifier stackReifier = this.interpreter.invokeFunction(unassignedVariableFunction);
            Intrinsics.checkNotNull(stackReifier);
            StackReifier reifier = stackReifier;
            this.pointers = savedPointers;
            this.interpreter.chunk = L2JVMChunk.Companion.getUnoptimizedChunk();
            this.interpreter.setOffset(savedOffset);
            this.interpreter.function = savedFunction;
            savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
            this.instructionDecoder.pc(savedPc);
            this.stackp = savedStackp;
            if (reifier.actuallyReify()) {
                this.reifyCurrentFrame(reifier, L2JVMChunk.ChunkEntryPoint.UNREACHABLE, "{0}Push reified continuation for L1 getVarClearing failure: {1}");
            }
            object = reifier;
        }
        return object;
    }

    private final StackReifier setVariable(A_Variable variable, AvailObject value) {
        block4: {
            try {
                variable.setValueNoCheck(value);
            }
            catch (VariableSetException e) {
                boolean bl = e.getNumericCode().equals(AvailErrorCode.E_OBSERVED_VARIABLE_WRITTEN_WHILE_UNTRACED.numericCode());
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Function a_Function = this.interpreter.function;
                Intrinsics.checkNotNull(a_Function);
                A_Function savedFunction = a_Function;
                AvailObject[] savedPointers = this.pointers;
                int savedOffset = this.interpreter.offset;
                int savedPc = this.pc();
                int savedStackp = this.stackp;
                A_Function implicitObserveFunction = this.interpreter.runtime.implicitObserveFunction();
                this.interpreter.argsBuffer.clear();
                List<AvailObject> list2 = this.interpreter.argsBuffer;
                A_Function a_Function2 = Interpreter.Companion.assignmentFunction();
                Intrinsics.checkNotNull(a_Function2, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                list2.add((AvailObject)a_Function2);
                List<AvailObject> list3 = this.interpreter.argsBuffer;
                A_Tuple a_Tuple = ObjectTupleDescriptor.Companion.tuple(variable, value);
                Intrinsics.checkNotNull(a_Tuple, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                list3.add((AvailObject)a_Tuple);
                StackReifier reifier = this.interpreter.invokeFunction(implicitObserveFunction);
                this.pointers = savedPointers;
                this.interpreter.chunk = L2JVMChunk.Companion.getUnoptimizedChunk();
                this.interpreter.setOffset(savedOffset);
                this.interpreter.function = savedFunction;
                savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
                this.instructionDecoder.pc(savedPc);
                this.stackp = savedStackp;
                if (reifier == null) break block4;
                if (reifier.actuallyReify()) {
                    this.reifyCurrentFrame(reifier, L2JVMChunk.ChunkEntryPoint.TO_RESUME, "{0}Push reified continuation for L1 setVar failure: {1}");
                }
                return reifier;
            }
        }
        return null;
    }

    private final StackReifier callMethodAfterLookup(A_Definition matching) {
        if (A_Sendable.Companion.isForwardDefinition(matching)) {
            return this.reifyAndReportFailedLookup(A_Definition.Companion.getDefinitionMethod(matching), AvailErrorCode.E_FORWARD_METHOD_DEFINITION);
        }
        if (A_Sendable.Companion.isAbstractDefinition(matching)) {
            return this.reifyAndReportFailedLookup(A_Definition.Companion.getDefinitionMethod(matching), AvailErrorCode.E_ABSTRACT_METHOD_DEFINITION);
        }
        A_Function a_Function = this.interpreter.function;
        Intrinsics.checkNotNull(a_Function);
        A_Function savedFunction = a_Function;
        boolean bl = Intrinsics.areEqual(this.interpreter.chunk, L2JVMChunk.Companion.getUnoptimizedChunk());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int savedOffset = this.interpreter.offset;
        AvailObject[] savedPointers = this.pointers;
        int savedPc = this.pc();
        int savedStackp = this.stackp;
        A_Function functionToInvoke = A_Sendable.Companion.bodyBlock(matching);
        StackReifier reifier = this.interpreter.invokeFunction(functionToInvoke);
        this.pointers = savedPointers;
        this.interpreter.chunk = L2JVMChunk.Companion.getUnoptimizedChunk();
        this.interpreter.setOffset(savedOffset);
        this.interpreter.function = savedFunction;
        savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
        this.instructionDecoder.pc(savedPc);
        this.stackp = savedStackp;
        if (reifier != null) {
            if (Interpreter.Companion.getDebugL2()) {
                Logger logger = Interpreter.Companion.getLoggerDebugL2();
                Level level = Level.FINER;
                Intrinsics.checkNotNullExpressionValue(level, "FINER");
                Object[] objectArray = new Object[]{this.interpreter.getDebugModeString(), reifier.actuallyReify()};
                Interpreter.Companion.log(logger, level, "{0}Reifying call from L1 ({1})", objectArray);
            }
            if (reifier.actuallyReify()) {
                this.reifyCurrentFrame(reifier, L2JVMChunk.ChunkEntryPoint.TO_RETURN_INTO, "{0}Push reified continuation for L1 call: {1}");
            }
        }
        return reifier;
    }

    @Nullable
    public final StackReifier checkReturnType$avail(@NotNull AvailObject result2, @NotNull A_Type expectedReturnType, @NotNull A_Function returnee) {
        Intrinsics.checkNotNullParameter(result2, "result");
        Intrinsics.checkNotNullParameter(expectedReturnType, "expectedReturnType");
        Intrinsics.checkNotNullParameter(returnee, "returnee");
        long before = AvailRuntimeSupport.INSTANCE.captureNanos();
        boolean checkOk = result2.isInstanceOf(expectedReturnType);
        long after = AvailRuntimeSupport.INSTANCE.captureNanos();
        A_Function a_Function = this.interpreter.returningFunction;
        Intrinsics.checkNotNull(a_Function);
        A_Function returner = a_Function;
        Primitive calledPrimitive = returner.code().codePrimitive();
        if (calledPrimitive != null) {
            calledPrimitive.addNanosecondsCheckingResultType(after - before, this.interpreter.getInterpreterIndex());
        } else {
            A_RawFunction.Companion.getReturnerCheckStat(returner.code()).record(after - before, this.interpreter.getInterpreterIndex());
            A_RawFunction.Companion.getReturneeCheckStat(returnee.code()).record(after - before, this.interpreter.getInterpreterIndex());
        }
        if (!checkOk) {
            A_Function a_Function2 = this.interpreter.function;
            Intrinsics.checkNotNull(a_Function2);
            A_Function savedFunction = a_Function2;
            boolean bl = Intrinsics.areEqual(this.interpreter.chunk, L2JVMChunk.Companion.getUnoptimizedChunk());
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            int savedOffset = this.interpreter.offset;
            AvailObject[] savedPointers = this.pointers;
            int savedPc = this.pc();
            int savedStackp = this.stackp;
            AvailObject reportedResult = VariableDescriptor.Companion.newVariableWithContentType$default(VariableDescriptor.Companion, PrimitiveTypeDescriptor.Types.ANY.getO(), null, 2, null);
            reportedResult.setValueNoCheck(result2);
            List<AvailObject> argsBuffer = this.interpreter.argsBuffer;
            argsBuffer.clear();
            argsBuffer.add((AvailObject)returner);
            argsBuffer.add((AvailObject)expectedReturnType);
            argsBuffer.add(reportedResult);
            StackReifier stackReifier = this.interpreter.invokeFunction(this.interpreter.runtime.resultDisagreedWithExpectedTypeFunction());
            Intrinsics.checkNotNull(stackReifier);
            StackReifier reifier = stackReifier;
            this.pointers = savedPointers;
            this.interpreter.chunk = L2JVMChunk.Companion.getUnoptimizedChunk();
            this.interpreter.setOffset(savedOffset);
            this.interpreter.function = savedFunction;
            savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
            this.instructionDecoder.pc(savedPc);
            this.stackp = savedStackp;
            if (reifier.actuallyReify()) {
                this.reifyCurrentFrame(reifier, L2JVMChunk.ChunkEntryPoint.UNREACHABLE, "{0}Push reified continuation for L1 check return type failure: {1}");
            }
            return reifier;
        }
        return null;
    }

    private final StackReifier reifyAndReportFailedLookup(A_Method method, AvailErrorCode errorCode) {
        A_Tuple arguments2 = ObjectTupleDescriptor.Companion.tupleFromList(this.interpreter.argsBuffer);
        A_Function a_Function = this.interpreter.function;
        Intrinsics.checkNotNull(a_Function);
        A_Function savedFunction = a_Function;
        boolean bl = Intrinsics.areEqual(this.interpreter.chunk, L2JVMChunk.Companion.getUnoptimizedChunk());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int savedOffset = this.interpreter.offset;
        AvailObject[] savedPointers = this.pointers;
        int savedPc = this.pc();
        int savedStackp = this.stackp;
        List<AvailObject> $this$reifyAndReportFailedLookup_u24lambda_u246 = this.interpreter.argsBuffer;
        boolean bl2 = false;
        $this$reifyAndReportFailedLookup_u24lambda_u246.clear();
        A_BasicObject $this$cast$iv = errorCode.numericCode();
        boolean $i$f$cast = false;
        $this$reifyAndReportFailedLookup_u24lambda_u246.add((AvailObject)$this$cast$iv);
        $this$cast$iv = method;
        $i$f$cast = false;
        $this$reifyAndReportFailedLookup_u24lambda_u246.add((AvailObject)$this$cast$iv);
        $this$cast$iv = arguments2;
        $i$f$cast = false;
        $this$reifyAndReportFailedLookup_u24lambda_u246.add((AvailObject)$this$cast$iv);
        StackReifier stackReifier = this.interpreter.invokeFunction(this.interpreter.runtime.invalidMessageSendFunction());
        Intrinsics.checkNotNull(stackReifier);
        StackReifier reifier = stackReifier;
        this.pointers = savedPointers;
        this.interpreter.chunk = L2JVMChunk.Companion.getUnoptimizedChunk();
        this.interpreter.setOffset(savedOffset);
        this.interpreter.function = savedFunction;
        savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
        this.instructionDecoder.pc(savedPc);
        this.stackp = savedStackp;
        if (reifier.actuallyReify()) {
            this.reifyCurrentFrame(reifier, L2JVMChunk.ChunkEntryPoint.UNREACHABLE, "{0}Push reified continuation for failed lookup handler: {1}");
        }
        return reifier;
    }

    public static final /* synthetic */ void access$push(L1InstructionStepper $this, A_BasicObject value) {
        $this.push(value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lavail/interpreter/levelTwo/L1InstructionStepper$Companion;", "", "()V", "emptyPointersArray", "", "Lavail/descriptor/representation/AvailObject;", "[Lavail/descriptor/representation/AvailObject;", "reificationBeforeLabelCreationStat", "Lavail/performance/Statistic;", "runMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getRunMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "whitespaces", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckedMethod getRunMethod() {
            return runMethod;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

