/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.characters;

import avail.descriptor.character.CharacterDescriptor;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/primitive/characters/P_CharacterFromCodePoint;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_CharacterFromCodePoint
extends Primitive {
    @NotNull
    public static final P_CharacterFromCodePoint INSTANCE = new P_CharacterFromCodePoint();

    private P_CharacterFromCodePoint() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject codePoint = interpreter.argument(0);
        return interpreter.primitiveSuccess(CharacterDescriptor.Companion.fromCodePoint(A_Number.Companion.getExtractInt(codePoint)));
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type intType = argumentTypes.get(0);
        if (intType.equals(IntegerRangeTypeDescriptor.Companion.getCharacterCodePoints())) {
            return PrimitiveTypeDescriptor.Types.CHARACTER.getO();
        }
        A_Set chars = SetDescriptor.Companion.getEmptySet();
        if (intType.isEnumeration()) {
            for (AvailObject intValue : A_Type.Companion.getInstances(intType)) {
                chars = A_Set.Companion.setWithElementCanDestroy(chars, CharacterDescriptor.Companion.fromCodePoint(A_Number.Companion.getExtractInt(intValue)), true);
            }
        } else {
            int high;
            int low = A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(intType));
            int intValue = low;
            if (intValue <= (high = A_Number.Companion.getExtractInt(A_Type.Companion.getUpperBound(intType)))) {
                while (true) {
                    chars = A_Set.Companion.setWithElementCanDestroy(chars, CharacterDescriptor.Companion.fromCodePoint(intValue), true);
                    if (intValue == high) break;
                    ++intValue;
                }
            }
        }
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(chars);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(IntegerRangeTypeDescriptor.Companion.getCharacterCodePoints()), PrimitiveTypeDescriptor.Types.CHARACTER.getO(), null, 4, null);
    }
}

