/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.functions;

import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.CompiledCodeTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/functions/P_CreateFunction;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_CreateFunction
extends Primitive {
    @NotNull
    public static final P_CreateFunction INSTANCE = new P_CreateFunction();

    private P_CreateFunction() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject rawFunction2 = interpreter.argument(0);
        AvailObject outers2 = interpreter.argument(1);
        int numOuters = A_RawFunction.Companion.getNumOuters(rawFunction2);
        if (A_Tuple.Companion.getTupleSize(outers2) != numOuters) {
            return interpreter.primitiveFailure(AvailErrorCode.E_WRONG_OUTERS);
        }
        int i2 = 1;
        if (i2 <= numOuters) {
            while (true) {
                A_Type requiredType;
                AvailObject outer;
                if (!(outer = A_Tuple.Companion.tupleAt(outers2, i2)).isInstanceOf(requiredType = A_RawFunction.Companion.outerTypeAt(rawFunction2, i2))) {
                    return interpreter.primitiveFailure(AvailErrorCode.E_WRONG_OUTERS);
                }
                if (i2 == numOuters) break;
                ++i2;
            }
        }
        A_Function function = FunctionDescriptor.Companion.createFunction(rawFunction2, outers2);
        return interpreter.primitiveSuccess(function);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(CompiledCodeTypeDescriptor.Companion.mostGeneralCompiledCodeType(), TupleTypeDescriptor.Companion.getMostGeneralTupleType()), FunctionTypeDescriptor.Companion.mostGeneralFunctionType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_WRONG_OUTERS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

