/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.maps;

import avail.descriptor.maps.A_Map;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.MapTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.AvailException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J8\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u00a8\u0006\u0016"}, d2={"Lavail/interpreter/primitive/maps/P_MapReplaceRangeNAryKey;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "recursivelyUpdateMap", "Lavail/descriptor/maps/A_Map;", "targetMap", "pathTuple", "Lavail/descriptor/tuples/A_Tuple;", "sliceStartIndex", "", "sliceEndIndex", "pathIndex", "newValues", "recursivelyUpdateTuple", "targetTuple", "avail"})
public final class P_MapReplaceRangeNAryKey
extends Primitive {
    @NotNull
    public static final P_MapReplaceRangeNAryKey INSTANCE = new P_MapReplaceRangeNAryKey();

    private P_MapReplaceRangeNAryKey() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.CanFold};
        super(5, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(5);
        AvailObject targetMap = interpreter.argument(0);
        AvailObject pathTuple = interpreter.argument(1);
        AvailObject sliceStartIndex = interpreter.argument(2);
        AvailObject sliceEndIndex = interpreter.argument(3);
        AvailObject newValues = interpreter.argument(4);
        if (!A_Number.Companion.isInt(sliceStartIndex) || !A_Number.Companion.isInt(sliceEndIndex)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS);
        }
        int startInt = A_Number.Companion.getExtractInt(sliceStartIndex);
        int endInt = A_Number.Companion.getExtractInt(sliceEndIndex);
        if (startInt < 1 || endInt < 0 || startInt > endInt + 1) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NEGATIVE_SIZE);
        }
        try {
            result2 = interpreter.primitiveSuccess(this.recursivelyUpdateMap(targetMap, pathTuple, startInt, endInt, 1, newValues));
        }
        catch (AvailException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    private final A_Tuple recursivelyUpdateTuple(A_Tuple targetTuple, A_Tuple pathTuple, int sliceStartIndex, int sliceEndIndex, int pathIndex, A_Tuple newValues) throws AvailException {
        if (pathIndex == A_Tuple.Companion.getTupleSize(pathTuple) + 1) {
            if (sliceEndIndex > A_Tuple.Companion.getTupleSize(targetTuple)) {
                throw new AvailException(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS, null, 2, null);
            }
            A_Tuple leftPart = A_Tuple.Companion.copyTupleFromToCanDestroy(targetTuple, 1, sliceStartIndex - 1, false);
            A_Tuple rightPart = A_Tuple.Companion.copyTupleFromToCanDestroy(targetTuple, sliceEndIndex + 1, A_Tuple.Companion.getTupleSize(targetTuple), true);
            return A_Tuple.Companion.concatenateWith(A_Tuple.Companion.concatenateWith(leftPart, newValues, true), rightPart, true);
        }
        AvailObject targetIndexNumber = A_Tuple.Companion.tupleAt(pathTuple, pathIndex);
        if (!A_Number.Companion.isInt(targetIndexNumber)) {
            throw new AvailException(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS, null, 2, null);
        }
        int targetIndex = A_Number.Companion.getExtractInt(targetIndexNumber);
        if (targetIndex > A_Tuple.Companion.getTupleSize(targetTuple)) {
            throw new AvailException(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS, null, 2, null);
        }
        AvailObject subtuple = A_Tuple.Companion.tupleAt(targetTuple, targetIndex);
        if (subtuple.isTuple()) {
            A_Tuple newTuple2 = this.recursivelyUpdateTuple(subtuple, pathTuple, sliceStartIndex, sliceEndIndex, pathIndex + 1, newValues);
            return A_Tuple.Companion.tupleAtPuttingCanDestroy(targetTuple, targetIndex, newTuple2, true);
        }
        if (subtuple.isMap()) {
            A_Map newMap = this.recursivelyUpdateMap(subtuple, pathTuple, sliceStartIndex, sliceEndIndex, pathIndex + 1, newValues);
            return A_Tuple.Companion.tupleAtPuttingCanDestroy(targetTuple, targetIndex, newMap, true);
        }
        throw new AvailException(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, null, 2, null);
    }

    private final A_Map recursivelyUpdateMap(A_Map targetMap, A_Tuple pathTuple, int sliceStartIndex, int sliceEndIndex, int pathIndex, A_Tuple newValues) throws AvailException {
        if (pathIndex == A_Tuple.Companion.getTupleSize(pathTuple) + 1) {
            throw new AvailException(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, null, 2, null);
        }
        AvailObject targetIndex = A_Tuple.Companion.tupleAt(pathTuple, pathIndex);
        AvailObject availObject = A_Map.Companion.mapAtOrNull(targetMap, targetIndex);
        if (availObject == null) {
            throw new AvailException(AvailErrorCode.E_KEY_NOT_FOUND, null, 2, null);
        }
        AvailObject targetElement = availObject;
        if (targetElement.isTuple()) {
            A_Tuple newTuple2 = this.recursivelyUpdateTuple(targetElement, pathTuple, sliceStartIndex, sliceEndIndex, pathIndex + 1, newValues);
            return A_Map.Companion.mapAtPuttingCanDestroy(targetMap, targetIndex, newTuple2, true);
        }
        if (targetElement.isMap()) {
            A_Map newMap = this.recursivelyUpdateMap(targetElement, pathTuple, sliceStartIndex, sliceEndIndex, pathIndex + 1, newValues);
            return A_Map.Companion.mapAtPuttingCanDestroy(targetMap, targetIndex, newMap, true);
        }
        throw new AvailException(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, null, 2, null);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(MapTypeDescriptor.Companion.mostGeneralMapType(), TupleTypeDescriptor.Companion.oneOrMoreOf(PrimitiveTypeDescriptor.Types.ANY.getO()), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), TupleTypeDescriptor.Companion.zeroOrMoreOf(PrimitiveTypeDescriptor.Types.ANY.getO())), MapTypeDescriptor.Companion.mostGeneralMapType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS, AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, AvailErrorCode.E_KEY_NOT_FOUND, AvailErrorCode.E_NEGATIVE_SIZE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

