/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.numbers;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.AbstractNumberDescriptor;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.ArithmeticException;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_ADD_INT_TO_INT;
import avail.interpreter.levelTwo.operation.L2_BIT_LOGIC_OP;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import avail.optimizer.values.L2SemanticPrimitiveInvocation;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016JH\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u0017H\u0016\u00a8\u0006\u001a"}, d2={"Lavail/interpreter/primitive/numbers/P_Addition;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_Addition
extends Primitive {
    @NotNull
    public static final P_Addition INSTANCE = new P_Addition();

    private P_Addition() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject a = interpreter.argument(0);
        AvailObject b = interpreter.argument(1);
        try {
            result2 = interpreter.primitiveSuccess(A_Number.Companion.plusCanDestroy(a, b, true));
        }
        catch (ArithmeticException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.NUMBER.getO(), PrimitiveTypeDescriptor.Types.NUMBER.getO()), PrimitiveTypeDescriptor.Types.NUMBER.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_ADD_UNLIKE_INFINITIES};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        try {
            if (aType.isEnumeration() && bType.isEnumeration()) {
                A_Set aInstances = A_Type.Companion.getInstances(aType);
                A_Set bInstances = A_Type.Companion.getInstances(bType);
                if ((long)A_Set.Companion.getSetSize(aInstances) * (long)A_Set.Companion.getSetSize(bInstances) < 100L) {
                    A_Set answers = SetDescriptor.Companion.getEmptySet();
                    for (AvailObject aInstance : aInstances) {
                        for (AvailObject bInstance : bInstances) {
                            answers = A_Set.Companion.setWithElementCanDestroy(answers, A_Number.Companion.plusCanDestroy(aInstance, bInstance, false), false);
                        }
                    }
                    return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(answers);
                }
            }
            if (aType.isIntegerRangeType() && bType.isIntegerRangeType()) {
                A_Number low = A_Number.Companion.plusCanDestroy(A_Type.Companion.getLowerBound(aType), A_Type.Companion.getLowerBound(bType), false);
                A_Number high = A_Number.Companion.plusCanDestroy(A_Type.Companion.getUpperBound(aType), A_Type.Companion.getUpperBound(bType), false);
                boolean includesNegativeInfinity = InfinityDescriptor.Companion.getNegativeInfinity().isInstanceOf(aType) || InfinityDescriptor.Companion.getNegativeInfinity().isInstanceOf(bType);
                boolean includesInfinity = InfinityDescriptor.Companion.getPositiveInfinity().isInstanceOf(aType) || InfinityDescriptor.Companion.getPositiveInfinity().isInstanceOf(bType);
                return IntegerRangeTypeDescriptor.Companion.integerRangeType(A_Number.Companion.minusCanDestroy(low, IntegerDescriptor.Companion.getOne(), false), includesNegativeInfinity, A_Number.Companion.plusCanDestroy(high, IntegerDescriptor.Companion.getOne(), false), includesInfinity);
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return AbstractNumberDescriptor.Companion.binaryNumericOperationTypeBound(aType, bType);
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        boolean aTypeIncludesNegativeInfinity = InfinityDescriptor.Companion.getNegativeInfinity().isInstanceOf(aType);
        boolean aTypeIncludesInfinity = InfinityDescriptor.Companion.getPositiveInfinity().isInstanceOf(aType);
        boolean bTypeIncludesNegativeInfinity = InfinityDescriptor.Companion.getNegativeInfinity().isInstanceOf(bType);
        boolean bTypeIncludesInfinity = InfinityDescriptor.Companion.getPositiveInfinity().isInstanceOf(bType);
        return aTypeIncludesInfinity && bTypeIncludesNegativeInfinity || aTypeIncludesNegativeInfinity && bTypeIncludesInfinity ? Primitive.Fallibility.CallSiteCanFail : Primitive.Fallibility.CallSiteCannotFail;
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        L2ReadBoxedOperand a = arguments2.get(0);
        L2ReadBoxedOperand b = arguments2.get(1);
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        A_Type aIntersectInt32 = A_Type.Companion.typeIntersection(aType, IntegerRangeTypeDescriptor.Companion.getI32());
        A_Type bIntersectInt32 = A_Type.Companion.typeIntersection(bType, IntegerRangeTypeDescriptor.Companion.getI32());
        if (A_Type.Companion.typeIntersection(aType, IntegerRangeTypeDescriptor.Companion.getI32()).isBottom() || A_Type.Companion.typeIntersection(bType, IntegerRangeTypeDescriptor.Companion.getI32()).isBottom()) {
            return false;
        }
        long lowest = A_Number.Companion.getExtractLong(A_Type.Companion.getLowerBound(aIntersectInt32)) + A_Number.Companion.getExtractLong(A_Type.Companion.getLowerBound(bIntersectInt32));
        long highest = A_Number.Companion.getExtractLong(A_Type.Companion.getLowerBound(aIntersectInt32)) + A_Number.Companion.getExtractLong(A_Type.Companion.getLowerBound(bIntersectInt32));
        if (lowest > Integer.MAX_VALUE || highest < Integer.MIN_VALUE) {
            return false;
        }
        L2Generator generator = translator.getGenerator();
        L2BasicBlock fallback = generator.createBasicBlock("fall back to boxed addition");
        L2ReadIntOperand intA = generator.readInt(new L2SemanticUnboxedInt(a.semanticValue()), fallback);
        L2ReadIntOperand intB = generator.readInt(new L2SemanticUnboxedInt(b.semanticValue()), fallback);
        if (generator.currentlyReachable()) {
            A_Type[] a_TypeArray = new A_Type[]{aIntersectInt32, bIntersectInt32};
            A_Type returnTypeIfInts = this.returnTypeGuaranteedByVM(rawFunction2, CollectionsKt.listOf(a_TypeArray));
            L2SemanticValue[] l2SemanticValueArray = new L2SemanticValue[]{a.semanticValue(), b.semanticValue()};
            L2SemanticPrimitiveInvocation semanticTemp = L2SemanticValue.Companion.primitiveInvocation(this, CollectionsKt.listOf(l2SemanticValueArray));
            L2WriteIntOperand tempWriter = generator.intWrite(SetsKt.setOf(new L2SemanticUnboxedInt(semanticTemp)), TypeRestriction.Companion.restrictionForType(returnTypeIfInts, TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG));
            if (A_Type.Companion.isSubtypeOf(returnTypeIfInts, IntegerRangeTypeDescriptor.Companion.getI32())) {
                L2Operand[] l2OperandArray = new L2Operand[]{intA, intB, tempWriter};
                translator.addInstruction(L2_BIT_LOGIC_OP.Companion.getWrappedAdd(), l2OperandArray);
            } else {
                L2BasicBlock success2 = generator.createBasicBlock("sum is in range");
                L2Operand[] l2OperandArray = new L2Operand[]{intA, intB, tempWriter, L2Generator.Companion.edgeTo(fallback), L2Generator.Companion.edgeTo(success2)};
                translator.addInstruction(L2_ADD_INT_TO_INT.INSTANCE, l2OperandArray);
                L2Generator.startBlock$default(generator, success2, false, null, 6, null);
            }
            callSiteHelper.useAnswer(generator.readBoxed(semanticTemp));
        }
        if (!((Collection)fallback.predecessorEdges()).isEmpty()) {
            L2Generator.startBlock$default(generator, fallback, false, null, 6, null);
            translator.generateGeneralFunctionInvocation(functionToCallReg, arguments2, false, callSiteHelper);
        }
        return true;
    }
}

