/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.style;

import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.methods.A_Styler;
import avail.descriptor.methods.StylerDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/style/P_BootstrapDefineSpecialObjectMacroStyler;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_BootstrapDefineSpecialObjectMacroStyler
extends Primitive {
    @NotNull
    public static final P_BootstrapDefineSpecialObjectMacroStyler INSTANCE = new P_BootstrapDefineSpecialObjectMacroStyler();

    private P_BootstrapDefineSpecialObjectMacroStyler() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.Bootstrap, Primitive.Flag.ReadsFromHiddenGlobalState, Primitive.Flag.WritesToHiddenGlobalState};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        A_Tuple optionalSendPhrase = interpreter.argument(0);
        A_Fiber fiber2 = interpreter.fiber();
        if (!A_Fiber.Companion.getCanStyle(fiber2)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_STYLE);
        }
        AvailLoader availLoader = A_Fiber.Companion.getAvailLoader(fiber2);
        Intrinsics.checkNotNull(availLoader);
        AvailLoader loader = availLoader;
        if (A_Tuple.Companion.getTupleSize(optionalSendPhrase) == 0) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        AvailObject sendPhrase = A_Tuple.Companion.tupleAt(optionalSendPhrase, 1);
        AvailLoader.styleTokens$default(loader, (Iterable)A_Phrase.Companion.getTokens(sendPhrase), StylerDescriptor.SystemStyle.SPECIAL_OBJECT, false, null, 12, null);
        A_Phrase namePhrase = A_Phrase.Companion.expressionAt(A_Phrase.Companion.getArgumentsListNode(sendPhrase), 1);
        A_Phrase nameLiteralSend = A_Phrase.Companion.isMacroSubstitutionNode(namePhrase) ? A_Phrase.Companion.getMacroOriginalSendNode(namePhrase) : namePhrase;
        A_Phrase nameLiteralSendArgs = A_Phrase.Companion.getArgumentsListNode(nameLiteralSend);
        if (A_Phrase.Companion.getExpressionsSize(nameLiteralSendArgs) == 1) {
            A_Phrase nameLiteralArg = A_Phrase.Companion.expressionAt(nameLiteralSendArgs, 1);
            if (A_Phrase.Companion.isMacroSubstitutionNode(nameLiteralArg)) {
                nameLiteralArg = A_Phrase.Companion.getMacroOriginalSendNode(nameLiteralArg);
            }
            if (A_Phrase.Companion.phraseKindIsUnder(nameLiteralArg, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
                loader.styleMethodName(A_Phrase.Companion.getToken(nameLiteralArg));
            }
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_STYLE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return A_Styler.Companion.getStylerFunctionType();
    }
}

