/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.style;

import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.functions.A_Function;
import avail.descriptor.methods.A_Styler;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.AvailException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.style.P_BootstrapDefinitionStyler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lavail/interpreter/primitive/style/P_SetStylerFunction;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapDefinitionStyler;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_SetStylerFunction
extends Primitive {
    @NotNull
    public static final P_SetStylerFunction INSTANCE = new P_SetStylerFunction();

    private P_SetStylerFunction() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanSuspend, Primitive.Flag.Unknown};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        A_Bundle a_Bundle;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        A_Atom atom = interpreter.argument(0);
        A_Function function = interpreter.argument(1);
        AvailLoader availLoader = A_Fiber.Companion.getAvailLoader(interpreter.fiber());
        if (availLoader == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        AvailLoader loader = availLoader;
        if (!loader.getPhase().isExecuting()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION);
        }
        try {
            a_Bundle = A_Atom.Companion.bundleOrCreate(atom);
        }
        catch (AvailException e) {
            return interpreter.primitiveFailure(e);
        }
        A_Bundle bundle = a_Bundle;
        return interpreter.suspendInSafePointThen((Function1<? super Interpreter.SuspensionHelper<A_BasicObject>, Unit>)new Function1<Interpreter.SuspensionHelper<A_BasicObject>, Unit>(loader, bundle, function){
            final /* synthetic */ AvailLoader $loader;
            final /* synthetic */ A_Bundle $bundle;
            final /* synthetic */ A_Function $function;
            {
                this.$loader = $loader;
                this.$bundle = $bundle;
                this.$function = $function;
                super(1);
            }

            public final void invoke(@NotNull Interpreter.SuspensionHelper<A_BasicObject> $this$suspendInSafePointThen) {
                Intrinsics.checkNotNullParameter($this$suspendInSafePointThen, "$this$suspendInSafePointThen");
                try {
                    this.$loader.addStyler(this.$bundle, this.$function);
                    $this$suspendInSafePointThen.succeed(NilDescriptor.Companion.getNil());
                }
                catch (AvailException e) {
                    boolean bl;
                    boolean bl2 = bl = e.getErrorCode() == AvailErrorCode.E_STYLER_ALREADY_SET_BY_THIS_MODULE;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    $this$suspendInSafePointThen.fail(e.getErrorCode());
                }
            }
        });
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), A_Styler.Companion.getStylerFunctionType()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER, AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION, AvailErrorCode.E_STYLER_ALREADY_SET_BY_THIS_MODULE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Set.Companion.setUnionCanDestroy(SetDescriptor.Companion.set(availErrorCodeArray), MessageSplitter.Companion.getPossibleErrors(), true));
    }

    @Override
    @NotNull
    public P_BootstrapDefinitionStyler bootstrapStyler() {
        return P_BootstrapDefinitionStyler.INSTANCE;
    }
}

