/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.tuples;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_COMPARE_INT;
import avail.interpreter.levelTwo.operation.L2_MOVE;
import avail.interpreter.levelTwo.operation.L2_TUPLE_AT_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_TUPLE_AT_NO_FAIL;
import avail.interpreter.levelTwo.operation.L2_TUPLE_SIZE;
import avail.interpreter.primitive.tuples.P_TupleSize;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import avail.optimizer.values.L2SemanticPrimitiveInvocation;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016JH\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u0017H\u0016\u00a8\u0006\u001a"}, d2={"Lavail/interpreter/primitive/tuples/P_TupleAt;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
@SourceDebugExtension(value={"SMAP\nP_TupleAt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_TupleAt.kt\navail/interpreter/primitive/tuples/P_TupleAt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1549#2:286\n1620#2,3:287\n*S KotlinDebug\n*F\n+ 1 P_TupleAt.kt\navail/interpreter/primitive/tuples/P_TupleAt\n*L\n223#1:286\n223#1:287,3\n*E\n"})
public final class P_TupleAt
extends Primitive {
    @NotNull
    public static final P_TupleAt INSTANCE = new P_TupleAt();

    private P_TupleAt() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject tuple2 = interpreter.argument(0);
        AvailObject indexObject = interpreter.argument(1);
        if (!A_Number.Companion.isInt(indexObject)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS);
        }
        int index2 = A_Number.Companion.getExtractInt(indexObject);
        return index2 > A_Tuple.Companion.getTupleSize(tuple2) ? interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS) : interpreter.primitiveSuccess(A_Tuple.Companion.tupleAt(tuple2, index2));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getMostGeneralTupleType(), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers()), PrimitiveTypeDescriptor.Types.ANY.getO(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type tupleType = argumentTypes.get(0);
        A_Type subscripts = argumentTypes.get(1);
        A_Number lower = A_Type.Companion.getLowerBound(subscripts);
        A_Number upper = A_Type.Companion.getUpperBound(subscripts);
        int lowerInt = A_Number.Companion.isInt(lower) ? A_Number.Companion.getExtractInt(lower) : 1;
        int upperInt = A_Number.Companion.isInt(upper) ? A_Number.Companion.getExtractInt(upper) : Integer.MAX_VALUE;
        A_Type unionType = A_Type.Companion.unionOfTypesAtThrough(tupleType, lowerInt, upperInt);
        unionType.makeImmutable();
        return unionType;
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type tupleType = argumentTypes.get(0);
        A_Type subscripts = argumentTypes.get(1);
        A_Type tupleTypeSizes = A_Type.Companion.getSizeRange(tupleType);
        A_Number minTupleSize = A_Type.Companion.getLowerBound(tupleTypeSizes);
        return A_Number.Companion.greaterOrEqual(A_Type.Companion.getLowerBound(subscripts), IntegerDescriptor.Companion.getOne()) && A_Number.Companion.lessOrEqual(A_Type.Companion.getUpperBound(subscripts), minTupleSize) ? Primitive.Fallibility.CallSiteCannotFail : super.fallibilityForArgumentTypes(argumentTypes);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        L2ReadBoxedOperand tupleReg = arguments2.get(0);
        L2ReadBoxedOperand subscriptReg = arguments2.get(1);
        L2Generator generator = translator.getGenerator();
        if (this.fallibilityForArgumentTypes(argumentTypes) != Primitive.Fallibility.CallSiteCannotFail) {
            L2BasicBlock failed = generator.createBasicBlock("failed bounds check");
            L2SemanticUnboxedInt unboxedSemanticSize = new L2SemanticUnboxedInt(L2SemanticValue.Companion.primitiveInvocation(P_TupleSize.INSTANCE, CollectionsKt.listOf(tupleReg.semanticValue())));
            TypeRestriction intSizeRestriction = TypeRestriction.Companion.restrictionForType(A_Type.Companion.typeIntersection(A_Type.Companion.getSizeRange(tupleReg.type()), IntegerRangeTypeDescriptor.Companion.getI31()), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG);
            A_Type intSizeType = intSizeRestriction.getType();
            if (A_Type.Companion.getLowerBound(intSizeType).equals(A_Type.Companion.getUpperBound(intSizeType))) {
                L2ReadIntOperand sizeRead = generator.unboxedIntConstant(A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(intSizeType)));
                generator.moveRegister(L2_MOVE.Companion.getUnboxedInt(), sizeRead.semanticValue(), unboxedSemanticSize);
            } else {
                L2WriteIntOperand sizeWriter = generator.intWrite(SetsKt.setOf(unboxedSemanticSize), intSizeRestriction);
                L2Operand[] l2OperandArray = new L2Operand[]{tupleReg, sizeWriter};
                translator.addInstruction(L2_TUPLE_SIZE.INSTANCE, l2OperandArray);
            }
            L2ReadIntOperand readSubscript = generator.readInt(new L2SemanticUnboxedInt(subscriptReg.semanticValue()), failed);
            if (generator.currentlyReachable() && A_Number.Companion.lessThan(A_Type.Companion.getLowerBound(readSubscript.restriction().getType()), IntegerDescriptor.Companion.getOne())) {
                L2BasicBlock success1 = generator.createBasicBlock("passed lower bound check");
                L2_JUMP_IF_COMPARE_INT.Companion.getGreaterOrEqual().compareAndBranch(generator, readSubscript, generator.unboxedIntConstant(1), L2Generator.Companion.edgeTo(success1), L2Generator.Companion.edgeTo(failed));
                L2Generator.startBlock$default(generator, success1, false, null, 6, null);
            }
            if (generator.currentlyReachable() && A_Number.Companion.greaterThan(A_Type.Companion.getUpperBound(subscriptReg.type()), A_Type.Companion.getLowerBound(intSizeRestriction.getType()))) {
                L2BasicBlock success2 = generator.createBasicBlock("passed upper bound check");
                L2_JUMP_IF_COMPARE_INT.Companion.getLessOrEqual().compareAndBranch(generator, readSubscript, translator.getCurrentManifest().readInt(unboxedSemanticSize), L2Generator.Companion.edgeTo(success2), L2Generator.Companion.edgeTo(failed));
                L2Generator.startBlock$default(generator, success2, false, null, 6, null);
            }
            if (generator.currentlyReachable()) {
                Collection<L2SemanticValue> collection2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                A_Type[] a_TypeArray = new A_Type[]{argumentTypes.get(0), intSizeRestriction.getType()};
                TypeRestriction resultRestriction = TypeRestriction.Companion.restrictionForType(this.returnTypeGuaranteedByVM(rawFunction2, CollectionsKt.listOf(a_TypeArray)), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG);
                Iterable iterable = arguments2;
                Primitive primitive2 = this;
                L2SemanticValue.Companion companion = L2SemanticValue.Companion;
                boolean $i$f$map = false;
                void var19_33 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    L2ReadBoxedOperand l2ReadBoxedOperand = (L2ReadBoxedOperand)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.semanticValue());
                }
                collection2 = (List)destination$iv$iv;
                L2SemanticPrimitiveInvocation semanticResult = companion.primitiveInvocation(primitive2, (List<? extends L2SemanticValue>)collection2);
                L2WriteBoxedOperand writeResult = generator.boxedWrite(semanticResult, resultRestriction);
                L2Operand[] l2OperandArray = new L2Operand[]{tupleReg, readSubscript, writeResult};
                generator.addInstruction(L2_TUPLE_AT_NO_FAIL.INSTANCE, l2OperandArray);
                callSiteHelper.useAnswer(translator.readBoxed(writeResult));
            }
            L2Generator.startBlock$default(generator, failed, false, null, 6, null);
            return !generator.currentlyReachable() ? true : super.tryToGenerateSpecialPrimitiveInvocation(functionToCallReg, rawFunction2, arguments2, argumentTypes, translator, callSiteHelper);
        }
        A_Type subscriptType = subscriptReg.type();
        A_Number lower = A_Type.Companion.getLowerBound(subscriptType);
        A_Number upper = A_Type.Companion.getUpperBound(subscriptType);
        L2WriteBoxedOperand writer = generator.boxedWriteTemp(TypeRestriction.Companion.restrictionForType(this.returnTypeGuaranteedByVM(rawFunction2, argumentTypes), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
        if (lower.equals(upper)) {
            int subscriptInt = A_Number.Companion.getExtractInt(lower);
            L2Operand[] resultRestriction = new L2Operand[]{tupleReg, new L2IntImmediateOperand(subscriptInt), writer};
            translator.addInstruction(L2_TUPLE_AT_CONSTANT.INSTANCE, resultRestriction);
            callSiteHelper.useAnswer(translator.readBoxed(writer));
            return true;
        }
        L2BasicBlock subscriptConversionFailure = generator.createBasicBlock("Should be unreachable");
        L2ReadIntOperand subscriptIntReg = generator.readInt(new L2SemanticUnboxedInt(subscriptReg.semanticValue()), subscriptConversionFailure);
        boolean bl = subscriptConversionFailure.predecessorEdges().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2Operand[] l2OperandArray = new L2Operand[]{tupleReg, subscriptIntReg, writer};
        translator.addInstruction(L2_TUPLE_AT_NO_FAIL.INSTANCE, l2OperandArray);
        callSiteHelper.useAnswer(translator.readBoxed(writer));
        return true;
    }
}

