/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.tuples;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/tuples/P_TupleTypeAtThrough;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_TupleTypeAtThrough
extends Primitive {
    @NotNull
    public static final P_TupleTypeAtThrough INSTANCE = new P_TupleTypeAtThrough();

    private P_TupleTypeAtThrough() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        List<AvailObject> list2 = interpreter.argsBuffer;
        AvailObject tupleType = list2.get(0);
        AvailObject startIndex = list2.get(1);
        AvailObject endIndex = list2.get(2);
        int startInt = A_Number.Companion.isInt(startIndex) ? A_Number.Companion.getExtractInt(startIndex) : Integer.MAX_VALUE;
        int endInt = A_Number.Companion.isInt(endIndex) ? A_Number.Companion.getExtractInt(endIndex) : Integer.MAX_VALUE;
        return interpreter.primitiveSuccess(A_Type.Companion.unionOfTypesAtThrough(tupleType, startInt, endInt));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getTupleMeta(), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), IntegerRangeTypeDescriptor.Companion.inclusive(IntegerDescriptor.Companion.getZero(), InfinityDescriptor.Companion.getPositiveInfinity())), InstanceMetaDescriptor.Companion.anyMeta(), null, 4, null);
    }
}

