/*
 * Decompiled with CFR 0.152.
 */
package avail.io;

import avail.io.NybbleArray;
import java.io.InputStream;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015H\u0096\u0002J\u0010\u0010\f\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lavail/io/NybbleInputStream;", "Ljava/io/InputStream;", "", "", "nybbles", "Lavail/io/NybbleArray;", "nybbleIndex", "(Lavail/io/NybbleArray;I)V", "atEnd", "", "getAtEnd", "()Z", "mark", "position", "getPosition", "()I", "available", "goTo", "", "index", "iterator", "", "readLimit", "markSupported", "read", "reset", "skip", "", "n", "toString", "", "avail"})
@SourceDebugExtension(value={"SMAP\nNybbleStreams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NybbleStreams.kt\navail/io/NybbleInputStream\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,372:1\n1864#2,3:373\n*S KotlinDebug\n*F\n+ 1 NybbleStreams.kt\navail/io/NybbleInputStream\n*L\n350#1:373,3\n*E\n"})
public final class NybbleInputStream
extends InputStream
implements Iterable<Integer>,
KMappedMarker {
    @NotNull
    private final NybbleArray nybbles;
    private int nybbleIndex;
    private int mark;

    public NybbleInputStream(@NotNull NybbleArray nybbles2, int nybbleIndex) {
        Intrinsics.checkNotNullParameter(nybbles2, "nybbles");
        this.nybbles = nybbles2;
        this.nybbleIndex = nybbleIndex;
    }

    public /* synthetic */ NybbleInputStream(NybbleArray nybbleArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(nybbleArray, n);
    }

    public final boolean getAtEnd() {
        return this.nybbleIndex == this.nybbles.getSize();
    }

    @Override
    public int available() {
        return this.nybbles.getSize() - this.nybbleIndex;
    }

    @Override
    public long skip(long n) {
        int delta = (int)n;
        int size = this.nybbles.getSize();
        if (this.nybbleIndex + delta > size) {
            int skipped = size - this.nybbleIndex;
            this.nybbleIndex = size;
            return skipped;
        }
        this.nybbleIndex += delta;
        return n;
    }

    @Override
    public int read() {
        int n;
        if (this.nybbleIndex == this.nybbles.getSize()) {
            n = -1;
        } else {
            int n2 = this.nybbleIndex;
            this.nybbleIndex = n2 + 1;
            n = this.nybbles.get(n2);
        }
        return n;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        this.mark = this.nybbleIndex;
    }

    @Override
    public void reset() {
        this.nybbleIndex = this.mark;
    }

    public final int getPosition() {
        return this.nybbleIndex;
    }

    public final void goTo(int index2) {
        if (!(0 <= index2 ? index2 < this.nybbles.getSize() : false)) {
            throw new IndexOutOfBoundsException(index2 + " \u2209 [0," + (this.nybbles.getSize() - 1) + "]");
        }
        this.nybbleIndex = index2;
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(this){
            final /* synthetic */ NybbleInputStream this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean hasNext() {
                return NybbleInputStream.access$getNybbleIndex$p(this.this$0) != NybbleInputStream.access$getNybbles$p(this.this$0).getSize();
            }

            @NotNull
            public Integer next() {
                return this.this$0.read();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u241.append('[');
        Iterable $this$forEachIndexed$iv = this.nybbles;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void nybble;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            byte by = ((Number)item$iv).byteValue();
            int index2 = n;
            boolean bl2 = false;
            String s = NybbleArray.Companion.getNybbleStrings().get((int)nybble);
            int n2 = index2;
            if (n2 == this.nybbleIndex) {
                $this$toString_u24lambda_u241.append('@');
                $this$toString_u24lambda_u241.append(s);
            } else if (n2 == this.mark) {
                $this$toString_u24lambda_u241.append('!');
                $this$toString_u24lambda_u241.append(s);
            } else {
                $this$toString_u24lambda_u241.append(s);
            }
            $this$toString_u24lambda_u241.append(", ");
        }
        if (this.nybbles.getSize() > 0) {
            $this$toString_u24lambda_u241.setLength($this$toString_u24lambda_u241.length() - 2);
        }
        $this$toString_u24lambda_u241.append(']');
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static final /* synthetic */ int access$getNybbleIndex$p(NybbleInputStream $this) {
        return $this.nybbleIndex;
    }

    public static final /* synthetic */ NybbleArray access$getNybbles$p(NybbleInputStream $this) {
        return $this.nybbles;
    }
}

