/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer.jvm;

import avail.descriptor.representation.AvailObject;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018BS\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u001a\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u000b\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lavail/optimizer/jvm/CheckedMethod;", "", "verifyAnnotation", "", "isStatic", "receiverClass", "Ljava/lang/Class;", "methodNameString", "", "returnClass", "argumentTypes", "", "(ZZLjava/lang/Class;Ljava/lang/String;Ljava/lang/Class;[Ljava/lang/Class;)V", "internalNameToCheckCastOrNull", "isInterface", "method", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "methodDescriptorString", "receiverClassInternalName", "generateCall", "", "methodVisitor", "Lorg/objectweb/asm/MethodVisitor;", "Companion", "avail"})
public final class CheckedMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isStatic;
    @NotNull
    private final String methodNameString;
    private final boolean isInterface;
    @NotNull
    private final String receiverClassInternalName;
    @NotNull
    private final String methodDescriptorString;
    @Nullable
    private String internalNameToCheckCastOrNull;
    private final Method method;

    /*
     * WARNING - void declaration
     */
    private CheckedMethod(boolean verifyAnnotation, boolean isStatic, Class<?> receiverClass, String methodNameString, Class<?> returnClass, Class<?> ... argumentTypes) {
        String string2;
        int modifiers;
        boolean e3;
        Object object;
        this.isStatic = isStatic;
        this.methodNameString = methodNameString;
        CheckedMethod checkedMethod = this;
        try {
            CheckedMethod checkedMethod2 = checkedMethod;
            object = receiverClass.getMethod(this.methodNameString, Arrays.copyOf(argumentTypes, argumentTypes.length));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            void e2;
            CheckedMethod checkedMethod3 = checkedMethod;
            throw new RuntimeException((Throwable)e2);
        }
        catch (SecurityException e2) {
            CheckedMethod checkedMethod4 = checkedMethod;
            throw new RuntimeException(e2);
        }
        checkedMethod2.method = object;
        if (verifyAnnotation) {
            ReferencedInGeneratedCode e3 = this.method.getAnnotation(ReferencedInGeneratedCode.class);
            if (e3 == null) {
                throw new IllegalStateException(("Method " + this.methodNameString + " should have had ReferencedInGeneratedCode annotation").toString());
            }
            object = e3;
        }
        boolean bl = e3 = ((modifiers = this.method.getModifiers()) & 1) != 0;
        if (_Assertions.ENABLED && !e3) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl2 = e3 = (modifiers & 8) != 0 == this.isStatic;
        if (_Assertions.ENABLED && !e3) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        Class<AvailObject> methodReturnType = this.method.getReturnType();
        if (Intrinsics.areEqual(methodReturnType, AvailObject.class)) {
            string2 = null;
        } else if (methodReturnType.isAssignableFrom(AvailObject.class)) {
            string2 = Type.getInternalName(AvailObject.class);
        } else if (returnClass.isAssignableFrom(methodReturnType)) {
            string2 = null;
        } else {
            boolean bl3 = methodReturnType.isAssignableFrom(returnClass);
            if (_Assertions.ENABLED && !bl3) {
                String string5 = "Assertion failed";
                throw new AssertionError((Object)string5);
            }
            string2 = Type.getInternalName(returnClass);
        }
        this.internalNameToCheckCastOrNull = string2;
        String string6 = Type.getInternalName(this.method.getDeclaringClass());
        Intrinsics.checkNotNullExpressionValue(string6, "getInternalName(...)");
        this.receiverClassInternalName = string6;
        this.isInterface = this.method.getDeclaringClass().isInterface();
        String string7 = Type.getMethodDescriptor(this.method);
        Intrinsics.checkNotNullExpressionValue(string7, "getMethodDescriptor(...)");
        this.methodDescriptorString = string7;
    }

    public final void generateCall(@NotNull MethodVisitor methodVisitor) {
        Intrinsics.checkNotNullParameter(methodVisitor, "methodVisitor");
        if (this.isStatic) {
            methodVisitor.visitMethodInsn(184, this.receiverClassInternalName, this.methodNameString, this.methodDescriptorString, this.isInterface);
        } else if (this.isInterface) {
            methodVisitor.visitMethodInsn(185, this.receiverClassInternalName, this.methodNameString, this.methodDescriptorString, this.isInterface);
        } else {
            methodVisitor.visitMethodInsn(182, this.receiverClassInternalName, this.methodNameString, this.methodDescriptorString, this.isInterface);
        }
        if (this.internalNameToCheckCastOrNull != null) {
            methodVisitor.visitTypeInsn(192, this.internalNameToCheckCastOrNull);
        }
    }

    public /* synthetic */ CheckedMethod(boolean verifyAnnotation, boolean isStatic, Class receiverClass, String methodNameString, Class returnClass, Class[] argumentTypes, DefaultConstructorMarker $constructor_marker) {
        this(verifyAnnotation, isStatic, receiverClass, methodNameString, returnClass, argumentTypes);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JG\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00062\u001a\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u000b\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\fJG\u0010\r\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00062\u001a\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u000b\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\fJG\u0010\u000e\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00062\u001a\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u000b\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\fJG\u0010\u000f\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00062\u001a\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u000b\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u0010"}, d2={"Lavail/optimizer/jvm/CheckedMethod$Companion;", "", "()V", "instanceMethod", "Lavail/optimizer/jvm/CheckedMethod;", "receiverClass", "Ljava/lang/Class;", "methodName", "", "returnClass", "argumentTypes", "", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;[Ljava/lang/Class;)Lavail/optimizer/jvm/CheckedMethod;", "javaLibraryInstanceMethod", "javaLibraryStaticMethod", "staticMethod", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckedMethod instanceMethod(@NotNull Class<?> receiverClass, @NotNull String methodName, @NotNull Class<?> returnClass, Class<?> ... argumentTypes) {
            Intrinsics.checkNotNullParameter(receiverClass, "receiverClass");
            Intrinsics.checkNotNullParameter(methodName, "methodName");
            Intrinsics.checkNotNullParameter(returnClass, "returnClass");
            Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
            return new CheckedMethod(true, false, (Class)receiverClass, methodName, (Class)returnClass, (Class[])Arrays.copyOf(argumentTypes, argumentTypes.length), null);
        }

        @NotNull
        public final CheckedMethod staticMethod(@NotNull Class<?> receiverClass, @NotNull String methodName, @NotNull Class<?> returnClass, Class<?> ... argumentTypes) {
            Intrinsics.checkNotNullParameter(receiverClass, "receiverClass");
            Intrinsics.checkNotNullParameter(methodName, "methodName");
            Intrinsics.checkNotNullParameter(returnClass, "returnClass");
            Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
            return new CheckedMethod(true, true, (Class)receiverClass, methodName, (Class)returnClass, (Class[])Arrays.copyOf(argumentTypes, argumentTypes.length), null);
        }

        @NotNull
        public final CheckedMethod javaLibraryInstanceMethod(@NotNull Class<?> receiverClass, @NotNull String methodName, @NotNull Class<?> returnClass, Class<?> ... argumentTypes) {
            Intrinsics.checkNotNullParameter(receiverClass, "receiverClass");
            Intrinsics.checkNotNullParameter(methodName, "methodName");
            Intrinsics.checkNotNullParameter(returnClass, "returnClass");
            Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
            return new CheckedMethod(false, false, (Class)receiverClass, methodName, (Class)returnClass, (Class[])Arrays.copyOf(argumentTypes, argumentTypes.length), null);
        }

        @NotNull
        public final CheckedMethod javaLibraryStaticMethod(@NotNull Class<?> receiverClass, @NotNull String methodName, @NotNull Class<?> returnClass, Class<?> ... argumentTypes) {
            Intrinsics.checkNotNullParameter(receiverClass, "receiverClass");
            Intrinsics.checkNotNullParameter(methodName, "methodName");
            Intrinsics.checkNotNullParameter(returnClass, "returnClass");
            Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
            return new CheckedMethod(false, true, (Class)receiverClass, methodName, (Class)returnClass, (Class[])Arrays.copyOf(argumentTypes, argumentTypes.length), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

