/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache;

import avail.AvailRuntime;
import avail.compiler.ModuleManifestEntry;
import avail.persistence.cache.Repository;
import avail.persistence.cache.record.ModuleArchive;
import avail.persistence.cache.record.ModuleCompilation;
import avail.persistence.cache.record.ModuleVersion;
import avail.persistence.cache.record.ModuleVersionKey;
import avail.persistence.cache.record.NameInModule;
import avail.persistence.cache.record.NamesIndex;
import avail.serialization.DeserializerDescriber;
import avail.utility.Strings;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.availlang.persistence.IndexedFile;
import org.availlang.persistence.MalformedSerialStreamException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lavail/persistence/cache/RepositoryDescriber;", "", "repository", "Lavail/persistence/cache/Repository;", "(Lavail/persistence/cache/Repository;)V", "getRepository$avail", "()Lavail/persistence/cache/Repository;", "describeCompilation", "", "recordNumber", "", "describeManifest", "recordNumberOfManifestEntries", "describeNamesIndex", "recordNumberOfNamesIndex", "dumpAll", "avail"})
@SourceDebugExtension(value={"SMAP\nRepositoryDescriber.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryDescriber.kt\navail/persistence/cache/RepositoryDescriber\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n215#2:200\n216#2:203\n1855#3,2:201\n*S KotlinDebug\n*F\n+ 1 RepositoryDescriber.kt\navail/persistence/cache/RepositoryDescriber\n*L\n83#1:200\n83#1:203\n86#1:201,2\n*E\n"})
public final class RepositoryDescriber {
    @NotNull
    private final Repository repository;

    public RepositoryDescriber(@NotNull Repository repository) {
        Intrinsics.checkNotNullParameter(repository, "repository");
        this.repository = repository;
    }

    @NotNull
    public final Repository getRepository$avail() {
        return this.repository;
    }

    @NotNull
    public final String dumpAll() {
        StringBuilder stringBuilder;
        StringBuilder $this$dumpAll_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$dumpAll_u24lambda_u243.append("Structure of repository " + this.repository.getFileName() + ":");
        List<ModuleArchive> archives = this.repository.getAllArchives$avail();
        for (ModuleArchive archive : archives) {
            Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u243, 0);
            $this$dumpAll_u24lambda_u243.append(archive.getRootRelativeName$avail());
            SortedMap<ModuleVersionKey, ModuleVersion> versionMap = archive.getAllKnownVersions();
            Map $this$forEach$iv = versionMap;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl2 = false;
                ModuleVersionKey versionKey = (ModuleVersionKey)entry.getKey();
                ModuleVersion version = (ModuleVersion)entry.getValue();
                Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u243, 1);
                $this$dumpAll_u24lambda_u243.append("digest=" + versionKey.getShortString());
                Iterable $this$forEach$iv2 = version.getAllCompilations();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    ModuleCompilation compilation = (ModuleCompilation)element$iv2;
                    boolean bl3 = false;
                    ModuleCompilation $this$dumpAll_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240 = compilation;
                    boolean bl4 = false;
                    Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u243, 2);
                    Object[] objectArray = new Object[]{$this$dumpAll_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getCompilationTime()};
                    $this$dumpAll_u24lambda_u243.append(String.format("Time: %tFT%<tTZ", objectArray));
                    Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u243, 3);
                    $this$dumpAll_u24lambda_u243.append("Compilation #" + $this$dumpAll_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getRecordNumber());
                    Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u243, 3);
                    $this$dumpAll_u24lambda_u243.append("Phrases #" + $this$dumpAll_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getRecordNumberOfBlockPhrases());
                    Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u243, 3);
                    $this$dumpAll_u24lambda_u243.append("Manifest #" + $this$dumpAll_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getRecordNumberOfManifest());
                    Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u243, 3);
                    $this$dumpAll_u24lambda_u243.append("Styling #" + $this$dumpAll_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getRecordNumberOfStyling());
                    Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u243, 3);
                    $this$dumpAll_u24lambda_u243.append("PhrasePaths #" + $this$dumpAll_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getRecordNumberOfPhrasePaths());
                    Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u243, 3);
                    $this$dumpAll_u24lambda_u243.append("NamesIndex #" + $this$dumpAll_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getRecordNumberOfNamesIndex());
                }
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    public final String describeCompilation(long recordNumber) {
        String string2;
        byte[] record = this.repository.get(recordNumber);
        try {
            ByteArrayInputStream stream = IndexedFile.Companion.validatedBytesFrom(record);
            DeserializerDescriber describer = new DeserializerDescriber(stream, AvailRuntime.Companion.currentRuntime());
            string2 = describer.describe();
        }
        catch (MalformedSerialStreamException e) {
            string2 = "Serialized record is malformed";
        }
        return string2;
    }

    @NotNull
    public final String describeManifest(long recordNumberOfManifestEntries) {
        StringBuilder stringBuilder;
        byte[] record = this.repository.get(recordNumberOfManifestEntries);
        StringBuilder $this$describeManifest_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(record));
        while (input.available() > 0) {
            ModuleManifestEntry $this$describeManifest_u24lambda_u245_u24lambda_u244 = new ModuleManifestEntry(input);
            boolean bl2 = false;
            $this$describeManifest_u24lambda_u245.append($this$describeManifest_u24lambda_u245_u24lambda_u244.getKind() + " " + $this$describeManifest_u24lambda_u245_u24lambda_u244.getSummaryText() + "\n");
            $this$describeManifest_u24lambda_u245.append("\ttopLevel = " + $this$describeManifest_u24lambda_u245_u24lambda_u244.getTopLevelStartingLine() + "\n");
            $this$describeManifest_u24lambda_u245.append("\tdefBody = " + $this$describeManifest_u24lambda_u245_u24lambda_u244.getDefinitionStartingLine() + "\n");
            $this$describeManifest_u24lambda_u245.append("\tbodyPhrase# = " + $this$describeManifest_u24lambda_u245_u24lambda_u244.getBodyPhraseIndexNumber() + "\n");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    public final String describeNamesIndex(long recordNumberOfNamesIndex) {
        byte[] record = this.repository.get(recordNumberOfNamesIndex);
        NamesIndex namesIndex = new NamesIndex(record);
        return Strings.buildUnicodeBox$default(Strings.INSTANCE, "Names Index", 0, new Function1<StringBuilder, Unit>(namesIndex){
            final /* synthetic */ NamesIndex $namesIndex;
            {
                this.$namesIndex = $namesIndex;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildUnicodeBox) {
                Intrinsics.checkNotNullParameter($this$buildUnicodeBox, "$this$buildUnicodeBox");
                Map<NameInModule, NamesIndex.NameOccurrences> $this$forEach$iv = this.$namesIndex.getOccurrences();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<NameInModule, NamesIndex.NameOccurrences>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    boolean $i$f$forEach2;
                    Iterable $this$forEach$iv2;
                    Map.Entry<NameInModule, NamesIndex.NameOccurrences> element$iv;
                    Map.Entry<NameInModule, NamesIndex.NameOccurrences> entry = element$iv = iterator2.next();
                    boolean bl = false;
                    NameInModule namesInIndex = entry.getKey();
                    NamesIndex.NameOccurrences occurrences2 = entry.getValue();
                    $this$buildUnicodeBox.append(namesInIndex.getModuleName());
                    $this$buildUnicodeBox.append("  ");
                    $this$buildUnicodeBox.append(namesInIndex.getAtomName());
                    if (!((Collection)occurrences2.getDeclarations()).isEmpty()) {
                        $this$buildUnicodeBox.append("\n\tDeclarations:");
                        $this$forEach$iv2 = occurrences2.getDeclarations();
                        $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            NamesIndex.Declaration decl = (NamesIndex.Declaration)element$iv2;
                            boolean bl2 = false;
                            $this$buildUnicodeBox.append("\n\t\tphraseIndex = ");
                            $this$buildUnicodeBox.append(decl.getPhraseIndex());
                            if (decl.getAlias() != null) {
                                NameInModule $this$invoke_u24lambda_u244_u24lambda_u241_u24lambda_u240;
                                boolean bl3 = false;
                                $this$buildUnicodeBox.append("(ALIAS OF: ");
                                $this$buildUnicodeBox.append($this$invoke_u24lambda_u244_u24lambda_u241_u24lambda_u240.getModuleName());
                                $this$buildUnicodeBox.append("  ");
                                $this$buildUnicodeBox.append($this$invoke_u24lambda_u244_u24lambda_u241_u24lambda_u240.getAtomName());
                                $this$buildUnicodeBox.append(")");
                            }
                        }
                    }
                    if (!((Collection)occurrences2.getDefinitions()).isEmpty()) {
                        $this$buildUnicodeBox.append("\n\tDefinitions:");
                        $this$forEach$iv2 = occurrences2.getDefinitions();
                        $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            NamesIndex.Definition def = (NamesIndex.Definition)element$iv2;
                            boolean bl4 = false;
                            $this$buildUnicodeBox.append("\n\t\t");
                            $this$buildUnicodeBox.append(def.getDefinitionType().name());
                            $this$buildUnicodeBox.append(": manifestIndex = ");
                            $this$buildUnicodeBox.append(def.getManifestIndex());
                        }
                    }
                    if (!((Collection)occurrences2.getUsages()).isEmpty()) {
                        $this$buildUnicodeBox.append("\n\tUsages:");
                        $this$forEach$iv2 = occurrences2.getUsages();
                        $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            NamesIndex.Usage usage = (NamesIndex.Usage)element$iv2;
                            boolean bl5 = false;
                            $this$buildUnicodeBox.append("\n\t\t");
                            $this$buildUnicodeBox.append(usage.getUsageType().name());
                            $this$buildUnicodeBox.append(": phraseIndex = ");
                            $this$buildUnicodeBox.append(usage.getPhraseIndex());
                        }
                    }
                    $this$buildUnicodeBox.append("\n");
                }
            }
        }, 2, null);
    }
}

