/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache.record;

import avail.builder.ResolvedModuleName;
import avail.error.ErrorCode;
import avail.persistence.cache.Repository;
import avail.persistence.cache.record.ModuleArchive;
import avail.persistence.cache.record.ModuleCompilation;
import avail.persistence.cache.record.ModuleCompilationKey;
import avail.persistence.cache.record.ModuleVersion;
import avail.persistence.cache.record.ModuleVersionKey;
import avail.resolver.ResolverReference;
import avail.utility.CodingKt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 92\u00020\u0001:\u00019B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001c\u001a\u00020\u001dJF\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001d0$2\u001a\u0010%\u001a\u0016\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010(\u0012\u0004\u0012\u00020\u001d0&J\u0010\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020\fJ\u0017\u0010+\u001a\u0004\u0018\u00010\u00132\u0006\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.J\u001e\u0010/\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\f2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\f2\u0006\u00105\u001a\u00020\rJ\b\u00106\u001a\u00020\bH\u0016J\u000e\u00107\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u000208R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R*\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u001aj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lavail/persistence/cache/record/ModuleArchive;", "", "repository", "Lavail/persistence/cache/Repository;", "binaryStream", "Ljava/io/DataInputStream;", "(Lavail/persistence/cache/Repository;Ljava/io/DataInputStream;)V", "rootRelativeName", "", "(Lavail/persistence/cache/Repository;Ljava/lang/String;)V", "allKnownVersions", "Ljava/util/SortedMap;", "Lavail/persistence/cache/record/ModuleVersionKey;", "Lavail/persistence/cache/record/ModuleVersion;", "getAllKnownVersions", "()Ljava/util/SortedMap;", "digestCache", "Lavail/persistence/cache/Repository$LimitedCache;", "", "", "lastUpdate", "getRepository$avail", "()Lavail/persistence/cache/Repository;", "getRootRelativeName$avail", "()Ljava/lang/String;", "versions", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "cleanCompilations", "", "digestForFile", "resolvedModuleName", "Lavail/builder/ResolvedModuleName;", "forceRefreshDigest", "", "withDigest", "Lkotlin/Function1;", "failureHandler", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "getVersion", "versionKey", "provideDigest", "reference", "Lavail/resolver/ResolverReference;", "provideDigest$avail", "putCompilation", "compilationKey", "Lavail/persistence/cache/record/ModuleCompilationKey;", "compilation", "Lavail/persistence/cache/record/ModuleCompilation;", "putVersion", "version", "toString", "write", "Ljava/io/DataOutputStream;", "Companion", "avail"})
@SourceDebugExtension(value={"SMAP\nModuleArchive.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleArchive.kt\navail/persistence/cache/record/ModuleArchive\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,313:1\n1#2:314\n1045#3:315\n*S KotlinDebug\n*F\n+ 1 ModuleArchive.kt\navail/persistence/cache/record/ModuleArchive\n*L\n126#1:315\n*E\n"})
public final class ModuleArchive {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Repository repository;
    @NotNull
    private final String rootRelativeName;
    @NotNull
    private final LinkedHashMap<ModuleVersionKey, ModuleVersion> versions;
    private long lastUpdate;
    @NotNull
    private final Repository.LimitedCache<Long, byte[]> digestCache;
    private static final int MAX_RECORDED_VERSIONS_PER_MODULE = 10;
    private static final int MAX_RECORDED_DIGESTS_PER_MODULE = 20;

    public ModuleArchive(@NotNull Repository repository, @NotNull String rootRelativeName2) {
        Intrinsics.checkNotNullParameter(repository, "repository");
        Intrinsics.checkNotNullParameter(rootRelativeName2, "rootRelativeName");
        this.repository = repository;
        this.rootRelativeName = rootRelativeName2;
        this.versions = new LinkedHashMap(10, 0.75f, true);
        this.digestCache = new Repository.LimitedCache(20);
    }

    @NotNull
    public final Repository getRepository$avail() {
        return this.repository;
    }

    @NotNull
    public final String getRootRelativeName$avail() {
        return this.rootRelativeName;
    }

    @Nullable
    public final byte[] provideDigest$avail(@NotNull ResolverReference reference) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        if (!Intrinsics.areEqual(this.rootRelativeName, reference.getModuleName().getRootRelativeName())) {
            boolean bl = false;
            String string2 = reference.getQualifiedName() + " attempted to access archive for " + this.rootRelativeName;
            throw new IllegalArgumentException(string2.toString());
        }
        return (byte[])this.digestCache.get(reference.getLastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SortedMap<ModuleVersionKey, ModuleVersion> getAllKnownVersions() {
        Map map;
        Lock lock = this.repository.getLock$avail();
        lock.lock();
        try {
            boolean bl = false;
            map = MapsKt.toMap((Map)this.versions);
        }
        finally {
            lock.unlock();
        }
        Map map2 = map;
        SortedMap<ModuleVersionKey, ModuleVersion> sortedMap = Collections.unmodifiableSortedMap(new TreeMap(map2));
        Intrinsics.checkNotNullExpressionValue(sortedMap, "unmodifiableSortedMap(...)");
        return sortedMap;
    }

    @NotNull
    public String toString() {
        String string2 = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        Set<Map.Entry<ModuleVersionKey, ModuleVersion>> set2 = this.versions.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-entries>(...)");
        Iterable $this$sortedBy$iv = set2;
        boolean $i$f$sortedBy = false;
        return string2 + CollectionsKt.joinToString$default(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (ModuleVersionKey)it.getKey();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((ModuleVersionKey)it.getKey()));
            }
        }), ", ", " " + this.rootRelativeName + " (", ")", 0, null, toString.2.INSTANCE, 24, null);
    }

    public final void digestForFile(@NotNull ResolvedModuleName resolvedModuleName, boolean forceRefreshDigest, @NotNull Function1<? super byte[], Unit> withDigest, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(resolvedModuleName, "resolvedModuleName");
        Intrinsics.checkNotNullParameter(withDigest, "withDigest");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        boolean bl = Intrinsics.areEqual(resolvedModuleName.getRootRelativeName(), this.rootRelativeName);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        ResolverReference sourceReference = resolvedModuleName.getResolverReference();
        long lastModification = sourceReference.getLastModified();
        byte[] digest = (byte[])this.digestCache.get(lastModification);
        if (digest != null && !forceRefreshDigest) {
            withDigest.invoke((byte[])digest);
            return;
        }
        sourceReference.digest$avail(forceRefreshDigest, (Function2<? super byte[], ? super Long, Unit>)new Function2<byte[], Long, Unit>(lastModification, this, withDigest){
            final /* synthetic */ long $lastModification;
            final /* synthetic */ ModuleArchive this$0;
            final /* synthetic */ Function1<byte[], Unit> $withDigest;
            {
                this.$lastModification = $lastModification;
                this.this$0 = $receiver;
                this.$withDigest = $withDigest;
                super(2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull byte[] newDigest, long lastModified) {
                boolean bl;
                Intrinsics.checkNotNullParameter(newDigest, "newDigest");
                boolean bl2 = bl = newDigest.length == 32;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                if (lastModified >= this.$lastModification) {
                    Lock lock = this.this$0.getRepository$avail().getLock$avail();
                    ModuleArchive moduleArchive = this.this$0;
                    lock.lock();
                    try {
                        boolean bl3 = false;
                        Long l = lastModified;
                        ((Map)ModuleArchive.access$getDigestCache$p(moduleArchive)).put(l, newDigest);
                        ModuleArchive.access$setLastUpdate$p(moduleArchive, lastModified);
                        moduleArchive.getRepository$avail().markDirty();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                this.$withDigest.invoke(newDigest);
            }
        }, failureHandler);
    }

    public final void write(@NotNull DataOutputStream binaryStream) throws IOException {
        Intrinsics.checkNotNullParameter(binaryStream, "binaryStream");
        CodingKt.sizedString(binaryStream, this.rootRelativeName);
        CodingKt.vlq(binaryStream, this.digestCache.size());
        for (Map.Entry entry : ((Map)this.digestCache).entrySet()) {
            long key = ((Number)entry.getKey()).longValue();
            byte[] value = (byte[])entry.getValue();
            binaryStream.writeLong(key);
            binaryStream.write(value);
        }
        CodingKt.vlq(binaryStream, this.versions.size());
        for (Map.Entry entry : ((Map)this.versions).entrySet()) {
            ModuleVersionKey key = (ModuleVersionKey)entry.getKey();
            ModuleVersion value = (ModuleVersion)entry.getValue();
            key.write(binaryStream);
            value.write$avail(binaryStream);
        }
    }

    public ModuleArchive(@NotNull Repository repository, @NotNull DataInputStream binaryStream) throws IOException {
        Intrinsics.checkNotNullParameter(repository, "repository");
        Intrinsics.checkNotNullParameter(binaryStream, "binaryStream");
        this(repository, CodingKt.decodeString(binaryStream));
        int digestCount = CodingKt.unvlqInt(binaryStream);
        while (digestCount-- > 0) {
            long lastModification = binaryStream.readLong();
            byte[] digest = new byte[32];
            binaryStream.readFully(digest);
            Long l = lastModification;
            ((Map)this.digestCache).put(l, digest);
        }
        int versionCount = CodingKt.unvlqInt(binaryStream);
        while (versionCount-- > 0) {
            ModuleVersionKey versionKey = new ModuleVersionKey(binaryStream);
            ModuleVersion version = new ModuleVersion(repository, binaryStream);
            ((Map)this.versions).put(versionKey, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ModuleVersion getVersion(@NotNull ModuleVersionKey versionKey) {
        ModuleVersion moduleVersion;
        Intrinsics.checkNotNullParameter(versionKey, "versionKey");
        Lock lock = this.repository.getLock$avail();
        lock.lock();
        try {
            boolean bl = false;
            moduleVersion = this.versions.get(versionKey);
        }
        finally {
            lock.unlock();
        }
        return moduleVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putVersion(@NotNull ModuleVersionKey versionKey, @NotNull ModuleVersion version) {
        Intrinsics.checkNotNullParameter(versionKey, "versionKey");
        Intrinsics.checkNotNullParameter(version, "version");
        Lock lock = this.repository.getLock$avail();
        lock.lock();
        try {
            boolean bl = false;
            ((Map)this.versions).put(versionKey, version);
            this.repository.markDirty();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putCompilation(@NotNull ModuleVersionKey versionKey, @NotNull ModuleCompilationKey compilationKey, @NotNull ModuleCompilation compilation) {
        Intrinsics.checkNotNullParameter(versionKey, "versionKey");
        Intrinsics.checkNotNullParameter(compilationKey, "compilationKey");
        Intrinsics.checkNotNullParameter(compilation, "compilation");
        Lock lock = this.repository.getLock$avail();
        lock.lock();
        try {
            boolean bl = false;
            ModuleVersion moduleVersion = this.versions.get(versionKey);
            Intrinsics.checkNotNull(moduleVersion);
            ModuleVersion version = moduleVersion;
            ((Map)version.getCompilations$avail()).put(compilationKey, compilation);
            this.repository.markDirty();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void cleanCompilations() {
        this.versions.clear();
    }

    public static final /* synthetic */ Repository.LimitedCache access$getDigestCache$p(ModuleArchive $this) {
        return $this.digestCache;
    }

    public static final /* synthetic */ void access$setLastUpdate$p(ModuleArchive $this, long l) {
        $this.lastUpdate = l;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lavail/persistence/cache/record/ModuleArchive$Companion;", "", "()V", "MAX_RECORDED_DIGESTS_PER_MODULE", "", "MAX_RECORDED_VERSIONS_PER_MODULE", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

