/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact;

import java.net.URI;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.AvailArtifact;
import org.availlang.artifact.environment.location.Absolute;
import org.availlang.artifact.environment.location.AvailLocation;
import org.availlang.artifact.environment.location.Scheme;
import org.availlang.artifact.jar.AvailArtifactJar;
import org.availlang.artifact.manifest.AvailArtifactManifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/availlang/artifact/AvailArtifactMetadata;", "", "location", "Lorg/availlang/artifact/environment/location/AvailLocation;", "manifest", "Lorg/availlang/artifact/manifest/AvailArtifactManifest;", "(Lorg/availlang/artifact/environment/location/AvailLocation;Lorg/availlang/artifact/manifest/AvailArtifactManifest;)V", "getLocation", "()Lorg/availlang/artifact/environment/location/AvailLocation;", "getManifest", "()Lorg/availlang/artifact/manifest/AvailArtifactManifest;", "rootNames", "", "", "getRootNames", "()Ljava/util/Set;", "Companion", "avail-artifact"})
public final class AvailArtifactMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AvailLocation location;
    @NotNull
    private final AvailArtifactManifest manifest;

    private AvailArtifactMetadata(AvailLocation location, AvailArtifactManifest manifest2) {
        this.location = location;
        this.manifest = manifest2;
    }

    @NotNull
    public final AvailLocation getLocation() {
        return this.location;
    }

    @NotNull
    public final AvailArtifactManifest getManifest() {
        return this.manifest;
    }

    @NotNull
    public final Set<String> getRootNames() {
        return this.manifest.getRoots().keySet();
    }

    public /* synthetic */ AvailArtifactMetadata(AvailLocation location, AvailArtifactManifest manifest2, DefaultConstructorMarker $constructor_marker) {
        this(location, manifest2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\f"}, d2={"Lorg/availlang/artifact/AvailArtifactMetadata$Companion;", "", "()V", "from", "Lorg/availlang/artifact/AvailArtifactMetadata;", "artifact", "Lorg/availlang/artifact/AvailArtifact;", "location", "Lorg/availlang/artifact/environment/location/AvailLocation;", "fromJar", "artifactJarUri", "Ljava/net/URI;", "avail-artifact"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AvailArtifactMetadata from(@NotNull AvailArtifact artifact, @NotNull AvailLocation location) {
            Intrinsics.checkNotNullParameter(artifact, "artifact");
            Intrinsics.checkNotNullParameter(location, "location");
            return new AvailArtifactMetadata(location, artifact.getManifest(), null);
        }

        @NotNull
        public final AvailArtifactMetadata fromJar(@NotNull URI artifactJarUri, @Nullable AvailLocation location) {
            Intrinsics.checkNotNullParameter(artifactJarUri, "artifactJarUri");
            AvailArtifact availArtifact = new AvailArtifactJar(artifactJarUri);
            AvailLocation availLocation = location;
            if (availLocation == null) {
                String string2 = artifactJarUri.getPath();
                Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
                availLocation = new Absolute(string2, Scheme.JAR, null);
            }
            return this.from(availArtifact, availLocation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

