/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.manifest;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.AvailArtifactException;
import org.availlang.artifact.AvailArtifactType;
import org.availlang.artifact.UtilityKt;
import org.availlang.artifact.environment.project.AvailProjectRoot;
import org.availlang.artifact.environment.project.StylingGroup;
import org.availlang.artifact.environment.project.TemplateGroup;
import org.availlang.artifact.manifest.AvailArtifactManifestV1;
import org.availlang.artifact.manifest.AvailRootManifest;
import org.availlang.json.JSONFriendly;
import org.availlang.json.JSONObject;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 %2\u00020\u0001:\u0001%J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!H\u0016J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u001e\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u0082\u0001\u0001&\u00a8\u0006'\u00c0\u0006\u0003"}, d2={"Lorg/availlang/artifact/manifest/AvailArtifactManifest;", "Lorg/availlang/json/JSONFriendly;", "artifactType", "Lorg/availlang/artifact/AvailArtifactType;", "getArtifactType", "()Lorg/availlang/artifact/AvailArtifactType;", "artifactVersion", "", "getArtifactVersion", "()I", "constructed", "", "getConstructed", "()Ljava/lang/String;", "description", "getDescription", "fileContent", "getFileContent", "roots", "", "Lorg/availlang/artifact/manifest/AvailRootManifest;", "getRoots", "()Ljava/util/Map;", "stylesFor", "Lorg/availlang/artifact/environment/project/StylingGroup;", "root", "templatesFor", "Lorg/availlang/artifact/environment/project/TemplateGroup;", "updateRoot", "", "Lorg/availlang/artifact/environment/project/AvailProjectRoot;", "rootNameInJar", "createdList", "", "writeFile", "targetFile", "Ljava/io/File;", "Companion", "Lorg/availlang/artifact/manifest/AvailArtifactManifestV1;", "avail-artifact"})
public interface AvailArtifactManifest
extends JSONFriendly {
    @NotNull
    public static final Companion Companion = org.availlang.artifact.manifest.AvailArtifactManifest$Companion.$$INSTANCE;
    public static final int CURRENT_MANIFEST_VERSION = 1;
    @NotNull
    public static final String manifestFileName = "avail-artifact-manifest.txt";
    @NotNull
    public static final String availArtifactManifestFile = "avail-artifact-contents/avail-artifact-manifest.txt";

    public int getArtifactVersion();

    @NotNull
    public AvailArtifactType getArtifactType();

    @NotNull
    public String getConstructed();

    @NotNull
    public String getDescription();

    @NotNull
    public Map<String, AvailRootManifest> getRoots();

    @Nullable
    default public StylingGroup stylesFor(@NotNull String root) {
        Intrinsics.checkNotNullParameter(root, "root");
        AvailRootManifest availRootManifest = this.getRoots().get(root);
        return availRootManifest != null ? availRootManifest.getStyles() : null;
    }

    @Nullable
    default public TemplateGroup templatesFor(@NotNull String root) {
        Intrinsics.checkNotNullParameter(root, "root");
        AvailRootManifest availRootManifest = this.getRoots().get(root);
        return availRootManifest != null ? availRootManifest.getTemplates() : null;
    }

    @NotNull
    default public String getFileContent() {
        return org.availlang.json.UtilityKt.jsonPrettyPrintWriter((Function1<? super JSONWriter, Unit>)new Function1<JSONWriter, Unit>(this){
            final /* synthetic */ AvailArtifactManifest this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JSONWriter $this$jsonPrettyPrintWriter) {
                Intrinsics.checkNotNullParameter($this$jsonPrettyPrintWriter, "$this$jsonPrettyPrintWriter");
                this.this$0.writeTo($this$jsonPrettyPrintWriter);
            }
        }).toString();
    }

    default public void writeFile(@NotNull File targetFile) {
        Intrinsics.checkNotNullParameter(targetFile, "targetFile");
        FilesKt.writeText$default(targetFile, this.getFileContent(), null, 2, null);
    }

    default public void updateRoot(@NotNull AvailProjectRoot root, @NotNull String rootNameInJar, @NotNull List<String> createdList) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(rootNameInJar, "rootNameInJar");
        Intrinsics.checkNotNullParameter(createdList, "createdList");
        if (createdList.isEmpty()) {
            return;
        }
        AvailRootManifest availRootManifest = this.getRoots().get(rootNameInJar);
        if (availRootManifest == null) {
            return;
        }
        AvailRootManifest u = availRootManifest;
        if (createdList.contains("styles.json")) {
            root.getStyles().updateFrom(u.getStyles());
            root.saveStylesToDisk();
        }
        if (createdList.contains("templates.json")) {
            TemplateGroup merged = root.getTemplateGroup().mergeOnto(u.getTemplates());
            root.getTemplateGroup().getTemplates().clear();
            root.getTemplateGroup().getTemplates().putAll(merged.getTemplates());
            root.saveTemplatesToDisk();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004J*\u0010\u0017\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0006J2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/availlang/artifact/manifest/AvailArtifactManifest$Companion;", "", "()V", "CURRENT_MANIFEST_VERSION", "", "availArtifactManifestFile", "", "manifestFileName", "createManifestFileContents", "", "artifactType", "Lorg/availlang/artifact/AvailArtifactType;", "roots", "", "Lorg/availlang/artifact/manifest/AvailRootManifest;", "description", "from", "Lorg/availlang/artifact/manifest/AvailArtifactManifest;", "obj", "Lorg/availlang/json/JSONObject;", "isValidVersion", "", "proposedOrdinal", "manifestFile", "writeManifestFile", "", "targetFile", "Ljava/io/File;", "avail-artifact"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        public static final int CURRENT_MANIFEST_VERSION = 1;
        @NotNull
        public static final String manifestFileName = "avail-artifact-manifest.txt";
        @NotNull
        public static final String availArtifactManifestFile = "avail-artifact-contents/avail-artifact-manifest.txt";

        private Companion() {
        }

        public final boolean isValidVersion(int proposedOrdinal) {
            return 0 <= proposedOrdinal ? proposedOrdinal < 2 : false;
        }

        @NotNull
        public final AvailArtifactManifest from(@NotNull JSONObject obj) {
            int n;
            Intrinsics.checkNotNullParameter(obj, "obj");
            try {
                n = JSONObject.getNumber$default(obj, "artifactVersion", null, 2, null).getInt();
            }
            catch (Throwable e) {
                throw new AvailArtifactException("Problem accessing Avail Artifact Manifest Version.", e);
            }
            int version = n;
            if (version != 1) {
                throw new AvailArtifactException("Invalid Avail Artifact: Version " + version + " is not in the valid range of known artifact versions, [1, 1].");
            }
            return AvailArtifactManifestV1.Companion.fromJSON$avail_artifact(obj);
        }

        public final void writeManifestFile(@NotNull AvailArtifactType artifactType, @NotNull File targetFile, @NotNull Map<String, AvailRootManifest> roots2, @NotNull String description2) {
            Intrinsics.checkNotNullParameter((Object)artifactType, "artifactType");
            Intrinsics.checkNotNullParameter(targetFile, "targetFile");
            Intrinsics.checkNotNullParameter(roots2, "roots");
            Intrinsics.checkNotNullParameter(description2, "description");
            new AvailArtifactManifestV1(artifactType, UtilityKt.getFormattedNow(), roots2, description2).writeFile(targetFile);
        }

        @NotNull
        public final AvailArtifactManifest manifestFile(@NotNull AvailArtifactType artifactType, @NotNull Map<String, AvailRootManifest> roots2, @NotNull String description2) {
            Intrinsics.checkNotNullParameter((Object)artifactType, "artifactType");
            Intrinsics.checkNotNullParameter(roots2, "roots");
            Intrinsics.checkNotNullParameter(description2, "description");
            return new AvailArtifactManifestV1(artifactType, UtilityKt.getFormattedNow(), roots2, description2);
        }

        @NotNull
        public final byte[] createManifestFileContents(@NotNull AvailArtifactType artifactType, @NotNull Map<String, AvailRootManifest> roots2, @NotNull String description2) {
            Intrinsics.checkNotNullParameter((Object)artifactType, "artifactType");
            Intrinsics.checkNotNullParameter(roots2, "roots");
            Intrinsics.checkNotNullParameter(description2, "description");
            String string2 = new AvailArtifactManifestV1(artifactType, UtilityKt.getFormattedNow(), roots2, description2).getFileContent();
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
            return byArray;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @Nullable
        public static StylingGroup stylesFor(@NotNull AvailArtifactManifest $this, @NotNull String root) {
            Intrinsics.checkNotNullParameter(root, "root");
            return $this.stylesFor(root);
        }

        @Deprecated
        @Nullable
        public static TemplateGroup templatesFor(@NotNull AvailArtifactManifest $this, @NotNull String root) {
            Intrinsics.checkNotNullParameter(root, "root");
            return $this.templatesFor(root);
        }

        @Deprecated
        @NotNull
        public static String getFileContent(@NotNull AvailArtifactManifest $this) {
            return $this.getFileContent();
        }

        @Deprecated
        public static void writeFile(@NotNull AvailArtifactManifest $this, @NotNull File targetFile) {
            Intrinsics.checkNotNullParameter(targetFile, "targetFile");
            $this.writeFile(targetFile);
        }

        @Deprecated
        public static void updateRoot(@NotNull AvailArtifactManifest $this, @NotNull AvailProjectRoot root, @NotNull String rootNameInJar, @NotNull List<String> createdList) {
            Intrinsics.checkNotNullParameter(root, "root");
            Intrinsics.checkNotNullParameter(rootNameInJar, "rootNameInJar");
            Intrinsics.checkNotNullParameter(createdList, "createdList");
            $this.updateRoot(root, rootNameInJar, createdList);
        }

        @Deprecated
        @NotNull
        public static String getJsonFormattedString(@NotNull AvailArtifactManifest $this) {
            return $this.getJsonFormattedString();
        }

        @Deprecated
        @NotNull
        public static String getJsonPrettyPrintedFormattedString(@NotNull AvailArtifactManifest $this) {
            return $this.getJsonPrettyPrintedFormattedString();
        }
    }
}

