/*
 * Decompiled with CFR 0.152.
 */
package avail.builder;

import avail.annotations.ThreadSafe;
import avail.builder.ModuleNameResolver;
import avail.builder.ModuleRoots;
import avail.builder.RenamesFileParserException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.MalformedInputException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001d2\u00020\u0001:\u0004\u001d\u001e\u001f B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\r\u0010\u0019\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001aJ\u000f\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\b\u001cR\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lavail/builder/RenamesFileParser;", "", "reader", "Ljava/io/Reader;", "roots", "Lavail/builder/ModuleRoots;", "(Ljava/io/Reader;Lavail/builder/ModuleRoots;)V", "atEnd", "", "getAtEnd", "()Z", "resolver", "Lavail/builder/ModuleNameResolver;", "nextCodePoint", "", "parse", "parseRenameRule", "", "modulePath", "", "parseRenamesFile", "peekFor", "c", "scan", "Lavail/builder/RenamesFileParser$Token;", "scanDoubleQuote", "scanDoubleQuote$avail", "scanSlash", "scanSlash$avail", "Companion", "ScannerAction", "Token", "TokenType", "avail"})
public final class RenamesFileParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Reader reader;
    @NotNull
    private final ModuleRoots roots;
    @Nullable
    private volatile ModuleNameResolver resolver;
    @NotNull
    private static final byte[] scannerTable = new byte[128];

    @ThreadSafe
    public RenamesFileParser(@NotNull Reader reader, @NotNull ModuleRoots roots2) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(roots2, "roots");
        this.reader = reader;
        this.roots = roots2;
        boolean bl = this.reader.markSupported();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    private final boolean getAtEnd() throws IOException {
        this.reader.mark(1);
        int next = this.reader.read();
        this.reader.reset();
        return next == -1;
    }

    private final int nextCodePoint() throws IOException {
        boolean bl;
        int next = this.reader.read();
        if (next == -1) {
            return -1;
        }
        boolean bl2 = bl = (next & 0xFFFF) == next;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        char high = (char)next;
        if (Character.isSurrogate(high)) {
            boolean bl3;
            next = this.reader.read();
            if (next == -1) {
                throw new MalformedInputException(1);
            }
            boolean bl4 = bl3 = (next & 0xFFFF) == next;
            if (_Assertions.ENABLED && !bl3) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            char low = (char)next;
            if (!Character.isSurrogate(low)) {
                throw new MalformedInputException(1);
            }
            return Character.toCodePoint(high, low);
        }
        return high;
    }

    private final boolean peekFor(int c) throws IOException {
        this.reader.mark(2);
        int next = this.nextCodePoint();
        if (next == c) {
            return true;
        }
        this.reader.reset();
        return false;
    }

    @NotNull
    public final Token scanDoubleQuote$avail() throws IOException {
        if (this.getAtEnd()) {
            return new Token(TokenType.UNKNOWN, "\"");
        }
        StringBuilder builder = new StringBuilder(50);
        while (true) {
            if (this.getAtEnd()) {
                throw new EOFException("Expected close quote to correspond with open quote but found end-of-file");
            }
            if (this.peekFor(34)) {
                String string2 = builder.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                return new Token(TokenType.PATH, string2);
            }
            builder.appendCodePoint(this.nextCodePoint());
        }
    }

    @Nullable
    public final Token scanSlash$avail() throws IOException {
        if (!this.peekFor(42)) {
            return new Token(TokenType.UNKNOWN, "/");
        }
        int depth2 = 1;
        do {
            if (this.getAtEnd()) {
                throw new EOFException("Expected close comment to correspond with open comment but found end-of-file");
            }
            if (this.peekFor(47) && this.peekFor(42)) {
                ++depth2;
                continue;
            }
            if (this.peekFor(42) && this.peekFor(47)) {
                --depth2;
                continue;
            }
            this.nextCodePoint();
        } while (depth2 != 0);
        return null;
    }

    private final Token scan() throws IOException, RenamesFileParserException {
        while (!this.getAtEnd()) {
            int c = this.nextCodePoint();
            Token token = RenamesFileParser.Companion.actionFor(c).scan(this, c);
            if (token == null) continue;
            if (token.getTokenType() == TokenType.UNKNOWN) {
                throw new RenamesFileParserException("Unknown token (" + token.getLexeme() + ")");
            }
            return token;
        }
        return new Token(TokenType.EOF, "<EOF>");
    }

    private final void parseRenameRule(String modulePath2) throws IOException, RenamesFileParserException {
        Token token = this.scan();
        if (token.getTokenType() != TokenType.ARROW) {
            throw new RenamesFileParserException("expected \u2192 but found (" + token.getLexeme() + ")");
        }
        Token filePath = this.scan();
        if (filePath.getTokenType() != TokenType.PATH) {
            throw new RenamesFileParserException("expected a file path but found (" + filePath.getLexeme() + ")");
        }
        if (((CharSequence)filePath.getLexeme()).length() == 0) {
            throw new RenamesFileParserException("module path (" + modulePath2 + ") must not bind an empty file path");
        }
        ModuleNameResolver moduleNameResolver = this.resolver;
        Intrinsics.checkNotNull(moduleNameResolver);
        ModuleNameResolver theResolver = moduleNameResolver;
        if (theResolver.hasRenameRuleFor$avail(modulePath2)) {
            throw new RenamesFileParserException("duplicate rename rule for \"" + modulePath2 + "\" is not allowed");
        }
        theResolver.addRenameRule(modulePath2, filePath.getLexeme());
    }

    private final void parseRenamesFile() throws IOException, RenamesFileParserException {
        Token token = this.scan();
        while (token.getTokenType() == TokenType.PATH) {
            if (((CharSequence)token.getLexeme()).length() == 0) {
                throw new RenamesFileParserException("module path must not be empty");
            }
            this.parseRenameRule(token.getLexeme());
            token = this.scan();
        }
        if (token.getTokenType() != TokenType.EOF) {
            throw new RenamesFileParserException("expected end of file but found (" + token.getLexeme() + ")");
        }
    }

    @NotNull
    public final ModuleNameResolver parse() throws RenamesFileParserException {
        ModuleNameResolver theResolver = this.resolver;
        if (theResolver == null) {
            this.resolver = theResolver = new ModuleNameResolver(this.roots);
            try {
                this.parseRenamesFile();
            }
            catch (IOException e) {
                throw new RenamesFileParserException(e);
            }
        }
        return theResolver;
    }

    static {
        int n = scannerTable.length;
        for (int i2 = 0; i2 < n; ++i2) {
            char c = (char)i2;
            ScannerAction action2 = c == '\"' ? ScannerAction.DOUBLE_QUOTE : (c == '/' ? ScannerAction.SLASH : (Character.isSpaceChar(c) || Character.isWhitespace(c) ? ScannerAction.WHITESPACE : ScannerAction.UNKNOWN));
            RenamesFileParser.scannerTable[i2] = (byte)action2.ordinal();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J!\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f0\fH\u0007\u00a2\u0006\u0002\u0010\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0013J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lavail/builder/RenamesFileParser$Companion;", "", "()V", "scannerTable", "", "actionFor", "Lavail/builder/RenamesFileParser$ScannerAction;", "c", "", "renamesFileFromRules", "", "rules", "", "([[Ljava/lang/String;)Ljava/lang/String;", "scanRightArrow", "Lavail/builder/RenamesFileParser$Token;", "scanRightArrow$avail", "scanUnknown", "unknownChar", "scanUnknown$avail", "scanWhitespace", "scanWhitespace$avail", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @ThreadSafe
        @NotNull
        public final String renamesFileFromRules(@NotNull String[][] rules) {
            Intrinsics.checkNotNullParameter(rules, "rules");
            StringBuilder builder = new StringBuilder(100);
            builder.append("/* Generated by ");
            builder.append(RenamesFileParser.class.getCanonicalName());
            builder.append(".renamesFileFromRules() */\n");
            int n = ((Object[])rules).length;
            for (int j = 0; j < n; ++j) {
                String[] rule2 = rules[j];
                builder.append('\"');
                builder.append(rule2[0]);
                builder.append("\" \u2192 \"");
                builder.append(rule2[1]);
                builder.append("\"\n");
            }
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            return string2;
        }

        @NotNull
        public final Token scanRightArrow$avail() {
            return new Token(TokenType.ARROW, "\u2192");
        }

        @Nullable
        public final Token scanWhitespace$avail() {
            return null;
        }

        @NotNull
        public final Token scanUnknown$avail(int unknownChar) {
            char[] cArray = Character.toChars(unknownChar);
            Intrinsics.checkNotNullExpressionValue(cArray, "toChars(...)");
            char[] cArray2 = cArray;
            return new Token(TokenType.UNKNOWN, new String(cArray2));
        }

        private final ScannerAction actionFor(int c) {
            return c == 8594 ? ScannerAction.RIGHT_ARROW : (c >= scannerTable.length ? ScannerAction.UNKNOWN : ScannerAction.Companion.getAll$avail()[scannerTable[c]]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lavail/builder/RenamesFileParser$ScannerAction;", "", "(Ljava/lang/String;I)V", "scan", "Lavail/builder/RenamesFileParser$Token;", "parser", "Lavail/builder/RenamesFileParser;", "firstChar", "", "DOUBLE_QUOTE", "RIGHT_ARROW", "SLASH", "WHITESPACE", "UNKNOWN", "Companion", "avail"})
    @SourceDebugExtension(value={"SMAP\nRenamesFileParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenamesFileParser.kt\navail/builder/RenamesFileParser$ScannerAction\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,615:1\n37#2,2:616\n*S KotlinDebug\n*F\n+ 1 RenamesFileParser.kt\navail/builder/RenamesFileParser$ScannerAction\n*L\n372#1:616,2\n*E\n"})
    private static final abstract class ScannerAction
    extends Enum<ScannerAction> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final ScannerAction[] all;
        public static final /* enum */ ScannerAction DOUBLE_QUOTE;
        public static final /* enum */ ScannerAction RIGHT_ARROW;
        public static final /* enum */ ScannerAction SLASH;
        public static final /* enum */ ScannerAction WHITESPACE;
        public static final /* enum */ ScannerAction UNKNOWN;
        private static final /* synthetic */ ScannerAction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ScannerAction() {
        }

        @Nullable
        public abstract Token scan(@NotNull RenamesFileParser var1, int var2) throws IOException;

        public static ScannerAction[] values() {
            return (ScannerAction[])$VALUES.clone();
        }

        public static ScannerAction valueOf(String value) {
            return Enum.valueOf(ScannerAction.class, value);
        }

        @NotNull
        public static EnumEntries<ScannerAction> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ ScannerAction(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            DOUBLE_QUOTE = new DOUBLE_QUOTE("DOUBLE_QUOTE", 0);
            RIGHT_ARROW = new RIGHT_ARROW("RIGHT_ARROW", 1);
            SLASH = new SLASH("SLASH", 2);
            WHITESPACE = new WHITESPACE("WHITESPACE", 3);
            UNKNOWN = new UNKNOWN("UNKNOWN", 4);
            $VALUES = scannerActionArray = new ScannerAction[]{ScannerAction.DOUBLE_QUOTE, ScannerAction.RIGHT_ARROW, ScannerAction.SLASH, ScannerAction.WHITESPACE, ScannerAction.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Collection $this$toTypedArray$iv = ScannerAction.getEntries();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            all = thisCollection$iv.toArray(new ScannerAction[0]);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lavail/builder/RenamesFileParser$ScannerAction$Companion;", "", "()V", "all", "", "Lavail/builder/RenamesFileParser$ScannerAction;", "getAll$avail", "()[Lavail/builder/RenamesFileParser$ScannerAction;", "[Lavail/builder/RenamesFileParser$ScannerAction;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ScannerAction[] getAll$avail() {
                return all;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lavail/builder/RenamesFileParser$ScannerAction$DOUBLE_QUOTE;", "Lavail/builder/RenamesFileParser$ScannerAction;", "scan", "Lavail/builder/RenamesFileParser$Token;", "parser", "Lavail/builder/RenamesFileParser;", "firstChar", "", "avail"})
        static final class DOUBLE_QUOTE
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            DOUBLE_QUOTE() {
                void var1_1;
            }

            @Override
            @NotNull
            public Token scan(@NotNull RenamesFileParser parser, int firstChar) throws IOException {
                Intrinsics.checkNotNullParameter(parser, "parser");
                return parser.scanDoubleQuote$avail();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lavail/builder/RenamesFileParser$ScannerAction$RIGHT_ARROW;", "Lavail/builder/RenamesFileParser$ScannerAction;", "scan", "Lavail/builder/RenamesFileParser$Token;", "parser", "Lavail/builder/RenamesFileParser;", "firstChar", "", "avail"})
        static final class RIGHT_ARROW
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            RIGHT_ARROW() {
                void var1_1;
            }

            @Override
            @NotNull
            public Token scan(@NotNull RenamesFileParser parser, int firstChar) {
                Intrinsics.checkNotNullParameter(parser, "parser");
                return RenamesFileParser.Companion.scanRightArrow$avail();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lavail/builder/RenamesFileParser$ScannerAction$SLASH;", "Lavail/builder/RenamesFileParser$ScannerAction;", "scan", "Lavail/builder/RenamesFileParser$Token;", "parser", "Lavail/builder/RenamesFileParser;", "firstChar", "", "avail"})
        static final class SLASH
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            SLASH() {
                void var1_1;
            }

            @Override
            @Nullable
            public Token scan(@NotNull RenamesFileParser parser, int firstChar) throws IOException {
                Intrinsics.checkNotNullParameter(parser, "parser");
                return parser.scanSlash$avail();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lavail/builder/RenamesFileParser$ScannerAction$UNKNOWN;", "Lavail/builder/RenamesFileParser$ScannerAction;", "scan", "Lavail/builder/RenamesFileParser$Token;", "parser", "Lavail/builder/RenamesFileParser;", "firstChar", "", "avail"})
        static final class UNKNOWN
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            UNKNOWN() {
                void var1_1;
            }

            @Override
            @NotNull
            public Token scan(@NotNull RenamesFileParser parser, int firstChar) {
                Intrinsics.checkNotNullParameter(parser, "parser");
                return RenamesFileParser.Companion.scanUnknown$avail(firstChar);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lavail/builder/RenamesFileParser$ScannerAction$WHITESPACE;", "Lavail/builder/RenamesFileParser$ScannerAction;", "scan", "Lavail/builder/RenamesFileParser$Token;", "parser", "Lavail/builder/RenamesFileParser;", "firstChar", "", "avail"})
        static final class WHITESPACE
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            WHITESPACE() {
                void var1_1;
            }

            @Override
            @Nullable
            public Token scan(@NotNull RenamesFileParser parser, int firstChar) {
                Intrinsics.checkNotNullParameter(parser, "parser");
                return RenamesFileParser.Companion.scanWhitespace$avail();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lavail/builder/RenamesFileParser$Token;", "", "tokenType", "Lavail/builder/RenamesFileParser$TokenType;", "lexeme", "", "(Lavail/builder/RenamesFileParser$TokenType;Ljava/lang/String;)V", "getLexeme", "()Ljava/lang/String;", "getTokenType", "()Lavail/builder/RenamesFileParser$TokenType;", "avail"})
    public static final class Token {
        @NotNull
        private final TokenType tokenType;
        @NotNull
        private final String lexeme;

        public Token(@NotNull TokenType tokenType, @NotNull String lexeme) {
            Intrinsics.checkNotNullParameter((Object)tokenType, "tokenType");
            Intrinsics.checkNotNullParameter(lexeme, "lexeme");
            this.tokenType = tokenType;
            this.lexeme = lexeme;
        }

        @NotNull
        public final TokenType getTokenType() {
            return this.tokenType;
        }

        @NotNull
        public final String getLexeme() {
            return this.lexeme;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/builder/RenamesFileParser$TokenType;", "", "(Ljava/lang/String;I)V", "PATH", "ARROW", "UNKNOWN", "EOF", "avail"})
    public static final class TokenType
    extends Enum<TokenType> {
        public static final /* enum */ TokenType PATH = new TokenType();
        public static final /* enum */ TokenType ARROW = new TokenType();
        public static final /* enum */ TokenType UNKNOWN = new TokenType();
        public static final /* enum */ TokenType EOF = new TokenType();
        private static final /* synthetic */ TokenType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TokenType[] values() {
            return (TokenType[])$VALUES.clone();
        }

        public static TokenType valueOf(String value) {
            return Enum.valueOf(TokenType.class, value);
        }

        @NotNull
        public static EnumEntries<TokenType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tokenTypeArray = new TokenType[]{TokenType.PATH, TokenType.ARROW, TokenType.UNKNOWN, TokenType.EOF};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

