/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler;

import avail.compiler.AvailCompiler;
import avail.compiler.ParserState;
import avail.compiler.ParsingConversionRule;
import avail.compiler.ParsingOperation;
import avail.compiler.ParsingStepState;
import avail.compiler.problems.CompilerDiagnostics;
import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.bundles.A_BundleTree;
import avail.descriptor.maps.A_Map;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.DeclarationPhraseDescriptor;
import avail.descriptor.phrases.ListPhraseDescriptor;
import avail.descriptor.phrases.LiteralPhraseDescriptor;
import avail.descriptor.phrases.MacroSubstitutionPhraseDescriptor;
import avail.descriptor.phrases.PermutedListPhraseDescriptor;
import avail.descriptor.phrases.ReferencePhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.LiteralTokenDescriptor;
import avail.descriptor.tokens.TokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import avail.utility.PrefixSharingList;
import avail.utility.StackPrinterKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b$\b\u0086\u0081\u0002\u0018\u0000 G2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001GB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J-\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H \u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003H\u0016J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@j\u0002\bAj\u0002\bBj\u0002\bCj\u0002\bDj\u0002\bEj\u0002\bF\u00a8\u0006H"}, d2={"Lavail/compiler/ParsingOperation;", "", "modulus", "", "commutesWithParsePart", "", "canRunIfHasFirstArgument", "(Ljava/lang/String;IIZZ)V", "getCanRunIfHasFirstArgument", "()Z", "getCommutesWithParsePart", "encoding", "getEncoding", "()I", "expandingStatisticInNanoseconds", "Lavail/performance/Statistic;", "getExpandingStatisticInNanoseconds", "()Lavail/performance/Statistic;", "parsingStatisticInNanoseconds", "getParsingStatisticInNanoseconds", "checkArgumentIndex", "instruction", "describe", "", "operand", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "keywordIndex", "successorPcs", "", "currentPc", "typeCheckArgumentIndex", "EMPTY_LIST", "APPEND_ARGUMENT", "SAVE_PARSE_POSITION", "DISCARD_SAVED_PARSE_POSITION", "ENSURE_PARSE_PROGRESS", "PARSE_ARGUMENT", "PARSE_TOP_VALUED_ARGUMENT", "PARSE_VARIABLE_REFERENCE", "PARSE_ARGUMENT_IN_MODULE_SCOPE", "PARSE_ANY_RAW_TOKEN", "PARSE_RAW_KEYWORD_TOKEN", "PARSE_RAW_LITERAL_TOKEN", "CONCATENATE", "MATCH_INDENT", "INCREASE_INDENT", "NO_LINE_BREAK", "BRANCH_FORWARD", "JUMP_FORWARD", "JUMP_BACKWARD", "PARSE_PART", "PARSE_PART_CASE_INSENSITIVELY", "CHECK_ARGUMENT", "CONVERT", "PREPARE_TO_RUN_PREFIX_FUNCTION", "RUN_PREFIX_FUNCTION", "PERMUTE_LIST", "CHECK_AT_LEAST", "CHECK_AT_MOST", "TYPE_CHECK_ARGUMENT", "WRAP_IN_LIST", "PUSH_LITERAL", "REVERSE_STACK", "Companion", "avail"})
@SourceDebugExtension(value={"SMAP\nParsingOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParsingOperation.kt\navail/compiler/ParsingOperation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1517:1\n1#2:1518\n37#3,2:1519\n*S KotlinDebug\n*F\n+ 1 ParsingOperation.kt\navail/compiler/ParsingOperation\n*L\n1422#1:1519,2\n*E\n"})
public abstract class ParsingOperation
extends Enum<ParsingOperation> {
    @NotNull
    public static final Companion Companion;
    private final int modulus;
    private final boolean commutesWithParsePart;
    private final boolean canRunIfHasFirstArgument;
    @NotNull
    private final Statistic parsingStatisticInNanoseconds;
    @NotNull
    private final Statistic expandingStatisticInNanoseconds;
    @NotNull
    private static final ParsingOperation[] all;
    public static final int distinctInstructionsShift = 4;
    public static final int distinctInstructions = 16;
    public static final /* enum */ ParsingOperation EMPTY_LIST;
    public static final /* enum */ ParsingOperation APPEND_ARGUMENT;
    public static final /* enum */ ParsingOperation SAVE_PARSE_POSITION;
    public static final /* enum */ ParsingOperation DISCARD_SAVED_PARSE_POSITION;
    public static final /* enum */ ParsingOperation ENSURE_PARSE_PROGRESS;
    public static final /* enum */ ParsingOperation PARSE_ARGUMENT;
    public static final /* enum */ ParsingOperation PARSE_TOP_VALUED_ARGUMENT;
    public static final /* enum */ ParsingOperation PARSE_VARIABLE_REFERENCE;
    public static final /* enum */ ParsingOperation PARSE_ARGUMENT_IN_MODULE_SCOPE;
    public static final /* enum */ ParsingOperation PARSE_ANY_RAW_TOKEN;
    public static final /* enum */ ParsingOperation PARSE_RAW_KEYWORD_TOKEN;
    public static final /* enum */ ParsingOperation PARSE_RAW_LITERAL_TOKEN;
    public static final /* enum */ ParsingOperation CONCATENATE;
    public static final /* enum */ ParsingOperation MATCH_INDENT;
    public static final /* enum */ ParsingOperation INCREASE_INDENT;
    public static final /* enum */ ParsingOperation NO_LINE_BREAK;
    public static final /* enum */ ParsingOperation BRANCH_FORWARD;
    public static final /* enum */ ParsingOperation JUMP_FORWARD;
    public static final /* enum */ ParsingOperation JUMP_BACKWARD;
    public static final /* enum */ ParsingOperation PARSE_PART;
    public static final /* enum */ ParsingOperation PARSE_PART_CASE_INSENSITIVELY;
    public static final /* enum */ ParsingOperation CHECK_ARGUMENT;
    public static final /* enum */ ParsingOperation CONVERT;
    public static final /* enum */ ParsingOperation PREPARE_TO_RUN_PREFIX_FUNCTION;
    public static final /* enum */ ParsingOperation RUN_PREFIX_FUNCTION;
    public static final /* enum */ ParsingOperation PERMUTE_LIST;
    public static final /* enum */ ParsingOperation CHECK_AT_LEAST;
    public static final /* enum */ ParsingOperation CHECK_AT_MOST;
    public static final /* enum */ ParsingOperation TYPE_CHECK_ARGUMENT;
    public static final /* enum */ ParsingOperation WRAP_IN_LIST;
    public static final /* enum */ ParsingOperation PUSH_LITERAL;
    public static final /* enum */ ParsingOperation REVERSE_STACK;
    private static final /* synthetic */ ParsingOperation[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private ParsingOperation(int modulus, boolean commutesWithParsePart, boolean canRunIfHasFirstArgument) {
        this.modulus = modulus;
        this.commutesWithParsePart = commutesWithParsePart;
        this.canRunIfHasFirstArgument = canRunIfHasFirstArgument;
        this.parsingStatisticInNanoseconds = new Statistic(StatisticReport.RUNNING_PARSING_INSTRUCTIONS, this.name());
        this.expandingStatisticInNanoseconds = new Statistic(StatisticReport.EXPANDING_PARSING_INSTRUCTIONS, this.name());
    }

    public final boolean getCommutesWithParsePart() {
        return this.commutesWithParsePart;
    }

    public final boolean getCanRunIfHasFirstArgument() {
        return this.canRunIfHasFirstArgument;
    }

    @NotNull
    public final Statistic getParsingStatisticInNanoseconds() {
        return this.parsingStatisticInNanoseconds;
    }

    @NotNull
    public final Statistic getExpandingStatisticInNanoseconds() {
        return this.expandingStatisticInNanoseconds;
    }

    public final int getEncoding() {
        if (this.ordinal() >= 16) {
            throw new UnsupportedOperationException();
        }
        return this.modulus;
    }

    @NotNull
    public String describe(int operand) {
        return operand == 0 ? this.name() : this.name() + " (#" + operand + ")";
    }

    public final int encoding(int operand) {
        boolean bl;
        boolean bl2;
        if (this.ordinal() < 16) {
            throw new UnsupportedOperationException();
        }
        boolean bl3 = bl2 = operand > 0 || operand == -1;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int result2 = (operand << 4) + this.modulus;
        boolean bl4 = bl = Companion.operand(result2) == operand;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string3 = "Overflow detected";
            throw new AssertionError((Object)string3);
        }
        return result2;
    }

    public int keywordIndex(int instruction2) {
        return 0;
    }

    @NotNull
    public List<Integer> successorPcs(int instruction2, int currentPc) {
        return CollectionsKt.listOf(currentPc + 1);
    }

    public int checkArgumentIndex(int instruction2) {
        return 0;
    }

    public int typeCheckArgumentIndex(int instruction2) {
        throw new RuntimeException("Parsing instruction is inappropriate");
    }

    public abstract void execute$avail(@NotNull AvailCompiler var1, @NotNull ParsingStepState var2, int var3, @NotNull A_BundleTree var4);

    public static ParsingOperation[] values() {
        return (ParsingOperation[])$VALUES.clone();
    }

    public static ParsingOperation valueOf(String value) {
        return Enum.valueOf(ParsingOperation.class, value);
    }

    @NotNull
    public static EnumEntries<ParsingOperation> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ ParsingOperation(String $enum$name, int $enum$ordinal, int modulus, boolean commutesWithParsePart, boolean canRunIfHasFirstArgument, DefaultConstructorMarker $constructor_marker) {
        this(modulus, commutesWithParsePart, canRunIfHasFirstArgument);
    }

    static {
        EMPTY_LIST = new EMPTY_LIST("EMPTY_LIST", 0);
        APPEND_ARGUMENT = new APPEND_ARGUMENT("APPEND_ARGUMENT", 1);
        SAVE_PARSE_POSITION = new SAVE_PARSE_POSITION("SAVE_PARSE_POSITION", 2);
        DISCARD_SAVED_PARSE_POSITION = new DISCARD_SAVED_PARSE_POSITION("DISCARD_SAVED_PARSE_POSITION", 3);
        ENSURE_PARSE_PROGRESS = new ENSURE_PARSE_PROGRESS("ENSURE_PARSE_PROGRESS", 4);
        PARSE_ARGUMENT = new PARSE_ARGUMENT("PARSE_ARGUMENT", 5);
        PARSE_TOP_VALUED_ARGUMENT = new PARSE_TOP_VALUED_ARGUMENT("PARSE_TOP_VALUED_ARGUMENT", 6);
        PARSE_VARIABLE_REFERENCE = new PARSE_VARIABLE_REFERENCE("PARSE_VARIABLE_REFERENCE", 7);
        PARSE_ARGUMENT_IN_MODULE_SCOPE = new PARSE_ARGUMENT_IN_MODULE_SCOPE("PARSE_ARGUMENT_IN_MODULE_SCOPE", 8);
        PARSE_ANY_RAW_TOKEN = new PARSE_ANY_RAW_TOKEN("PARSE_ANY_RAW_TOKEN", 9);
        PARSE_RAW_KEYWORD_TOKEN = new PARSE_RAW_KEYWORD_TOKEN("PARSE_RAW_KEYWORD_TOKEN", 10);
        PARSE_RAW_LITERAL_TOKEN = new PARSE_RAW_LITERAL_TOKEN("PARSE_RAW_LITERAL_TOKEN", 11);
        CONCATENATE = new CONCATENATE("CONCATENATE", 12);
        MATCH_INDENT = new MATCH_INDENT("MATCH_INDENT", 13);
        INCREASE_INDENT = new INCREASE_INDENT("INCREASE_INDENT", 14);
        NO_LINE_BREAK = new NO_LINE_BREAK("NO_LINE_BREAK", 15);
        BRANCH_FORWARD = new BRANCH_FORWARD("BRANCH_FORWARD", 16);
        JUMP_FORWARD = new JUMP_FORWARD("JUMP_FORWARD", 17);
        JUMP_BACKWARD = new JUMP_BACKWARD("JUMP_BACKWARD", 18);
        PARSE_PART = new PARSE_PART("PARSE_PART", 19);
        PARSE_PART_CASE_INSENSITIVELY = new PARSE_PART_CASE_INSENSITIVELY("PARSE_PART_CASE_INSENSITIVELY", 20);
        CHECK_ARGUMENT = new CHECK_ARGUMENT("CHECK_ARGUMENT", 21);
        CONVERT = new CONVERT("CONVERT", 22);
        PREPARE_TO_RUN_PREFIX_FUNCTION = new PREPARE_TO_RUN_PREFIX_FUNCTION("PREPARE_TO_RUN_PREFIX_FUNCTION", 23);
        RUN_PREFIX_FUNCTION = new RUN_PREFIX_FUNCTION("RUN_PREFIX_FUNCTION", 24);
        PERMUTE_LIST = new PERMUTE_LIST("PERMUTE_LIST", 25);
        CHECK_AT_LEAST = new CHECK_AT_LEAST("CHECK_AT_LEAST", 26);
        CHECK_AT_MOST = new CHECK_AT_MOST("CHECK_AT_MOST", 27);
        TYPE_CHECK_ARGUMENT = new TYPE_CHECK_ARGUMENT("TYPE_CHECK_ARGUMENT", 28);
        WRAP_IN_LIST = new WRAP_IN_LIST("WRAP_IN_LIST", 29);
        PUSH_LITERAL = new PUSH_LITERAL("PUSH_LITERAL", 30);
        REVERSE_STACK = new REVERSE_STACK("REVERSE_STACK", 31);
        $VALUES = parsingOperationArray = new ParsingOperation[]{ParsingOperation.EMPTY_LIST, ParsingOperation.APPEND_ARGUMENT, ParsingOperation.SAVE_PARSE_POSITION, ParsingOperation.DISCARD_SAVED_PARSE_POSITION, ParsingOperation.ENSURE_PARSE_PROGRESS, ParsingOperation.PARSE_ARGUMENT, ParsingOperation.PARSE_TOP_VALUED_ARGUMENT, ParsingOperation.PARSE_VARIABLE_REFERENCE, ParsingOperation.PARSE_ARGUMENT_IN_MODULE_SCOPE, ParsingOperation.PARSE_ANY_RAW_TOKEN, ParsingOperation.PARSE_RAW_KEYWORD_TOKEN, ParsingOperation.PARSE_RAW_LITERAL_TOKEN, ParsingOperation.CONCATENATE, ParsingOperation.MATCH_INDENT, ParsingOperation.INCREASE_INDENT, ParsingOperation.NO_LINE_BREAK, ParsingOperation.BRANCH_FORWARD, ParsingOperation.JUMP_FORWARD, ParsingOperation.JUMP_BACKWARD, ParsingOperation.PARSE_PART, ParsingOperation.PARSE_PART_CASE_INSENSITIVELY, ParsingOperation.CHECK_ARGUMENT, ParsingOperation.CONVERT, ParsingOperation.PREPARE_TO_RUN_PREFIX_FUNCTION, ParsingOperation.RUN_PREFIX_FUNCTION, ParsingOperation.PERMUTE_LIST, ParsingOperation.CHECK_AT_LEAST, ParsingOperation.CHECK_AT_MOST, ParsingOperation.TYPE_CHECK_ARGUMENT, ParsingOperation.WRAP_IN_LIST, ParsingOperation.PUSH_LITERAL, ParsingOperation.REVERSE_STACK};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        Collection $this$toTypedArray$iv = ParsingOperation.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        all = thisCollection$iv.toArray(new ParsingOperation[0]);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$APPEND_ARGUMENT;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class APPEND_ARGUMENT
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        APPEND_ARGUMENT() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            A_Phrase value = stepState.pop();
            A_Phrase list2 = stepState.pop();
            stepState.push(A_Phrase.Companion.copyWith(list2, value));
            compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lavail/compiler/ParsingOperation$BRANCH_FORWARD;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "successorPcs", "", "currentPc", "avail"})
    static final class BRANCH_FORWARD
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        BRANCH_FORWARD() {
            void var1_1;
        }

        @Override
        @NotNull
        public List<Integer> successorPcs(int instruction2, int currentPc) {
            Integer[] integerArray = new Integer[]{Companion.operand(instruction2), currentPc + 1};
            return CollectionsKt.listOf(integerArray);
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            throw new UnsupportedOperationException(this.name() + " instruction should not be dispatched");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J-\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lavail/compiler/ParsingOperation$CHECK_ARGUMENT;", "Lavail/compiler/ParsingOperation;", "checkArgumentIndex", "", "instruction", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class CHECK_ARGUMENT
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        CHECK_ARGUMENT() {
            void var1_1;
        }

        @Override
        public int checkArgumentIndex(int instruction2) {
            return Companion.operand(instruction2);
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            boolean bl;
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            boolean bl2 = bl = stepState.getFirstArgOrNull() == null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$CHECK_AT_LEAST;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class CHECK_AT_LEAST
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        CHECK_AT_LEAST() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            int limit = Companion.operand(instruction2);
            A_Phrase top = CollectionsKt.last(stepState.getArgsSoFar());
            if (A_Phrase.Companion.getExpressionsSize(top) >= limit) {
                compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$CHECK_AT_MOST;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class CHECK_AT_MOST
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        CHECK_AT_MOST() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            int limit = Companion.operand(instruction2);
            A_Phrase top = CollectionsKt.last(stepState.getArgsSoFar());
            if (A_Phrase.Companion.getExpressionsSize(top) <= limit) {
                compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$CONCATENATE;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class CONCATENATE
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        CONCATENATE() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            A_Phrase right = stepState.pop();
            A_Phrase left = stepState.pop();
            if (A_Phrase.Companion.getExpressionsSize(left) == 0) {
                stepState.push(right);
            } else {
                stepState.push(A_Phrase.Companion.copyConcatenating(left, right));
            }
            compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lavail/compiler/ParsingOperation$CONVERT;", "Lavail/compiler/ParsingOperation;", "describe", "", "operand", "", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class CONVERT
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        CONVERT() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            A_Phrase input = stepState.pop();
            AtomicBoolean sanityFlag = new AtomicBoolean();
            ParsingConversionRule conversionRule = ParsingConversionRule.Companion.ruleNumber(Companion.operand(instruction2));
            conversionRule.convert(compiler2.getCompilationContext(), stepState.getStart().getLexingState(), input, (Function1<? super A_Phrase, Unit>)new Function1<A_Phrase, Unit>(sanityFlag, stepState, compiler2, successorTree){
                final /* synthetic */ AtomicBoolean $sanityFlag;
                final /* synthetic */ ParsingStepState $stepState;
                final /* synthetic */ AvailCompiler $compiler;
                final /* synthetic */ A_BundleTree $successorTree;
                {
                    this.$sanityFlag = $sanityFlag;
                    this.$stepState = $stepState;
                    this.$compiler = $compiler;
                    this.$successorTree = $successorTree;
                    super(1);
                }

                public final void invoke(@NotNull A_Phrase replacementExpression) {
                    Intrinsics.checkNotNullParameter(replacementExpression, "replacementExpression");
                    boolean bl = this.$sanityFlag.compareAndSet(false, true);
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    this.$stepState.push(replacementExpression);
                    this.$compiler.eventuallyParseRestOfSendNode$avail(this.$successorTree, this.$stepState);
                }
            }, (Function1<? super Throwable, Unit>)new Function1<Throwable, Unit>(sanityFlag, stepState){
                final /* synthetic */ AtomicBoolean $sanityFlag;
                final /* synthetic */ ParsingStepState $stepState;
                {
                    this.$sanityFlag = $sanityFlag;
                    this.$stepState = $stepState;
                    super(1);
                }

                public final void invoke(@NotNull Throwable e) {
                    Intrinsics.checkNotNullParameter(e, "e");
                    boolean bl = this.$sanityFlag.compareAndSet(false, true);
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    this.$stepState.getStart().expected$avail(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(e){
                        final /* synthetic */ Throwable $e;
                        {
                            this.$e = $e;
                            super(1);
                        }

                        public final void invoke(@NotNull Function1<? super String, Unit> it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            it.invoke("evaluation of expression not to have thrown Java exception:\n" + StackPrinterKt.getStackToString(this.$e));
                        }
                    });
                }
            });
        }

        @Override
        @NotNull
        public String describe(int operand) {
            return super.describe(operand) + " = " + ParsingConversionRule.Companion.ruleNumber(operand);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\nJ,\u0010\u0013\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nR\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lavail/compiler/ParsingOperation$Companion;", "", "()V", "all", "", "Lavail/compiler/ParsingOperation;", "getAll$avail", "()[Lavail/compiler/ParsingOperation;", "[Lavail/compiler/ParsingOperation;", "distinctInstructions", "", "distinctInstructionsShift", "q", "", "Lavail/descriptor/tuples/A_String;", "getQ", "(Lavail/descriptor/tuples/A_String;)Ljava/lang/String;", "decode", "instruction", "describeWhyVariableUseIsExpected", "Lkotlin/Function1;", "", "Lavail/utility/evaluation/Describer;", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "operand", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ParsingOperation[] getAll$avail() {
            return all;
        }

        public final int operand(int instruction2) {
            return instruction2 >> 4;
        }

        @NotNull
        public final ParsingOperation decode(int instruction2) {
            if (instruction2 < 16) {
                return this.getAll$avail()[instruction2];
            }
            int subscript = (instruction2 & 0xF) + 16;
            return this.getAll$avail()[subscript];
        }

        private final Function1<Function1<? super String, Unit>, Unit> describeWhyVariableUseIsExpected(A_BundleTree successorTree) {
            return new Function1<Function1<? super String, ? extends Unit>, Unit>(successorTree){
                final /* synthetic */ A_BundleTree $successorTree;
                {
                    this.$successorTree = $successorTree;
                    super(1);
                }

                public final void invoke(@NotNull Function1<? super String, Unit> continuation) {
                    Intrinsics.checkNotNullParameter(continuation, "continuation");
                    A_Set bundles = A_Map.Companion.getKeysAsSet(A_BundleTree.Companion.getAllParsingPlansInProgress(this.$successorTree));
                    StringBuilder builder = new StringBuilder();
                    builder.append("a variable use, for one of:");
                    if (A_Set.Companion.getSetSize(bundles) > 2) {
                        builder.append("\n\t");
                    } else {
                        builder.append(' ');
                    }
                    boolean first = true;
                    for (AvailObject bundle : bundles) {
                        if (!first) {
                            builder.append(", ");
                        }
                        builder.append(A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(bundle)));
                        first = false;
                    }
                    String string2 = builder.toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                    continuation.invoke(string2);
                }
            };
        }

        private final String getQ(A_String $this$q) {
            return A_Tuple.Companion.getTupleSize($this$q) == 0 ? "\"\"" : $this$q.toString();
        }

        public static final /* synthetic */ Function1 access$describeWhyVariableUseIsExpected(Companion $this, A_BundleTree successorTree) {
            return $this.describeWhyVariableUseIsExpected(successorTree);
        }

        public static final /* synthetic */ String access$getQ(Companion $this, A_String $receiver) {
            return $this.getQ($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$DISCARD_SAVED_PARSE_POSITION;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class DISCARD_SAVED_PARSE_POSITION
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        DISCARD_SAVED_PARSE_POSITION() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            stepState.popMarker();
            compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$EMPTY_LIST;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class EMPTY_LIST
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        EMPTY_LIST() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            stepState.push(ListPhraseDescriptor.Companion.emptyListNode());
            compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$ENSURE_PARSE_PROGRESS;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class ENSURE_PARSE_PROGRESS
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        ENSURE_PARSE_PROGRESS() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            int oldMarker = stepState.popMarker();
            int newMarker = stepState.getStart().getPosition();
            if (oldMarker != newMarker) {
                stepState.pushMarker(newMarker);
                compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$INCREASE_INDENT;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class INCREASE_INDENT
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        INCREASE_INDENT() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            AvailCompiler.Companion.skipWhitespaceAndComments(stepState.getStart(), (Function1<? super List<ParserState>, Unit>)new Function1<List<? extends ParserState>, Unit>(stepState, compiler2, successorTree){
                final /* synthetic */ ParsingStepState $stepState;
                final /* synthetic */ AvailCompiler $compiler;
                final /* synthetic */ A_BundleTree $successorTree;
                {
                    this.$stepState = $stepState;
                    this.$compiler = $compiler;
                    this.$successorTree = $successorTree;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull List<ParserState> successorStates) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter(successorStates, "successorStates");
                    Iterable iterable = successorStates;
                    ParsingStepState parsingStepState = this.$stepState;
                    AvailCompiler availCompiler = this.$compiler;
                    A_BundleTree a_BundleTree = this.$successorTree;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ParserState parsingState = (ParserState)element$iv;
                        boolean bl = false;
                        ParsingStepState state2 = parsingStepState.copy((Function1<? super ParsingStepState, Unit>)new Function1<ParsingStepState, Unit>(parsingState){
                            final /* synthetic */ ParserState $parsingState;
                            {
                                this.$parsingState = $parsingState;
                                super(1);
                            }

                            public final void invoke(@NotNull ParsingStepState $this$copy) {
                                Intrinsics.checkNotNullParameter($this$copy, "$this$copy");
                                $this$copy.setStart(this.$parsingState);
                            }
                        });
                        A_String initialIndent = state2.initialIndentationString();
                        A_String currentIndent = state2.currentIndentationString();
                        if (currentIndent == null) {
                            state2.getStart().expected$avail(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(initialIndent){
                                final /* synthetic */ A_String $initialIndent;
                                {
                                    this.$initialIndent = $initialIndent;
                                    super(1);
                                }

                                public final void invoke(@NotNull Function1<? super String, Unit> accept) {
                                    Intrinsics.checkNotNullParameter(accept, "accept");
                                    accept.invoke("an indentation to exceed that at the beginning of the phrase (" + avail.compiler.ParsingOperation$Companion.access$getQ(ParsingOperation.Companion, this.$initialIndent) + "), but this position is not after leading whitespace on the line");
                                }
                            });
                            continue;
                        }
                        if (A_Tuple.Companion.getTupleSize(currentIndent) > A_Tuple.Companion.getTupleSize(initialIndent) && A_Tuple.Companion.compareFromToWithStartingAt(currentIndent, 1, A_Tuple.Companion.getTupleSize(initialIndent), initialIndent, 1)) {
                            availCompiler.eventuallyParseRestOfSendNode$avail(a_BundleTree, state2);
                            continue;
                        }
                        if (initialIndent.equals(currentIndent)) {
                            state2.getStart().expected$avail(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(currentIndent){
                                final /* synthetic */ A_String $currentIndent;
                                {
                                    this.$currentIndent = $currentIndent;
                                    super(1);
                                }

                                public final void invoke(@NotNull Function1<? super String, Unit> accept) {
                                    Intrinsics.checkNotNullParameter(accept, "accept");
                                    accept.invoke("the indentation at this position to be strictly deeper than at the beginning of the phrase, but they're equal (" + avail.compiler.ParsingOperation$Companion.access$getQ(ParsingOperation.Companion, this.$currentIndent) + ").");
                                }
                            });
                            continue;
                        }
                        if (currentIndent.equals(initialIndent)) {
                            state2.getStart().expected$avail(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(initialIndent, currentIndent){
                                final /* synthetic */ A_String $initialIndent;
                                final /* synthetic */ A_String $currentIndent;
                                {
                                    this.$initialIndent = $initialIndent;
                                    this.$currentIndent = $currentIndent;
                                    super(1);
                                }

                                public final void invoke(@NotNull Function1<? super String, Unit> accept) {
                                    Intrinsics.checkNotNullParameter(accept, "accept");
                                    accept.invoke("the indentation at this position to be strictly deeper than at the beginning of the phrase. The initial indentation is " + avail.compiler.ParsingOperation$Companion.access$getQ(ParsingOperation.Companion, this.$initialIndent) + ", but the current indentation is " + avail.compiler.ParsingOperation$Companion.access$getQ(ParsingOperation.Companion, this.$currentIndent) + ".");
                                }
                            });
                            continue;
                        }
                        state2.getStart().expected$avail(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(initialIndent, currentIndent){
                            final /* synthetic */ A_String $initialIndent;
                            final /* synthetic */ A_String $currentIndent;
                            {
                                this.$initialIndent = $initialIndent;
                                this.$currentIndent = $currentIndent;
                                super(1);
                            }

                            public final void invoke(@NotNull Function1<? super String, Unit> accept) {
                                Intrinsics.checkNotNullParameter(accept, "accept");
                                accept.invoke("the indentation to exceed that at the beginning of the phrase. The indentation at the beginning was " + avail.compiler.ParsingOperation$Companion.access$getQ(ParsingOperation.Companion, this.$initialIndent) + ", but the current line begins with " + avail.compiler.ParsingOperation$Companion.access$getQ(ParsingOperation.Companion, this.$currentIndent) + ".");
                            }
                        });
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lavail/compiler/ParsingOperation$JUMP_BACKWARD;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "successorPcs", "", "currentPc", "avail"})
    static final class JUMP_BACKWARD
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        JUMP_BACKWARD() {
            void var1_1;
        }

        @Override
        @NotNull
        public List<Integer> successorPcs(int instruction2, int currentPc) {
            return CollectionsKt.listOf(Companion.operand(instruction2));
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            throw new UnsupportedOperationException(this.name() + " instruction should not be dispatched");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lavail/compiler/ParsingOperation$JUMP_FORWARD;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "successorPcs", "", "currentPc", "avail"})
    static final class JUMP_FORWARD
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        JUMP_FORWARD() {
            void var1_1;
        }

        @Override
        @NotNull
        public List<Integer> successorPcs(int instruction2, int currentPc) {
            return CollectionsKt.listOf(Companion.operand(instruction2));
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            throw new UnsupportedOperationException(this.name() + " instruction should not be dispatched");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$MATCH_INDENT;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class MATCH_INDENT
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        MATCH_INDENT() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            AvailCompiler.Companion.skipWhitespaceAndComments(stepState.getStart(), (Function1<? super List<ParserState>, Unit>)new Function1<List<? extends ParserState>, Unit>(stepState, compiler2, successorTree){
                final /* synthetic */ ParsingStepState $stepState;
                final /* synthetic */ AvailCompiler $compiler;
                final /* synthetic */ A_BundleTree $successorTree;
                {
                    this.$stepState = $stepState;
                    this.$compiler = $compiler;
                    this.$successorTree = $successorTree;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull List<ParserState> successorStates) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter(successorStates, "successorStates");
                    Iterable iterable = successorStates;
                    ParsingStepState parsingStepState = this.$stepState;
                    AvailCompiler availCompiler = this.$compiler;
                    A_BundleTree a_BundleTree = this.$successorTree;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ParserState parsingState = (ParserState)element$iv;
                        boolean bl = false;
                        ParsingStepState state2 = parsingStepState.copy((Function1<? super ParsingStepState, Unit>)new Function1<ParsingStepState, Unit>(parsingState){
                            final /* synthetic */ ParserState $parsingState;
                            {
                                this.$parsingState = $parsingState;
                                super(1);
                            }

                            public final void invoke(@NotNull ParsingStepState $this$copy) {
                                Intrinsics.checkNotNullParameter($this$copy, "$this$copy");
                                $this$copy.setStart(this.$parsingState);
                            }
                        });
                        A_String initialIndent = state2.initialIndentationString();
                        A_String currentIndent = state2.currentIndentationString();
                        if (currentIndent == null) {
                            state2.getStart().expected$avail(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(initialIndent){
                                final /* synthetic */ A_String $initialIndent;
                                {
                                    this.$initialIndent = $initialIndent;
                                    super(1);
                                }

                                public final void invoke(@NotNull Function1<? super String, Unit> accept) {
                                    Intrinsics.checkNotNullParameter(accept, "accept");
                                    accept.invoke("an indentation to match that at the beginning of the phrase (" + avail.compiler.ParsingOperation$Companion.access$getQ(ParsingOperation.Companion, this.$initialIndent) + "), but this position is not after leading whitespace on the line");
                                }
                            });
                            continue;
                        }
                        if (!currentIndent.equals(initialIndent)) {
                            state2.getStart().expected$avail(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(initialIndent, currentIndent){
                                final /* synthetic */ A_String $initialIndent;
                                final /* synthetic */ A_String $currentIndent;
                                {
                                    this.$initialIndent = $initialIndent;
                                    this.$currentIndent = $currentIndent;
                                    super(1);
                                }

                                public final void invoke(@NotNull Function1<? super String, Unit> accept) {
                                    Intrinsics.checkNotNullParameter(accept, "accept");
                                    accept.invoke("the indentation to exactly match that at the beginning of the phrase. The indentation at the beginning was " + avail.compiler.ParsingOperation$Companion.access$getQ(ParsingOperation.Companion, this.$initialIndent) + ", but the current line begins with " + avail.compiler.ParsingOperation$Companion.access$getQ(ParsingOperation.Companion, this.$currentIndent) + ".");
                                }
                            });
                            continue;
                        }
                        availCompiler.eventuallyParseRestOfSendNode$avail(a_BundleTree, state2);
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$NO_LINE_BREAK;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class NO_LINE_BREAK
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        NO_LINE_BREAK() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            int line = stepState.getStart().getLineNumber();
            AvailCompiler.Companion.skipWhitespaceAndComments(stepState.getStart(), (Function1<? super List<ParserState>, Unit>)new Function1<List<? extends ParserState>, Unit>(line, compiler2, successorTree, stepState){
                final /* synthetic */ int $line;
                final /* synthetic */ AvailCompiler $compiler;
                final /* synthetic */ A_BundleTree $successorTree;
                final /* synthetic */ ParsingStepState $stepState;
                {
                    this.$line = $line;
                    this.$compiler = $compiler;
                    this.$successorTree = $successorTree;
                    this.$stepState = $stepState;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull List<ParserState> successorStates) {
                    void $this$partition$iv;
                    Intrinsics.checkNotNullParameter(successorStates, "successorStates");
                    Iterable iterable = successorStates;
                    int n = this.$line;
                    boolean $i$f$partition2 = false;
                    Object first$iv = new ArrayList<T>();
                    Object second$iv = new ArrayList<T>();
                    for (T element$iv : $this$partition$iv) {
                        ParserState it = (ParserState)element$iv;
                        boolean bl = false;
                        if (it.getLineNumber() == n) {
                            ((ArrayList)first$iv).add(element$iv);
                            continue;
                        }
                        ((ArrayList)second$iv).add(element$iv);
                    }
                    Pair<ArrayList<E>, ArrayList<E>> pair = new Pair<ArrayList<E>, ArrayList<E>>(first$iv, second$iv);
                    List sameLine = pair.component1();
                    List otherLine = pair.component2();
                    if (!((Collection)sameLine).isEmpty()) {
                        void $this$forEach$iv;
                        Iterable $i$f$partition2 = sameLine;
                        first$iv = this.$compiler;
                        second$iv = this.$successorTree;
                        ParsingStepState parsingStepState = this.$stepState;
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            ParserState s = (ParserState)element$iv;
                            boolean bl = false;
                            ((AvailCompiler)first$iv).eventuallyParseRestOfSendNode$avail((A_BundleTree)second$iv, parsingStepState.copy((Function1<? super ParsingStepState, Unit>)new Function1<ParsingStepState, Unit>(s){
                                final /* synthetic */ ParserState $s;
                                {
                                    this.$s = $s;
                                    super(1);
                                }

                                public final void invoke(@NotNull ParsingStepState $this$copy) {
                                    Intrinsics.checkNotNullParameter($this$copy, "$this$copy");
                                    $this$copy.setStart(this.$s);
                                }
                            }));
                        }
                    } else if (!((Collection)otherLine).isEmpty()) {
                        T t;
                        Iterable $this$maxBy$iv = otherLine;
                        boolean $i$f$maxByOrThrow = false;
                        Iterator<T> iterator$iv = $this$maxBy$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        T maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            t = maxElem$iv;
                        } else {
                            ParserState p0 = (ParserState)maxElem$iv;
                            boolean bl = false;
                            int maxValue$iv = p0.getPosition();
                            do {
                                T e$iv = iterator$iv.next();
                                ParserState p02 = (ParserState)e$iv;
                                $i$a$-maxByOrThrow-ParsingOperation$NO_LINE_BREAK$execute$1$furthest$1 = false;
                                int v$iv = p02.getPosition();
                                if (maxValue$iv >= v$iv) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            t = maxElem$iv;
                        }
                        ParserState furthest = (ParserState)t;
                        furthest.expected$avail(CompilerDiagnostics.ParseNotificationLevel.WEAK, execute.3.INSTANCE);
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$PARSE_ANY_RAW_TOKEN;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class PARSE_ANY_RAW_TOKEN
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PARSE_ANY_RAW_TOKEN() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            if (stepState.getFirstArgOrNull() != null) {
                return;
            }
            compiler2.nextNonwhitespaceTokensDo$avail(stepState.getStart(), (Function1<? super A_Token, Unit>)new Function1<A_Token, Unit>(stepState, compiler2, successorTree){
                final /* synthetic */ ParsingStepState $stepState;
                final /* synthetic */ AvailCompiler $compiler;
                final /* synthetic */ A_BundleTree $successorTree;
                {
                    this.$stepState = $stepState;
                    this.$compiler = $compiler;
                    this.$successorTree = $successorTree;
                    super(1);
                }

                public final void invoke(@NotNull A_Token token) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(token, "token");
                    TokenDescriptor.TokenType tokenType = token.tokenType();
                    boolean bl2 = bl = tokenType != TokenDescriptor.TokenType.WHITESPACE && tokenType != TokenDescriptor.TokenType.COMMENT;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    if (tokenType == TokenDescriptor.TokenType.END_OF_FILE) {
                        this.$stepState.getStart().expected$avail(this.$stepState.getStaticTokens().isEmpty() ? CompilerDiagnostics.ParseNotificationLevel.WEAK : CompilerDiagnostics.ParseNotificationLevel.STRONG, "any token, not end-of-file");
                        return;
                    }
                    AvailObject syntheticToken = LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, token.string(), token.start(), token.lineNumber(), token, token.getGeneratingLexer(), null, 32, null);
                    syntheticToken.setCurrentModule(this.$compiler.getCompilationContext().getModule());
                    ParsingStepState stepStateCopy2 = this.$stepState.copy((Function1<? super ParsingStepState, Unit>)new Function1<ParsingStepState, Unit>(token, this.$stepState, syntheticToken){
                        final /* synthetic */ A_Token $token;
                        final /* synthetic */ ParsingStepState $stepState;
                        final /* synthetic */ AvailObject $syntheticToken;
                        {
                            this.$token = $token;
                            this.$stepState = $stepState;
                            this.$syntheticToken = $syntheticToken;
                            super(1);
                        }

                        public final void invoke(@NotNull ParsingStepState $this$copy) {
                            Intrinsics.checkNotNullParameter($this$copy, "$this$copy");
                            $this$copy.setStart(new ParserState(this.$token.nextLexingState(), this.$stepState.getStart().getClientDataMap()));
                            $this$copy.setConsumedAnythingBeforeLatestArgument($this$copy.getConsumedAnything());
                            $this$copy.setConsumedAnything(true);
                            $this$copy.setFirstArgOrNull(null);
                            $this$copy.push(LiteralPhraseDescriptor.Companion.literalNodeFromToken(this.$syntheticToken));
                        }
                    });
                    this.$compiler.eventuallyParseRestOfSendNode$avail(this.$successorTree, stepStateCopy2);
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$PARSE_ARGUMENT;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class PARSE_ARGUMENT
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PARSE_ARGUMENT() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            AvailCompiler.PartialSubexpressionList partialSubexpressionList;
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            if (stepState.getFirstArgOrNull() == null) {
                AvailCompiler.PartialSubexpressionList partialSubexpressionList2 = stepState.getSuperexpressions();
                Intrinsics.checkNotNull(partialSubexpressionList2);
                partialSubexpressionList = partialSubexpressionList2.advancedTo(successorTree);
            } else {
                partialSubexpressionList = stepState.getSuperexpressions();
            }
            AvailCompiler.PartialSubexpressionList partialSubexpressionList3 = partialSubexpressionList;
            compiler2.parseSendArgumentWithExplanationThen$avail(stepState.getStart(), "argument", stepState.getFirstArgOrNull(), stepState.getFirstArgOrNull() == null && !Intrinsics.areEqual(stepState.getInitialTokenPosition().getLexingState(), stepState.getStart().getLexingState()), false, partialSubexpressionList3, (Function2<? super ParserState, ? super A_Phrase, Unit>)new Function2<ParserState, A_Phrase, Unit>(stepState, compiler2, successorTree){
                final /* synthetic */ ParsingStepState $stepState;
                final /* synthetic */ AvailCompiler $compiler;
                final /* synthetic */ A_BundleTree $successorTree;
                {
                    this.$stepState = $stepState;
                    this.$compiler = $compiler;
                    this.$successorTree = $successorTree;
                    super(2);
                }

                public final void invoke(@NotNull ParserState afterArg, @NotNull A_Phrase phrase) {
                    Intrinsics.checkNotNullParameter(afterArg, "afterArg");
                    Intrinsics.checkNotNullParameter(phrase, "phrase");
                    ParsingStepState stepStateCopy2 = this.$stepState.copy((Function1<? super ParsingStepState, Unit>)new Function1<ParsingStepState, Unit>(afterArg, phrase){
                        final /* synthetic */ ParserState $afterArg;
                        final /* synthetic */ A_Phrase $phrase;
                        {
                            this.$afterArg = $afterArg;
                            this.$phrase = $phrase;
                            super(1);
                        }

                        public final void invoke(@NotNull ParsingStepState $this$copy) {
                            Intrinsics.checkNotNullParameter($this$copy, "$this$copy");
                            $this$copy.setStart(this.$afterArg);
                            $this$copy.setConsumedAnythingBeforeLatestArgument($this$copy.getConsumedAnything());
                            $this$copy.setConsumedAnything($this$copy.getFirstArgOrNull() == null);
                            $this$copy.setFirstArgOrNull(null);
                            $this$copy.push(this.$phrase);
                        }
                    });
                    this.$compiler.eventuallyParseRestOfSendNode$avail(this.$successorTree, stepStateCopy2);
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$PARSE_ARGUMENT_IN_MODULE_SCOPE;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class PARSE_ARGUMENT_IN_MODULE_SCOPE
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PARSE_ARGUMENT_IN_MODULE_SCOPE() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            compiler2.parseArgumentInModuleScopeThen$avail(stepState, successorTree);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/compiler/ParsingOperation$PARSE_PART;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "keywordIndex", "avail"})
    static final class PARSE_PART
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PARSE_PART() {
            void var1_1;
        }

        @Override
        public int keywordIndex(int instruction2) {
            return Companion.operand(instruction2);
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            throw new UnsupportedOperationException(this.name() + " instruction should not be dispatched");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/compiler/ParsingOperation$PARSE_PART_CASE_INSENSITIVELY;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "keywordIndex", "avail"})
    static final class PARSE_PART_CASE_INSENSITIVELY
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PARSE_PART_CASE_INSENSITIVELY() {
            void var1_1;
        }

        @Override
        public int keywordIndex(int instruction2) {
            return Companion.operand(instruction2);
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            throw new UnsupportedOperationException(this.name() + " instruction should not be dispatched");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$PARSE_RAW_KEYWORD_TOKEN;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class PARSE_RAW_KEYWORD_TOKEN
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PARSE_RAW_KEYWORD_TOKEN() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            if (stepState.getFirstArgOrNull() != null) {
                return;
            }
            compiler2.nextNonwhitespaceTokensDo$avail(stepState.getStart(), (Function1<? super A_Token, Unit>)new Function1<A_Token, Unit>(stepState, compiler2, successorTree){
                final /* synthetic */ ParsingStepState $stepState;
                final /* synthetic */ AvailCompiler $compiler;
                final /* synthetic */ A_BundleTree $successorTree;
                {
                    this.$stepState = $stepState;
                    this.$compiler = $compiler;
                    this.$successorTree = $successorTree;
                    super(1);
                }

                public final void invoke(@NotNull A_Token token) {
                    Intrinsics.checkNotNullParameter(token, "token");
                    TokenDescriptor.TokenType tokenType = token.tokenType();
                    if (tokenType != TokenDescriptor.TokenType.KEYWORD) {
                        if (this.$stepState.getConsumedAnything()) {
                            this.$stepState.getStart().expected$avail(this.$stepState.getStaticTokens().isEmpty() ? CompilerDiagnostics.ParseNotificationLevel.WEAK : CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(tokenType, token){
                                final /* synthetic */ TokenDescriptor.TokenType $tokenType;
                                final /* synthetic */ A_Token $token;
                                {
                                    this.$tokenType = $tokenType;
                                    this.$token = $token;
                                    super(1);
                                }

                                public final void invoke(@NotNull Function1<? super String, Unit> it) {
                                    Intrinsics.checkNotNullParameter(it, "it");
                                    it.invoke("a keyword token, not " + (switch (execute.WhenMappings.$EnumSwitchMapping$0[this.$tokenType.ordinal()]) {
                                        case 1 -> "end-of-file";
                                        case 2 -> this.$token.literal();
                                        default -> this.$token.string();
                                    }));
                                }
                            });
                        }
                        return;
                    }
                    AvailObject syntheticToken = LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, token.string(), token.start(), token.lineNumber(), token, token.getGeneratingLexer(), null, 32, null);
                    syntheticToken.setCurrentModule(this.$compiler.getCompilationContext().getModule());
                    ParsingStepState stepStateCopy2 = this.$stepState.copy((Function1<? super ParsingStepState, Unit>)new Function1<ParsingStepState, Unit>(token, this.$stepState, syntheticToken){
                        final /* synthetic */ A_Token $token;
                        final /* synthetic */ ParsingStepState $stepState;
                        final /* synthetic */ AvailObject $syntheticToken;
                        {
                            this.$token = $token;
                            this.$stepState = $stepState;
                            this.$syntheticToken = $syntheticToken;
                            super(1);
                        }

                        public final void invoke(@NotNull ParsingStepState $this$copy) {
                            Intrinsics.checkNotNullParameter($this$copy, "$this$copy");
                            $this$copy.setStart(new ParserState(this.$token.nextLexingState(), this.$stepState.getStart().getClientDataMap()));
                            $this$copy.setConsumedAnythingBeforeLatestArgument($this$copy.getConsumedAnything());
                            $this$copy.setConsumedAnything(true);
                            $this$copy.setFirstArgOrNull(null);
                            $this$copy.push(LiteralPhraseDescriptor.Companion.literalNodeFromToken(this.$syntheticToken));
                        }
                    });
                    this.$compiler.eventuallyParseRestOfSendNode$avail(this.$successorTree, stepStateCopy2);
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$PARSE_RAW_LITERAL_TOKEN;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class PARSE_RAW_LITERAL_TOKEN
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PARSE_RAW_LITERAL_TOKEN() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            if (stepState.getFirstArgOrNull() != null) {
                return;
            }
            compiler2.nextNonwhitespaceTokensDo$avail(stepState.getStart(), (Function1<? super A_Token, Unit>)new Function1<A_Token, Unit>(stepState, compiler2, successorTree){
                final /* synthetic */ ParsingStepState $stepState;
                final /* synthetic */ AvailCompiler $compiler;
                final /* synthetic */ A_BundleTree $successorTree;
                {
                    this.$stepState = $stepState;
                    this.$compiler = $compiler;
                    this.$successorTree = $successorTree;
                    super(1);
                }

                public final void invoke(@NotNull A_Token token) {
                    Intrinsics.checkNotNullParameter(token, "token");
                    TokenDescriptor.TokenType tokenType = token.tokenType();
                    if (tokenType != TokenDescriptor.TokenType.LITERAL) {
                        if (this.$stepState.getConsumedAnything()) {
                            this.$stepState.getStart().expected$avail(this.$stepState.getStaticTokens().isEmpty() ? CompilerDiagnostics.ParseNotificationLevel.WEAK : CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(tokenType, token){
                                final /* synthetic */ TokenDescriptor.TokenType $tokenType;
                                final /* synthetic */ A_Token $token;
                                {
                                    this.$tokenType = $tokenType;
                                    this.$token = $token;
                                    super(1);
                                }

                                public final void invoke(@NotNull Function1<? super String, Unit> it) {
                                    Intrinsics.checkNotNullParameter(it, "it");
                                    it.invoke("a literal token, not " + (execute.WhenMappings.$EnumSwitchMapping$0[this.$tokenType.ordinal()] == 1 ? "end-of-file" : this.$token.string()));
                                }
                            });
                        }
                        return;
                    }
                    AvailObject syntheticToken = LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, token.string(), token.start(), token.lineNumber(), token, token.getGeneratingLexer(), null, 32, null);
                    syntheticToken.setCurrentModule(this.$compiler.getCompilationContext().getModule());
                    ParsingStepState stepStateCopy2 = this.$stepState.copy((Function1<? super ParsingStepState, Unit>)new Function1<ParsingStepState, Unit>(token, this.$stepState, syntheticToken){
                        final /* synthetic */ A_Token $token;
                        final /* synthetic */ ParsingStepState $stepState;
                        final /* synthetic */ AvailObject $syntheticToken;
                        {
                            this.$token = $token;
                            this.$stepState = $stepState;
                            this.$syntheticToken = $syntheticToken;
                            super(1);
                        }

                        public final void invoke(@NotNull ParsingStepState $this$copy) {
                            Intrinsics.checkNotNullParameter($this$copy, "$this$copy");
                            $this$copy.setStart(new ParserState(this.$token.nextLexingState(), this.$stepState.getStart().getClientDataMap()));
                            $this$copy.setConsumedAnythingBeforeLatestArgument($this$copy.getConsumedAnything());
                            $this$copy.setConsumedAnything(true);
                            $this$copy.setFirstArgOrNull(null);
                            $this$copy.push(LiteralPhraseDescriptor.Companion.literalNodeFromToken(this.$syntheticToken));
                        }
                    });
                    this.$compiler.eventuallyParseRestOfSendNode$avail(this.$successorTree, stepStateCopy2);
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$PARSE_TOP_VALUED_ARGUMENT;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class PARSE_TOP_VALUED_ARGUMENT
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PARSE_TOP_VALUED_ARGUMENT() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            AvailCompiler.PartialSubexpressionList partialSubexpressionList;
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            if (stepState.getFirstArgOrNull() == null) {
                AvailCompiler.PartialSubexpressionList partialSubexpressionList2 = stepState.getSuperexpressions();
                Intrinsics.checkNotNull(partialSubexpressionList2);
                partialSubexpressionList = partialSubexpressionList2.advancedTo(successorTree);
            } else {
                partialSubexpressionList = stepState.getSuperexpressions();
            }
            AvailCompiler.PartialSubexpressionList partialSubexpressionList3 = partialSubexpressionList;
            compiler2.parseSendArgumentWithExplanationThen$avail(stepState.getStart(), "top-valued argument", stepState.getFirstArgOrNull(), stepState.getFirstArgOrNull() == null && !Intrinsics.areEqual(stepState.getInitialTokenPosition().getLexingState(), stepState.getStart().getLexingState()), true, partialSubexpressionList3, (Function2<? super ParserState, ? super A_Phrase, Unit>)new Function2<ParserState, A_Phrase, Unit>(stepState, compiler2, successorTree){
                final /* synthetic */ ParsingStepState $stepState;
                final /* synthetic */ AvailCompiler $compiler;
                final /* synthetic */ A_BundleTree $successorTree;
                {
                    this.$stepState = $stepState;
                    this.$compiler = $compiler;
                    this.$successorTree = $successorTree;
                    super(2);
                }

                public final void invoke(@NotNull ParserState afterArg, @NotNull A_Phrase phrase) {
                    Intrinsics.checkNotNullParameter(afterArg, "afterArg");
                    Intrinsics.checkNotNullParameter(phrase, "phrase");
                    ParsingStepState stepStateCopy2 = this.$stepState.copy((Function1<? super ParsingStepState, Unit>)new Function1<ParsingStepState, Unit>(afterArg, phrase){
                        final /* synthetic */ ParserState $afterArg;
                        final /* synthetic */ A_Phrase $phrase;
                        {
                            this.$afterArg = $afterArg;
                            this.$phrase = $phrase;
                            super(1);
                        }

                        public final void invoke(@NotNull ParsingStepState $this$copy) {
                            Intrinsics.checkNotNullParameter($this$copy, "$this$copy");
                            $this$copy.setStart(this.$afterArg);
                            $this$copy.setConsumedAnythingBeforeLatestArgument($this$copy.getConsumedAnything());
                            $this$copy.setConsumedAnything($this$copy.getFirstArgOrNull() == null);
                            $this$copy.setFirstArgOrNull(null);
                            $this$copy.push(this.$phrase);
                        }
                    });
                    this.$compiler.eventuallyParseRestOfSendNode$avail(this.$successorTree, stepStateCopy2);
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$PARSE_VARIABLE_REFERENCE;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class PARSE_VARIABLE_REFERENCE
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PARSE_VARIABLE_REFERENCE() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            AvailCompiler.PartialSubexpressionList partialSubexpressionList;
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            if (stepState.getFirstArgOrNull() == null) {
                AvailCompiler.PartialSubexpressionList partialSubexpressionList2 = stepState.getSuperexpressions();
                Intrinsics.checkNotNull(partialSubexpressionList2);
                partialSubexpressionList = partialSubexpressionList2.advancedTo(successorTree);
            } else {
                partialSubexpressionList = stepState.getSuperexpressions();
            }
            AvailCompiler.PartialSubexpressionList partialSubexpressionList3 = partialSubexpressionList;
            compiler2.parseSendArgumentWithExplanationThen$avail(stepState.getStart(), "variable reference", stepState.getFirstArgOrNull(), stepState.getFirstArgOrNull() == null && !Intrinsics.areEqual(stepState.getInitialTokenPosition().getLexingState(), stepState.getStart().getLexingState()), false, partialSubexpressionList3, (Function2<? super ParserState, ? super A_Phrase, Unit>)new Function2<ParserState, A_Phrase, Unit>(stepState, successorTree, compiler2){
                final /* synthetic */ ParsingStepState $stepState;
                final /* synthetic */ A_BundleTree $successorTree;
                final /* synthetic */ AvailCompiler $compiler;
                {
                    this.$stepState = $stepState;
                    this.$successorTree = $successorTree;
                    this.$compiler = $compiler;
                    super(2);
                }

                public final void invoke(@NotNull ParserState afterUse, @NotNull A_Phrase variableUse) {
                    Intrinsics.checkNotNullParameter(afterUse, "afterUse");
                    Intrinsics.checkNotNullParameter(variableUse, "variableUse");
                    A_Phrase rawVariableUse = A_Phrase.Companion.getStripMacro(variableUse);
                    if (!A_Phrase.Companion.phraseKindIsUnder(rawVariableUse, PhraseTypeDescriptor.PhraseKind.VARIABLE_USE_PHRASE)) {
                        if (this.$stepState.getConsumedAnything()) {
                            afterUse.expected$avail(this.$stepState.getStaticTokens().isEmpty() ? CompilerDiagnostics.ParseNotificationLevel.WEAK : CompilerDiagnostics.ParseNotificationLevel.STRONG, avail.compiler.ParsingOperation$Companion.access$describeWhyVariableUseIsExpected(ParsingOperation.Companion, this.$successorTree));
                        }
                        return;
                    }
                    DeclarationPhraseDescriptor.DeclarationKind declarationKind = A_Phrase.Companion.getDeclaration(rawVariableUse).declarationKind();
                    if (!declarationKind.isVariable()) {
                        if (this.$stepState.getConsumedAnything()) {
                            afterUse.expected$avail(CompilerDiagnostics.ParseNotificationLevel.WEAK, "variable for reference argument to be assignable, not " + declarationKind.nativeKindName());
                        }
                        return;
                    }
                    A_Phrase rawVariableReference = ReferencePhraseDescriptor.Companion.referenceNodeFromUse(rawVariableUse);
                    A_Phrase variableReference = A_Phrase.Companion.isMacroSubstitutionNode(variableUse) ? MacroSubstitutionPhraseDescriptor.Companion.newMacroSubstitution(A_Phrase.Companion.getMacroOriginalSendNode(variableUse), rawVariableReference) : rawVariableReference;
                    ParsingStepState stepStateCopy2 = this.$stepState.copy((Function1<? super ParsingStepState, Unit>)new Function1<ParsingStepState, Unit>(afterUse, variableReference){
                        final /* synthetic */ ParserState $afterUse;
                        final /* synthetic */ A_Phrase $variableReference;
                        {
                            this.$afterUse = $afterUse;
                            this.$variableReference = $variableReference;
                            super(1);
                        }

                        public final void invoke(@NotNull ParsingStepState $this$copy) {
                            Intrinsics.checkNotNullParameter($this$copy, "$this$copy");
                            $this$copy.setStart(this.$afterUse);
                            $this$copy.setConsumedAnythingBeforeLatestArgument($this$copy.getConsumedAnything());
                            $this$copy.setConsumedAnything($this$copy.getFirstArgOrNull() == null);
                            $this$copy.setFirstArgOrNull(null);
                            $this$copy.push(this.$variableReference);
                        }
                    });
                    this.$compiler.eventuallyParseRestOfSendNode$avail(this.$successorTree, stepStateCopy2);
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lavail/compiler/ParsingOperation$PERMUTE_LIST;", "Lavail/compiler/ParsingOperation;", "describe", "", "operand", "", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class PERMUTE_LIST
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PERMUTE_LIST() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            int permutationIndex = Companion.operand(instruction2);
            AvailObject permutation = MessageSplitter.Companion.permutationAtIndex(permutationIndex);
            stepState.push(PermutedListPhraseDescriptor.Companion.newPermutedListNode(stepState.pop(), permutation));
            compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
        }

        @Override
        @NotNull
        public String describe(int operand) {
            return super.describe(operand) + " = " + MessageSplitter.Companion.permutationAtIndex(operand);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$PREPARE_TO_RUN_PREFIX_FUNCTION;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class PREPARE_TO_RUN_PREFIX_FUNCTION
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PREPARE_TO_RUN_PREFIX_FUNCTION() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            int fixupDepth;
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            List<A_Phrase> stackCopy = stepState.getArgsSoFar();
            for (int i2 = fixupDepth = Companion.operand(instruction2); 1 < i2; --i2) {
                A_Phrase value = CollectionsKt.last(stackCopy);
                List<A_Phrase> poppedOnce = PrefixSharingList.Companion.withoutLast(stackCopy);
                A_Phrase oldNode = CollectionsKt.last(poppedOnce);
                A_Phrase listNode = A_Phrase.Companion.copyWith(oldNode, value);
                stackCopy = PrefixSharingList.Companion.append(PrefixSharingList.Companion.withoutLast(poppedOnce), listNode);
            }
            stepState.push(CollectionsKt.single(stackCopy));
            compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lavail/compiler/ParsingOperation$PUSH_LITERAL;", "Lavail/compiler/ParsingOperation;", "describe", "", "operand", "", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class PUSH_LITERAL
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        PUSH_LITERAL() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            AvailObject constant = MessageSplitter.Companion.constantForIndex(Companion.operand(instruction2));
            AvailObject token = LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, StringDescriptor.Companion.stringFrom(constant.toString()), stepState.getInitialTokenPosition().getPosition(), stepState.getInitialTokenPosition().getLineNumber(), constant, NilDescriptor.Companion.getNil(), null, 32, null);
            stepState.push(LiteralPhraseDescriptor.Companion.literalNodeFromToken(token));
            compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
        }

        @Override
        @NotNull
        public String describe(int operand) {
            return super.describe(operand) + " = " + MessageSplitter.Companion.constantForIndex(operand);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$REVERSE_STACK;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class REVERSE_STACK
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        REVERSE_STACK() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            int depthToReverse = Companion.operand(instruction2);
            ParsingStepState $this$execute_u24lambda_u240 = stepState;
            boolean bl = false;
            int totalSize = $this$execute_u24lambda_u240.getArgsSoFar().size();
            List<A_Phrase> unpopped = $this$execute_u24lambda_u240.getArgsSoFar().subList(0, totalSize - depthToReverse);
            List<A_Phrase> popped = $this$execute_u24lambda_u240.getArgsSoFar().subList(totalSize - depthToReverse, totalSize);
            $this$execute_u24lambda_u240.setArgsSoFar(CollectionsKt.plus((Collection)unpopped, (Iterable)CollectionsKt.reversed((Iterable)popped)));
            compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$RUN_PREFIX_FUNCTION;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class RUN_PREFIX_FUNCTION
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        RUN_PREFIX_FUNCTION() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            boolean bl;
            boolean bl2;
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            A_Map bundlesMap = A_BundleTree.Companion.getAllParsingPlansInProgress(successorTree);
            boolean bl3 = bl2 = A_Map.Companion.getMapSize(bundlesMap) == 1;
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            AvailObject submap = CollectionsKt.first(A_Map.Companion.getMapIterable(bundlesMap)).value();
            boolean bl4 = bl = A_Map.Companion.getMapSize(submap) == 1;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            AvailObject definition = CollectionsKt.first(A_Map.Companion.getMapIterable(submap)).key();
            A_Tuple prefixFunctions = definition.prefixFunctions();
            int prefixIndex = Companion.operand(instruction2);
            AvailObject prefixFunction = A_Tuple.Companion.tupleAt(prefixFunctions, prefixIndex);
            A_Tuple arguments2 = A_Phrase.Companion.getExpressionsTuple(stepState.pop());
            compiler2.runPrefixFunctionThen$avail(successorTree, stepState, prefixFunction, TupleDescriptor.Companion.toList(arguments2));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$SAVE_PARSE_POSITION;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class SAVE_PARSE_POSITION
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        SAVE_PARSE_POSITION() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            int marker = stepState.getFirstArgOrNull() == null ? stepState.getStart().getPosition() : stepState.getInitialTokenPosition().getPosition();
            stepState.pushMarker(marker);
            compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/compiler/ParsingOperation$TYPE_CHECK_ARGUMENT;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "typeCheckArgumentIndex", "avail"})
    static final class TYPE_CHECK_ARGUMENT
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        TYPE_CHECK_ARGUMENT() {
            void var1_1;
        }

        @Override
        public int typeCheckArgumentIndex(int instruction2) {
            return Companion.operand(instruction2);
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            throw new UnsupportedOperationException(this.name() + " instruction should not be dispatched");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J-\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/compiler/ParsingOperation$WRAP_IN_LIST;", "Lavail/compiler/ParsingOperation;", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "instruction", "", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
    static final class WRAP_IN_LIST
    extends ParsingOperation {
        /*
         * WARNING - void declaration
         */
        WRAP_IN_LIST() {
            void var1_1;
        }

        @Override
        public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, int instruction2, @NotNull A_BundleTree successorTree) {
            Intrinsics.checkNotNullParameter(compiler2, "compiler");
            Intrinsics.checkNotNullParameter(stepState, "stepState");
            Intrinsics.checkNotNullParameter(successorTree, "successorTree");
            int listSize = Companion.operand(instruction2);
            ParsingStepState $this$execute_u24lambda_u240 = stepState;
            boolean bl = false;
            int totalSize = $this$execute_u24lambda_u240.getArgsSoFar().size();
            List<A_Phrase> unpopped = $this$execute_u24lambda_u240.getArgsSoFar().subList(0, totalSize - listSize);
            List<A_Phrase> popped = $this$execute_u24lambda_u240.getArgsSoFar().subList(totalSize - listSize, totalSize);
            AvailObject newListNode = ListPhraseDescriptor.Companion.newListNode(ObjectTupleDescriptor.Companion.tupleFromList(popped));
            $this$execute_u24lambda_u240.setArgsSoFar(PrefixSharingList.Companion.append(unpopped, newListNode));
            compiler2.eventuallyParseRestOfSendNode$avail(successorTree, stepState);
        }
    }
}

