/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.ParsingOperation;
import avail.compiler.splitter.Expression;
import avail.compiler.splitter.InstructionGenerator;
import avail.compiler.splitter.MessageSplitter;
import avail.compiler.splitter.SectionCheckpoint;
import avail.compiler.splitter.Sequence;
import avail.compiler.splitter.WrapState;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.ListPhraseDescriptor;
import avail.descriptor.phrases.LiteralPhraseDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.ListPhraseTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.exceptions.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\r\u0010%\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b&J\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0002J\u001d\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b0J\u0013\u00101\u001a\b\u0012\u0004\u0012\u00020\u000602H\u0010\u00a2\u0006\u0002\b3J\u0018\u00104\u001a\u00020,2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020.H\u0002J\u0018\u00108\u001a\u00020,2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020.H\u0002J%\u00109\u001a\u00020:2\u0006\u00107\u001a\u00020.2\u0006\u00105\u001a\u0002062\u0006\u0010;\u001a\u00020:H\u0010\u00a2\u0006\u0002\b<J\u001b\u0010=\u001a\u00020,2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0010\u00a2\u0006\u0002\bAJ\u0015\u0010B\u001a\u00020\b2\u0006\u00107\u001a\u00020.H\u0010\u00a2\u0006\u0002\bCJ0\u0010D\u001a\u00020,2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F2\n\u0010H\u001a\u00060Ij\u0002`J2\u0006\u0010K\u001a\u00020\u00032\u0006\u0010L\u001a\u00020\bJ1\u0010M\u001a\u00020,2\u000e\u0010N\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010F2\n\u0010H\u001a\u00060Ij\u0002`J2\u0006\u0010K\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\bOJ \u0010P\u001a\u00020,2\u0006\u00105\u001a\u0002062\u0006\u0010Q\u001a\u00020\u00032\u0006\u0010R\u001a\u00020\bH\u0002J\b\u0010S\u001a\u00020TH\u0016R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0014\u0010\u001d\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010R\u0014\u0010\u001f\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0010R\u0014\u0010!\u001a\u00020\u00038PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0016R\u0014\u0010#\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0010\u00a8\u0006U"}, d2={"Lavail/compiler/splitter/Group;", "Lavail/compiler/splitter/Expression;", "startInName", "", "pastEndInName", "beforeDagger", "Lavail/compiler/splitter/Sequence;", "hasDagger", "", "afterDagger", "maximumCardinality", "(IILavail/compiler/splitter/Sequence;ZLavail/compiler/splitter/Sequence;I)V", "getAfterDagger", "()Lavail/compiler/splitter/Sequence;", "getBeforeDagger", "getHasDagger", "()Z", "isGroup", "isGroup$avail", "isLowerCase", "isLowerCase$avail", "getMaximumCardinality", "()I", "setMaximumCardinality", "(I)V", "needsDoubleWrapping", "getNeedsDoubleWrapping", "recursivelyContainsReorders", "getRecursivelyContainsReorders", "shouldBeSeparatedOnLeft", "getShouldBeSeparatedOnLeft$avail", "shouldBeSeparatedOnRight", "getShouldBeSeparatedOnRight$avail", "underscoreCount", "getUnderscoreCount$avail", "yieldsValue", "getYieldsValue$avail", "applyCaseInsensitive", "applyCaseInsensitive$avail", "checkListStructure", "phrase", "Lavail/descriptor/phrases/A_Phrase;", "checkOneRepeatedSublistStructure", "checkType", "", "argumentType", "Lavail/descriptor/types/A_Type;", "sectionNumber", "checkType$avail", "children", "", "children$avail", "emitDoubleWrappedAfterDaggerOn", "generator", "Lavail/compiler/splitter/InstructionGenerator;", "phraseType", "emitDoubleWrappedBeforeDaggerOn", "emitOn", "Lavail/compiler/splitter/WrapState;", "wrapState", "emitOn$avail", "extractSectionCheckpointsInto", "sectionCheckpoints", "", "Lavail/compiler/splitter/SectionCheckpoint;", "extractSectionCheckpointsInto$avail", "mightBeEmpty", "mightBeEmpty$avail", "printGroupOccurrence", "argumentProvider", "", "Lavail/descriptor/representation/AvailObject;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "completeGroup", "printWithArguments", "arguments", "printWithArguments$avail", "tidyPushedList", "ungroupedArgCount", "listIsPushed", "toString", "", "avail"})
@SourceDebugExtension(value={"SMAP\nGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Group.kt\navail/compiler/splitter/Group\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1105:1\n1549#2:1106\n1620#2,3:1107\n1726#2,3:1110\n1620#2,3:1113\n*S KotlinDebug\n*F\n+ 1 Group.kt\navail/compiler/splitter/Group\n*L\n909#1:1106\n909#1:1107,3\n1026#1:1110,3\n1070#1:1113,3\n*E\n"})
public final class Group
extends Expression {
    @NotNull
    private final Sequence beforeDagger;
    private final boolean hasDagger;
    @NotNull
    private final Sequence afterDagger;
    private int maximumCardinality;

    public Group(int startInName, int pastEndInName, @NotNull Sequence beforeDagger, boolean hasDagger, @NotNull Sequence afterDagger, int maximumCardinality) {
        Intrinsics.checkNotNullParameter(beforeDagger, "beforeDagger");
        Intrinsics.checkNotNullParameter(afterDagger, "afterDagger");
        super(startInName, pastEndInName);
        this.beforeDagger = beforeDagger;
        this.hasDagger = hasDagger;
        this.afterDagger = afterDagger;
        this.maximumCardinality = maximumCardinality;
    }

    public /* synthetic */ Group(int n, int n2, Sequence sequence, boolean bl, Sequence sequence2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x20) != 0) {
            n3 = Integer.MAX_VALUE;
        }
        this(n, n2, sequence, bl, sequence2, n3);
    }

    @NotNull
    public final Sequence getBeforeDagger() {
        return this.beforeDagger;
    }

    public final boolean getHasDagger() {
        return this.hasDagger;
    }

    @NotNull
    public final Sequence getAfterDagger() {
        return this.afterDagger;
    }

    public final int getMaximumCardinality() {
        return this.maximumCardinality;
    }

    public final void setMaximumCardinality(int n) {
        this.maximumCardinality = n;
    }

    @Override
    public boolean getRecursivelyContainsReorders() {
        return this.beforeDagger.getRecursivelyContainsReorders() || this.afterDagger.getRecursivelyContainsReorders();
    }

    @Override
    public boolean getYieldsValue$avail() {
        return true;
    }

    @Override
    public boolean isGroup$avail() {
        return true;
    }

    @Override
    public boolean isLowerCase$avail() {
        return this.beforeDagger.isLowerCase$avail() && this.afterDagger.isLowerCase$avail();
    }

    @Override
    @NotNull
    public Group applyCaseInsensitive$avail() throws MalformedMessageException {
        if (!this.isLowerCase$avail()) {
            MessageSplitter.Companion.throwMalformedMessageException(AvailErrorCode.E_CASE_INSENSITIVE_EXPRESSION_CANONIZATION, "Tilde (~) may only occur after a lowercase token or a group of lowercase tokens");
            throw new KotlinNothingValueException();
        }
        return new Group(this.getStartInName(), this.getPastEndInName(), this.beforeDagger.applyCaseInsensitive$avail(), this.hasDagger, this.afterDagger.applyCaseInsensitive$avail(), this.maximumCardinality);
    }

    @Override
    public int getUnderscoreCount$avail() {
        return this.beforeDagger.getUnderscoreCount$avail() + this.afterDagger.getUnderscoreCount$avail();
    }

    private final boolean getNeedsDoubleWrapping() {
        return this.beforeDagger.getYielders().size() != 1 || !((Collection)this.afterDagger.getYielders()).isEmpty();
    }

    @Override
    public void extractSectionCheckpointsInto$avail(@NotNull List<SectionCheckpoint> sectionCheckpoints) {
        Intrinsics.checkNotNullParameter(sectionCheckpoints, "sectionCheckpoints");
        this.beforeDagger.extractSectionCheckpointsInto$avail(sectionCheckpoints);
        this.afterDagger.extractSectionCheckpointsInto$avail(sectionCheckpoints);
    }

    @NotNull
    public List<Sequence> children$avail() {
        Sequence[] sequenceArray = new Sequence[]{this.beforeDagger, this.afterDagger};
        return CollectionsKt.listOf(sequenceArray);
    }

    @Override
    public void checkType$avail(@NotNull A_Type argumentType, int sectionNumber) throws SignatureException {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        if (argumentType.isBottom()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
            throw new KotlinNothingValueException();
        }
        if (!argumentType.isTupleType()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        A_Type requiredRange = IntegerRangeTypeDescriptor.Companion.integerRangeType(IntegerDescriptor.Companion.getZero(), true, this.maximumCardinality == Integer.MAX_VALUE ? InfinityDescriptor.Companion.getPositiveInfinity() : (A_Number)IntegerDescriptor.Companion.fromInt(this.maximumCardinality + 1), false);
        if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.getSizeRange(argumentType), requiredRange)) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        if (this.getNeedsDoubleWrapping()) {
            boolean bl = argumentType.isTupleType();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            int argsBeforeDagger = this.beforeDagger.getYielders().size();
            int argsAfterDagger = this.afterDagger.getYielders().size();
            AvailObject expectedLower = IntegerDescriptor.Companion.fromInt(argsBeforeDagger);
            AvailObject expectedUpper = IntegerDescriptor.Companion.fromInt(argsBeforeDagger + argsAfterDagger);
            int i2 = 1;
            A_Tuple typeTuple2 = A_Type.Companion.getTypeTuple(argumentType);
            int limit = A_Tuple.Companion.getTupleSize(typeTuple2) + 1;
            if (i2 <= limit) {
                A_Type solutionType;
                while (!(solutionType = A_Type.Companion.typeAtIndex(argumentType, i2)).isBottom()) {
                    if (!solutionType.isTupleType()) {
                        MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
                        throw new KotlinNothingValueException();
                    }
                    A_Type solutionTypeSizes = A_Type.Companion.getSizeRange(solutionType);
                    A_Number lower = A_Type.Companion.getLowerBound(solutionTypeSizes);
                    A_Number upper = A_Type.Companion.getUpperBound(solutionTypeSizes);
                    if (!lower.equals(expectedLower) || !upper.equals(expectedUpper)) {
                        MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_COMPLEX_GROUP);
                        throw new KotlinNothingValueException();
                    }
                    int j = 1;
                    for (Expression e : this.beforeDagger.getYielders()) {
                        e.checkType$avail(A_Type.Companion.typeAtIndex(solutionType, j++), sectionNumber);
                    }
                    for (Expression e : this.afterDagger.getYielders()) {
                        e.checkType$avail(A_Type.Companion.typeAtIndex(solutionType, j++), sectionNumber);
                    }
                    if (i2 == limit) break;
                    ++i2;
                }
            }
        }
    }

    @Override
    @NotNull
    public WrapState emitOn$avail(@NotNull A_Type phraseType, @NotNull InstructionGenerator generator, @NotNull WrapState wrapState) throws SignatureException {
        Intrinsics.checkNotNullParameter(phraseType, "phraseType");
        Intrinsics.checkNotNullParameter(generator, "generator");
        Intrinsics.checkNotNullParameter((Object)wrapState, "wrapState");
        AvailObject intersected = A_Type.Companion.typeIntersection(phraseType.makeImmutable(), PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.getMostGeneralType()).makeShared();
        if (intersected.isBottom()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        A_Type subexpressionsTupleType2 = A_Type.Companion.getSubexpressionsTupleType(intersected);
        A_Type sizeRange = A_Type.Companion.getSizeRange(subexpressionsTupleType2);
        A_Number minInteger = A_Type.Companion.getLowerBound(sizeRange);
        int minSize = A_Number.Companion.isInt(minInteger) ? A_Number.Companion.getExtractInt(minInteger) : Integer.MAX_VALUE;
        A_Number maxInteger = A_Type.Companion.getUpperBound(sizeRange);
        int maxSize = A_Number.Companion.isInt(maxInteger) ? A_Number.Companion.getExtractInt(maxInteger) : Integer.MAX_VALUE;
        int endOfVariation = Math.min(Math.max(A_Tuple.Companion.getTupleSize(A_Type.Companion.getTypeTuple(subexpressionsTupleType2)) + 2, Math.min(minSize, 3)), maxSize);
        boolean needsProgressCheck2 = this.beforeDagger.mightBeEmpty$avail(intersected);
        generator.flushDelayed();
        if (maxSize == 0) {
            generator.emit(this, ParsingOperation.EMPTY_LIST);
        } else if (!this.getNeedsDoubleWrapping()) {
            A_Type singularListType;
            A_Type[] a_TypeArray;
            A_Type innerPhraseType;
            int n = generator.getPartialListsCount();
            generator.setPartialListsCount(n + 1);
            int n2 = n = this.beforeDagger.getYielders().size() == 1 ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            n = this.afterDagger.getYielders().isEmpty() ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            boolean hasWrapped = false;
            InstructionGenerator.Label $skip = new InstructionGenerator.Label();
            if (minSize == 0) {
                boolean bl;
                boolean bl2 = bl = maxSize > 0;
                if (_Assertions.ENABLED && !bl) {
                    String string4 = "Assertion failed";
                    throw new AssertionError((Object)string4);
                }
                generator.emit(this, ParsingOperation.EMPTY_LIST);
                hasWrapped = true;
                generator.emitBranchForward(this, $skip);
            }
            if (!hasWrapped && this.beforeDagger.getHasSectionCheckpoints$avail()) {
                generator.emit(this, ParsingOperation.EMPTY_LIST);
                hasWrapped = true;
            }
            generator.emitIf(needsProgressCheck2, this, ParsingOperation.SAVE_PARSE_POSITION);
            InstructionGenerator.Label $exit = new InstructionGenerator.Label();
            for (int index2 = 1; index2 < endOfVariation; ++index2) {
                innerPhraseType = A_Type.Companion.typeAtIndex(subexpressionsTupleType2, index2);
                a_TypeArray = new A_Type[]{A_Type.Companion.getPhraseTypeExpressionType(innerPhraseType)};
                A_Type a_Type = TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray);
                a_TypeArray = new A_Type[]{innerPhraseType};
                singularListType = ListPhraseTypeDescriptor.Companion.createListPhraseType(PhraseTypeDescriptor.PhraseKind.LIST_PHRASE, a_Type, TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray));
                this.beforeDagger.emitOn$avail(singularListType, generator, hasWrapped ? WrapState.PUSHED_LIST : WrapState.SHOULD_NOT_PUSH_LIST);
                if (index2 >= minSize) {
                    generator.flushDelayed();
                    if (!hasWrapped && index2 == minSize) {
                        generator.emitWrapped(this, index2);
                        hasWrapped = true;
                    }
                    generator.emitBranchForward(this, $exit);
                }
                if (!hasWrapped && index2 == 1 && this.afterDagger.getHasSectionCheckpoints$avail()) {
                    generator.flushDelayed();
                    generator.emitWrapped(this, 1);
                    hasWrapped = true;
                }
                this.afterDagger.emitOn$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType(), generator, WrapState.PUSHED_LIST);
                generator.emitIf(needsProgressCheck2, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
            }
            generator.flushDelayed();
            if (!hasWrapped) {
                generator.emitWrapped(this, endOfVariation - 1);
            }
            InstructionGenerator.Label $loopStart = new InstructionGenerator.Label();
            generator.emit($loopStart);
            innerPhraseType = A_Type.Companion.getDefaultType(subexpressionsTupleType2);
            a_TypeArray = new A_Type[]{A_Type.Companion.getPhraseTypeExpressionType(innerPhraseType)};
            A_Type a_Type = TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray);
            a_TypeArray = new A_Type[]{innerPhraseType};
            singularListType = ListPhraseTypeDescriptor.Companion.createListPhraseType(PhraseTypeDescriptor.PhraseKind.LIST_PHRASE, a_Type, TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray));
            this.beforeDagger.emitOn$avail(singularListType, generator, WrapState.PUSHED_LIST);
            if (endOfVariation < maxSize) {
                generator.flushDelayed();
                InstructionGenerator.Label $exitCheckMin = new InstructionGenerator.Label();
                generator.emitBranchForward(this, endOfVariation >= minSize ? $exit : $exitCheckMin);
                if (maxInteger.isFinite()) {
                    generator.emit((Expression)this, ParsingOperation.CHECK_AT_MOST, maxSize - 1);
                }
                this.afterDagger.emitOn$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType(), generator, WrapState.PUSHED_LIST);
                generator.flushDelayed();
                generator.emitIf(needsProgressCheck2, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
                generator.emitJumpBackward(this, $loopStart);
                if ($exitCheckMin.isUsed()) {
                    generator.emit($exitCheckMin);
                    generator.emit((Expression)this, ParsingOperation.CHECK_AT_LEAST, minSize);
                }
            }
            generator.flushDelayed();
            generator.emit($exit);
            generator.emitIf(needsProgressCheck2, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
            generator.emitIf(needsProgressCheck2, this, ParsingOperation.DISCARD_SAVED_PARSE_POSITION);
            generator.emit($skip);
            int $exitCheckMin = generator.getPartialListsCount();
            generator.setPartialListsCount($exitCheckMin + -1);
        } else {
            A_Type sublistPhraseType;
            generator.flushDelayed();
            boolean hasWrapped = false;
            InstructionGenerator.Label $skip = new InstructionGenerator.Label();
            if (minSize == 0) {
                boolean $exit;
                boolean bl = $exit = maxSize > 0;
                if (_Assertions.ENABLED && !$exit) {
                    String $loopStart = "Assertion failed";
                    throw new AssertionError((Object)$loopStart);
                }
                generator.emit(this, ParsingOperation.EMPTY_LIST);
                hasWrapped = true;
                generator.emitBranchForward(this, $skip);
            }
            if (!hasWrapped && (this.beforeDagger.getHasSectionCheckpoints$avail() || this.afterDagger.getHasSectionCheckpoints$avail())) {
                generator.emit(this, ParsingOperation.EMPTY_LIST);
                hasWrapped = true;
            }
            generator.emitIf(needsProgressCheck2, this, ParsingOperation.SAVE_PARSE_POSITION);
            InstructionGenerator.Label $exit = new InstructionGenerator.Label();
            for (int index3 = 1; index3 < endOfVariation; ++index3) {
                if (index3 >= minSize && !hasWrapped && index3 == minSize) {
                    generator.flushDelayed();
                    generator.emitWrapped(this, index3 - 1);
                    hasWrapped = true;
                }
                sublistPhraseType = A_Type.Companion.typeAtIndex(subexpressionsTupleType2, index3);
                this.emitDoubleWrappedBeforeDaggerOn(generator, sublistPhraseType);
                if (index3 >= minSize) {
                    generator.flushDelayed();
                    generator.emitBranchForward(this, $exit);
                }
                this.emitDoubleWrappedAfterDaggerOn(generator, sublistPhraseType);
                generator.flushDelayed();
                if (hasWrapped) {
                    generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
                }
                generator.emitIf(needsProgressCheck2, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
            }
            generator.flushDelayed();
            if (!hasWrapped) {
                generator.emitWrapped(this, endOfVariation - 1);
            }
            InstructionGenerator.Label $loopStart = new InstructionGenerator.Label();
            generator.emit($loopStart);
            sublistPhraseType = A_Type.Companion.typeAtIndex(subexpressionsTupleType2, endOfVariation);
            this.emitDoubleWrappedBeforeDaggerOn(generator, sublistPhraseType);
            generator.flushDelayed();
            InstructionGenerator.Label $mergedExit = new InstructionGenerator.Label();
            if (endOfVariation < maxSize) {
                InstructionGenerator.Label $exitCheckMin = new InstructionGenerator.Label();
                generator.emitBranchForward(this, endOfVariation >= minSize ? $exit : $exitCheckMin);
                if (maxInteger.isFinite()) {
                    generator.emit((Expression)this, ParsingOperation.CHECK_AT_MOST, maxSize - 1);
                }
                this.emitDoubleWrappedAfterDaggerOn(generator, sublistPhraseType);
                generator.flushDelayed();
                generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
                generator.emitIf(needsProgressCheck2, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
                generator.emitJumpBackward(this, $loopStart);
                if ($exitCheckMin.isUsed()) {
                    generator.emit($exitCheckMin);
                    generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
                    generator.emit((Expression)this, ParsingOperation.CHECK_AT_LEAST, minSize);
                    generator.emitJumpForward(this, $mergedExit);
                }
            }
            generator.emit($exit);
            generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
            generator.emit($mergedExit);
            generator.emitIf(needsProgressCheck2, this, ParsingOperation.ENSURE_PARSE_PROGRESS);
            generator.emitIf(needsProgressCheck2, this, ParsingOperation.DISCARD_SAVED_PARSE_POSITION);
            generator.emit($skip);
        }
        return wrapState.processAfterPushedArgument$avail(this, generator);
    }

    private final void emitDoubleWrappedBeforeDaggerOn(InstructionGenerator generator, A_Type phraseType) throws SignatureException {
        boolean bl;
        AvailObject intersected = A_Type.Companion.typeIntersection(phraseType.makeImmutable(), PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.getMostGeneralType()).makeShared();
        if (intersected.isBottom()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        A_Type subexpressionsTupleType2 = A_Type.Companion.getSubexpressionsTupleType(intersected);
        generator.setPartialListsCount(generator.getPartialListsCount() + 2);
        int argIndex = 0;
        int ungroupedArgCount = 0;
        boolean listIsPushed = false;
        for (Expression expression2 : this.beforeDagger.getExpressions()) {
            if (expression2.getHasSectionCheckpoints$avail()) {
                this.tidyPushedList(generator, ungroupedArgCount, listIsPushed);
                ungroupedArgCount = 0;
                listIsPushed = true;
            }
            if (expression2.getYieldsValue$avail()) {
                int realTypeIndex = this.beforeDagger.isReordered() ? ((Number)this.beforeDagger.getPermutation().get(argIndex - 1)).intValue() : ++argIndex;
                A_Type entryType = A_Type.Companion.typeAtIndex(subexpressionsTupleType2, realTypeIndex);
                generator.flushDelayed();
                expression2.emitOn$avail(entryType, generator, WrapState.SHOULD_NOT_PUSH_LIST);
                ++ungroupedArgCount;
                continue;
            }
            expression2.emitOn$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType(), generator, WrapState.SHOULD_NOT_HAVE_ARGUMENTS);
        }
        boolean bl2 = bl = argIndex == this.beforeDagger.getYielders().size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.tidyPushedList(generator, ungroupedArgCount, listIsPushed);
        generator.setPartialListsCount(generator.getPartialListsCount() - 2);
        if (this.beforeDagger.isReordered()) {
            A_Tuple permutationTuple = TupleDescriptor.Companion.tupleFromIntegerList(this.beforeDagger.getPermutation());
            int n = MessageSplitter.Companion.indexForPermutation(permutationTuple);
            generator.flushDelayed();
            generator.emit((Expression)this, ParsingOperation.PERMUTE_LIST, n);
        }
    }

    private final void emitDoubleWrappedAfterDaggerOn(InstructionGenerator generator, A_Type phraseType) {
        AvailObject intersected = A_Type.Companion.typeIntersection(phraseType.makeImmutable(), PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.getMostGeneralType()).makeShared();
        if (intersected.isBottom()) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP);
            throw new KotlinNothingValueException();
        }
        A_Type subexpressionsTupleType2 = A_Type.Companion.getSubexpressionsTupleType(intersected);
        generator.setPartialListsCount(generator.getPartialListsCount() + 2);
        int argIndex = this.beforeDagger.getYielders().size();
        int ungroupedArgCount = 0;
        for (Expression expression2 : this.afterDagger.getExpressions()) {
            if (expression2.getHasSectionCheckpoints$avail()) {
                this.tidyPushedList(generator, ungroupedArgCount, true);
                ungroupedArgCount = 0;
            }
            if (expression2.getYieldsValue$avail()) {
                int realTypeIndex = this.afterDagger.isReordered() ? ((Number)this.afterDagger.getPermutation().get(argIndex - 1)).intValue() : ++argIndex;
                A_Type entryType = A_Type.Companion.typeAtIndex(subexpressionsTupleType2, realTypeIndex);
                generator.flushDelayed();
                expression2.emitOn$avail(entryType, generator, WrapState.PUSHED_LIST);
                ungroupedArgCount = 0;
                continue;
            }
            expression2.emitOn$avail(ListPhraseTypeDescriptor.Companion.emptyListPhraseType(), generator, WrapState.SHOULD_NOT_HAVE_ARGUMENTS);
        }
        this.tidyPushedList(generator, ungroupedArgCount, true);
        generator.setPartialListsCount(generator.getPartialListsCount() - 2);
        if (this.afterDagger.isReordered()) {
            int leftArgCount = this.beforeDagger.getYielders().size();
            int rightArgCount = this.afterDagger.getYielders().size();
            List adjustedPermutationList = new ArrayList();
            int i2 = 1;
            if (i2 <= leftArgCount) {
                while (true) {
                    adjustedPermutationList.add(i2);
                    if (i2 == leftArgCount) break;
                    ++i2;
                }
            }
            for (i2 = 0; i2 < rightArgCount; ++i2) {
                adjustedPermutationList.add(this.afterDagger.getYielders().get(i2).getExplicitOrdinal() + leftArgCount);
            }
            A_Tuple permutationTuple = TupleDescriptor.Companion.tupleFromIntegerList(adjustedPermutationList);
            int permutationIndex = MessageSplitter.Companion.indexForPermutation(permutationTuple);
            generator.flushDelayed();
            generator.emit((Expression)this, ParsingOperation.PERMUTE_LIST, permutationIndex);
        }
        boolean bl = A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound(A_Type.Companion.getSizeRange(subexpressionsTupleType2)), argIndex);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    private final void tidyPushedList(InstructionGenerator generator, int ungroupedArgCount, boolean listIsPushed) {
        generator.flushDelayed();
        if (!listIsPushed) {
            generator.emitWrapped(this, ungroupedArgCount);
        } else if (ungroupedArgCount == 1) {
            generator.emit(this, ParsingOperation.APPEND_ARGUMENT);
        } else if (ungroupedArgCount > 1) {
            generator.emitWrapped(this, ungroupedArgCount);
            generator.emit(this, ParsingOperation.CONCATENATE);
        }
    }

    @Override
    @NotNull
    public String toString() {
        Expression e;
        List strings2 = new ArrayList();
        Iterator<Expression> iterator2 = this.beforeDagger.getExpressions().iterator();
        while (iterator2.hasNext()) {
            String string2;
            StringBuilder stringBuilder;
            e = iterator2.next();
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u240.append(e);
            if (e.getCanBeReordered() && e.getExplicitOrdinal() != -1) {
                $this$toString_u24lambda_u240.appendCodePoint(MessageSplitter.Companion.circledNumberCodePoint(e.getExplicitOrdinal()));
            }
            Intrinsics.checkNotNullExpressionValue(stringBuilder.toString(), "StringBuilder().apply(builderAction).toString()");
            strings2.add(string2);
        }
        if (this.hasDagger) {
            strings2.add("\u2021");
            iterator2 = this.afterDagger.getExpressions().iterator();
            while (iterator2.hasNext()) {
                e = iterator2.next();
                strings2.add(e.toString());
            }
        }
        Iterator<Expression> $this$toString_u24lambda_u241 = iterator2 = new StringBuilder();
        boolean bl = false;
        ((StringBuilder)((Object)$this$toString_u24lambda_u241)).append("Group(");
        boolean first = true;
        for (String s : strings2) {
            if (!first) {
                ((StringBuilder)((Object)$this$toString_u24lambda_u241)).append(", ");
            }
            ((StringBuilder)((Object)$this$toString_u24lambda_u241)).append(s);
            first = false;
        }
        ((StringBuilder)((Object)$this$toString_u24lambda_u241)).append(')');
        String string3 = ((StringBuilder)((Object)iterator2)).toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printWithArguments$avail(@Nullable Iterator<? extends A_Phrase> arguments2, @NotNull StringBuilder builder, int indent) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        boolean needsDouble = this.getNeedsDoubleWrapping();
        Iterator<? extends A_Phrase> iterator2 = arguments2;
        Intrinsics.checkNotNull(iterator2);
        A_Phrase groupArguments = iterator2.next();
        if (A_Phrase.Companion.phraseKindIsUnder(groupArguments, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
            Collection<A_Phrase> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = A_Phrase.Companion.getToken(groupArguments).literal();
            ObjectTupleDescriptor.Companion companion = ObjectTupleDescriptor.Companion;
            ListPhraseDescriptor.Companion companion2 = ListPhraseDescriptor.Companion;
            boolean $i$f$map = false;
            void var8_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AvailObject availObject = (AvailObject)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(LiteralPhraseDescriptor.Companion.syntheticLiteralNodeFor$default(LiteralPhraseDescriptor.Companion, (A_BasicObject)it, StringDescriptor.Companion.stringFrom(it.toString()), null, 4, null));
            }
            collection2 = (List)destination$iv$iv;
            groupArguments = companion2.newListNode(companion.tupleFromList(collection2));
        }
        Iterator occurrenceProvider = A_Phrase.Companion.getExpressionsTuple(groupArguments).iterator();
        while (occurrenceProvider.hasNext()) {
            boolean bl;
            AvailObject occurrence = (AvailObject)occurrenceProvider.next();
            Iterator<AvailObject> innerIterator = null;
            if (needsDouble) {
                boolean destination$iv$iv = occurrence.isInstanceOfKind(PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.getMostGeneralType());
                if (_Assertions.ENABLED && !destination$iv$iv) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                innerIterator = A_Phrase.Companion.getExpressionsTuple(occurrence).iterator();
            } else {
                boolean destination$iv$iv = occurrence.isInstanceOfKind(PhraseTypeDescriptor.PhraseKind.EXPRESSION_PHRASE.getMostGeneralType());
                if (_Assertions.ENABLED && !destination$iv$iv) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                List<AvailObject> argumentNodes = CollectionsKt.listOf(occurrence);
                innerIterator = argumentNodes.iterator();
            }
            this.printGroupOccurrence(innerIterator, builder, indent, occurrenceProvider.hasNext());
            boolean bl2 = bl = !innerIterator.hasNext();
            if (!_Assertions.ENABLED || bl) continue;
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
    }

    public final void printGroupOccurrence(@NotNull Iterator<AvailObject> argumentProvider, @NotNull StringBuilder builder, int indent, boolean completeGroup) {
        boolean bl;
        List list2;
        Intrinsics.checkNotNullParameter(argumentProvider, "argumentProvider");
        Intrinsics.checkNotNullParameter(builder, "builder");
        builder.append('\u00ab');
        List $this$printGroupOccurrence_u24lambda_u243 = list2 = (List)new ArrayList();
        boolean bl2 = false;
        $this$printGroupOccurrence_u24lambda_u243.addAll((Collection)this.beforeDagger.getExpressions());
        if (completeGroup && !((Collection)this.afterDagger.getExpressions()).isEmpty()) {
            $this$printGroupOccurrence_u24lambda_u243.add(null);
            $this$printGroupOccurrence_u24lambda_u243.addAll((Collection)this.afterDagger.getExpressions());
        }
        List expressionsToVisit = list2;
        boolean needsSpace = false;
        for (Expression expr : expressionsToVisit) {
            if (expr == null) {
                builder.append('\u2021');
                needsSpace = false;
                continue;
            }
            if (needsSpace && expr.getShouldBeSeparatedOnLeft$avail()) {
                builder.append(' ');
            }
            int oldLength = builder.length();
            expr.printWithArguments$avail(argumentProvider, builder, indent);
            needsSpace = expr.getShouldBeSeparatedOnRight$avail() && builder.length() != oldLength;
        }
        boolean bl3 = bl = !argumentProvider.hasNext();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        builder.append('\u00bb');
    }

    @Override
    public boolean getShouldBeSeparatedOnLeft$avail() {
        return false;
    }

    @Override
    public boolean getShouldBeSeparatedOnRight$avail() {
        return false;
    }

    @Override
    public boolean mightBeEmpty$avail(@NotNull A_Type phraseType) {
        Intrinsics.checkNotNullParameter(phraseType, "phraseType");
        A_Type tupleType = A_Type.Companion.getPhraseTypeExpressionType(phraseType);
        boolean bl = tupleType.isTupleType();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound(A_Type.Companion.getSizeRange(tupleType)), 0);
    }

    @Override
    public boolean checkListStructure(@NotNull A_Phrase phrase) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(phrase, "phrase");
            if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
                return true;
            }
            if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.PERMUTED_LIST_PHRASE)) {
                return false;
            }
            if (!A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LIST_PHRASE)) {
                return false;
            }
            Iterable $this$all$iv = A_Phrase.Companion.getExpressionsTuple(phrase);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AvailObject subphrase = (AvailObject)element$iv;
                    boolean bl2 = false;
                    if (this.checkOneRepeatedSublistStructure(subphrase)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkOneRepeatedSublistStructure(A_Phrase phrase) {
        int n;
        int i2;
        if (!this.getNeedsDoubleWrapping()) {
            return this.beforeDagger.getYielders().get(0).checkListStructure(phrase);
        }
        if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
            return true;
        }
        if (!A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LIST_PHRASE)) {
            return false;
        }
        A_Tuple subphrases = A_Phrase.Companion.getExpressionsTuple(phrase);
        int subphrasesSize = A_Tuple.Companion.getTupleSize(subphrases);
        if (subphrasesSize == this.beforeDagger.getYielders().size()) {
            return this.beforeDagger.checkListStructure(phrase);
        }
        if (subphrasesSize != this.beforeDagger.getYielders().size() + this.afterDagger.getYielders().size()) {
            return false;
        }
        int leftSize = this.beforeDagger.getYielders().size();
        if (this.beforeDagger.isReordered() || this.afterDagger.isReordered()) {
            if (!A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.PERMUTED_LIST_PHRASE)) {
                return false;
            }
            A_Tuple actualPermutation = A_Phrase.Companion.getPermutation(phrase);
            List<Integer> expectedPermutation = CollectionsKt.toMutableList((Collection)this.beforeDagger.getPermutation());
            Iterable $this$mapTo$iv = this.afterDagger.getPermutation();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                int n2 = ((Number)item$iv).intValue();
                Collection collection2 = expectedPermutation;
                boolean bl = false;
                collection2.add((int)(it + leftSize));
            }
            if (!TupleDescriptor.Companion.tupleFromIntegerList(expectedPermutation).equals(actualPermutation)) {
                return false;
            }
        } else if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.PERMUTED_LIST_PHRASE)) {
            return false;
        }
        if ((i2 = 1) <= leftSize) {
            while (true) {
                if (!this.beforeDagger.getYielders().get(i2 - 1).checkListStructure(A_Tuple.Companion.tupleAt(subphrases, i2))) {
                    return false;
                }
                if (i2 == leftSize) break;
                ++i2;
            }
        }
        if ((i2 = 1) <= (n = this.afterDagger.getYielders().size())) {
            while (true) {
                if (!this.afterDagger.getYielders().get(i2 - 1).checkListStructure(A_Tuple.Companion.tupleAt(subphrases, i2 + leftSize))) {
                    return false;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return true;
    }
}

