/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2PcVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operation.L2ConditionalJump;
import avail.interpreter.levelTwo.operation.L2_EXTRACT_TAG_ORDINAL;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_COMPARE_INT;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.reoptimizer.L2Regenerator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J>\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J \u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006'"}, d2={"Lavail/interpreter/levelTwo/operation/L2_MULTIWAY_JUMP;", "Lavail/interpreter/levelTwo/operation/L2ConditionalJump;", "()V", "isPlaceholder", "", "()Z", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "generateReplacement", "regenerator", "Lavail/optimizer/reoptimizer/L2Regenerator;", "generateSubtree", "generator", "Lavail/optimizer/L2Generator;", "value", "Lavail/interpreter/levelTwo/operand/L2ReadIntOperand;", "splitPoints", "Lavail/descriptor/tuples/A_Tuple;", "edges", "", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "firstSplit", "", "lastSplit", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_MULTIWAY_JUMP
extends L2ConditionalJump {
    @NotNull
    public static final L2_MULTIWAY_JUMP INSTANCE = new L2_MULTIWAY_JUMP();

    private L2_MULTIWAY_JUMP() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_INT.named("value"), L2OperandType.CONSTANT.named("split points"), L2OperandType.PC_VECTOR.named("branch edges", L2NamedOperandType.Purpose.SUCCESS)};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, "desiredTypes");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, "warningStyleChange");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadIntOperand value = (L2ReadIntOperand)instruction2.operand(0);
        L2ConstantOperand splitPoints = (L2ConstantOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder);
        builder.append(" ").append(value.registerString()).append(" in ").append(splitPoints.getConstant());
        this.renderOperandsStartingAt(instruction2, 2, desiredTypes, builder);
    }

    @Override
    public boolean isPlaceholder() {
        return true;
    }

    @Override
    public void generateReplacement(@NotNull L2Instruction instruction2, @NotNull L2Regenerator regenerator2) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(regenerator2, "regenerator");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2Generator generator = regenerator2.getTargetGenerator();
        L2ReadIntOperand value = (L2ReadIntOperand)regenerator2.transformOperand(instruction2.operand(0));
        L2ConstantOperand splitPoints = (L2ConstantOperand)regenerator2.transformOperand(instruction2.operand(1));
        L2PcVectorOperand edges = (L2PcVectorOperand)regenerator2.transformOperand(instruction2.operand(2));
        A_Tuple splitTuple = splitPoints.getConstant();
        this.generateSubtree(generator, value, splitTuple, edges.getEdges(), 1, A_Tuple.Companion.getTupleSize(splitTuple));
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " should have been replaced during optimization");
    }

    private final void generateSubtree(L2Generator generator, L2ReadIntOperand value, A_Tuple splitPoints, List<L2PcOperand> edges, int firstSplit, int lastSplit) {
        if (!generator.currentlyReachable()) {
            return;
        }
        if (firstSplit > lastSplit) {
            boolean bl;
            boolean bl2 = bl = firstSplit == lastSplit + 1;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            L2PcOperand edge2 = edges.get(firstSplit - 1);
            generator.jumpTo(edge2.targetBlock());
            return;
        }
        int splitIndex = firstSplit + lastSplit >>> 1;
        int splitValue = A_Tuple.Companion.tupleIntAt(splitPoints, splitIndex);
        String leftName = "< " + splitValue;
        String rightName = "\u2265 " + splitValue;
        if (Intrinsics.areEqual(value.definition().getInstruction().getOperation(), L2_EXTRACT_TAG_ORDINAL.INSTANCE)) {
            A_Type range = A_Type.Companion.typeIntersection(generator.getCurrentManifest().restrictionFor(value.semanticValue()).getType(), IntegerRangeTypeDescriptor.Companion.inclusive(0L, (long)TypeTag.getEntries().size() - 1L));
            int low = A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(range));
            int high = A_Number.Companion.getExtractInt(A_Type.Companion.getUpperBound(range));
            leftName = leftName + " " + TypeTag.Companion.tagFromOrdinal(low);
            if (low < splitValue - 1) {
                leftName = leftName + ".." + TypeTag.Companion.tagFromOrdinal(splitValue - 1);
            }
            rightName = rightName + " " + TypeTag.Companion.tagFromOrdinal(splitValue);
            if (splitValue < high) {
                rightName = rightName + ".." + TypeTag.Companion.tagFromOrdinal(high);
            }
        }
        L2BasicBlock left = generator.createBasicBlock(leftName);
        L2BasicBlock right = generator.createBasicBlock(rightName);
        L2_JUMP_IF_COMPARE_INT.Companion.getGreaterOrEqual().compareAndBranch(generator, value, generator.unboxedIntConstant(splitValue), L2Generator.Companion.edgeTo(right), L2Generator.Companion.edgeTo(left));
        L2Generator.startBlock$default(generator, left, false, null, 6, null);
        this.generateSubtree(generator, value, splitPoints, edges, firstSplit, splitIndex - 1);
        L2Generator.startBlock$default(generator, right, false, null, 6, null);
        this.generateSubtree(generator, value, splitPoints, edges, splitIndex + 1, lastSplit);
    }
}

