/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.methods.MethodDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.BlockPhraseDescriptor;
import avail.descriptor.phrases.ExpressionAsStatementPhraseDescriptor;
import avail.descriptor.phrases.ListPhraseDescriptor;
import avail.descriptor.phrases.LiteralPhraseDescriptor;
import avail.descriptor.phrases.SendPhraseDescriptor;
import avail.descriptor.phrases.SequencePhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.LiteralTokenTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AmbiguousNameException;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.style.P_BootstrapDefineSpecialObjectMacroStyler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapDefineSpecialObjectMacro;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapDefineSpecialObjectMacroStyler;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_BootstrapDefineSpecialObjectMacro
extends Primitive {
    @NotNull
    public static final P_BootstrapDefineSpecialObjectMacro INSTANCE = new P_BootstrapDefineSpecialObjectMacro();

    private P_BootstrapDefineSpecialObjectMacro() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Bootstrap, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        A_Bundle a_Bundle;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject nameLiteral = interpreter.argument(0);
        AvailObject specialObjectLiteral = interpreter.argument(1);
        A_Fiber fiber2 = interpreter.fiber();
        AvailLoader loader = A_Fiber.Companion.getAvailLoader(fiber2);
        if (loader == null || loader.getModule().isNil()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        try {
            a_Bundle = A_Atom.Companion.bundleOrCreate(AvailLoader.lookupName$default(loader, A_Phrase.Companion.getToken(nameLiteral).literal(), null, 2, null));
        }
        catch (AmbiguousNameException e) {
            return interpreter.primitiveFailure(e);
        }
        catch (MalformedMessageException e) {
            return interpreter.primitiveFailure(e);
        }
        A_Bundle bundle = a_Bundle;
        A_Type literalType = A_Phrase.Companion.getPhraseExpressionType(specialObjectLiteral);
        A_Phrase defineMethod = SendPhraseDescriptor.Companion.newSendNode(TupleDescriptor.Companion.getEmptyTuple(), TupleDescriptor.Companion.getEmptyTuple(), MethodDescriptor.SpecialMethodAtom.METHOD_DEFINER.getBundle(), ListPhraseDescriptor.Companion.newListNode(ObjectTupleDescriptor.Companion.tuple(nameLiteral, BlockPhraseDescriptor.Companion.newBlockNode(TupleDescriptor.Companion.getEmptyTuple(), null, ObjectTupleDescriptor.Companion.tuple(specialObjectLiteral), literalType, SetDescriptor.Companion.getEmptySet(), 0), ListPhraseDescriptor.Companion.emptyListNode())), PrimitiveTypeDescriptor.Types.TOP.getO());
        A_Phrase getValue = SendPhraseDescriptor.Companion.newSendNode(TupleDescriptor.Companion.getEmptyTuple(), TupleDescriptor.Companion.getEmptyTuple(), bundle, ListPhraseDescriptor.Companion.newListNode(TupleDescriptor.Companion.getEmptyTuple()), literalType);
        A_Phrase createLiteralToken = SendPhraseDescriptor.Companion.newSendNode(TupleDescriptor.Companion.getEmptyTuple(), TupleDescriptor.Companion.getEmptyTuple(), MethodDescriptor.SpecialMethodAtom.CREATE_LITERAL_TOKEN.getBundle(), ListPhraseDescriptor.Companion.newListNode(ObjectTupleDescriptor.Companion.tuple(getValue, LiteralPhraseDescriptor.Companion.syntheticLiteralNodeFor$default(LiteralPhraseDescriptor.Companion, A_Phrase.Companion.getToken(specialObjectLiteral).string(), null, null, 6, null), LiteralPhraseDescriptor.Companion.syntheticLiteralNodeFor$default(LiteralPhraseDescriptor.Companion, IntegerDescriptor.Companion.fromInt(0), null, null, 6, null), LiteralPhraseDescriptor.Companion.syntheticLiteralNodeFor$default(LiteralPhraseDescriptor.Companion, IntegerDescriptor.Companion.fromInt(0), null, null, 6, null), ListPhraseDescriptor.Companion.emptyListNode())), LiteralTokenTypeDescriptor.Companion.literalTokenType(literalType));
        A_Phrase createLiteralNode = SendPhraseDescriptor.Companion.newSendNode(TupleDescriptor.Companion.getEmptyTuple(), TupleDescriptor.Companion.getEmptyTuple(), MethodDescriptor.SpecialMethodAtom.CREATE_LITERAL_PHRASE.getBundle(), ListPhraseDescriptor.Companion.newListNode(ObjectTupleDescriptor.Companion.tuple(createLiteralToken)), PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(literalType));
        A_Phrase defineMacro = SendPhraseDescriptor.Companion.newSendNode(TupleDescriptor.Companion.getEmptyTuple(), TupleDescriptor.Companion.getEmptyTuple(), MethodDescriptor.SpecialMethodAtom.MACRO_DEFINER.getBundle(), ListPhraseDescriptor.Companion.newListNode(ObjectTupleDescriptor.Companion.tuple(nameLiteral, ListPhraseDescriptor.Companion.emptyListNode(), BlockPhraseDescriptor.Companion.newBlockNode(TupleDescriptor.Companion.getEmptyTuple(), null, ObjectTupleDescriptor.Companion.tuple(createLiteralNode), PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(literalType), SetDescriptor.Companion.getEmptySet(), 0), ListPhraseDescriptor.Companion.emptyListNode())), PrimitiveTypeDescriptor.Types.TOP.getO());
        return interpreter.primitiveSuccess(SequencePhraseDescriptor.Companion.newSequence(ObjectTupleDescriptor.Companion.tuple(ExpressionAsStatementPhraseDescriptor.Companion.newExpressionAsStatement(defineMethod), ExpressionAsStatementPhraseDescriptor.Companion.newExpressionAsStatement(defineMacro))));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(TupleTypeDescriptor.Companion.getNonemptyStringType()), PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(PrimitiveTypeDescriptor.Types.ANY.getO())), PhraseTypeDescriptor.PhraseKind.SEQUENCE_PHRASE.getMostGeneralType(), null, 4, null);
    }

    @Override
    @NotNull
    public P_BootstrapDefineSpecialObjectMacroStyler bootstrapStyler() {
        return P_BootstrapDefineSpecialObjectMacroStyler.INSTANCE;
    }
}

