/*
 * Decompiled with CFR 0.152.
 */
package avail;

import avail.AvailDebuggerModel;
import avail.AvailRuntime;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_Function;
import avail.descriptor.maps.A_Map;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.interpreter.execution.Interpreter;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0018\u001a\u00020\f2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001b0\u001aJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dJ\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001fJ\u000e\u0010#\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0007J\u0014\u0010$\u001a\u00020\f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u001aJ\u0006\u0010&\u001a\u00020\fJ\u000e\u0010'\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0007J;\u0010(\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162#\u0010)\u001a\u001f\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\f0*\u00a2\u0006\u0002\b+J\u0006\u0010,\u001a\u00020\fJ\u0006\u0010-\u001a\u00020\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR#\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u00a8\u0006/"}, d2={"Lavail/AvailDebuggerModel;", "", "runtime", "Lavail/AvailRuntime;", "(Lavail/AvailRuntime;)V", "debuggedFibers", "", "Lavail/descriptor/fiber/A_Fiber;", "getDebuggedFibers", "()Ljava/util/List;", "fiberCaptureFunction", "Lkotlin/Function1;", "", "getRuntime", "()Lavail/AvailRuntime;", "whenAddedFiberActions", "getWhenAddedFiberActions", "whenPausedActions", "getWhenPausedActions", "doSingleStep", "fiber", "selectedContinuation", "Lavail/descriptor/functions/A_Continuation;", "doStepOver", "gatherFibers", "fibersProvider", "Lkotlin/Function0;", "", "installFiberCapture", "", "kind", "Lavail/descriptor/fiber/FiberDescriptor$FiberKind;", "install", "isCapturingNewFibers", "fiberKind", "justPaused", "releaseFibersThen", "then", "restartFrameThen", "resume", "runFiberAction", "doAction", "Lkotlin/Function3;", "Lkotlin/ExtensionFunctionType;", "stepOutThen", "stepToLineThen", "Companion", "avail"})
@SourceDebugExtension(value={"SMAP\nAvailDebuggerModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvailDebuggerModel.kt\navail/AvailDebuggerModel\n+ 2 Locks.kt\navail/utility/LocksKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,347:1\n55#2:348\n55#2:351\n1855#3,2:349\n766#3:352\n857#3,2:353\n1045#3:355\n1855#3,2:356\n*S KotlinDebug\n*F\n+ 1 AvailDebuggerModel.kt\navail/AvailDebuggerModel\n*L\n207#1:348\n301#1:351\n210#1:349,2\n304#1:352\n304#1:353,2\n310#1:355\n312#1:356,2\n*E\n"})
public final class AvailDebuggerModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AvailRuntime runtime;
    @NotNull
    private final List<A_Fiber> debuggedFibers;
    @NotNull
    private final Function1<A_Fiber, Unit> fiberCaptureFunction;
    @NotNull
    private final List<Function1<A_Fiber, Unit>> whenPausedActions;
    @NotNull
    private final List<Function1<A_Fiber, Unit>> whenAddedFiberActions;
    @NotNull
    private static final Statistic reificationForDebuggerStat = new Statistic(StatisticReport.REIFICATIONS, "Reification for debugger");

    public AvailDebuggerModel(@NotNull AvailRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.runtime = runtime;
        this.debuggedFibers = new ArrayList();
        this.fiberCaptureFunction = (Function1)new Function1<A_Fiber, Unit>(this){
            final /* synthetic */ AvailDebuggerModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull A_Fiber fiber2) {
                Intrinsics.checkNotNullParameter((Object)fiber2, (String)"fiber");
                if (!A_Map.Companion.hasKey(A_Fiber.Companion.getHeritableFiberGlobals(fiber2), AtomDescriptor.SpecialAtom.DONT_DEBUG_KEY.getAtom())) {
                    this.this$0.getRuntime().whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, fiber2){
                        final /* synthetic */ AvailDebuggerModel this$0;
                        final /* synthetic */ A_Fiber $fiber;
                        {
                            this.this$0 = $receiver;
                            this.$fiber = $fiber;
                            super(0);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            void $this$safeWrite$iv;
                            ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                            AvailDebuggerModel availDebuggerModel = this.this$0;
                            A_Fiber a_Fiber = this.$fiber;
                            boolean $i$f$safeWrite = false;
                            ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
                            Lock lock = writeLock;
                            lock.lock();
                            try {
                                boolean bl = false;
                                availDebuggerModel.getDebuggedFibers().removeIf(arg_0 -> fiberCaptureFunction.1.invoke$lambda$3$lambda$0(fiberCaptureFunction.1.1.INSTANCE, arg_0));
                                if (A_Fiber.Companion.getFiberHelper(a_Fiber).getDebugger().get() == null) {
                                    A_Fiber.Companion.captureInDebugger(a_Fiber, availDebuggerModel);
                                    availDebuggerModel.getDebuggedFibers().add(a_Fiber);
                                    SwingUtilities.invokeLater(() -> fiberCaptureFunction.1.invoke$lambda$3$lambda$2(availDebuggerModel, a_Fiber));
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            finally {
                                lock.unlock();
                            }
                        }

                        private static final boolean invoke$lambda$3$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            return (Boolean)$tmp0.invoke(p0);
                        }

                        private static final void invoke$lambda$3$lambda$2(AvailDebuggerModel this$0, A_Fiber $fiber) {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Intrinsics.checkNotNullParameter((Object)$fiber, (String)"$fiber");
                            Iterable $this$forEach$iv = this$0.getWhenAddedFiberActions();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Function1 it = (Function1)element$iv;
                                boolean bl = false;
                                it.invoke((Object)$fiber);
                            }
                        }
                    }));
                }
            }
        };
        this.whenPausedActions = new ArrayList();
        this.whenAddedFiberActions = new ArrayList();
    }

    @NotNull
    public final AvailRuntime getRuntime() {
        return this.runtime;
    }

    @NotNull
    public final List<A_Fiber> getDebuggedFibers() {
        return this.debuggedFibers;
    }

    public final boolean isCapturingNewFibers(@NotNull FiberDescriptor.FiberKind fiberKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)fiberKind), (String)"fiberKind");
        AtomicReference<Function1<A_Fiber, Unit>> atomicReference = this.runtime.getNewFiberHandlers().get((Object)fiberKind);
        Intrinsics.checkNotNull(atomicReference);
        return atomicReference.get() == this.fiberCaptureFunction;
    }

    public final void runFiberAction(@NotNull A_Fiber fiber2, @NotNull A_Continuation selectedContinuation, @NotNull Function3<? super AvailDebuggerModel, ? super A_Fiber, ? super A_Continuation, Unit> doAction) {
        Intrinsics.checkNotNullParameter((Object)fiber2, (String)"fiber");
        Intrinsics.checkNotNullParameter((Object)selectedContinuation, (String)"selectedContinuation");
        Intrinsics.checkNotNullParameter(doAction, (String)"doAction");
        this.runtime.whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this, fiber2, doAction, selectedContinuation){
            final /* synthetic */ AvailDebuggerModel this$0;
            final /* synthetic */ A_Fiber $fiber;
            final /* synthetic */ Function3<AvailDebuggerModel, A_Fiber, A_Continuation, Unit> $doAction;
            final /* synthetic */ A_Continuation $selectedContinuation;
            {
                this.this$0 = $receiver;
                this.$fiber = $fiber;
                this.$doAction = $doAction;
                this.$selectedContinuation = $selectedContinuation;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$safeWrite$iv;
                this.this$0.getRuntime().assertInSafePoint();
                ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                A_Fiber a_Fiber = this.$fiber;
                AvailDebuggerModel availDebuggerModel = this.this$0;
                Function3<AvailDebuggerModel, A_Fiber, A_Continuation, Unit> function3 = this.$doAction;
                A_Continuation a_Continuation = this.$selectedContinuation;
                boolean $i$f$safeWrite = false;
                ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
                Lock lock = writeLock;
                lock.lock();
                try {
                    boolean bl = false;
                    a_Fiber.lock((Function0)new Function0<Unit>(a_Fiber, availDebuggerModel, function3, a_Continuation){
                        final /* synthetic */ A_Fiber $fiber;
                        final /* synthetic */ AvailDebuggerModel this$0;
                        final /* synthetic */ Function3<AvailDebuggerModel, A_Fiber, A_Continuation, Unit> $doAction;
                        final /* synthetic */ A_Continuation $selectedContinuation;
                        {
                            this.$fiber = $fiber;
                            this.this$0 = $receiver;
                            this.$doAction = $doAction;
                            this.$selectedContinuation = $selectedContinuation;
                            super(0);
                        }

                        public final void invoke() {
                            boolean bl = Intrinsics.areEqual((Object)A_Fiber.Companion.getFiberHelper(this.$fiber).getDebugger().get(), (Object)this.this$0);
                            if (_Assertions.ENABLED && !bl) {
                                String string2 = "Assertion failed";
                                throw new AssertionError((Object)string2);
                            }
                            this.$doAction.invoke((Object)this.this$0, (Object)this.$fiber, (Object)this.$selectedContinuation);
                            this.this$0.getRuntime().resumeIfPausedByDebugger(this.$fiber);
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        }));
    }

    public final void doSingleStep(@NotNull A_Fiber fiber2, @NotNull A_Continuation selectedContinuation) {
        Intrinsics.checkNotNullParameter((Object)fiber2, (String)"fiber");
        Intrinsics.checkNotNullParameter((Object)selectedContinuation, (String)"selectedContinuation");
        Ref.BooleanRef allow = new Ref.BooleanRef();
        allow.element = true;
        A_Fiber.Companion.getFiberHelper(fiber2).setDebuggerRunCondition((Function1<? super Interpreter, Boolean>)((Function1)new Function1<Interpreter, Boolean>(allow){
            final /* synthetic */ Ref.BooleanRef $allow;
            {
                this.$allow = $allow;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Interpreter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Boolean bl = this.$allow.element;
                Ref.BooleanRef booleanRef = this.$allow;
                boolean it2 = bl;
                boolean bl2 = false;
                booleanRef.element = false;
                return bl;
            }
        }));
        A_Fiber.Companion.getFiberHelper(fiber2).setDebuggerCanInvoke(false);
    }

    public final void doStepOver(@NotNull A_Fiber fiber2, @NotNull A_Continuation selectedContinuation) {
        Intrinsics.checkNotNullParameter((Object)fiber2, (String)"fiber");
        Intrinsics.checkNotNullParameter((Object)selectedContinuation, (String)"selectedContinuation");
        A_Continuation initialContinuation = selectedContinuation.traversed().makeShared();
        if (initialContinuation.isNil()) {
            return;
        }
        A_Function initialFunction = A_Continuation.Companion.function(initialContinuation);
        A_Continuation initialCaller = A_Continuation.Companion.caller(initialContinuation).traversed();
        Ref.BooleanRef firstPoll = new Ref.BooleanRef();
        firstPoll.element = true;
        A_Fiber.Companion.getFiberHelper(fiber2).setDebuggerRunCondition((Function1<? super Interpreter, Boolean>)((Function1)new Function1<Interpreter, Boolean>(firstPoll, fiber2, initialCaller, initialFunction){
            final /* synthetic */ Ref.BooleanRef $firstPoll;
            final /* synthetic */ A_Fiber $fiber;
            final /* synthetic */ A_Continuation $initialCaller;
            final /* synthetic */ A_Function $initialFunction;
            {
                this.$firstPoll = $firstPoll;
                this.$fiber = $fiber;
                this.$initialCaller = $initialCaller;
                this.$initialFunction = $initialFunction;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Interpreter interpreter) {
                AvailObject availObject;
                AvailObject availObject2;
                AvailObject currentCallerTraversed;
                Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
                if (this.$firstPoll.element) {
                    this.$firstPoll.element = false;
                    return true;
                }
                if (!interpreter.callerIsReified()) {
                    return true;
                }
                boolean bl = interpreter.fiber().equals(this.$fiber);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                AvailObject initialCallerTraversed = this.$initialCaller.traversed();
                AvailObject availObject3 = interpreter.getReifiedContinuation();
                AvailObject availObject4 = currentCallerTraversed = availObject3 != null && (availObject2 = availObject3.traversed()) != null && (availObject = availObject2.makeShared()) != null ? availObject : NilDescriptor.Companion.getNil();
                if (currentCallerTraversed.sameAddressAs(initialCallerTraversed)) {
                    A_Function a_Function = interpreter.function;
                    Intrinsics.checkNotNull((Object)a_Function);
                    if (a_Function.equals(this.$initialFunction)) {
                        return false;
                    }
                }
                AvailObject c = currentCallerTraversed;
                while (c.getNotNil()) {
                    if (c.sameAddressAs(initialCallerTraversed)) {
                        return true;
                    }
                    c = A_Continuation.Companion.caller(c).traversed();
                }
                return false;
            }
        }));
        A_Fiber.Companion.getFiberHelper(fiber2).setDebuggerCanInvoke(true);
    }

    public final void stepOutThen() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    public final void stepToLineThen() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume(@NotNull A_Fiber fiber2) {
        Intrinsics.checkNotNullParameter((Object)fiber2, (String)"fiber");
        ReentrantReadWriteLock $this$safeWrite$iv = this.runtime.getRuntimeLock();
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            A_Fiber.Companion.releaseFromDebugger(fiber2);
            this.debuggedFibers.remove(fiber2);
            Iterable $this$forEach$iv = this.whenAddedFiberActions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl2 = false;
                it.invoke((Object)fiber2);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void restartFrameThen() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    public final boolean installFiberCapture(@NotNull FiberDescriptor.FiberKind kind2, boolean install) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        return install ? this.runtime.compareAndSetFiberCaptureFunction(kind2, null, this.fiberCaptureFunction) : this.runtime.compareAndSetFiberCaptureFunction(kind2, this.fiberCaptureFunction, null);
    }

    @NotNull
    public final List<Function1<A_Fiber, Unit>> getWhenPausedActions() {
        return this.whenPausedActions;
    }

    @NotNull
    public final List<Function1<A_Fiber, Unit>> getWhenAddedFiberActions() {
        return this.whenAddedFiberActions;
    }

    public final void justPaused(@NotNull A_Fiber fiber2) {
        Intrinsics.checkNotNullParameter((Object)fiber2, (String)"fiber");
        this.runtime.whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this, fiber2){
            final /* synthetic */ AvailDebuggerModel this$0;
            final /* synthetic */ A_Fiber $fiber;
            {
                this.this$0 = $receiver;
                this.$fiber = $fiber;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$safeWrite$iv;
                ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                AvailDebuggerModel availDebuggerModel = this.this$0;
                A_Fiber a_Fiber = this.$fiber;
                boolean $i$f$safeWrite = false;
                ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
                Lock lock = writeLock;
                lock.lock();
                try {
                    boolean bl = false;
                    SwingUtilities.invokeLater(() -> justPaused.1.invoke$lambda$2$lambda$1(availDebuggerModel, a_Fiber));
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }

            private static final void invoke$lambda$2$lambda$1(AvailDebuggerModel this$0, A_Fiber $fiber) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$fiber, (String)"$fiber");
                Iterable $this$forEach$iv = this$0.getWhenPausedActions();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Function1 it = (Function1)element$iv;
                    boolean bl = false;
                    it.invoke((Object)$fiber);
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void gatherFibers(@NotNull Function0<? extends Collection<? extends A_Fiber>> fibersProvider) {
        Intrinsics.checkNotNullParameter(fibersProvider, (String)"fibersProvider");
        ReentrantReadWriteLock $this$safeWrite$iv = this.runtime.getRuntimeLock();
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            void $this$sortedBy$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            boolean bl = false;
            this.runtime.assertInSafePoint();
            Iterable iterable = (Iterable)fibersProvider.invoke();
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                A_Fiber it = (A_Fiber)element$iv$iv;
                boolean bl2 = false;
                boolean bl3 = A_Fiber.Companion.getFiberHelper(it).getDebugger().get() == null && !A_Fiber.Companion.getExecutionState(it).getIndicatesTermination() && !A_Map.Companion.hasKey(A_Fiber.Companion.getHeritableFiberGlobals(it), AtomDescriptor.SpecialAtom.DONT_DEBUG_KEY.getAtom());
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List newFibers = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    A_Fiber it = (A_Fiber)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(A_Fiber.Companion.getFiberHelper(it).getDebugUniqueId());
                    it = (A_Fiber)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(A_Fiber.Companion.getFiberHelper(it).getDebugUniqueId()));
                }
            });
            this.debuggedFibers.addAll(newFibers);
            Iterable $this$forEach$iv = newFibers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl4;
                A_Fiber fiber2 = (A_Fiber)element$iv;
                boolean bl5 = false;
                boolean bl6 = bl4 = A_Fiber.Companion.getFiberHelper(fiber2).getDebugger().get() == null;
                if (_Assertions.ENABLED && !bl4) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Fiber.Companion.captureInDebugger(fiber2, this);
                A_Fiber.Companion.getFiberHelper(fiber2).setDebuggerRunCondition((Function1<? super Interpreter, Boolean>)((Function1)gatherFibers.1.1.1.INSTANCE));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void releaseFibersThen(@NotNull Function0<Unit> then) {
        Intrinsics.checkNotNullParameter(then, (String)"then");
        this.runtime.whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this, then){
            final /* synthetic */ AvailDebuggerModel this$0;
            final /* synthetic */ Function0<Unit> $then;
            {
                this.this$0 = $receiver;
                this.$then = $then;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$safeWrite$iv;
                ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                AvailDebuggerModel availDebuggerModel = this.this$0;
                boolean $i$f$safeWrite = false;
                ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
                Lock lock = writeLock;
                lock.lock();
                try {
                    boolean bl = false;
                    Iterable $this$forEach$iv = availDebuggerModel.getDebuggedFibers();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        A_Fiber it = (A_Fiber)element$iv;
                        boolean bl2 = false;
                        A_Fiber.Companion.releaseFromDebugger(it);
                    }
                    availDebuggerModel.getDebuggedFibers().clear();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                this.$then.invoke();
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/AvailDebuggerModel$Companion;", "", "()V", "reificationForDebuggerStat", "Lavail/performance/Statistic;", "getReificationForDebuggerStat", "()Lavail/performance/Statistic;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Statistic getReificationForDebuggerStat() {
            return reificationForDebuggerStat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

