/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.actions;

import avail.anvil.AvailWorkbench;
import avail.anvil.actions.AbstractWorkbenchAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Path;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lavail/anvil/actions/SetDocumentationPathAction;", "Lavail/anvil/actions/AbstractWorkbenchAction;", "workbench", "Lavail/anvil/AvailWorkbench;", "(Lavail/anvil/AvailWorkbench;)V", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "updateIsEnabled", "busy", "", "avail"})
public final class SetDocumentationPathAction
extends AbstractWorkbenchAction {
    public SetDocumentationPathAction(@NotNull AvailWorkbench workbench) {
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        super(workbench, "Set Documentation Path\u2026", null, null, 12, null);
        this.putValue("ShortDescription", "Set the Stacks documentation path.");
    }

    @Override
    public void updateIsEnabled(boolean busy) {
        this.setEnabled(!busy);
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JFileChooser chooser2 = new JFileChooser();
        chooser2.setFileSelectionMode(1);
        chooser2.setSelectedFile(this.getWorkbench().getDocumentationPath().toFile());
        chooser2.ensureFileIsVisible(this.getWorkbench().getDocumentationPath().toFile());
        chooser2.addChoosableFileFilter(new FileFilter(){

            @NotNull
            public String getDescription() {
                return "Directories";
            }

            public boolean accept(@NotNull File f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                return f.isDirectory() && f.canWrite();
            }
        });
        int result2 = chooser2.showDialog(this.getWorkbench(), "Set Documentation Path");
        if (result2 == 0) {
            AvailWorkbench availWorkbench = this.getWorkbench();
            Path path = chooser2.getSelectedFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            availWorkbench.setDocumentationPath(path);
        }
    }
}

