/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.streams;

import avail.anvil.AvailWorkbench;
import avail.anvil.streams.StreamStyle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\"\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/anvil/streams/BuildOutputStream;", "Ljava/io/ByteArrayOutputStream;", "workbench", "Lavail/anvil/AvailWorkbench;", "streamStyle", "Lavail/anvil/streams/StreamStyle;", "(Lavail/anvil/AvailWorkbench;Lavail/anvil/streams/StreamStyle;)V", "getStreamStyle", "()Lavail/anvil/streams/StreamStyle;", "queueForTranscript", "", "write", "b", "", "off", "", "len", "avail"})
@SourceDebugExtension(value={"SMAP\nBuildOutputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildOutputStream.kt\navail/anvil/streams/BuildOutputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class BuildOutputStream
extends ByteArrayOutputStream {
    @NotNull
    private final AvailWorkbench workbench;
    @NotNull
    private final StreamStyle streamStyle;

    public BuildOutputStream(@NotNull AvailWorkbench workbench, @NotNull StreamStyle streamStyle) {
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        Intrinsics.checkNotNullParameter((Object)((Object)streamStyle), (String)"streamStyle");
        super(1);
        this.workbench = workbench;
        this.streamStyle = streamStyle;
    }

    @NotNull
    public final StreamStyle getStreamStyle() {
        return this.streamStyle;
    }

    private final void queueForTranscript() {
        boolean bl = Thread.holdsLock(this);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        String text = null;
        try {
            String string3 = this.toString(StandardCharsets.UTF_8.name());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            text = string3;
        }
        catch (UnsupportedEncodingException e) {
            if (_Assertions.ENABLED) {
                boolean bl2 = false;
                String string4 = "Somehow Java doesn't support characters";
                throw new AssertionError((Object)string4);
            }
            throw new RuntimeException(e);
        }
        if (((CharSequence)text).length() == 0) {
            return;
        }
        this.reset();
        this.workbench.writeText(text, this.streamStyle);
    }

    @Override
    public synchronized void write(int b) {
        super.write(b);
        this.queueForTranscript();
    }

    @Override
    public synchronized void write(@Nullable byte[] b) throws IOException {
        boolean bl;
        boolean bl2 = bl = b != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Intrinsics.checkNotNull((Object)b);
        super.write(b);
        this.queueForTranscript();
    }

    @Override
    public synchronized void write(@Nullable byte[] b, int off, int len) {
        boolean bl;
        boolean bl2 = bl = b != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Intrinsics.checkNotNull((Object)b);
        super.write(b, off, len);
        this.queueForTranscript();
    }
}

