/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.controlflow;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.ContinuationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_RETURN;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import avail.optimizer.L2Synonym;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.values.L2SemanticValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014JH\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/controlflow/P_ExitContinuationIf;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "arguments", "", "argumentTypes", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_ExitContinuationIf
extends Primitive {
    @NotNull
    public static final P_ExitContinuationIf INSTANCE = new P_ExitContinuationIf();

    private P_ExitContinuationIf() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.CanSwitchContinuations, Primitive.Flag.CannotFail};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        List<AvailObject> list2 = interpreter.argsBuffer;
        AvailObject continuation = list2.get(0);
        AvailObject condition = list2.get(1);
        if (!A_Atom.Companion.getExtractBoolean(condition)) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        A_Continuation caller = A_Continuation.Companion.caller(continuation);
        interpreter.setReifiedContinuation(caller);
        if (caller.isNil()) {
            interpreter.function = null;
            interpreter.chunk = null;
            interpreter.offset = Integer.MAX_VALUE;
            interpreter.returnNow = true;
        } else {
            interpreter.function = A_Continuation.Companion.function(caller);
            interpreter.chunk = A_Continuation.Companion.levelTwoChunk(caller);
            interpreter.offset = A_Continuation.Companion.levelTwoOffset(caller);
            interpreter.returnNow = false;
        }
        interpreter.setLatestResult(NilDescriptor.Companion.getNil());
        return Primitive.Result.CONTINUATION_CHANGED;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(ContinuationTypeDescriptor.Companion.continuationTypeForFunctionType(FunctionTypeDescriptor.Companion.functionTypeReturning(PrimitiveTypeDescriptor.Types.TOP.getO())), EnumerationTypeDescriptor.Companion.getBooleanType()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CONTINUATION_EXPECTED_STRONGER_TYPE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        L2ReadBoxedOperand continuationReg = arguments.get(0);
        L2ReadBoxedOperand conditionReg = arguments.get(1);
        L2Generator generator = translator.getGenerator();
        L2ValueManifest manifest2 = generator.getCurrentManifest();
        L2Synonym synonym = manifest2.semanticValueToSynonym(continuationReg.semanticValue());
        L2SemanticValue label = generator.getTopFrame().label();
        if (manifest2.hasSemanticValue(label) && Intrinsics.areEqual((Object)manifest2.semanticValueToSynonym(label), (Object)synonym)) {
            L2BasicBlock exit = generator.createBasicBlock("Exit");
            L2BasicBlock dontExit = generator.createBasicBlock("Don't exit");
            generator.jumpIfEqualsConstant(generator.readBoxed(conditionReg.originalBoxedWriteSkippingMoves(true)), AtomDescriptor.Companion.getTrueObject(), exit, dontExit);
            L2Generator.startBlock$default(generator, exit, false, null, 6, null);
            L2Operand[] l2OperandArray = new L2Operand[]{generator.boxedConstant(NilDescriptor.Companion.getNil())};
            generator.addInstruction(L2_RETURN.INSTANCE, l2OperandArray);
            L2Generator.startBlock$default(generator, dontExit, false, null, 6, null);
            callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(NilDescriptor.Companion.getNil()));
            return true;
        }
        return false;
    }
}

