/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.methods;

import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.bundles.A_BundleTree;
import avail.descriptor.bundles.MessageBundleDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.MethodDescriptor;
import avail.descriptor.parsing.ParsingPlanInProgressDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AmbiguousNameException;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.interpreter.Primitive;
import avail.interpreter.effects.LoadingEffectToRunPrimitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/methods/P_Alias;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_Alias
extends Primitive {
    @NotNull
    public static final P_Alias INSTANCE = new P_Alias();

    private P_Alias() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        A_Bundle oldBundle;
        A_Atom a_Atom;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        A_String newString = interpreter.argument(0);
        A_Atom oldAtom = interpreter.argument(1);
        AvailLoader loader = interpreter.availLoaderOrNull();
        if (loader == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        if (!loader.getPhase().isExecuting()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION);
        }
        if (A_Atom.Companion.isAtomSpecial(oldAtom)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SPECIAL_ATOM);
        }
        try {
            a_Atom = AvailLoader.lookupName$default(loader, newString, null, 2, null);
        }
        catch (AmbiguousNameException e) {
            return interpreter.primitiveFailure(e);
        }
        A_Atom newAtom = a_Atom;
        if (A_Atom.Companion.getBundleOrNil(newAtom).getNotNil()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_ATOM_ALREADY_EXISTS);
        }
        try {
            oldBundle = A_Atom.Companion.bundleOrCreate(oldAtom);
            A_Method method = A_Bundle.Companion.getBundleMethod(oldBundle);
            A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{newString, oldAtom};
            loader.recordEarlyEffect(new LoadingEffectToRunPrimitive(MethodDescriptor.SpecialMethodAtom.ALIAS, a_BasicObjectArray));
            oldBundle = MessageBundleDescriptor.Companion.newBundle(newAtom, method, MessageSplitter.Companion.split(newString));
        }
        catch (MalformedMessageException e) {
            return interpreter.primitiveFailure(e.getErrorCode());
        }
        A_Bundle newBundle = oldBundle;
        A_Atom.Companion.setAtomBundle(newAtom, newBundle);
        if (loader.getPhase() == AvailLoader.Phase.EXECUTING_FOR_COMPILE) {
            A_BundleTree root = loader.getRootBundleTree();
            loader.getModule().lock((Function0)new Function0<Unit>(newBundle, root){
                final /* synthetic */ A_Bundle $newBundle;
                final /* synthetic */ A_BundleTree $root;
                {
                    this.$newBundle = $newBundle;
                    this.$root = $root;
                    super(0);
                }

                public final void invoke() {
                    A_Map.Companion.forEach(A_Bundle.Companion.getDefinitionParsingPlans(this.$newBundle), (Function2<? super AvailObject, ? super AvailObject, Unit>)((Function2)new Function2<AvailObject, AvailObject, Unit>(this.$root){
                        final /* synthetic */ A_BundleTree $root;
                        {
                            this.$root = $root;
                            super(2);
                        }

                        public final void invoke(@NotNull AvailObject availObject, @NotNull AvailObject value) {
                            Intrinsics.checkNotNullParameter((Object)availObject, (String)"<anonymous parameter 0>");
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            A_BundleTree.Companion.addPlanInProgress(this.$root, ParsingPlanInProgressDescriptor.Companion.newPlanInProgress(value, 1));
                        }
                    }));
                }
            });
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getStringType(), PrimitiveTypeDescriptor.Types.ATOM.getO()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER, AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION, AvailErrorCode.E_SPECIAL_ATOM, AvailErrorCode.E_AMBIGUOUS_NAME, AvailErrorCode.E_ATOM_ALREADY_EXISTS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Set.Companion.setUnionCanDestroy(SetDescriptor.Companion.set(availErrorCodeArray), MessageSplitter.Companion.getPossibleErrors(), true));
    }
}

