/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.methods;

import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.methods.A_Sendable;
import avail.descriptor.module.A_Module;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.AvailException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/methods/P_CopyMacros;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_CopyMacros
extends Primitive {
    @NotNull
    public static final P_CopyMacros INSTANCE = new P_CopyMacros();

    private P_CopyMacros() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanSuspend, Primitive.Flag.HasSideEffect};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        A_Atom oldAtom = interpreter.argument(0);
        A_Atom newAtom = interpreter.argument(1);
        AvailLoader loader = interpreter.availLoaderOrNull();
        if (loader == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        if (!loader.getPhase().isExecuting()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION);
        }
        if (A_Atom.Companion.isAtomSpecial(oldAtom) || A_Atom.Companion.isAtomSpecial(newAtom)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SPECIAL_ATOM);
        }
        A_Bundle oldBundle = A_Atom.Companion.getBundleOrNil(oldAtom);
        if (oldBundle.isNil()) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        A_Module currentModule = loader.getModule();
        return interpreter.suspendInSafePointThen((Function1<? super Interpreter.SuspensionHelper<A_BasicObject>, Unit>)((Function1)new Function1<Interpreter.SuspensionHelper<A_BasicObject>, Unit>(oldBundle, currentModule, loader, newAtom){
            final /* synthetic */ A_Bundle $oldBundle;
            final /* synthetic */ A_Module $currentModule;
            final /* synthetic */ AvailLoader $loader;
            final /* synthetic */ A_Atom $newAtom;
            {
                this.$oldBundle = $oldBundle;
                this.$currentModule = $currentModule;
                this.$loader = $loader;
                this.$newAtom = $newAtom;
                super(1);
            }

            public final void invoke(@NotNull Interpreter.SuspensionHelper<A_BasicObject> $this$suspendInSafePointThen) {
                Intrinsics.checkNotNullParameter($this$suspendInSafePointThen, (String)"$this$suspendInSafePointThen");
                try {
                    for (AvailObject macro : A_Bundle.Companion.getMacrosTuple(this.$oldBundle)) {
                        A_Module definitionModule = macro.definitionModule();
                        if (!definitionModule.isNil() && !definitionModule.equals(this.$currentModule) && !A_Set.Companion.hasElement(A_Module.Companion.getAllAncestors(this.$currentModule), definitionModule)) continue;
                        this.$loader.addMacroBody(this.$newAtom, A_Sendable.Companion.bodyBlock(macro), macro.prefixFunctions(), false);
                    }
                    $this$suspendInSafePointThen.succeed(NilDescriptor.Companion.getNil());
                }
                catch (AvailException e) {
                    $this$suspendInSafePointThen.fail(e.getErrorCode());
                }
            }
        }));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), PrimitiveTypeDescriptor.Types.ATOM.getO()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER, AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION, AvailErrorCode.E_REDEFINED_WITH_SAME_ARGUMENT_TYPES, AvailErrorCode.E_SPECIAL_ATOM, AvailErrorCode.E_AMBIGUOUS_NAME, AvailErrorCode.E_ATOM_ALREADY_EXISTS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Set.Companion.setUnionCanDestroy(SetDescriptor.Companion.set(availErrorCodeArray), MessageSplitter.Companion.getPossibleErrors(), true));
    }
}

